/*
 * Decompiled with CFR 0.152.
 */
package android.devicelock;

import android.devicelock.IGetDeviceIdCallback;
import android.devicelock.IGetKioskAppsCallback;
import android.devicelock.IIsDeviceLockedCallback;
import android.devicelock.IVoidResultCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IDeviceLockService
extends IInterface {
    public static final String DESCRIPTOR = "android.devicelock.IDeviceLockService";
    public static final int DEVICE_LOCK_ROLE_FINANCING = 0;
    public static final String KEY_REMOTE_CALLBACK_RESULT = "KEY_REMOTE_CALLBACK_RESULT";

    public void lockDevice(IVoidResultCallback var1) throws RemoteException;

    public void unlockDevice(IVoidResultCallback var1) throws RemoteException;

    public void isDeviceLocked(IIsDeviceLockedCallback var1) throws RemoteException;

    public void clearDeviceRestrictions(IVoidResultCallback var1) throws RemoteException;

    public void getDeviceId(IGetDeviceIdCallback var1) throws RemoteException;

    public void getKioskApps(IGetKioskAppsCallback var1) throws RemoteException;

    public void addFinancedDeviceKioskRole(String var1, RemoteCallback var2) throws RemoteException;

    public void removeFinancedDeviceKioskRole(String var1, RemoteCallback var2) throws RemoteException;

    public void setCallerExemptFromActivityBgStartRestrictionState(boolean var1, RemoteCallback var2) throws RemoteException;

    public void setCallerAllowedToSendUndismissibleNotifications(boolean var1, RemoteCallback var2) throws RemoteException;

    public void setUidExemptFromRestrictionsState(int var1, boolean var2, RemoteCallback var3) throws RemoteException;

    public void enableKioskKeepalive(String var1, RemoteCallback var2) throws RemoteException;

    public void disableKioskKeepalive(RemoteCallback var1) throws RemoteException;

    public void enableControllerKeepalive(RemoteCallback var1) throws RemoteException;

    public void disableControllerKeepalive(RemoteCallback var1) throws RemoteException;

    public void setDeviceFinalized(boolean var1, RemoteCallback var2) throws RemoteException;

    public void setPostNotificationsSystemFixed(boolean var1, RemoteCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceLockService {
        static final int TRANSACTION_lockDevice = 1;
        static final int TRANSACTION_unlockDevice = 2;
        static final int TRANSACTION_isDeviceLocked = 3;
        static final int TRANSACTION_clearDeviceRestrictions = 4;
        static final int TRANSACTION_getDeviceId = 5;
        static final int TRANSACTION_getKioskApps = 6;
        static final int TRANSACTION_addFinancedDeviceKioskRole = 7;
        static final int TRANSACTION_removeFinancedDeviceKioskRole = 8;
        static final int TRANSACTION_setCallerExemptFromActivityBgStartRestrictionState = 9;
        static final int TRANSACTION_setCallerAllowedToSendUndismissibleNotifications = 10;
        static final int TRANSACTION_setUidExemptFromRestrictionsState = 11;
        static final int TRANSACTION_enableKioskKeepalive = 12;
        static final int TRANSACTION_disableKioskKeepalive = 13;
        static final int TRANSACTION_enableControllerKeepalive = 14;
        static final int TRANSACTION_disableControllerKeepalive = 15;
        static final int TRANSACTION_setDeviceFinalized = 16;
        static final int TRANSACTION_setPostNotificationsSystemFixed = 17;

        public Stub() {
            this.attachInterface(this, IDeviceLockService.DESCRIPTOR);
        }

        public static IDeviceLockService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceLockService.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceLockService) {
                return (IDeviceLockService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "lockDevice";
                }
                case 2: {
                    return "unlockDevice";
                }
                case 3: {
                    return "isDeviceLocked";
                }
                case 4: {
                    return "clearDeviceRestrictions";
                }
                case 5: {
                    return "getDeviceId";
                }
                case 6: {
                    return "getKioskApps";
                }
                case 7: {
                    return "addFinancedDeviceKioskRole";
                }
                case 8: {
                    return "removeFinancedDeviceKioskRole";
                }
                case 9: {
                    return "setCallerExemptFromActivityBgStartRestrictionState";
                }
                case 10: {
                    return "setCallerAllowedToSendUndismissibleNotifications";
                }
                case 11: {
                    return "setUidExemptFromRestrictionsState";
                }
                case 12: {
                    return "enableKioskKeepalive";
                }
                case 13: {
                    return "disableKioskKeepalive";
                }
                case 14: {
                    return "enableControllerKeepalive";
                }
                case 15: {
                    return "disableControllerKeepalive";
                }
                case 16: {
                    return "setDeviceFinalized";
                }
                case 17: {
                    return "setPostNotificationsSystemFixed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceLockService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IVoidResultCallback _arg0 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.lockDevice(_arg0);
                    break;
                }
                case 2: {
                    IVoidResultCallback _arg0 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unlockDevice(_arg0);
                    break;
                }
                case 3: {
                    IIsDeviceLockedCallback _arg0 = IIsDeviceLockedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isDeviceLocked(_arg0);
                    break;
                }
                case 4: {
                    IVoidResultCallback _arg0 = IVoidResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.clearDeviceRestrictions(_arg0);
                    break;
                }
                case 5: {
                    IGetDeviceIdCallback _arg0 = IGetDeviceIdCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getDeviceId(_arg0);
                    break;
                }
                case 6: {
                    IGetKioskAppsCallback _arg0 = IGetKioskAppsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getKioskApps(_arg0);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.addFinancedDeviceKioskRole(_arg0, _arg1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeFinancedDeviceKioskRole(_arg0, _arg1);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCallerExemptFromActivityBgStartRestrictionState(_arg0, _arg1);
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCallerAllowedToSendUndismissibleNotifications(_arg0, _arg1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUidExemptFromRestrictionsState(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.enableKioskKeepalive(_arg0, _arg1);
                    break;
                }
                case 13: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.disableKioskKeepalive(_arg0);
                    break;
                }
                case 14: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.enableControllerKeepalive(_arg0);
                    break;
                }
                case 15: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.disableControllerKeepalive(_arg0);
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDeviceFinalized(_arg0, _arg1);
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPostNotificationsSystemFixed(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements IDeviceLockService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceLockService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockDevice(IVoidResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockDevice(IVoidResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isDeviceLocked(IIsDeviceLockedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearDeviceRestrictions(IVoidResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDeviceId(IGetDeviceIdCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getKioskApps(IGetKioskAppsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCallerExemptFromActivityBgStartRestrictionState(boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeBoolean(exempt);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCallerAllowedToSendUndismissibleNotifications(boolean allowed, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeBoolean(allowed);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidExemptFromRestrictionsState(int uid, boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeBoolean(exempt);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableKioskKeepalive(String packageName, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableKioskKeepalive(RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableControllerKeepalive(RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableControllerKeepalive(RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceFinalized(boolean finalized, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeBoolean(finalized);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPostNotificationsSystemFixed(boolean systemFixed, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeBoolean(systemFixed);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceLockService {
        @Override
        public void lockDevice(IVoidResultCallback callback) throws RemoteException {
        }

        @Override
        public void unlockDevice(IVoidResultCallback callback) throws RemoteException {
        }

        @Override
        public void isDeviceLocked(IIsDeviceLockedCallback callback) throws RemoteException {
        }

        @Override
        public void clearDeviceRestrictions(IVoidResultCallback callback) throws RemoteException {
        }

        @Override
        public void getDeviceId(IGetDeviceIdCallback callback) throws RemoteException {
        }

        @Override
        public void getKioskApps(IGetKioskAppsCallback callback) throws RemoteException {
        }

        @Override
        public void addFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void removeFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setCallerExemptFromActivityBgStartRestrictionState(boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setCallerAllowedToSendUndismissibleNotifications(boolean allowed, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setUidExemptFromRestrictionsState(int uid, boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void enableKioskKeepalive(String packageName, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void disableKioskKeepalive(RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void enableControllerKeepalive(RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void disableControllerKeepalive(RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setDeviceFinalized(boolean finalized, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setPostNotificationsSystemFixed(boolean systemFixed, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

