/*
 * Decompiled with CFR 0.152.
 */
package android.debug;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAdbCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.debug.IAdbCallback";

    public void onDebuggingChanged(boolean var1, byte var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAdbCallback {
        static final int TRANSACTION_onDebuggingChanged = 1;

        public Stub() {
            this.attachInterface(this, IAdbCallback.DESCRIPTOR);
        }

        public static IAdbCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAdbCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IAdbCallback) {
                return (IAdbCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDebuggingChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAdbCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    byte _arg1 = data.readByte();
                    data.enforceNoDataAvail();
                    this.onDebuggingChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IAdbCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAdbCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDebuggingChanged(boolean enabled, byte type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAdbCallback.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeByte(type);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAdbCallback {
        @Override
        public void onDebuggingChanged(boolean enabled, byte type) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

