/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.compat.annotation.UnsupportedAppUsage;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.Closeable;

@RavenwoodKeepWholeClass
public abstract class SQLiteClosable
implements Closeable {
    @UnsupportedAppUsage
    private int mReferenceCount = 1;
    protected boolean mTrackClosure = false;
    private Throwable mClosedBy = null;

    protected abstract void onAllReferencesReleased();

    @Deprecated
    protected void onAllReferencesReleasedFromContainer() {
        this.onAllReferencesReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReference() {
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to re-open an already-closed object: " + this, this.mClosedBy);
            }
            ++this.mReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference() {
        boolean refCountIsZero = false;
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            refCountIsZero = --this.mReferenceCount == 0;
        }
        if (refCountIsZero) {
            this.onAllReferencesReleased();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void releaseReferenceFromContainer() {
        boolean refCountIsZero = false;
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            refCountIsZero = --this.mReferenceCount == 0;
        }
        if (refCountIsZero) {
            this.onAllReferencesReleasedFromContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.releaseReference();
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            if (this.mTrackClosure && this.mClosedBy == null) {
                String name = this.getClass().getName();
                this.mClosedBy = new Exception("closed by " + name + ".close()").fillInStackTrace();
            }
        }
    }
}

