/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.hidden_from_bootclasspath.android.credentials.flags.Flags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CredentialProviderInfo
implements Parcelable {
    @NonNull
    private final ServiceInfo mServiceInfo;
    @NonNull
    private final List<String> mCapabilities = new ArrayList<String>();
    @Nullable
    private final CharSequence mOverrideLabel;
    @Nullable
    private CharSequence mSettingsSubtitle = null;
    @Nullable
    private CharSequence mSettingsActivity = null;
    private final boolean mIsSystemProvider;
    private final boolean mIsEnabled;
    private final boolean mIsPrimary;
    @NonNull
    public static final Parcelable.Creator<CredentialProviderInfo> CREATOR = new Parcelable.Creator<CredentialProviderInfo>(){

        public CredentialProviderInfo[] newArray(int size) {
            return new CredentialProviderInfo[size];
        }

        @Override
        public CredentialProviderInfo createFromParcel(@NonNull Parcel in) {
            return new CredentialProviderInfo(in);
        }
    };

    private CredentialProviderInfo(@NonNull Builder builder) {
        this.mServiceInfo = builder.mServiceInfo;
        this.mCapabilities.addAll(builder.mCapabilities);
        this.mIsSystemProvider = builder.mIsSystemProvider;
        this.mSettingsSubtitle = builder.mSettingsSubtitle;
        this.mIsEnabled = builder.mIsEnabled;
        this.mIsPrimary = builder.mIsPrimary;
        this.mOverrideLabel = builder.mOverrideLabel;
        this.mSettingsActivity = builder.mSettingsActivity;
    }

    @NonNull
    public boolean hasCapability(@NonNull String credentialType) {
        return this.mCapabilities.contains(credentialType);
    }

    @NonNull
    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public boolean isSystemProvider() {
        return this.mIsSystemProvider;
    }

    @Nullable
    public Drawable getServiceIcon(@NonNull Context context) {
        return this.mServiceInfo.loadIcon(context.getPackageManager());
    }

    @Nullable
    public CharSequence getLabel(@NonNull Context context) {
        if (this.mOverrideLabel != null) {
            return this.mOverrideLabel;
        }
        return this.mServiceInfo.loadSafeLabel(context.getPackageManager());
    }

    @NonNull
    public List<String> getCapabilities() {
        return Collections.unmodifiableList(this.mCapabilities);
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    @Nullable
    public CharSequence getSettingsSubtitle() {
        return this.mSettingsSubtitle;
    }

    @Nullable
    @FlaggedApi(value="android.credentials.flags.settings_activity_enabled")
    public CharSequence getSettingsActivity() {
        if (!Flags.settingsActivityEnabled()) {
            return null;
        }
        return this.mSettingsActivity;
    }

    @NonNull
    public ComponentName getComponentName() {
        return this.mServiceInfo.getComponentName();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mServiceInfo, flags);
        dest.writeBoolean(this.mIsSystemProvider);
        dest.writeStringList(this.mCapabilities);
        dest.writeBoolean(this.mIsEnabled);
        dest.writeBoolean(this.mIsPrimary);
        TextUtils.writeToParcel(this.mOverrideLabel, dest, flags);
        TextUtils.writeToParcel(this.mSettingsSubtitle, dest, flags);
        TextUtils.writeToParcel(this.mSettingsActivity, dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CredentialProviderInfo {serviceInfo=" + this.mServiceInfo + ", isSystemProvider=" + this.mIsSystemProvider + ", isEnabled=" + this.mIsEnabled + ", isPrimary=" + this.mIsPrimary + ", overrideLabel=" + this.mOverrideLabel + ", settingsSubtitle=" + this.mSettingsSubtitle + ", settingsActivity=" + this.mSettingsActivity + ", capabilities=" + String.join((CharSequence)",", this.mCapabilities) + "}";
    }

    private CredentialProviderInfo(@NonNull Parcel in) {
        this.mServiceInfo = in.readTypedObject(ServiceInfo.CREATOR);
        this.mIsSystemProvider = in.readBoolean();
        in.readStringList(this.mCapabilities);
        this.mIsEnabled = in.readBoolean();
        this.mIsPrimary = in.readBoolean();
        this.mOverrideLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSettingsSubtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSettingsActivity = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
    }

    public static class Builder {
        @NonNull
        private ServiceInfo mServiceInfo;
        @NonNull
        private List<String> mCapabilities = new ArrayList<String>();
        private boolean mIsSystemProvider = false;
        @Nullable
        private CharSequence mSettingsSubtitle = null;
        @Nullable
        private CharSequence mSettingsActivity = null;
        private boolean mIsEnabled = false;
        private boolean mIsPrimary = false;
        @Nullable
        private CharSequence mOverrideLabel = null;

        public Builder(@NonNull ServiceInfo serviceInfo) {
            this.mServiceInfo = serviceInfo;
        }

        @NonNull
        public Builder setSystemProvider(boolean isSystemProvider) {
            this.mIsSystemProvider = isSystemProvider;
            return this;
        }

        @NonNull
        public Builder setOverrideLabel(@NonNull CharSequence overrideLabel) {
            this.mOverrideLabel = overrideLabel;
            return this;
        }

        @NonNull
        public Builder setSettingsSubtitle(@Nullable CharSequence settingsSubtitle) {
            this.mSettingsSubtitle = settingsSubtitle;
            return this;
        }

        @NonNull
        public Builder setSettingsActivity(@Nullable CharSequence settingsActivity) {
            this.mSettingsActivity = settingsActivity;
            return this;
        }

        @NonNull
        public Builder addCapabilities(@NonNull List<String> capabilities) {
            this.mCapabilities.addAll(capabilities);
            return this;
        }

        @NonNull
        public Builder setEnabled(boolean isEnabled) {
            this.mIsEnabled = isEnabled;
            return this;
        }

        @NonNull
        public Builder setPrimary(boolean isPrimary) {
            this.mIsPrimary = isPrimary;
            return this;
        }

        @NonNull
        public CredentialProviderInfo build() {
            return new CredentialProviderInfo(this);
        }
    }
}

