/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.content.res.Element;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.ArrayDeque;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class Validator {
    private final ArrayDeque<Element> mElements = new ArrayDeque();

    private void cleanUp() {
        while (!this.mElements.isEmpty()) {
            this.mElements.pop().recycle();
        }
    }

    public void validate(@NonNull XmlPullParser parser) throws XmlPullParserException {
        int eventType = parser.getEventType();
        int depth = parser.getDepth();
        if (depth > this.mElements.size() + 1) {
            return;
        }
        if (eventType == 2) {
            String tag = parser.getName();
            if (Element.shouldValidate(tag)) {
                Element element = Element.obtain(tag);
                Element parent = this.mElements.peek();
                if (parent != null && parent.hasChild(tag)) {
                    try {
                        parent.seen(element);
                    }
                    catch (SecurityException e) {
                        this.cleanUp();
                        throw e;
                    }
                }
                this.mElements.push(element);
            }
        } else if (eventType == 3 && depth == this.mElements.size()) {
            this.mElements.pop().recycle();
        } else if (eventType == 1) {
            this.cleanUp();
        }
    }

    public void validateResStrAttr(@NonNull XmlPullParser parser, int index, CharSequence stringValue) {
        if (parser.getDepth() > this.mElements.size()) {
            return;
        }
        this.mElements.peek().validateResStrAttr(index, stringValue);
        if (index == 1) {
            this.validateComponentMetadata(stringValue.toString());
        }
    }

    public void validateStrAttr(@NonNull XmlPullParser parser, String attrName, String attrValue) {
        if (parser.getDepth() > this.mElements.size()) {
            return;
        }
        this.mElements.peek().validateStrAttr(attrName, attrValue);
        if (attrName.equals("value")) {
            this.validateComponentMetadata(attrValue);
        }
    }

    private void validateComponentMetadata(String attrValue) {
        Element element = this.mElements.peek();
        if (element.mTag.equals("meta-data") && this.mElements.size() > 1) {
            element = this.mElements.pop();
            this.mElements.peek().validateComponentMetadata(attrValue);
            this.mElements.push(element);
        }
    }
}

