/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.content.res.FontScaleConverter;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.MathUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
@RavenwoodKeepWholeClass
public class FontScaleConverterImpl
implements FontScaleConverter {
    @VisibleForTesting
    public final float[] mFromSpValues;
    @VisibleForTesting
    public final float[] mToDpValues;

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public FontScaleConverterImpl(@NonNull float[] fromSp, @NonNull float[] toDp) {
        if (fromSp.length != toDp.length || fromSp.length == 0) {
            throw new IllegalArgumentException("Array lengths must match and be nonzero");
        }
        this.mFromSpValues = fromSp;
        this.mToDpValues = toDp;
    }

    @Override
    public float convertDpToSp(float dp) {
        return FontScaleConverterImpl.lookupAndInterpolate(dp, this.mToDpValues, this.mFromSpValues);
    }

    @Override
    public float convertSpToDp(float sp) {
        return FontScaleConverterImpl.lookupAndInterpolate(sp, this.mFromSpValues, this.mToDpValues);
    }

    private static float lookupAndInterpolate(float sourceValue, float[] sourceValues, float[] targetValues) {
        float endDp;
        float endSp;
        float startDp;
        float startSp;
        float sourceValuePositive = Math.abs(sourceValue);
        float sign = Math.signum(sourceValue);
        int index = Arrays.binarySearch(sourceValues, sourceValuePositive);
        if (index >= 0) {
            return sign * targetValues[index];
        }
        int lowerIndex = -(index + 1) - 1;
        if (lowerIndex >= sourceValues.length - 1) {
            float startSp2 = sourceValues[sourceValues.length - 1];
            float startDp2 = targetValues[sourceValues.length - 1];
            if (startSp2 == 0.0f) {
                return 0.0f;
            }
            float scalingFactor = startDp2 / startSp2;
            return sourceValue * scalingFactor;
        }
        if (lowerIndex == -1) {
            startSp = 0.0f;
            startDp = 0.0f;
            endSp = sourceValues[0];
            endDp = targetValues[0];
        } else {
            startSp = sourceValues[lowerIndex];
            endSp = sourceValues[lowerIndex + 1];
            startDp = targetValues[lowerIndex];
            endDp = targetValues[lowerIndex + 1];
        }
        return sign * MathUtils.constrainedMap(startDp, endDp, startSp, endSp, sourceValuePositive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FontScaleConverterImpl)) {
            return false;
        }
        FontScaleConverterImpl that = (FontScaleConverterImpl)o;
        return Arrays.equals(this.mFromSpValues, that.mFromSpValues) && Arrays.equals(this.mToDpValues, that.mToDpValues);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mFromSpValues);
        result = 31 * result + Arrays.hashCode(this.mToDpValues);
        return result;
    }

    public String toString() {
        return "FontScaleConverter{fromSpValues=" + Arrays.toString(this.mFromSpValues) + ", toDpValues=" + Arrays.toString(this.mToDpValues) + '}';
    }
}

