/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Flags;
import android.content.res.FontScaleConverter;
import android.content.res.FontScaleConverterImpl;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.MathUtils;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;

@RavenwoodKeepWholeClass
public class FontScaleConverterFactory {
    private static final float SCALE_KEY_MULTIPLIER = 100.0f;
    @VisibleForTesting
    @NonNull
    public static volatile SparseArray<FontScaleConverter> sLookupTables = new SparseArray();
    private static final Object LOOKUP_TABLES_WRITE_LOCK = new Object();
    private static float sMinScaleBeforeCurvesApplied = 1.05f;

    private FontScaleConverterFactory() {
    }

    public static boolean isNonLinearFontScalingActive(float fontScale) {
        return fontScale >= sMinScaleBeforeCurvesApplied;
    }

    @Nullable
    public static FontScaleConverter forScale(float fontScale) {
        if (!FontScaleConverterFactory.isNonLinearFontScalingActive(fontScale)) {
            return null;
        }
        FontScaleConverter lookupTable = FontScaleConverterFactory.get(fontScale);
        if (lookupTable != null) {
            return lookupTable;
        }
        int index = sLookupTables.indexOfKey(FontScaleConverterFactory.getKey(fontScale));
        if (index >= 0) {
            return sLookupTables.valueAt(index);
        }
        int lowerIndex = -(index + 1) - 1;
        int higherIndex = lowerIndex + 1;
        if (lowerIndex < 0 || higherIndex >= sLookupTables.size()) {
            FontScaleConverterImpl converter = new FontScaleConverterImpl(new float[]{1.0f}, new float[]{fontScale});
            if (Flags.fontScaleConverterPublic()) {
                FontScaleConverterFactory.put(fontScale, converter);
            }
            return converter;
        }
        float startScale = FontScaleConverterFactory.getScaleFromKey(sLookupTables.keyAt(lowerIndex));
        float endScale = FontScaleConverterFactory.getScaleFromKey(sLookupTables.keyAt(higherIndex));
        float interpolationPoint = MathUtils.constrainedMap(0.0f, 1.0f, startScale, endScale, fontScale);
        FontScaleConverter converter = FontScaleConverterFactory.createInterpolatedTableBetween(sLookupTables.valueAt(lowerIndex), sLookupTables.valueAt(higherIndex), interpolationPoint);
        if (Flags.fontScaleConverterPublic()) {
            FontScaleConverterFactory.put(fontScale, converter);
        }
        return converter;
    }

    @NonNull
    private static FontScaleConverter createInterpolatedTableBetween(FontScaleConverter start, FontScaleConverter end, float interpolationPoint) {
        float[] commonSpSizes = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
        float[] dpInterpolated = new float[commonSpSizes.length];
        for (int i = 0; i < commonSpSizes.length; ++i) {
            float sp = commonSpSizes[i];
            float startDp = start.convertSpToDp(sp);
            float endDp = end.convertSpToDp(sp);
            dpInterpolated[i] = MathUtils.lerp(startDp, endDp, interpolationPoint);
        }
        return new FontScaleConverterImpl(commonSpSizes, dpInterpolated);
    }

    private static int getKey(float fontScale) {
        return (int)(fontScale * 100.0f);
    }

    private static float getScaleFromKey(int key) {
        return (float)key / 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(float scaleKey, @NonNull FontScaleConverter fontScaleConverter) {
        Object object = LOOKUP_TABLES_WRITE_LOCK;
        synchronized (object) {
            Object newTable = sLookupTables.clone();
            FontScaleConverterFactory.putInto((SparseArray<FontScaleConverter>)newTable, scaleKey, fontScaleConverter);
            sLookupTables = newTable;
        }
    }

    private static void putInto(SparseArray<FontScaleConverter> table, float scaleKey, @NonNull FontScaleConverter fontScaleConverter) {
        table.put(FontScaleConverterFactory.getKey(scaleKey), fontScaleConverter);
    }

    @Nullable
    private static FontScaleConverter get(float scaleKey) {
        return sLookupTables.get(FontScaleConverterFactory.getKey(scaleKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = LOOKUP_TABLES_WRITE_LOCK;
        synchronized (object) {
            FontScaleConverterFactory.putInto(sLookupTables, 1.05f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{8.4f, 10.5f, 12.6f, 14.8f, 18.6f, 20.6f, 24.4f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.1f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{8.8f, 11.0f, 13.2f, 15.6f, 19.2f, 21.2f, 24.8f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.15f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{9.2f, 11.5f, 13.8f, 16.4f, 19.8f, 21.8f, 25.2f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.2f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{9.6f, 12.0f, 14.4f, 17.2f, 20.4f, 22.4f, 25.6f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.3f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{10.4f, 13.0f, 15.6f, 18.8f, 21.6f, 23.6f, 26.4f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.5f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{12.0f, 15.0f, 18.0f, 22.0f, 24.0f, 26.0f, 28.0f, 30.0f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 1.8f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{14.4f, 18.0f, 21.6f, 24.4f, 27.6f, 30.8f, 32.8f, 34.8f, 100.0f}));
            FontScaleConverterFactory.putInto(sLookupTables, 2.0f, new FontScaleConverterImpl(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{16.0f, 20.0f, 24.0f, 26.0f, 30.0f, 34.0f, 36.0f, 38.0f, 100.0f}));
        }
        sMinScaleBeforeCurvesApplied = FontScaleConverterFactory.getScaleFromKey(sLookupTables.keyAt(0)) - 0.01f;
        if (sMinScaleBeforeCurvesApplied <= 1.0f) {
            throw new IllegalStateException("You should only apply non-linear scaling to font scales > 1");
        }
    }
}

