/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.CustomFeatureFlags;
import android.content.res.FeatureFlags;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class FakeFeatureFlagsImpl
extends CustomFeatureFlags {
    private final Map<String, Boolean> mFlagMap = new HashMap<String, Boolean>();
    private final FeatureFlags mDefaults;

    public FakeFeatureFlagsImpl() {
        this((FeatureFlags)null);
    }

    public FakeFeatureFlagsImpl(FeatureFlags defaults) {
        super(null);
        this.mDefaults = defaults;
        for (String flagName : this.getFlagNames()) {
            this.mFlagMap.put(flagName, null);
        }
    }

    @Override
    protected boolean getValue(String flagName, Predicate<FeatureFlags> getter) {
        Boolean value = this.mFlagMap.get(flagName);
        if (value != null) {
            return value;
        }
        if (this.mDefaults != null) {
            return getter.test(this.mDefaults);
        }
        throw new IllegalArgumentException(flagName + " is not set");
    }

    public void setFlag(String flagName, boolean value) {
        if (!this.mFlagMap.containsKey(flagName)) {
            throw new IllegalArgumentException("no such flag " + flagName);
        }
        this.mFlagMap.put(flagName, value);
    }

    public void resetAll() {
        for (Map.Entry<String, Boolean> entry : this.mFlagMap.entrySet()) {
            entry.setValue(null);
        }
    }
}

