/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.pm.ActivityInfo;
import android.content.pm.IncrementalStatesInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;

public class LauncherActivityInfoInternal
implements Parcelable {
    @UnsupportedAppUsage
    @NonNull
    private ActivityInfo mActivityInfo;
    @NonNull
    private ComponentName mComponentName;
    @NonNull
    private IncrementalStatesInfo mIncrementalStatesInfo;
    @NonNull
    private UserHandle mUser;
    private boolean mSupportsMultiInstance;
    @NonNull
    public static final Parcelable.Creator<LauncherActivityInfoInternal> CREATOR = new Parcelable.Creator<LauncherActivityInfoInternal>(){

        @Override
        public LauncherActivityInfoInternal createFromParcel(Parcel source) {
            return new LauncherActivityInfoInternal(source);
        }

        public LauncherActivityInfoInternal[] newArray(int size) {
            return new LauncherActivityInfoInternal[size];
        }
    };

    public LauncherActivityInfoInternal(@NonNull ActivityInfo info, @NonNull IncrementalStatesInfo incrementalStatesInfo, @NonNull UserHandle user, boolean supportsMultiInstance) {
        this.mActivityInfo = info;
        this.mComponentName = new ComponentName(info.packageName, info.name);
        this.mIncrementalStatesInfo = incrementalStatesInfo;
        this.mUser = user;
        this.mSupportsMultiInstance = supportsMultiInstance;
    }

    public LauncherActivityInfoInternal(Parcel source) {
        this.mActivityInfo = source.readTypedObject(ActivityInfo.CREATOR);
        this.mComponentName = new ComponentName(this.mActivityInfo.packageName, this.mActivityInfo.name);
        this.mIncrementalStatesInfo = source.readTypedObject(IncrementalStatesInfo.CREATOR);
        this.mUser = source.readTypedObject(UserHandle.CREATOR);
        this.mSupportsMultiInstance = source.readBoolean();
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public ActivityInfo getActivityInfo() {
        return this.mActivityInfo;
    }

    public UserHandle getUser() {
        return this.mUser;
    }

    public IncrementalStatesInfo getIncrementalStatesInfo() {
        return this.mIncrementalStatesInfo;
    }

    public boolean supportsMultiInstance() {
        return this.mSupportsMultiInstance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mActivityInfo, flags);
        dest.writeTypedObject(this.mIncrementalStatesInfo, flags);
        dest.writeTypedObject(this.mUser, flags);
        dest.writeBoolean(this.mSupportsMultiInstance);
    }
}

