/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ContentInterface;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;

public class LoggingContentInterface
implements ContentInterface {
    private final String tag;
    private final ContentInterface delegate;

    public LoggingContentInterface(String tag, ContentInterface delegate) {
        this.tag = tag;
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable Bundle queryArgs, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        Logger l = new Logger("query", uri, projection, queryArgs, cancellationSignal);
        try {
            Cursor cursor = l.setResult(this.delegate.query(uri, projection, queryArgs, cancellationSignal));
            return cursor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public String getType(@NonNull Uri uri) throws RemoteException {
        Logger l = new Logger("getType", uri);
        try {
            String string2 = l.setResult(this.delegate.getType(uri));
            return string2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public String[] getStreamTypes(@NonNull Uri uri, @NonNull String mimeTypeFilter) throws RemoteException {
        Logger l = new Logger("getStreamTypes", uri, mimeTypeFilter);
        try {
            String[] stringArray = l.setResult(this.delegate.getStreamTypes(uri, mimeTypeFilter));
            return stringArray;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public Uri canonicalize(@NonNull Uri uri) throws RemoteException {
        Logger l = new Logger("canonicalize", uri);
        try {
            Uri uri2 = l.setResult(this.delegate.canonicalize(uri));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public Uri uncanonicalize(@NonNull Uri uri) throws RemoteException {
        Logger l = new Logger("uncanonicalize", uri);
        try {
            Uri uri2 = l.setResult(this.delegate.uncanonicalize(uri));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public boolean refresh(@NonNull Uri uri, @Nullable Bundle args, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        Logger l = new Logger("refresh", uri, args, cancellationSignal);
        try {
            boolean bl = l.setResult(this.delegate.refresh(uri, args, cancellationSignal));
            return bl;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int checkUriPermission(@NonNull Uri uri, int uid, int modeFlags) throws RemoteException {
        Logger l = new Logger("checkUriPermission", uri, uid, modeFlags);
        try {
            int n = l.setResult(this.delegate.checkUriPermission(uri, uid, modeFlags));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues initialValues, @Nullable Bundle extras) throws RemoteException {
        Logger l = new Logger("insert", uri, initialValues, extras);
        try {
            Uri uri2 = l.setResult(this.delegate.insert(uri, initialValues, extras));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] initialValues) throws RemoteException {
        Logger l = new Logger("bulkInsert", uri, initialValues);
        try {
            int n = l.setResult(this.delegate.bulkInsert(uri, initialValues));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable Bundle extras) throws RemoteException {
        Logger l = new Logger("delete", uri, extras);
        try {
            int n = l.setResult(this.delegate.delete(uri, extras));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable Bundle extras) throws RemoteException {
        Logger l = new Logger("update", uri, values, extras);
        try {
            int n = l.setResult(this.delegate.update(uri, values, extras));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openFile", uri, mode, signal);
        try {
            ParcelFileDescriptor parcelFileDescriptor = l.setResult(this.delegate.openFile(uri, mode, signal));
            return parcelFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openAssetFile", uri, mode, signal);
        try {
            AssetFileDescriptor assetFileDescriptor = l.setResult(this.delegate.openAssetFile(uri, mode, signal));
            return assetFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public AssetFileDescriptor openTypedAssetFile(@NonNull Uri uri, @NonNull String mimeTypeFilter, @Nullable Bundle opts, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openTypedAssetFile", uri, mimeTypeFilter, opts, signal);
        try {
            AssetFileDescriptor assetFileDescriptor = l.setResult(this.delegate.openTypedAssetFile(uri, mimeTypeFilter, opts, signal));
            return assetFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull String authority, @NonNull ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Logger l = new Logger("applyBatch", authority, operations);
        try {
            ContentProviderResult[] contentProviderResultArray = l.setResult(this.delegate.applyBatch(authority, operations));
            return contentProviderResultArray;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    @Nullable
    public Bundle call(@NonNull String authority, @NonNull String method, @Nullable String arg, @Nullable Bundle extras) throws RemoteException {
        Logger l = new Logger("call", authority, method, arg, extras);
        try {
            Bundle bundle = l.setResult(this.delegate.call(authority, method, arg, extras));
            return bundle;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private class Logger
    implements AutoCloseable {
        private final StringBuilder sb = new StringBuilder();

        public Logger(String method, Object ... args) {
            for (Object arg : args) {
                if (!(arg instanceof Bundle)) continue;
                ((Bundle)arg).size();
            }
            this.sb.append("callingUid=").append(Binder.getCallingUid()).append(' ');
            this.sb.append(method);
            this.sb.append('(').append(this.deepToString(args)).append(')');
        }

        private String deepToString(Object value) {
            if (value != null && value.getClass().isArray()) {
                return Arrays.deepToString((Object[])value);
            }
            return String.valueOf(value);
        }

        public <T> T setResult(T res) {
            if (res instanceof Cursor) {
                this.sb.append('\n');
                DatabaseUtils.dumpCursor((Cursor)res, this.sb);
            } else {
                this.sb.append(" = ").append(this.deepToString(res));
            }
            return res;
        }

        @Override
        public void close() {
            Log.v(LoggingContentInterface.this.tag, this.sb.toString());
        }
    }
}

