/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.AttributionSource;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ContextParams {
    @Nullable
    private final String mAttributionTag;
    @Nullable
    private final AttributionSource mNext;
    @NonNull
    private final Set<String> mRenouncedPermissions;
    private final boolean mShouldRegisterAttributionSource;
    public static final ContextParams EMPTY = new Builder().build();

    private ContextParams(@Nullable String attributionTag, @Nullable AttributionSource next, @Nullable Set<String> renouncedPermissions, boolean shouldRegister) {
        this.mAttributionTag = attributionTag;
        this.mNext = next;
        this.mRenouncedPermissions = renouncedPermissions != null ? renouncedPermissions : Collections.emptySet();
        this.mShouldRegisterAttributionSource = shouldRegister;
    }

    @Nullable
    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
    @NonNull
    public Set<String> getRenouncedPermissions() {
        return this.mRenouncedPermissions;
    }

    public boolean isRenouncedPermission(@NonNull String permission2) {
        return this.mRenouncedPermissions.contains(permission2);
    }

    @Nullable
    public AttributionSource getNextAttributionSource() {
        return this.mNext;
    }

    @NonNull
    @FlaggedApi(value="android.permission.flags.should_register_attribution_source")
    public boolean shouldRegisterAttributionSource() {
        return this.mShouldRegisterAttributionSource;
    }

    public static class Builder {
        @Nullable
        private String mAttributionTag;
        @NonNull
        private Set<String> mRenouncedPermissions = Collections.emptySet();
        @Nullable
        private AttributionSource mNext;
        private boolean mShouldRegisterAttributionSource;

        public Builder() {
        }

        public Builder(@NonNull ContextParams params) {
            Objects.requireNonNull(params);
            this.mAttributionTag = params.mAttributionTag;
            this.mRenouncedPermissions = params.mRenouncedPermissions;
            this.mNext = params.mNext;
        }

        @NonNull
        public Builder setAttributionTag(@Nullable String attributionTag) {
            this.mAttributionTag = attributionTag;
            return this;
        }

        @NonNull
        public Builder setNextAttributionSource(@Nullable AttributionSource next) {
            this.mNext = next;
            return this;
        }

        @NonNull
        @FlaggedApi(value="android.permission.flags.should_register_attribution_source")
        public Builder setShouldRegisterAttributionSource(boolean shouldRegister) {
            this.mShouldRegisterAttributionSource = shouldRegister;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.RENOUNCE_PERMISSIONS")
        @NonNull
        public Builder setRenouncedPermissions(@Nullable Set<String> renouncedPermissions) {
            if (renouncedPermissions != null && !renouncedPermissions.isEmpty() && ActivityThread.currentApplication().checkSelfPermission("android.permission.RENOUNCE_PERMISSIONS") != 0) {
                throw new SecurityException("Renouncing permissions requires: android.permission.RENOUNCE_PERMISSIONS");
            }
            this.mRenouncedPermissions = renouncedPermissions;
            return this;
        }

        @NonNull
        public ContextParams build() {
            return new ContextParams(this.mAttributionTag, this.mNext, this.mRenouncedPermissions, this.mShouldRegisterAttributionSource);
        }
    }
}

