/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.PermissionMethod;
import android.annotation.PermissionName;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.BroadcastOptions;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.AutofillOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.ContentResolver;
import android.content.ContextParams;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.UserHandle;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.util.AttributeSet;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.ViewDebug;
import android.view.autofill.AutofillManager;
import android.view.contentcapture.ContentCaptureManager;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

@RavenwoodKeepPartialClass
public abstract class Context {
    @VisibleForTesting
    public static final long OVERRIDABLE_COMPONENT_CALLBACKS = 193247900L;
    public static final int DEVICE_ID_DEFAULT = 0;
    public static final int DEVICE_ID_INVALID = -1;
    public static final int MODE_PRIVATE = 0;
    @Deprecated
    public static final int MODE_WORLD_READABLE = 1;
    @Deprecated
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_APPEND = 32768;
    @Deprecated
    public static final int MODE_MULTI_PROCESS = 4;
    public static final int MODE_ENABLE_WRITE_AHEAD_LOGGING = 8;
    public static final int MODE_NO_LOCALIZED_COLLATORS = 16;
    public static final int BIND_AUTO_CREATE = 1;
    public static final int BIND_DEBUG_UNBIND = 2;
    public static final int BIND_NOT_FOREGROUND = 4;
    public static final int BIND_ABOVE_CLIENT = 8;
    public static final int BIND_ALLOW_OOM_MANAGEMENT = 16;
    public static final int BIND_WAIVE_PRIORITY = 32;
    public static final int BIND_IMPORTANT = 64;
    public static final int BIND_ADJUST_WITH_ACTIVITY = 128;
    public static final int BIND_NOT_PERCEPTIBLE = 256;
    public static final int BIND_ALLOW_ACTIVITY_STARTS = 512;
    public static final int BIND_INCLUDE_CAPABILITIES = 4096;
    public static final int BIND_SHARED_ISOLATED_PROCESS = 8192;
    @FlaggedApi(value="android.content.flags.enable_bind_package_isolated_process")
    public static final int BIND_PACKAGE_ISOLATED_PROCESS = 16384;
    public static final int BIND_NOT_APP_COMPONENT_USAGE = 32768;
    public static final int BIND_ALMOST_PERCEPTIBLE = 65536;
    public static final int BIND_BYPASS_POWER_NETWORK_RESTRICTIONS = 131072;
    @SystemApi
    @Deprecated
    public static final int BIND_ALLOW_FOREGROUND_SERVICE_STARTS_FROM_BACKGROUND = 262144;
    public static final int BIND_SCHEDULE_LIKE_TOP_APP = 524288;
    @SystemApi
    public static final int BIND_ALLOW_BACKGROUND_ACTIVITY_STARTS = 0x100000;
    public static final int BIND_RESTRICT_ASSOCIATIONS = 0x200000;
    public static final int BIND_ALLOW_INSTANT = 0x400000;
    public static final int BIND_IMPORTANT_BACKGROUND = 0x800000;
    public static final int BIND_ALLOW_WHITELIST_MANAGEMENT = 0x1000000;
    public static final int BIND_FOREGROUND_SERVICE_WHILE_AWAKE = 0x2000000;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence_module")
    public static final int BIND_FOREGROUND_SERVICE = 0x4000000;
    public static final int BIND_TREAT_LIKE_ACTIVITY = 0x8000000;
    @Deprecated
    public static final int BIND_VISIBLE = 0x10000000;
    public static final int BIND_TREAT_LIKE_VISIBLE_FOREGROUND_SERVICE = 0x10000000;
    public static final int BIND_SHOWING_UI = 0x20000000;
    public static final int BIND_NOT_VISIBLE = 0x40000000;
    public static final int BIND_EXTERNAL_SERVICE = Integer.MIN_VALUE;
    public static final long BIND_EXTERNAL_SERVICE_LONG = 0x4000000000000000L;
    public static final long BIND_BYPASS_USER_NETWORK_RESTRICTIONS = 0x100000000L;
    public static final long BIND_MATCH_QUARANTINED_COMPONENTS = 0x200000000L;
    public static final long BIND_ALLOW_FREEZE = 0x400000000L;
    public static final long BIND_REDUCTION_FLAGS = 18253611312L;
    public static final int RECEIVER_VISIBLE_TO_INSTANT_APPS = 1;
    public static final int RECEIVER_EXPORTED = 2;
    @Deprecated
    public static final int RECEIVER_EXPORTED_UNAUDITED = 2;
    public static final int RECEIVER_NOT_EXPORTED = 4;
    public static final int PERMISSION_REQUEST_STATE_GRANTED = 0;
    public static final int PERMISSION_REQUEST_STATE_REQUESTABLE = 1;
    public static final int PERMISSION_REQUEST_STATE_UNREQUESTABLE = 2;
    private static int sLastAutofillId = -1;
    public static final String POWER_SERVICE = "power";
    public static final String POWER_STATS_SERVICE = "powerstats";
    public static final String RECOVERY_SERVICE = "recovery";
    @SystemApi
    public static final String SYSTEM_UPDATE_SERVICE = "system_update";
    public static final String WINDOW_SERVICE = "window";
    public static final String LAYOUT_INFLATER_SERVICE = "layout_inflater";
    public static final String ACCOUNT_SERVICE = "account";
    public static final String ACTIVITY_SERVICE = "activity";
    public static final String ACTIVITY_TASK_SERVICE = "activity_task";
    public static final String URI_GRANTS_SERVICE = "uri_grants";
    public static final String ALARM_SERVICE = "alarm";
    public static final String NOTIFICATION_SERVICE = "notification";
    public static final String ACCESSIBILITY_SERVICE = "accessibility";
    public static final String CAPTIONING_SERVICE = "captioning";
    public static final String KEYGUARD_SERVICE = "keyguard";
    public static final String LOCATION_SERVICE = "location";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static final String COUNTRY_DETECTOR = "country_detector";
    public static final String SEARCH_SERVICE = "search";
    public static final String SENSOR_SERVICE = "sensor";
    public static final String SENSOR_PRIVACY_SERVICE = "sensor_privacy";
    @FlaggedApi(value="android.security.keystore_grant_api")
    public static final String KEYSTORE_SERVICE = "keystore";
    public static final String STORAGE_SERVICE = "storage";
    public static final String STORAGE_STATS_SERVICE = "storagestats";
    public static final String WALLPAPER_SERVICE = "wallpaper";
    @SuppressLint(value={"ServiceName"})
    public static final String VIBRATOR_MANAGER_SERVICE = "vibrator_manager";
    @Deprecated
    public static final String VIBRATOR_SERVICE = "vibrator";
    @SuppressLint(value={"ServiceName"})
    public static final String STATUS_BAR_SERVICE = "statusbar";
    public static final String CONNECTIVITY_SERVICE = "connectivity";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String PAC_PROXY_SERVICE = "pac_proxy";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.mainline_vcn_platform_api")
    public static final String VCN_MANAGEMENT_SERVICE = "vcn_management";
    @SystemApi
    public static final String NETD_SERVICE = "netd";
    public static final String NETWORK_STACK_SERVICE = "network_stack";
    @SuppressLint(value={"UnflaggedApi"})
    public static final String TETHERING_SERVICE = "tethering";
    @SystemApi
    @FlaggedApi(value="com.android.net.thread.platform.flags.thread_enabled_platform")
    public static final String THREAD_NETWORK_SERVICE = "thread_network";
    public static final String IPSEC_SERVICE = "ipsec";
    public static final String VPN_MANAGEMENT_SERVICE = "vpn_management";
    public static final String CONNECTIVITY_DIAGNOSTICS_SERVICE = "connectivity_diagnostics";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String TEST_NETWORK_SERVICE = "test_network";
    public static final String UPDATE_LOCK_SERVICE = "updatelock";
    public static final String NETWORKMANAGEMENT_SERVICE = "network_management";
    public static final String SLICE_SERVICE = "slice";
    public static final String NETWORK_STATS_SERVICE = "netstats";
    public static final String NETWORK_POLICY_SERVICE = "netpolicy";
    public static final String NETWORK_WATCHLIST_SERVICE = "network_watchlist";
    public static final String WIFI_SERVICE = "wifi";
    @SystemApi
    @SuppressLint(value={"ServiceName"})
    public static final String WIFI_NL80211_SERVICE = "wifinl80211";
    public static final String WIFI_P2P_SERVICE = "wifip2p";
    public static final String WIFI_AWARE_SERVICE = "wifiaware";
    @SystemApi
    public static final String WIFI_SCANNING_SERVICE = "wifiscanner";
    @SystemApi
    @Deprecated
    public static final String WIFI_RTT_SERVICE = "rttmanager";
    public static final String WIFI_RTT_RANGING_SERVICE = "wifirtt";
    @SystemApi
    @FlaggedApi(value="android.net.wifi.flags.usd")
    public static final String WIFI_USD_SERVICE = "wifi_usd";
    public static final String LOWPAN_SERVICE = "lowpan";
    @SystemApi
    public static final String ETHERNET_SERVICE = "ethernet";
    public static final String NSD_SERVICE = "servicediscovery";
    public static final String AUDIO_SERVICE = "audio";
    @SystemApi
    public static final String AUDIO_DEVICE_VOLUME_SERVICE = "audio_device_volume";
    @SystemApi
    public static final String MEDIA_TRANSCODING_SERVICE = "media_transcoding";
    public static final String AUTH_SERVICE = "auth";
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final String AUTHENTICATION_POLICY_SERVICE = "authentication_policy";
    public static final String FINGERPRINT_SERVICE = "fingerprint";
    public static final String FACE_SERVICE = "face";
    public static final String IRIS_SERVICE = "iris";
    public static final String BIOMETRIC_SERVICE = "biometric";
    public static final String MEDIA_COMMUNICATION_SERVICE = "media_communication";
    public static final String MEDIA_ROUTER_SERVICE = "media_router";
    public static final String MEDIA_SESSION_SERVICE = "media_session";
    public static final String TELEPHONY_SERVICE = "phone";
    public static final String TELEPHONY_SUBSCRIPTION_SERVICE = "telephony_subscription_service";
    public static final String TELECOM_SERVICE = "telecom";
    public static final String CARRIER_CONFIG_SERVICE = "carrier_config";
    public static final String EUICC_SERVICE = "euicc";
    @SystemApi
    public static final String EUICC_CARD_SERVICE = "euicc_card";
    public static final String MMS_SERVICE = "mms";
    public static final String CLIPBOARD_SERVICE = "clipboard";
    public static final String TEXT_CLASSIFICATION_SERVICE = "textclassification";
    public static final String SELECTION_TOOLBAR_SERVICE = "selection_toolbar";
    @SystemApi
    public static final String FONT_SERVICE = "font";
    public static final String ATTENTION_SERVICE = "attention";
    public static final String ROTATION_RESOLVER_SERVICE = "resolver";
    public static final String INPUT_METHOD_SERVICE = "input_method";
    public static final String TEXT_SERVICES_MANAGER_SERVICE = "textservices";
    public static final String APPWIDGET_SERVICE = "appwidget";
    public static final String VOICE_INTERACTION_MANAGER_SERVICE = "voiceinteraction";
    public static final String AUTOFILL_MANAGER_SERVICE = "autofill";
    public static final String TEXT_TO_SPEECH_MANAGER_SERVICE = "texttospeech";
    @SuppressLint(value={"ServiceName"})
    public static final String CONTENT_CAPTURE_MANAGER_SERVICE = "content_capture";
    @SystemApi
    @SuppressLint(value={"ServiceName"})
    public static final String TRANSLATION_MANAGER_SERVICE = "translation";
    @SystemApi
    public static final String UI_TRANSLATION_SERVICE = "ui_translation";
    @SystemApi
    public static final String CONTENT_SUGGESTIONS_SERVICE = "content_suggestions";
    @SystemApi
    public static final String APP_PREDICTION_SERVICE = "app_prediction";
    public static final String FEATURE_FLAGS_SERVICE = "feature_flags";
    @SystemApi
    public static final String SEARCH_UI_SERVICE = "search_ui";
    @SystemApi
    public static final String SMARTSPACE_SERVICE = "smartspace";
    @SystemApi
    public static final String CONTEXTUAL_SEARCH_SERVICE = "contextual_search";
    @SystemApi
    public static final String CLOUDSEARCH_SERVICE = "cloudsearch";
    public static final String SOUND_TRIGGER_SERVICE = "soundtrigger";
    public static final String SOUND_TRIGGER_MIDDLEWARE_SERVICE = "soundtrigger_middleware";
    @SystemApi
    public static final String WALLPAPER_EFFECTS_GENERATION_SERVICE = "wallpaper_effects_generation";
    @SystemApi
    public static final String MUSIC_RECOGNITION_SERVICE = "music_recognition";
    @SystemApi
    public static final String PERMISSION_SERVICE = "permission";
    public static final String LEGACY_PERMISSION_SERVICE = "legacy_permission";
    @SystemApi
    public static final String PERMISSION_CONTROLLER_SERVICE = "permission_controller";
    public static final String PERMISSION_CHECKER_SERVICE = "permission_checker";
    public static final String PERMISSION_ENFORCER_SERVICE = "permission_enforcer";
    @SystemApi
    public static final String APP_HIBERNATION_SERVICE = "app_hibernation";
    @SystemApi
    public static final String BACKUP_SERVICE = "backup";
    @SystemApi
    public static final String ROLLBACK_SERVICE = "rollback";
    @SystemApi
    public static final String REBOOT_READINESS_SERVICE = "reboot_readiness";
    public static final String DROPBOX_SERVICE = "dropbox";
    @SuppressLint(value={"ServiceName"})
    public static final String BACKGROUND_INSTALL_CONTROL_SERVICE = "background_install_control";
    @SuppressLint(value={"ServiceName"})
    public static final String BINARY_TRANSPARENCY_SERVICE = "transparency";
    @FlaggedApi(value="android.security.afl_api")
    public static final String INTRUSION_DETECTION_SERVICE = "intrusion_detection";
    @SuppressLint(value={"ServiceName"})
    public static final String DEVICE_IDLE_CONTROLLER = "deviceidle";
    @Deprecated
    @SuppressLint(value={"ServiceName"})
    public static final String POWER_WHITELIST_MANAGER = "power_whitelist";
    public static final String POWER_EXEMPTION_SERVICE = "power_exemption";
    public static final String DEVICE_POLICY_SERVICE = "device_policy";
    public static final String UI_MODE_SERVICE = "uimode";
    public static final String DOWNLOAD_SERVICE = "download";
    public static final String BATTERY_SERVICE = "batterymanager";
    public static final String NFC_SERVICE = "nfc";
    public static final String BLUETOOTH_SERVICE = "bluetooth";
    public static final String SIP_SERVICE = "sip";
    public static final String USB_SERVICE = "usb";
    public static final String ADB_SERVICE = "adb";
    public static final String SERIAL_SERVICE = "serial";
    @SystemApi
    public static final String HDMI_CONTROL_SERVICE = "hdmi_control";
    public static final String INPUT_SERVICE = "input";
    public static final String DISPLAY_SERVICE = "display";
    public static final String COLOR_DISPLAY_SERVICE = "color_display";
    public static final String USER_SERVICE = "user";
    public static final String LAUNCHER_APPS_SERVICE = "launcherapps";
    public static final String RESTRICTIONS_SERVICE = "restrictions";
    public static final String APP_OPS_SERVICE = "appops";
    public static final String ROLE_SERVICE = "role";
    public static final String CAMERA_SERVICE = "camera";
    public static final String PRINT_SERVICE = "print";
    public static final String COMPANION_DEVICE_SERVICE = "companiondevice";
    @SuppressLint(value={"ServiceName"})
    public static final String VIRTUAL_DEVICE_SERVICE = "virtualdevice";
    public static final String CONSUMER_IR_SERVICE = "consumer_ir";
    public static final String TRUST_SERVICE = "trust";
    public static final String TV_INTERACTIVE_APP_SERVICE = "tv_interactive_app";
    public static final String TV_INPUT_SERVICE = "tv_input";
    @FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
    public static final String TV_AD_SERVICE = "tv_ad";
    public static final String TV_TUNER_RESOURCE_MGR_SERVICE = "tv_tuner_resource_mgr";
    @SystemApi
    @Deprecated
    public static final String NETWORK_SCORE_SERVICE = "network_score";
    public static final String USAGE_STATS_SERVICE = "usagestats";
    public static final String JOB_SCHEDULER_SERVICE = "jobscheduler";
    @FlaggedApi(value="android.security.frp_enforcement")
    public static final String PERSISTENT_DATA_BLOCK_SERVICE = "persistent_data_block";
    @SystemApi
    public static final String OEM_LOCK_SERVICE = "oem_lock";
    public static final String MEDIA_PROJECTION_SERVICE = "media_projection";
    public static final String MIDI_SERVICE = "midi";
    public static final String RADIO_SERVICE = "broadcastradio";
    public static final String HARDWARE_PROPERTIES_SERVICE = "hardware_properties";
    public static final String THERMAL_SERVICE = "thermalservice";
    public static final String PERFORMANCE_HINT_SERVICE = "performance_hint";
    public static final String SHORTCUT_SERVICE = "shortcut";
    @SystemApi
    public static final String CONTEXTHUB_SERVICE = "contexthub";
    public static final String SYSTEM_HEALTH_SERVICE = "systemhealth";
    public static final String GATEKEEPER_SERVICE = "android.service.gatekeeper.IGateKeeperService";
    public static final String DEVICE_IDENTIFIERS_SERVICE = "device_identifiers";
    public static final String INCIDENT_SERVICE = "incident";
    public static final String INCIDENT_COMPANION_SERVICE = "incidentcompanion";
    public static final String STATS_MANAGER_SERVICE = "statsmanager";
    public static final String STATS_COMPANION_SERVICE = "statscompanion";
    public static final String STATS_BOOTSTRAP_ATOM_SERVICE = "statsbootstrap";
    @SystemApi
    public static final String STATS_MANAGER = "stats";
    public static final String PLATFORM_COMPAT_SERVICE = "platform_compat";
    public static final String PLATFORM_COMPAT_NATIVE_SERVICE = "platform_compat_native";
    public static final String BUGREPORT_SERVICE = "bugreport";
    public static final String OVERLAY_SERVICE = "overlay";
    public static final String RESOURCES_SERVICE = "resources";
    public static final String IDMAP_SERVICE = "idmap";
    @SystemApi
    public static final String VR_SERVICE = "vrmanager";
    public static final String CROSS_PROFILE_APPS_SERVICE = "crossprofileapps";
    @SystemApi
    public static final String SECURE_ELEMENT_SERVICE = "secure_element";
    public static final String TIME_DETECTOR_SERVICE = "time_detector";
    public static final String TIME_ZONE_DETECTOR_SERVICE = "time_zone_detector";
    @SystemApi
    @SuppressLint(value={"ServiceName"})
    public static final String TIME_MANAGER_SERVICE = "time_manager";
    public static final String APP_BINDING_SERVICE = "app_binding";
    public static final String TELEPHONY_IMS_SERVICE = "telephony_ims";
    @SystemApi
    public static final String SYSTEM_CONFIG_SERVICE = "system_config";
    public static final String TELEPHONY_RCS_MESSAGE_SERVICE = "ircsmessage";
    public static final String DYNAMIC_SYSTEM_SERVICE = "dynamic_system";
    public static final String BLOB_STORE_SERVICE = "blob_store";
    public static final String TELEPHONY_REGISTRY_SERVICE = "telephony_registry";
    @SystemApi
    @SuppressLint(value={"ServiceName"})
    public static final String BATTERY_STATS_SERVICE = "batterystats";
    public static final String APP_SEARCH_SERVICE = "app_search";
    @FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
    public static final String APP_FUNCTION_SERVICE = "app_function";
    @SystemApi
    public static final String APP_INTEGRITY_SERVICE = "app_integrity";
    public static final String DATA_LOADER_MANAGER_SERVICE = "dataloader_manager";
    public static final String INCREMENTAL_SERVICE = "incremental";
    public static final String ATTESTATION_VERIFICATION_SERVICE = "attestation_verification";
    @FlaggedApi(value="android.security.aapm_api")
    public static final String ADVANCED_PROTECTION_SERVICE = "advanced_protection";
    public static final String FILE_INTEGRITY_SERVICE = "file_integrity";
    public static final String REMOTE_PROVISIONING_SERVICE = "remote_provisioning";
    public static final String LIGHTS_SERVICE = "lights";
    @SystemApi
    public static final String UWB_SERVICE = "uwb";
    @SystemApi
    @FlaggedApi(value="com.android.ranging.flags.ranging_stack_enabled")
    public static final String RANGING_SERVICE = "ranging";
    public static final String DREAM_SERVICE = "dream";
    public static final String SMS_SERVICE = "sms";
    public static final String PEOPLE_SERVICE = "people";
    public static final String DEVICE_STATE_SERVICE = "device_state";
    public static final String MEDIA_METRICS_SERVICE = "media_metrics";
    public static final String SPEECH_RECOGNITION_SERVICE = "speech_recognition";
    public static final String GAME_SERVICE = "game";
    public static final String DOMAIN_VERIFICATION_SERVICE = "domain_verification";
    public static final String DISPLAY_HASH_SERVICE = "display_hash";
    public static final String LOCALE_SERVICE = "locale";
    @SystemApi
    public static final String SAFETY_CENTER_SERVICE = "safety_center";
    @SystemApi
    public static final String NEARBY_SERVICE = "nearby";
    public static final String REMOTE_AUTH_SERVICE = "remote_auth";
    @SystemApi
    public static final String AMBIENT_CONTEXT_SERVICE = "ambient_context";
    @SystemApi
    public static final String WEARABLE_SENSING_SERVICE = "wearable_sensing";
    @SystemApi
    @FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence")
    public static final String ON_DEVICE_INTELLIGENCE_SERVICE = "on_device_intelligence";
    public static final String HEALTHCONNECT_SERVICE = "healthconnect";
    public static final String CREDENTIAL_SERVICE = "credential";
    public static final String DEVICE_LOCK_SERVICE = "device_lock";
    @SystemApi
    public static final String VIRTUALIZATION_SERVICE = "virtualization";
    public static final String GRAMMATICAL_INFLECTION_SERVICE = "grammatical_inflection";
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_state_change_listener")
    public static final String SATELLITE_SERVICE = "satellite";
    @SystemApi
    public static final String SHARED_CONNECTIVITY_SERVICE = "shared_connectivity";
    @FlaggedApi(value="android.os.security_state_service")
    public static final String SECURITY_STATE_SERVICE = "security_state";
    @SystemApi
    @FlaggedApi(value="android.permission.flags.enhanced_confirmation_mode_apis_enabled")
    public static final String ECM_ENHANCED_CONFIRMATION_SERVICE = "ecm_enhanced_confirmation";
    public static final String SENSITIVE_CONTENT_PROTECTION_SERVICE = "sensitive_content_protection_service";
    @FlaggedApi(value="android.provider.user_keys")
    public static final String CONTACT_KEYS_SERVICE = "contact_keys";
    @FlaggedApi(value="android.os.telemetry_apis_framework_initialization")
    public static final String PROFILING_SERVICE = "profiling";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.webkit.update_service_ipc_wrapper")
    @SuppressLint(value={"ServiceName"})
    public static final String WEBVIEW_UPDATE_SERVICE = "webviewupdate";
    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_mainline_blocked_numbers_manager")
    public static final String BLOCKED_NUMBERS_SERVICE = "blocked_numbers";
    public static final String PROTOLOG_CONFIGURATION_SERVICE = "protolog_configuration";
    @SystemApi
    @FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
    public static final String SUPERVISION_SERVICE = "supervision";
    @FlaggedApi(value="android.media.tv.flags.media_quality_fw")
    public static final String MEDIA_QUALITY_SERVICE = "media_quality";
    public static final String DYNAMIC_INSTRUMENTATION_SERVICE = "dynamic_instrumentation";
    public static final int CONTEXT_INCLUDE_CODE = 1;
    public static final int CONTEXT_IGNORE_SECURITY = 2;
    public static final int CONTEXT_RESTRICTED = 4;
    public static final int CONTEXT_DEVICE_PROTECTED_STORAGE = 8;
    public static final int CONTEXT_CREDENTIAL_PROTECTED_STORAGE = 16;
    public static final int CONTEXT_REGISTER_PACKAGE = 0x40000000;

    public abstract AssetManager getAssets();

    public abstract Resources getResources();

    public abstract PackageManager getPackageManager();

    public abstract ContentResolver getContentResolver();

    public abstract Looper getMainLooper();

    public Executor getMainExecutor() {
        return new HandlerExecutor(new Handler(this.getMainLooper()));
    }

    public abstract Context getApplicationContext();

    public int getNextAutofillId() {
        if (sLastAutofillId == 0x3FFFFFFE) {
            sLastAutofillId = -1;
        }
        return ++sLastAutofillId;
    }

    public void registerComponentCallbacks(ComponentCallbacks callback) {
        this.getApplicationContext().registerComponentCallbacks(callback);
    }

    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        this.getApplicationContext().unregisterComponentCallbacks(callback);
    }

    @NonNull
    @RavenwoodKeep
    public CharSequence getText(int resId) {
        return this.getResources().getText(resId);
    }

    @NonNull
    @RavenwoodKeep
    public String getString(int resId) {
        return this.getResources().getString(resId);
    }

    @NonNull
    @RavenwoodKeep
    public String getString(int resId, Object ... formatArgs) {
        return this.getResources().getString(resId, formatArgs);
    }

    @RavenwoodKeep
    public int getColor(int id2) {
        return this.getResources().getColor(id2, this.getTheme());
    }

    @Nullable
    public Drawable getDrawable(int id2) {
        return this.getResources().getDrawable(id2, this.getTheme());
    }

    @NonNull
    public ColorStateList getColorStateList(int id2) {
        return this.getResources().getColorStateList(id2, this.getTheme());
    }

    public abstract void setTheme(int var1);

    @UnsupportedAppUsage
    public int getThemeResId() {
        return 0;
    }

    @ViewDebug.ExportedProperty(deepExport=true)
    public abstract Resources.Theme getTheme();

    @NonNull
    @RavenwoodKeep
    public TypedArray obtainStyledAttributes(@NonNull int[] attrs) {
        return this.getTheme().obtainStyledAttributes(attrs);
    }

    @NonNull
    @RavenwoodKeep
    public TypedArray obtainStyledAttributes(int resid, @NonNull int[] attrs) throws Resources.NotFoundException {
        return this.getTheme().obtainStyledAttributes(resid, attrs);
    }

    @NonNull
    @RavenwoodKeep
    public TypedArray obtainStyledAttributes(@Nullable AttributeSet set, @NonNull int[] attrs) {
        return this.getTheme().obtainStyledAttributes(set, attrs, 0, 0);
    }

    @NonNull
    @RavenwoodKeep
    public TypedArray obtainStyledAttributes(@Nullable AttributeSet set, @NonNull int[] attrs, int defStyleAttr, int defStyleRes) {
        return this.getTheme().obtainStyledAttributes(set, attrs, defStyleAttr, defStyleRes);
    }

    public abstract ClassLoader getClassLoader();

    public abstract String getPackageName();

    @UnsupportedAppUsage
    public abstract String getBasePackageName();

    @NonNull
    public String getOpPackageName() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public String getAttributionTag() {
        return null;
    }

    @NonNull
    public AttributionSource getAttributionSource() {
        return null;
    }

    @Deprecated
    @Nullable
    public String getFeatureId() {
        return this.getAttributionTag();
    }

    @Nullable
    public ContextParams getParams() {
        return null;
    }

    public abstract ApplicationInfo getApplicationInfo();

    public abstract String getPackageResourcePath();

    public abstract String getPackageCodePath();

    @Deprecated
    @UnsupportedAppUsage
    public File getSharedPrefsFile(String name) {
        return this.getSharedPreferencesPath(name);
    }

    public abstract SharedPreferences getSharedPreferences(String var1, int var2);

    public abstract SharedPreferences getSharedPreferences(File var1, int var2);

    public abstract boolean moveSharedPreferencesFrom(Context var1, String var2);

    public abstract boolean deleteSharedPreferences(String var1);

    public abstract void reloadSharedPreferences();

    public abstract FileInputStream openFileInput(String var1) throws FileNotFoundException;

    public abstract FileOutputStream openFileOutput(String var1, int var2) throws FileNotFoundException;

    public abstract boolean deleteFile(String var1);

    public abstract File getFileStreamPath(String var1);

    public abstract File getSharedPreferencesPath(String var1);

    public abstract File getDataDir();

    public abstract File getFilesDir();

    @NonNull
    public File getCrateDir(@NonNull String crateId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract File getNoBackupFilesDir();

    @Nullable
    public abstract File getExternalFilesDir(@Nullable String var1);

    public abstract File[] getExternalFilesDirs(String var1);

    public abstract File getObbDir();

    public abstract File[] getObbDirs();

    public abstract File getCacheDir();

    public abstract File getCodeCacheDir();

    @Nullable
    public abstract File getExternalCacheDir();

    @SystemApi
    @Nullable
    public abstract File getPreloadsFileCache();

    public abstract File[] getExternalCacheDirs();

    @Deprecated
    public abstract File[] getExternalMediaDirs();

    public abstract String[] fileList();

    public abstract File getDir(String var1, int var2);

    public abstract SQLiteDatabase openOrCreateDatabase(String var1, int var2, SQLiteDatabase.CursorFactory var3);

    public abstract SQLiteDatabase openOrCreateDatabase(String var1, int var2, SQLiteDatabase.CursorFactory var3, @Nullable DatabaseErrorHandler var4);

    public abstract boolean moveDatabaseFrom(Context var1, String var2);

    public abstract boolean deleteDatabase(String var1);

    public abstract File getDatabasePath(String var1);

    public abstract String[] databaseList();

    @Deprecated
    public abstract Drawable getWallpaper();

    @Deprecated
    public abstract Drawable peekWallpaper();

    @Deprecated
    public abstract int getWallpaperDesiredMinimumWidth();

    @Deprecated
    public abstract int getWallpaperDesiredMinimumHeight();

    @Deprecated
    public abstract void setWallpaper(Bitmap var1) throws IOException;

    @Deprecated
    public abstract void setWallpaper(InputStream var1) throws IOException;

    @Deprecated
    public abstract void clearWallpaper() throws IOException;

    public abstract void startActivity(@RequiresPermission Intent var1);

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public void startActivityAsUser(@RequiresPermission @NonNull Intent intent, @NonNull UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void startActivity(@RequiresPermission Intent var1, @Nullable Bundle var2);

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public void startActivityAsUser(@RequiresPermission @NonNull Intent intent, @Nullable Bundle options, @NonNull UserHandle userId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @UnsupportedAppUsage
    public void startActivityForResult(@NonNull String who, Intent intent, int requestCode, @Nullable Bundle options) {
        throw new RuntimeException("This method is only implemented for Activity-based Contexts. Check canStartActivityForResult() before calling.");
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean canStartActivityForResult() {
        return false;
    }

    public abstract void startActivities(@RequiresPermission Intent[] var1);

    public abstract void startActivities(@RequiresPermission Intent[] var1, Bundle var2);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public int startActivitiesAsUser(Intent[] intents, Bundle options, UserHandle userHandle) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void startIntentSender(IntentSender var1, @Nullable Intent var2, int var3, int var4, int var5) throws IntentSender.SendIntentException;

    public abstract void startIntentSender(IntentSender var1, @Nullable Intent var2, int var3, int var4, int var5, @Nullable Bundle var6) throws IntentSender.SendIntentException;

    public abstract void sendBroadcast(@RequiresPermission Intent var1);

    public abstract void sendBroadcast(@RequiresPermission Intent var1, @Nullable String var2);

    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String[] excludedPermissions) {
        this.sendBroadcastMultiplePermissions(intent, receiverPermissions, excludedPermissions, null);
    }

    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String[] excludedPermissions, @Nullable String[] excludedPackages) {
        this.sendBroadcastMultiplePermissions(intent, receiverPermissions, excludedPermissions, excludedPackages, null);
    }

    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String[] excludedPermissions, @Nullable String[] excludedPackages, @Nullable BroadcastOptions options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SystemApi
    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable BroadcastOptions options) {
        this.sendBroadcastMultiplePermissions(intent, receiverPermissions, options == null ? null : options.toBundle());
    }

    public void sendBroadcastWithMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions) {
        this.sendBroadcastMultiplePermissions(intent, receiverPermissions);
    }

    public abstract void sendBroadcastAsUserMultiplePermissions(Intent var1, UserHandle var2, String[] var3);

    public void sendBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @UnsupportedAppUsage
    public abstract void sendBroadcast(Intent var1, String var2, int var3);

    public abstract void sendOrderedBroadcast(@RequiresPermission Intent var1, @Nullable String var2);

    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void sendOrderedBroadcast(@RequiresPermission @NonNull Intent var1, @Nullable String var2, @Nullable BroadcastReceiver var3, @Nullable Handler var4, int var5, @Nullable String var6, @Nullable Bundle var7);

    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @UnsupportedAppUsage
    public abstract void sendOrderedBroadcast(Intent var1, String var2, int var3, BroadcastReceiver var4, Handler var5, int var6, String var7, Bundle var8);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract void sendBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract void sendBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, @Nullable String var3);

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract void sendBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, @Nullable String var3, @Nullable Bundle var4);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract void sendBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, @Nullable String var3, int var4);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract void sendOrderedBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, @Nullable String var3, BroadcastReceiver var4, @Nullable Handler var5, int var6, @Nullable String var7, @Nullable Bundle var8);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract void sendOrderedBroadcastAsUser(Intent var1, UserHandle var2, @Nullable String var3, int var4, BroadcastReceiver var5, @Nullable Handler var6, int var7, @Nullable String var8, @Nullable Bundle var9);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @UnsupportedAppUsage
    public abstract void sendOrderedBroadcastAsUser(Intent var1, UserHandle var2, @Nullable String var3, int var4, @Nullable Bundle var5, BroadcastReceiver var6, @Nullable Handler var7, int var8, @Nullable String var9, @Nullable Bundle var10);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public void sendOrderedBroadcastAsUserMultiplePermissions(Intent intent, UserHandle user, String[] receiverPermissions, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void sendOrderedBroadcast(@RequiresPermission @NonNull Intent intent, int initialCode, @Nullable String receiverPermission, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, @Nullable String initialData, @Nullable Bundle initialExtras, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SystemApi
    @FlaggedApi(value="android.os.ordered_broadcast_multiple_permissions")
    public void sendOrderedBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BROADCAST_STICKY")
    public abstract void sendStickyBroadcast(@RequiresPermission Intent var1);

    @Deprecated
    @RequiresPermission(value="android.permission.BROADCAST_STICKY")
    public void sendStickyBroadcast(@RequiresPermission @NonNull Intent intent, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BROADCAST_STICKY")
    public abstract void sendStickyOrderedBroadcast(@RequiresPermission Intent var1, BroadcastReceiver var2, @Nullable Handler var3, int var4, @Nullable String var5, @Nullable Bundle var6);

    @Deprecated
    @RequiresPermission(value="android.permission.BROADCAST_STICKY")
    public abstract void removeStickyBroadcast(@RequiresPermission Intent var1);

    @Deprecated
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.BROADCAST_STICKY"})
    public abstract void sendStickyBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2);

    @Deprecated
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.BROADCAST_STICKY"})
    public abstract void sendStickyBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, Bundle var3);

    @Deprecated
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.BROADCAST_STICKY"})
    public abstract void sendStickyOrderedBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2, BroadcastReceiver var3, @Nullable Handler var4, int var5, @Nullable String var6, @Nullable Bundle var7);

    @Deprecated
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.BROADCAST_STICKY"})
    public abstract void removeStickyBroadcastAsUser(@RequiresPermission Intent var1, UserHandle var2);

    @Nullable
    public abstract Intent registerReceiver(@Nullable BroadcastReceiver var1, IntentFilter var2);

    @Nullable
    public abstract Intent registerReceiver(@Nullable BroadcastReceiver var1, IntentFilter var2, int var3);

    @Nullable
    public abstract Intent registerReceiver(BroadcastReceiver var1, IntentFilter var2, @Nullable String var3, @Nullable Handler var4);

    @Nullable
    public abstract Intent registerReceiver(BroadcastReceiver var1, IntentFilter var2, @Nullable String var3, @Nullable Handler var4, int var5);

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public Intent registerReceiverForAllUsers(@Nullable BroadcastReceiver receiver, @NonNull IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SystemApi
    @SuppressLint(value={"IntentBuilderName"})
    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public Intent registerReceiverForAllUsers(@Nullable BroadcastReceiver receiver, @NonNull IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler, int flags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    @UnsupportedAppUsage
    public abstract Intent registerReceiverAsUser(BroadcastReceiver var1, UserHandle var2, IntentFilter var3, @Nullable String var4, @Nullable Handler var5);

    @SuppressLint(value={"IntentBuilderName"})
    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    @UnsupportedAppUsage
    public abstract Intent registerReceiverAsUser(BroadcastReceiver var1, UserHandle var2, IntentFilter var3, @Nullable String var4, @Nullable Handler var5, int var6);

    public abstract void unregisterReceiver(BroadcastReceiver var1);

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public List<IntentFilter> getRegisteredIntentFilters(@NonNull BroadcastReceiver receiver) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public abstract ComponentName startService(Intent var1);

    @Nullable
    public abstract ComponentName startForegroundService(Intent var1);

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract ComponentName startForegroundServiceAsUser(Intent var1, UserHandle var2);

    public abstract boolean stopService(Intent var1);

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @UnsupportedAppUsage
    public abstract ComponentName startServiceAsUser(Intent var1, UserHandle var2);

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public abstract boolean stopServiceAsUser(Intent var1, UserHandle var2);

    public abstract boolean bindService(@RequiresPermission @NonNull Intent var1, @NonNull ServiceConnection var2, int var3);

    public boolean bindService(@RequiresPermission @NonNull Intent service, @NonNull ServiceConnection conn, @NonNull BindServiceFlags flags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean bindService(@RequiresPermission @NonNull Intent service, int flags, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean bindService(@RequiresPermission @NonNull Intent service, @NonNull BindServiceFlags flags, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean bindIsolatedService(@RequiresPermission @NonNull Intent service, int flags, @NonNull String instanceName, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean bindIsolatedService(@RequiresPermission @NonNull Intent service, @NonNull BindServiceFlags flags, @NonNull String instanceName, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_PROFILES"}, conditional=true)
    public boolean bindServiceAsUser(@NonNull @RequiresPermission Intent service, @NonNull ServiceConnection conn, int flags, @NonNull UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_PROFILES"}, conditional=true)
    public boolean bindServiceAsUser(@NonNull @RequiresPermission Intent service, @NonNull ServiceConnection conn, @NonNull BindServiceFlags flags, @NonNull UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_PROFILES"}, conditional=true)
    @UnsupportedAppUsage(trackingBug=136728678L)
    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, int flags, Handler handler, UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_PROFILES"}, conditional=true)
    @UnsupportedAppUsage(trackingBug=136728678L)
    public boolean bindServiceAsUser(@NonNull Intent service, @NonNull ServiceConnection conn, @NonNull BindServiceFlags flags, @NonNull Handler handler, @NonNull UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void updateServiceGroup(@NonNull ServiceConnection conn, int group, int importance) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void unbindService(@NonNull ServiceConnection var1);

    public abstract boolean startInstrumentation(@NonNull ComponentName var1, @Nullable String var2, @Nullable Bundle var3);

    public abstract Object getSystemService(@NonNull String var1);

    @RavenwoodKeep
    public <T> T getSystemService(@NonNull Class<T> serviceClass) {
        String serviceName = this.getSystemServiceName(serviceClass);
        return (T)(serviceName != null ? this.getSystemService(serviceName) : null);
    }

    @Nullable
    public abstract String getSystemServiceName(@NonNull Class<?> var1);

    @PermissionMethod
    public abstract int checkPermission(@NonNull @PermissionName String var1, int var2, int var3);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public abstract int checkPermission(@NonNull String var1, int var2, int var3, IBinder var4);

    @PermissionMethod
    public abstract int checkCallingPermission(@NonNull @PermissionName String var1);

    @PermissionMethod(orSelf=true)
    public abstract int checkCallingOrSelfPermission(@NonNull @PermissionName String var1);

    public abstract int checkSelfPermission(@NonNull String var1);

    @PermissionMethod
    public abstract void enforcePermission(@NonNull @PermissionName String var1, int var2, int var3, @Nullable String var4);

    @PermissionMethod
    public abstract void enforceCallingPermission(@NonNull @PermissionName String var1, @Nullable String var2);

    @PermissionMethod(orSelf=true)
    public abstract void enforceCallingOrSelfPermission(@NonNull @PermissionName String var1, @Nullable String var2);

    public int getPermissionRequestState(@NonNull String permission2) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void grantUriPermission(String var1, Uri var2, int var3);

    public abstract void revokeUriPermission(Uri var1, int var2);

    public abstract void revokeUriPermission(String var1, Uri var2, int var3);

    public abstract int checkUriPermission(Uri var1, int var2, int var3, int var4);

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public int checkContentUriPermissionFull(@NonNull Uri uri, int pid, int uid, int modeFlags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public int[] checkUriPermissions(@NonNull List<Uri> uris, int pid, int uid, int modeFlags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract int checkUriPermission(Uri var1, int var2, int var3, int var4, IBinder var5);

    public abstract int checkCallingUriPermission(Uri var1, int var2);

    @NonNull
    public int[] checkCallingUriPermissions(@NonNull List<Uri> uris, int modeFlags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract int checkCallingOrSelfUriPermission(Uri var1, int var2);

    @NonNull
    public int[] checkCallingOrSelfUriPermissions(@NonNull List<Uri> uris, int modeFlags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract int checkUriPermission(@Nullable Uri var1, @Nullable String var2, @Nullable String var3, int var4, int var5, int var6);

    public abstract void enforceUriPermission(Uri var1, int var2, int var3, int var4, String var5);

    public abstract void enforceCallingUriPermission(Uri var1, int var2, String var3);

    public abstract void enforceCallingOrSelfUriPermission(Uri var1, int var2, String var3);

    public abstract void enforceUriPermission(@Nullable Uri var1, @Nullable String var2, @Nullable String var3, int var4, int var5, int var6, @Nullable String var7);

    public void revokeSelfPermissionOnKill(@NonNull String permName) {
        this.revokeSelfPermissionsOnKill(Collections.singletonList(permName));
    }

    public void revokeSelfPermissionsOnKill(@NonNull Collection<String> permissions) {
        throw new AbstractMethodError("Must be overridden in implementing class");
    }

    public abstract Context createPackageContext(String var1, int var2) throws PackageManager.NameNotFoundException;

    @SystemApi
    @NonNull
    public Context createPackageContextAsUser(@NonNull String packageName, int flags, @NonNull UserHandle user) throws PackageManager.NameNotFoundException {
        if (_Original_Build.IS_ENG) {
            throw new IllegalStateException("createPackageContextAsUser not overridden!");
        }
        return this;
    }

    @SystemApi
    @NonNull
    public Context createContextAsUser(@NonNull UserHandle user, int flags) {
        if (_Original_Build.IS_ENG) {
            throw new IllegalStateException("createContextAsUser not overridden!");
        }
        return this;
    }

    @UnsupportedAppUsage
    public abstract Context createApplicationContext(ApplicationInfo var1, int var2) throws PackageManager.NameNotFoundException;

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public Context createContextForSdkInSandbox(@NonNull ApplicationInfo sdkInfo, int flags) throws PackageManager.NameNotFoundException {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract Context createContextForSplit(String var1) throws PackageManager.NameNotFoundException;

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public UserHandle getUser() {
        return Process.myUserHandle();
    }

    @UnsupportedAppUsage
    public int getUserId() {
        return UserHandle.myUserId();
    }

    public abstract Context createConfigurationContext(@NonNull Configuration var1);

    public abstract Context createDisplayContext(@NonNull Display var1);

    @NonNull
    public Context createDeviceContext(int deviceId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public Context createWindowContext(int type, @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public Context createWindowContext(@NonNull Display display, int type, @SuppressLint(value={"NullableCollection"}) @Nullable Bundle options) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public Context createContext(@NonNull ContextParams contextParams) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public Context createAttributionContext(@Nullable String attributionTag) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Deprecated
    @NonNull
    public Context createFeatureContext(@Nullable String attributionTag) {
        return this.createContext(new ContextParams.Builder(this.getParams()).setAttributionTag(attributionTag).build());
    }

    public abstract Context createDeviceProtectedStorageContext();

    @SystemApi
    public abstract Context createCredentialProtectedStorageContext();

    @NonNull
    public Context createTokenContext(@NonNull IBinder token, @NonNull Display display) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract DisplayAdjustments getDisplayAdjustments(int var1);

    @NonNull
    public Display getDisplay() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public Display getDisplayNoVerify() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract int getDisplayId();

    public int getAssociatedDisplayId() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SuppressLint(value={"UnflaggedApi"})
    public abstract void updateDisplay(int var1);

    public void updateDeviceId(int deviceId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public int getDeviceId() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void registerDeviceIdChangeListener(@NonNull Executor executor, @NonNull IntConsumer listener) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void unregisterDeviceIdChangeListener(@NonNull IntConsumer listener) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean isRestricted() {
        return false;
    }

    public abstract boolean isDeviceProtectedStorage();

    @SystemApi
    public abstract boolean isCredentialProtectedStorage();

    public abstract boolean canLoadUnsafeResources();

    @Nullable
    public IBinder getActivityToken() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public IBinder getWindowContextToken() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public static IBinder getToken(@NonNull Context context) {
        return context.getActivityToken() != null ? context.getActivityToken() : context.getWindowContextToken();
    }

    @Nullable
    public IServiceConnection getServiceDispatcher(ServiceConnection conn, Handler handler, long flags) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public IApplicationThread getIApplicationThread() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public IBinder getProcessToken() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public Handler getMainThreadHandler() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public AutofillManager.AutofillClient getAutofillClient() {
        return null;
    }

    public void setAutofillClient(AutofillManager.AutofillClient client) {
    }

    @Nullable
    public ContentCaptureManager.ContentCaptureClient getContentCaptureClient() {
        return null;
    }

    public boolean isAutofillCompatibilityEnabled() {
        AutofillOptions options = this.getAutofillOptions();
        return options != null && options.compatModeEnabled;
    }

    @Nullable
    public AutofillOptions getAutofillOptions() {
        return null;
    }

    public void setAutofillOptions(@Nullable AutofillOptions options) {
    }

    @Nullable
    public ContentCaptureOptions getContentCaptureOptions() {
        return null;
    }

    public void setContentCaptureOptions(@Nullable ContentCaptureOptions options) {
    }

    public void assertRuntimeOverlayThemable() {
        if (this.getResources() == Resources.getSystem()) {
            throw new IllegalArgumentException("Non-UI context used to display UI; get a UI context from ActivityThread#getSystemUiContext()");
        }
    }

    public boolean isUiContext() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void destroy() {
    }

    public boolean isConfigurationContext() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @RequiresPermission(value="android.permission.BROADCAST_CLOSE_SYSTEM_DIALOGS")
    public void closeSystemDialogs() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public ClassLoader getFrameworkClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreatePackageOptions {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionRequestState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegisterReceiverFlags {
    }

    public static class BindServiceFlags {
        private final long mValue;

        private BindServiceFlags(long value) {
            this.mValue = value;
        }

        public long getValue() {
            return this.mValue;
        }

        @NonNull
        public static BindServiceFlags of(long value) {
            if ((value & Integer.toUnsignedLong(Integer.MIN_VALUE)) != 0L) {
                throw new IllegalArgumentException("BIND_EXTERNAL_SERVICE is deprecated. Use BIND_EXTERNAL_SERVICE_LONG instead");
            }
            return new BindServiceFlags(value);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BindServiceFlagsLongBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BindServiceFlagsBits {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatabaseMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreferencesMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FileMode {
    }
}

