/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.camera;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.camera.IVirtualCameraCallback;
import android.companion.virtual.camera.VirtualCameraCallback;
import android.companion.virtual.camera.VirtualCameraStreamConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.view.Surface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@SystemApi
public class VirtualCameraConfig
implements Parcelable {
    private static final int LENS_FACING_UNKNOWN = -1;
    public static final int SENSOR_ORIENTATION_0 = 0;
    public static final int SENSOR_ORIENTATION_90 = 90;
    public static final int SENSOR_ORIENTATION_180 = 180;
    public static final int SENSOR_ORIENTATION_270 = 270;
    private final String mName;
    private final Set<VirtualCameraStreamConfig> mStreamConfigurations;
    private final IVirtualCameraCallback mCallback;
    private final int mSensorOrientation;
    private final int mLensFacing;
    @NonNull
    public static final Parcelable.Creator<VirtualCameraConfig> CREATOR = new Parcelable.Creator<VirtualCameraConfig>(){

        @Override
        public VirtualCameraConfig createFromParcel(Parcel in) {
            return new VirtualCameraConfig(in);
        }

        public VirtualCameraConfig[] newArray(int size) {
            return new VirtualCameraConfig[size];
        }
    };

    private VirtualCameraConfig(@NonNull String name, @NonNull Set<VirtualCameraStreamConfig> streamConfigurations, @NonNull Executor executor, @NonNull VirtualCameraCallback callback, int sensorOrientation, int lensFacing) {
        this.mName = Objects.requireNonNull(name, "Missing name");
        if (lensFacing == -1) {
            throw new IllegalArgumentException("Lens facing must be set");
        }
        this.mLensFacing = lensFacing;
        this.mStreamConfigurations = Set.copyOf((Collection)Objects.requireNonNull(streamConfigurations, "Missing stream configurations"));
        if (this.mStreamConfigurations.isEmpty()) {
            throw new IllegalArgumentException("At least one stream configuration is needed to create a virtual camera.");
        }
        this.mCallback = new VirtualCameraCallbackInternal(Objects.requireNonNull(callback, "Missing callback"), Objects.requireNonNull(executor, "Missing callback executor"));
        this.mSensorOrientation = sensorOrientation;
    }

    private VirtualCameraConfig(@NonNull Parcel in) {
        this.mName = in.readString8();
        this.mCallback = IVirtualCameraCallback.Stub.asInterface(in.readStrongBinder());
        this.mStreamConfigurations = Set.of(in.readParcelableArray(VirtualCameraStreamConfig.class.getClassLoader(), VirtualCameraStreamConfig.class));
        this.mSensorOrientation = in.readInt();
        this.mLensFacing = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mName);
        dest.writeStrongInterface(this.mCallback);
        dest.writeParcelableArray(this.mStreamConfigurations.toArray(new VirtualCameraStreamConfig[0]), flags);
        dest.writeInt(this.mSensorOrientation);
        dest.writeInt(this.mLensFacing);
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public Set<VirtualCameraStreamConfig> getStreamConfigs() {
        return this.mStreamConfigurations;
    }

    @NonNull
    public IVirtualCameraCallback getCallback() {
        return this.mCallback;
    }

    public int getSensorOrientation() {
        return this.mSensorOrientation;
    }

    public int getLensFacing() {
        return this.mLensFacing;
    }

    private static boolean isFormatSupported(int format) {
        boolean bl;
        switch (format) {
            case 1: 
            case 35: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static class VirtualCameraCallbackInternal
    extends IVirtualCameraCallback.Stub {
        private final VirtualCameraCallback mCallback;
        private final Executor mExecutor;

        private VirtualCameraCallbackInternal(VirtualCameraCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onStreamConfigured(int streamId, Surface surface, int width, int height, int format) {
            this.mExecutor.execute(() -> this.mCallback.onStreamConfigured(streamId, surface, width, height, format));
        }

        @Override
        public void onProcessCaptureRequest(int streamId, long frameId) {
            this.mExecutor.execute(() -> this.mCallback.onProcessCaptureRequest(streamId, frameId));
        }

        @Override
        public void onStreamClosed(int streamId) {
            this.mExecutor.execute(() -> this.mCallback.onStreamClosed(streamId));
        }
    }

    public static class Builder {
        private final String mName;
        private final ArraySet<VirtualCameraStreamConfig> mStreamConfigurations = new ArraySet();
        private Executor mCallbackExecutor;
        private VirtualCameraCallback mCallback;
        private int mSensorOrientation = 0;
        private int mLensFacing = -1;

        public Builder(@NonNull String name) {
            this.mName = Objects.requireNonNull(name, "Name cannot be null");
        }

        @NonNull
        public Builder addStreamConfig(int width, int height, int format, int maximumFramesPerSecond) {
            if (width <= 0) {
                throw new IllegalArgumentException("Invalid width passed for stream config: " + width + ", must be greater than 0");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Invalid height passed for stream config: " + height + ", must be greater than 0");
            }
            if (!VirtualCameraConfig.isFormatSupported(format)) {
                throw new IllegalArgumentException("Invalid format passed for stream config: " + format);
            }
            if (maximumFramesPerSecond <= 0 || maximumFramesPerSecond > 60) {
                throw new IllegalArgumentException("Invalid maximumFramesPerSecond, must be greater than 0 and less than 60");
            }
            this.mStreamConfigurations.add(new VirtualCameraStreamConfig(width, height, format, maximumFramesPerSecond));
            return this;
        }

        @NonNull
        public Builder setSensorOrientation(int sensorOrientation) {
            if (sensorOrientation != 0 && sensorOrientation != 90 && sensorOrientation != 180 && sensorOrientation != 270) {
                throw new IllegalArgumentException("Invalid sensor orientation: " + sensorOrientation);
            }
            this.mSensorOrientation = sensorOrientation;
            return this;
        }

        @NonNull
        public Builder setLensFacing(int lensFacing) {
            if (lensFacing != 1 && lensFacing != 0) {
                throw new IllegalArgumentException("Unsupported lens facing: " + lensFacing);
            }
            this.mLensFacing = lensFacing;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setVirtualCameraCallback(@NonNull Executor executor, @NonNull VirtualCameraCallback callback) {
            this.mCallbackExecutor = Objects.requireNonNull(executor);
            this.mCallback = Objects.requireNonNull(callback);
            return this;
        }

        @NonNull
        public VirtualCameraConfig build() {
            return new VirtualCameraConfig(this.mName, this.mStreamConfigurations, this.mCallbackExecutor, this.mCallback, this.mSensorOrientation, this.mLensFacing);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SensorOrientation {
    }
}

