/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.camera;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface IVirtualCameraCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.camera.IVirtualCameraCallback";

    public void onStreamConfigured(int var1, Surface var2, int var3, int var4, int var5) throws RemoteException;

    public void onProcessCaptureRequest(int var1, long var2) throws RemoteException;

    public void onStreamClosed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualCameraCallback {
        static final int TRANSACTION_onStreamConfigured = 1;
        static final int TRANSACTION_onProcessCaptureRequest = 2;
        static final int TRANSACTION_onStreamClosed = 3;

        public Stub() {
            this.attachInterface(this, IVirtualCameraCallback.DESCRIPTOR);
        }

        public static IVirtualCameraCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualCameraCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualCameraCallback) {
                return (IVirtualCameraCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStreamConfigured";
                }
                case 2: {
                    return "onProcessCaptureRequest";
                }
                case 3: {
                    return "onStreamClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualCameraCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStreamConfigured(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onProcessCaptureRequest(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStreamClosed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IVirtualCameraCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualCameraCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStreamConfigured(int streamId, Surface surface, int width, int height, int format) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualCameraCallback.DESCRIPTOR);
                    _data.writeInt(streamId);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(format);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProcessCaptureRequest(int streamId, long frameId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualCameraCallback.DESCRIPTOR);
                    _data.writeInt(streamId);
                    _data.writeLong(frameId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStreamClosed(int streamId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualCameraCallback.DESCRIPTOR);
                    _data.writeInt(streamId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualCameraCallback {
        @Override
        public void onStreamConfigured(int streamId, Surface surface, int width, int height, int format) throws RemoteException {
        }

        @Override
        public void onProcessCaptureRequest(int streamId, long frameId) throws RemoteException {
        }

        @Override
        public void onStreamClosed(int streamId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

