/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import android.companion.virtual.ActivityPolicyExemption;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceIntentInterceptor;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.IVirtualDeviceSoundEffectListener;
import android.companion.virtual.VirtualDeviceManager;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.audio.VirtualAudioDevice;
import android.companion.virtual.camera.VirtualCamera;
import android.companion.virtual.camera.VirtualCameraConfig;
import android.companion.virtual.sensor.VirtualSensor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.VirtualDpad;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualKeyboard;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouse;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualNavigationTouchpad;
import android.hardware.input.VirtualNavigationTouchpadConfig;
import android.hardware.input.VirtualRotaryEncoder;
import android.hardware.input.VirtualRotaryEncoderConfig;
import android.hardware.input.VirtualStylus;
import android.hardware.input.VirtualStylusConfig;
import android.hardware.input.VirtualTouchscreen;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

public class VirtualDeviceInternal {
    private final Context mContext;
    private final IVirtualDevice mVirtualDevice;
    private final Object mActivityListenersLock = new Object();
    @GuardedBy(value={"mActivityListenersLock"})
    private final ArrayMap<VirtualDeviceManager.ActivityListener, ActivityListenerDelegate> mActivityListeners = new ArrayMap();
    private final Object mIntentInterceptorListenersLock = new Object();
    @GuardedBy(value={"mIntentInterceptorListenersLock"})
    private final ArrayMap<VirtualDeviceManager.IntentInterceptorCallback, IntentInterceptorDelegate> mIntentInterceptorListeners = new ArrayMap();
    private final Object mSoundEffectListenersLock = new Object();
    @GuardedBy(value={"mSoundEffectListenersLock"})
    private final ArrayMap<VirtualDeviceManager.SoundEffectListener, SoundEffectListenerDelegate> mSoundEffectListeners = new ArrayMap();
    private final IVirtualDeviceActivityListener mActivityListenerBinder = new IVirtualDeviceActivityListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onTopActivityChanged(displayId, topActivity);
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onTopActivityChanged(displayId, topActivity, userId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayEmpty(int displayId) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onDisplayEmpty(displayId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActivityLaunchBlocked(int displayId, ComponentName componentName, UserHandle user, IntentSender intentSender) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onActivityLaunchBlocked(displayId, componentName, user, intentSender);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSecureWindowShown(int displayId, ComponentName componentName, UserHandle user) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onSecureWindowShown(displayId, componentName, user);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSecureWindowHidden(int displayId) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onSecureWindowHidden(displayId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private final IVirtualDeviceSoundEffectListener mSoundEffectListener = new IVirtualDeviceSoundEffectListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlaySoundEffect(int soundEffect) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mSoundEffectListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mSoundEffectListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mSoundEffectListeners.valueAt(i).onPlaySoundEffect(soundEffect);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    @Nullable
    private VirtualAudioDevice mVirtualAudioDevice;

    VirtualDeviceInternal(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) throws RemoteException {
        this.mContext = context.getApplicationContext();
        this.mVirtualDevice = service.createVirtualDevice(new Binder(), this.mContext.getAttributionSource(), associationId, params, this.mActivityListenerBinder, this.mSoundEffectListener);
    }

    VirtualDeviceInternal(Context context, IVirtualDevice virtualDevice) {
        this.mContext = context.getApplicationContext();
        this.mVirtualDevice = virtualDevice;
        try {
            this.mVirtualDevice.setListeners(this.mActivityListenerBinder, this.mSoundEffectListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    int getDeviceId() {
        try {
            return this.mVirtualDevice.getDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    String getPersistentDeviceId() {
        try {
            return this.mVirtualDevice.getPersistentDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    Context createContext() {
        try {
            return this.mContext.createDeviceContext(this.mVirtualDevice.getDeviceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    List<VirtualSensor> getVirtualSensorList() {
        try {
            return this.mVirtualDevice.getVirtualSensorList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void goToSleep() {
        try {
            this.mVirtualDevice.goToSleep();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void wakeUp() {
        try {
            this.mVirtualDevice.wakeUp();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void launchPendingIntent(int displayId, @NonNull PendingIntent pendingIntent, final @NonNull Executor executor, final @NonNull IntConsumer listener) {
        try {
            this.mVirtualDevice.launchPendingIntent(displayId, pendingIntent, new ResultReceiver(this, new Handler(Looper.getMainLooper())){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    super.onReceiveResult(resultCode, resultData);
                    executor.execute(() -> listener.accept(resultCode));
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Nullable
    VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig config, @Nullable Executor executor, @Nullable VirtualDisplay.Callback callback) {
        int displayId;
        DisplayManagerGlobal.VirtualDisplayCallback callbackWrapper = new DisplayManagerGlobal.VirtualDisplayCallback(callback, executor);
        try {
            displayId = this.mVirtualDevice.createVirtualDisplay(config, callbackWrapper);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        DisplayManagerGlobal displayManager = DisplayManagerGlobal.getInstance();
        return displayManager.createVirtualDisplayWrapper(config, callbackWrapper, displayId);
    }

    void close() {
        try {
            this.mVirtualDevice.close();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (this.mVirtualAudioDevice != null) {
            this.mVirtualAudioDevice.close();
            this.mVirtualAudioDevice = null;
        }
    }

    void setDevicePolicy(int policyType, int devicePolicy) {
        switch (policyType) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Device policy " + policyType + " cannot be changed at runtime. ");
            }
        }
        try {
            this.mVirtualDevice.setDevicePolicy(policyType, devicePolicy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void addActivityPolicyExemption(@NonNull ActivityPolicyExemption exemption) {
        try {
            this.mVirtualDevice.addActivityPolicyExemption(exemption);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void removeActivityPolicyExemption(@NonNull ActivityPolicyExemption exemption) {
        try {
            this.mVirtualDevice.removeActivityPolicyExemption(exemption);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setDevicePolicyForDisplay(int displayId, int policyType, int devicePolicy) {
        switch (policyType) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Device policy " + policyType + " cannot be changed for a specific display. ");
            }
        }
        try {
            this.mVirtualDevice.setDevicePolicyForDisplay(displayId, policyType, devicePolicy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualDpad createVirtualDpad(@NonNull VirtualDpadConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualDpad:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualDpad(config, token);
            return new VirtualDpad(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualKeyboard createVirtualKeyboard(@NonNull VirtualKeyboardConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualKeyboard:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualKeyboard(config, token);
            return new VirtualKeyboard(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualMouse createVirtualMouse(@NonNull VirtualMouseConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualMouse:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualMouse(config, token);
            return new VirtualMouse(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualTouchscreen createVirtualTouchscreen(@NonNull VirtualTouchscreenConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualTouchscreen:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualTouchscreen(config, token);
            return new VirtualTouchscreen(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualStylus createVirtualStylus(@NonNull VirtualStylusConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualStylus:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualStylus(config, token);
            return new VirtualStylus(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualRotaryEncoder createVirtualRotaryEncoder(@NonNull VirtualRotaryEncoderConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualRotaryEncoder:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualRotaryEncoder(config, token);
            return new VirtualRotaryEncoder(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualNavigationTouchpad createVirtualNavigationTouchpad(@NonNull VirtualNavigationTouchpadConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualNavigationTouchpad:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualNavigationTouchpad(config, token);
            return new VirtualNavigationTouchpad(config, this.mVirtualDevice, (IBinder)token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    VirtualAudioDevice createVirtualAudioDevice(@NonNull VirtualDisplay display, @Nullable Executor executor, @Nullable VirtualAudioDevice.AudioConfigurationChangeCallback callback) {
        if (this.mVirtualAudioDevice == null) {
            try {
                Context context = this.mVirtualDevice.getDevicePolicy(1) == 1 ? this.mContext.createDeviceContext(this.getDeviceId()) : this.mContext;
                this.mVirtualAudioDevice = new VirtualAudioDevice(context, this.mVirtualDevice, display, executor, callback, () -> {
                    this.mVirtualAudioDevice = null;
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mVirtualAudioDevice;
    }

    @NonNull
    VirtualCamera createVirtualCamera(@NonNull VirtualCameraConfig config) {
        try {
            this.mVirtualDevice.registerVirtualCamera(config);
            return new VirtualCamera(this.mVirtualDevice, this.mVirtualDevice.getVirtualCameraId(config), config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setShowPointerIcon(boolean showPointerIcon) {
        try {
            this.mVirtualDevice.setShowPointerIcon(showPointerIcon);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setDisplayImePolicy(int displayId, int policy) {
        try {
            this.mVirtualDevice.setDisplayImePolicy(displayId, policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActivityListener(@NonNull Executor executor, @NonNull VirtualDeviceManager.ActivityListener listener) {
        ActivityListenerDelegate delegate = new ActivityListenerDelegate(Objects.requireNonNull(listener), Objects.requireNonNull(executor));
        Object object = this.mActivityListenersLock;
        synchronized (object) {
            this.mActivityListeners.put(listener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActivityListener(@NonNull VirtualDeviceManager.ActivityListener listener) {
        Object object = this.mActivityListenersLock;
        synchronized (object) {
            this.mActivityListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSoundEffectListener(@NonNull Executor executor, @NonNull VirtualDeviceManager.SoundEffectListener soundEffectListener) {
        SoundEffectListenerDelegate delegate = new SoundEffectListenerDelegate(Objects.requireNonNull(executor), Objects.requireNonNull(soundEffectListener));
        Object object = this.mSoundEffectListenersLock;
        synchronized (object) {
            this.mSoundEffectListeners.put(soundEffectListener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSoundEffectListener(@NonNull VirtualDeviceManager.SoundEffectListener soundEffectListener) {
        Object object = this.mSoundEffectListenersLock;
        synchronized (object) {
            this.mSoundEffectListeners.remove(Objects.requireNonNull(soundEffectListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIntentInterceptor(@NonNull IntentFilter interceptorFilter, @NonNull Executor executor, @NonNull VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(interceptorFilter);
        Objects.requireNonNull(interceptorCallback);
        IntentInterceptorDelegate delegate = new IntentInterceptorDelegate(executor, interceptorCallback);
        try {
            this.mVirtualDevice.registerIntentInterceptor(delegate, interceptorFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Object object = this.mIntentInterceptorListenersLock;
        synchronized (object) {
            this.mIntentInterceptorListeners.put(interceptorCallback, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterIntentInterceptor(@NonNull VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
        IntentInterceptorDelegate delegate;
        Objects.requireNonNull(interceptorCallback);
        Object object = this.mIntentInterceptorListenersLock;
        synchronized (object) {
            delegate = this.mIntentInterceptorListeners.remove(interceptorCallback);
        }
        if (delegate != null) {
            try {
                this.mVirtualDevice.unregisterIntentInterceptor(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static class ActivityListenerDelegate {
        @NonNull
        private final VirtualDeviceManager.ActivityListener mActivityListener;
        @NonNull
        private final Executor mExecutor;

        ActivityListenerDelegate(@NonNull VirtualDeviceManager.ActivityListener listener, @NonNull Executor executor) {
            this.mActivityListener = listener;
            this.mExecutor = executor;
        }

        public void onTopActivityChanged(int displayId, ComponentName topActivity) {
            this.mExecutor.execute(() -> this.mActivityListener.onTopActivityChanged(displayId, topActivity));
        }

        public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) {
            this.mExecutor.execute(() -> this.mActivityListener.onTopActivityChanged(displayId, topActivity, userId));
        }

        public void onDisplayEmpty(int displayId) {
            this.mExecutor.execute(() -> this.mActivityListener.onDisplayEmpty(displayId));
        }

        public void onActivityLaunchBlocked(int displayId, ComponentName componentName, UserHandle user, IntentSender intentSender) {
            this.mExecutor.execute(() -> this.mActivityListener.onActivityLaunchBlocked(displayId, componentName, user, intentSender));
        }

        public void onSecureWindowShown(int displayId, ComponentName componentName, UserHandle user) {
            this.mExecutor.execute(() -> this.mActivityListener.onSecureWindowShown(displayId, componentName, user));
        }

        public void onSecureWindowHidden(int displayId) {
            this.mExecutor.execute(() -> this.mActivityListener.onSecureWindowHidden(displayId));
        }
    }

    private static class SoundEffectListenerDelegate {
        @NonNull
        private final VirtualDeviceManager.SoundEffectListener mSoundEffectListener;
        @NonNull
        private final Executor mExecutor;

        private SoundEffectListenerDelegate(Executor executor, VirtualDeviceManager.SoundEffectListener soundEffectCallback) {
            this.mSoundEffectListener = soundEffectCallback;
            this.mExecutor = executor;
        }

        public void onPlaySoundEffect(int effectType) {
            this.mExecutor.execute(() -> this.mSoundEffectListener.onPlaySoundEffect(effectType));
        }
    }

    private static class IntentInterceptorDelegate
    extends IVirtualDeviceIntentInterceptor.Stub {
        @NonNull
        private final VirtualDeviceManager.IntentInterceptorCallback mIntentInterceptorCallback;
        @NonNull
        private final Executor mExecutor;

        private IntentInterceptorDelegate(Executor executor, VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
            this.mExecutor = executor;
            this.mIntentInterceptorCallback = interceptorCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onIntentIntercepted(Intent intent) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mIntentInterceptorCallback.onIntentIntercepted(intent));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }
}

