/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.DeviceId;
import android.companion.IAssociationRequestCallback;
import android.companion.IOnAssociationsChangedListener;
import android.companion.IOnMessageReceivedListener;
import android.companion.IOnTransportsChangedListener;
import android.companion.ISystemDataTransferCallback;
import android.companion.ObservingDevicePresenceRequest;
import android.companion.datatransfer.PermissionSyncRequest;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICompanionDeviceManager
extends IInterface {
    public void associate(AssociationRequest var1, IAssociationRequestCallback var2, String var3, int var4) throws RemoteException;

    public List<AssociationInfo> getAssociations(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public List<AssociationInfo> getAllAssociationsForUser(int var1) throws RemoteException;

    @Deprecated
    public void legacyDisassociate(String var1, String var2, int var3) throws RemoteException;

    public void disassociate(int var1) throws RemoteException;

    @Deprecated
    public boolean hasNotificationAccess(ComponentName var1) throws RemoteException;

    public PendingIntent requestNotificationAccess(ComponentName var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean isDeviceAssociatedForWifiConnection(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void legacyStartObservingDevicePresence(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void legacyStopObservingDevicePresence(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(ObservingDevicePresenceRequest var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(ObservingDevicePresenceRequest var1, String var2, int var3) throws RemoteException;

    public boolean canPairWithoutPrompt(String var1, String var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
    public void createAssociation(String var1, String var2, int var3, byte[] var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void addOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void addOnTransportsChangedListener(IOnTransportsChangedListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void removeOnTransportsChangedListener(IOnTransportsChangedListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void sendMessage(int var1, byte[] var2, int[] var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void addOnMessageReceivedListener(int var1, IOnMessageReceivedListener var2) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_COMPANION_TRANSPORTS")
    public void removeOnMessageReceivedListener(int var1, IOnMessageReceivedListener var2) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifySelfManagedDeviceAppeared(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifySelfManagedDeviceDisappeared(int var1) throws RemoteException;

    public PendingIntent buildPermissionTransferUserConsentIntent(String var1, int var2, int var3) throws RemoteException;

    public boolean isPermissionTransferUserConsented(String var1, int var2, int var3) throws RemoteException;

    public void startSystemDataTransfer(String var1, int var2, int var3, ISystemDataTransferCallback var4) throws RemoteException;

    @EnforcePermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void attachSystemDataTransport(String var1, int var2, int var3, ParcelFileDescriptor var4, int var5) throws RemoteException;

    @EnforcePermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void detachSystemDataTransport(String var1, int var2, int var3) throws RemoteException;

    public boolean isCompanionApplicationBound(String var1, int var2) throws RemoteException;

    public PendingIntent buildAssociationCancellationIntent(String var1, int var2) throws RemoteException;

    public void enableSystemDataSync(int var1, int var2) throws RemoteException;

    public void disableSystemDataSync(int var1, int var2) throws RemoteException;

    public void enablePermissionsSync(int var1) throws RemoteException;

    public void disablePermissionsSync(int var1) throws RemoteException;

    public PermissionSyncRequest getPermissionSyncRequest(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void enableSecureTransport(boolean var1) throws RemoteException;

    public void setDeviceId(int var1, DeviceId var2) throws RemoteException;

    public byte[] getBackupPayload(int var1) throws RemoteException;

    public void applyRestoredPayload(byte[] var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond(int var1, String var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICompanionDeviceManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.companion.ICompanionDeviceManager";
        static final int TRANSACTION_associate = 1;
        static final int TRANSACTION_getAssociations = 2;
        static final int TRANSACTION_getAllAssociationsForUser = 3;
        static final int TRANSACTION_legacyDisassociate = 4;
        static final int TRANSACTION_disassociate = 5;
        static final int TRANSACTION_hasNotificationAccess = 6;
        static final int TRANSACTION_requestNotificationAccess = 7;
        static final int TRANSACTION_isDeviceAssociatedForWifiConnection = 8;
        static final int TRANSACTION_legacyStartObservingDevicePresence = 9;
        static final int TRANSACTION_legacyStopObservingDevicePresence = 10;
        static final int TRANSACTION_startObservingDevicePresence = 11;
        static final int TRANSACTION_stopObservingDevicePresence = 12;
        static final int TRANSACTION_canPairWithoutPrompt = 13;
        static final int TRANSACTION_createAssociation = 14;
        static final int TRANSACTION_addOnAssociationsChangedListener = 15;
        static final int TRANSACTION_removeOnAssociationsChangedListener = 16;
        static final int TRANSACTION_addOnTransportsChangedListener = 17;
        static final int TRANSACTION_removeOnTransportsChangedListener = 18;
        static final int TRANSACTION_sendMessage = 19;
        static final int TRANSACTION_addOnMessageReceivedListener = 20;
        static final int TRANSACTION_removeOnMessageReceivedListener = 21;
        static final int TRANSACTION_notifySelfManagedDeviceAppeared = 22;
        static final int TRANSACTION_notifySelfManagedDeviceDisappeared = 23;
        static final int TRANSACTION_buildPermissionTransferUserConsentIntent = 24;
        static final int TRANSACTION_isPermissionTransferUserConsented = 25;
        static final int TRANSACTION_startSystemDataTransfer = 26;
        static final int TRANSACTION_attachSystemDataTransport = 27;
        static final int TRANSACTION_detachSystemDataTransport = 28;
        static final int TRANSACTION_isCompanionApplicationBound = 29;
        static final int TRANSACTION_buildAssociationCancellationIntent = 30;
        static final int TRANSACTION_enableSystemDataSync = 31;
        static final int TRANSACTION_disableSystemDataSync = 32;
        static final int TRANSACTION_enablePermissionsSync = 33;
        static final int TRANSACTION_disablePermissionsSync = 34;
        static final int TRANSACTION_getPermissionSyncRequest = 35;
        static final int TRANSACTION_enableSecureTransport = 36;
        static final int TRANSACTION_setDeviceId = 37;
        static final int TRANSACTION_getBackupPayload = 38;
        static final int TRANSACTION_applyRestoredPayload = 39;
        static final int TRANSACTION_removeBond = 40;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static ICompanionDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICompanionDeviceManager) {
                return (ICompanionDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "associate";
                }
                case 2: {
                    return "getAssociations";
                }
                case 3: {
                    return "getAllAssociationsForUser";
                }
                case 4: {
                    return "legacyDisassociate";
                }
                case 5: {
                    return "disassociate";
                }
                case 6: {
                    return "hasNotificationAccess";
                }
                case 7: {
                    return "requestNotificationAccess";
                }
                case 8: {
                    return "isDeviceAssociatedForWifiConnection";
                }
                case 9: {
                    return "legacyStartObservingDevicePresence";
                }
                case 10: {
                    return "legacyStopObservingDevicePresence";
                }
                case 11: {
                    return "startObservingDevicePresence";
                }
                case 12: {
                    return "stopObservingDevicePresence";
                }
                case 13: {
                    return "canPairWithoutPrompt";
                }
                case 14: {
                    return "createAssociation";
                }
                case 15: {
                    return "addOnAssociationsChangedListener";
                }
                case 16: {
                    return "removeOnAssociationsChangedListener";
                }
                case 17: {
                    return "addOnTransportsChangedListener";
                }
                case 18: {
                    return "removeOnTransportsChangedListener";
                }
                case 19: {
                    return "sendMessage";
                }
                case 20: {
                    return "addOnMessageReceivedListener";
                }
                case 21: {
                    return "removeOnMessageReceivedListener";
                }
                case 22: {
                    return "notifySelfManagedDeviceAppeared";
                }
                case 23: {
                    return "notifySelfManagedDeviceDisappeared";
                }
                case 24: {
                    return "buildPermissionTransferUserConsentIntent";
                }
                case 25: {
                    return "isPermissionTransferUserConsented";
                }
                case 26: {
                    return "startSystemDataTransfer";
                }
                case 27: {
                    return "attachSystemDataTransport";
                }
                case 28: {
                    return "detachSystemDataTransport";
                }
                case 29: {
                    return "isCompanionApplicationBound";
                }
                case 30: {
                    return "buildAssociationCancellationIntent";
                }
                case 31: {
                    return "enableSystemDataSync";
                }
                case 32: {
                    return "disableSystemDataSync";
                }
                case 33: {
                    return "enablePermissionsSync";
                }
                case 34: {
                    return "disablePermissionsSync";
                }
                case 35: {
                    return "getPermissionSyncRequest";
                }
                case 36: {
                    return "enableSecureTransport";
                }
                case 37: {
                    return "setDeviceId";
                }
                case 38: {
                    return "getBackupPayload";
                }
                case 39: {
                    return "applyRestoredPayload";
                }
                case 40: {
                    return "removeBond";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AssociationRequest _arg0 = data.readTypedObject(AssociationRequest.CREATOR);
                    IAssociationRequestCallback _arg1 = IAssociationRequestCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.associate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAssociations(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAllAssociationsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.legacyDisassociate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disassociate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNotificationAccess(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.requestNotificationAccess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceAssociatedForWifiConnection(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.legacyStartObservingDevicePresence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.legacyStopObservingDevicePresence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    ObservingDevicePresenceRequest _arg0 = data.readTypedObject(ObservingDevicePresenceRequest.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startObservingDevicePresence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ObservingDevicePresenceRequest _arg0 = data.readTypedObject(ObservingDevicePresenceRequest.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopObservingDevicePresence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.canPairWithoutPrompt(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.createAssociation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IOnTransportsChangedListener _arg0 = IOnTransportsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnTransportsChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IOnTransportsChangedListener _arg0 = IOnTransportsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnTransportsChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.sendMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    IOnMessageReceivedListener _arg1 = IOnMessageReceivedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnMessageReceivedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    IOnMessageReceivedListener _arg1 = IOnMessageReceivedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnMessageReceivedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySelfManagedDeviceAppeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySelfManagedDeviceDisappeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.buildPermissionTransferUserConsentIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPermissionTransferUserConsented(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ISystemDataTransferCallback _arg3 = ISystemDataTransferCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startSystemDataTransfer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParcelFileDescriptor _arg3 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.attachSystemDataTransport(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.detachSystemDataTransport(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isCompanionApplicationBound(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.buildAssociationCancellationIntent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableSystemDataSync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableSystemDataSync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enablePermissionsSync(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disablePermissionsSync(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    PermissionSyncRequest _result = this.getPermissionSyncRequest(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.enableSecureTransport(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    DeviceId _arg1 = data.readTypedObject(DeviceId.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDeviceId(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getBackupPayload(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 39: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.applyRestoredPayload(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeBond(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getAllAssociationsForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isDeviceAssociatedForWifiConnection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void legacyStartObservingDevicePresence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void legacyStopObservingDevicePresence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startObservingDevicePresence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopObservingDevicePresence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createAssociation_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ASSOCIATE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addOnAssociationsChangedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeOnAssociationsChangedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addOnTransportsChangedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_COMPANION_TRANSPORTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeOnTransportsChangedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_COMPANION_TRANSPORTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendMessage_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_COMPANION_TRANSPORTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addOnMessageReceivedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_COMPANION_TRANSPORTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeOnMessageReceivedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_COMPANION_TRANSPORTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifySelfManagedDeviceAppeared_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_COMPANION_SELF_MANAGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifySelfManagedDeviceDisappeared_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REQUEST_COMPANION_SELF_MANAGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void attachSystemDataTransport_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DELIVER_COMPANION_MESSAGES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void detachSystemDataTransport_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DELIVER_COMPANION_MESSAGES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enableSecureTransport_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_COMPANION_DEVICES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeBond_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_CONNECT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 39;
        }

        private static class Proxy
        implements ICompanionDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(AssociationRequest request, IAssociationRequestCallback callback, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceMacAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociate(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNotificationAccess(ComponentName component) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent requestNotificationAccess(ComponentName component, int userId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void legacyStartObservingDevicePresence(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void legacyStopObservingDevicePresence(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startObservingDevicePresence(ObservingDevicePresenceRequest request, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopObservingDevicePresence(ObservingDevicePresenceRequest request, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(deviceMacAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    _data.writeByteArray(certificate);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int messageType, byte[] data, int[] associationIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeByteArray(data);
                    _data.writeIntArray(associationIds);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySelfManagedDeviceAppeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySelfManagedDeviceDisappeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent buildPermissionTransferUserConsentIntent(String callingPackage, int userId, int associationId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPermissionTransferUserConsented(String callingPackage, int userId, int associationId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSystemDataTransfer(String packageName, int userId, int associationId, ISystemDataTransferCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachSystemDataTransport(String packageName, int userId, int associationId, ParcelFileDescriptor fd, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(fd, 0);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachSystemDataTransport(String packageName, int userId, int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCompanionApplicationBound(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent buildAssociationCancellationIntent(String callingPackage, int userId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableSystemDataSync(int associationId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSystemDataSync(int associationId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePermissionsSync(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disablePermissionsSync(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PermissionSyncRequest getPermissionSyncRequest(int associationId) throws RemoteException {
                PermissionSyncRequest _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PermissionSyncRequest.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableSecureTransport(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceId(int associationId, DeviceId deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(deviceId, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getBackupPayload(int userId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyRestoredPayload(byte[] payload, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(payload);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeBond(int associationId, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICompanionDeviceManager {
        @Override
        public void associate(AssociationRequest request, IAssociationRequestCallback callback, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void disassociate(int associationId) throws RemoteException {
        }

        @Override
        public boolean hasNotificationAccess(ComponentName component) throws RemoteException {
            return false;
        }

        @Override
        public PendingIntent requestNotificationAccess(ComponentName component, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void legacyStartObservingDevicePresence(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void legacyStopObservingDevicePresence(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void startObservingDevicePresence(ObservingDevicePresenceRequest request, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void stopObservingDevicePresence(ObservingDevicePresenceRequest request, String packageName, int userId) throws RemoteException {
        }

        @Override
        public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
        }

        @Override
        public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void addOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
        }

        @Override
        public void removeOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
        }

        @Override
        public void sendMessage(int messageType, byte[] data, int[] associationIds) throws RemoteException {
        }

        @Override
        public void addOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
        }

        @Override
        public void removeOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
        }

        @Override
        public void notifySelfManagedDeviceAppeared(int associationId) throws RemoteException {
        }

        @Override
        public void notifySelfManagedDeviceDisappeared(int associationId) throws RemoteException {
        }

        @Override
        public PendingIntent buildPermissionTransferUserConsentIntent(String callingPackage, int userId, int associationId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPermissionTransferUserConsented(String callingPackage, int userId, int associationId) throws RemoteException {
            return false;
        }

        @Override
        public void startSystemDataTransfer(String packageName, int userId, int associationId, ISystemDataTransferCallback callback) throws RemoteException {
        }

        @Override
        public void attachSystemDataTransport(String packageName, int userId, int associationId, ParcelFileDescriptor fd, int flags) throws RemoteException {
        }

        @Override
        public void detachSystemDataTransport(String packageName, int userId, int associationId) throws RemoteException {
        }

        @Override
        public boolean isCompanionApplicationBound(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public PendingIntent buildAssociationCancellationIntent(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void enableSystemDataSync(int associationId, int flags) throws RemoteException {
        }

        @Override
        public void disableSystemDataSync(int associationId, int flags) throws RemoteException {
        }

        @Override
        public void enablePermissionsSync(int associationId) throws RemoteException {
        }

        @Override
        public void disablePermissionsSync(int associationId) throws RemoteException {
        }

        @Override
        public PermissionSyncRequest getPermissionSyncRequest(int associationId) throws RemoteException {
            return null;
        }

        @Override
        public void enableSecureTransport(boolean enabled) throws RemoteException {
        }

        @Override
        public void setDeviceId(int associationId, DeviceId deviceId) throws RemoteException {
        }

        @Override
        public byte[] getBackupPayload(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void applyRestoredPayload(byte[] payload, int userId) throws RemoteException {
        }

        @Override
        public boolean removeBond(int associationId, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

