/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.AssociatedDevice;
import android.companion.DeviceId;
import android.graphics.drawable.Icon;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.companion.Flags;
import java.util.Date;
import java.util.Objects;

public class AssociationInfo
implements Parcelable {
    private static final String LAST_TIME_CONNECTED_NONE = "None";
    private final int mId;
    private final int mUserId;
    @NonNull
    private final String mPackageName;
    @Nullable
    private final MacAddress mDeviceMacAddress;
    @Nullable
    private final CharSequence mDisplayName;
    @Nullable
    private final String mDeviceProfile;
    @Nullable
    private final AssociatedDevice mAssociatedDevice;
    private final boolean mSelfManaged;
    private final boolean mNotifyOnDeviceNearby;
    private final boolean mRevoked;
    private final boolean mPending;
    private final long mTimeApprovedMs;
    private final long mLastTimeConnectedMs;
    private final int mSystemDataSyncFlags;
    @Nullable
    private final DeviceId mDeviceId;
    private final Icon mDeviceIcon;
    @NonNull
    public static final Parcelable.Creator<AssociationInfo> CREATOR = new Parcelable.Creator<AssociationInfo>(){

        public AssociationInfo[] newArray(int size) {
            return new AssociationInfo[size];
        }

        @Override
        public AssociationInfo createFromParcel(@NonNull Parcel in) {
            return new AssociationInfo(in);
        }
    };

    public AssociationInfo(int id2, int userId, @NonNull String packageName, @Nullable MacAddress macAddress, @Nullable CharSequence displayName, @Nullable String deviceProfile, @Nullable AssociatedDevice associatedDevice, boolean selfManaged, boolean notifyOnDeviceNearby, boolean revoked, boolean pending, long timeApprovedMs, long lastTimeConnectedMs, int systemDataSyncFlags, @Nullable Icon deviceIcon, @Nullable DeviceId deviceId) {
        if (id2 <= 0) {
            throw new IllegalArgumentException("Association ID should be greater than 0");
        }
        if (macAddress == null && displayName == null) {
            throw new IllegalArgumentException("MAC address and the Display Name must NOT be null at the same time");
        }
        this.mId = id2;
        this.mUserId = userId;
        this.mPackageName = packageName;
        this.mDeviceMacAddress = macAddress;
        this.mDisplayName = displayName;
        this.mDeviceProfile = deviceProfile;
        this.mAssociatedDevice = associatedDevice;
        this.mSelfManaged = selfManaged;
        this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
        this.mRevoked = revoked;
        this.mPending = pending;
        this.mTimeApprovedMs = timeApprovedMs;
        this.mLastTimeConnectedMs = lastTimeConnectedMs;
        this.mSystemDataSyncFlags = systemDataSyncFlags;
        this.mDeviceIcon = deviceIcon;
        this.mDeviceId = deviceId;
    }

    public int getId() {
        return this.mId;
    }

    public int getUserId() {
        return this.mUserId;
    }

    @SystemApi
    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @FlaggedApi(value="android.companion.association_tag")
    @Nullable
    public DeviceId getDeviceId() {
        return this.mDeviceId;
    }

    @Nullable
    public MacAddress getDeviceMacAddress() {
        return this.mDeviceMacAddress;
    }

    @Nullable
    public String getDeviceMacAddressAsString() {
        return this.mDeviceMacAddress != null ? ((Object)this.mDeviceMacAddress).toString().toUpperCase() : null;
    }

    @Nullable
    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    @Nullable
    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    @Nullable
    public AssociatedDevice getAssociatedDevice() {
        return this.mAssociatedDevice;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public boolean isSelfManaged() {
        return this.mSelfManaged;
    }

    public boolean isNotifyOnDeviceNearby() {
        return this.mNotifyOnDeviceNearby;
    }

    public long getTimeApprovedMs() {
        return this.mTimeApprovedMs;
    }

    public boolean belongsToPackage(int userId, String packageName) {
        return this.mUserId == userId && Objects.equals(this.mPackageName, packageName);
    }

    public boolean isRevoked() {
        return this.mRevoked;
    }

    public boolean isPending() {
        return this.mPending;
    }

    public boolean isActive() {
        return !this.mRevoked && !this.mPending;
    }

    public long getLastTimeConnectedMs() {
        return this.mLastTimeConnectedMs;
    }

    public int getSystemDataSyncFlags() {
        return this.mSystemDataSyncFlags;
    }

    @FlaggedApi(value="android.companion.association_device_icon")
    @Nullable
    public Icon getDeviceIcon() {
        return this.mDeviceIcon;
    }

    public boolean isLinkedTo(@Nullable String addr) {
        MacAddress macAddress;
        if (this.mSelfManaged) {
            return false;
        }
        if (addr == null) {
            return false;
        }
        try {
            macAddress = MacAddress.fromString(addr);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return ((Object)macAddress).equals(this.mDeviceMacAddress);
    }

    public boolean shouldBindWhenPresent() {
        return this.mNotifyOnDeviceNearby || this.mSelfManaged;
    }

    @NonNull
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.mId);
        if (this.mDeviceMacAddress != null) {
            sb.append(", addr=").append(this.getDeviceMacAddressAsString());
        }
        if (this.mSelfManaged) {
            sb.append(", self-managed");
        }
        sb.append(", pkg=u").append(this.mUserId).append('/').append(this.mPackageName);
        return sb.toString();
    }

    public String toString() {
        return "Association{mId=" + this.mId + ", mUserId=" + this.mUserId + ", mPackageName='" + this.mPackageName + '\'' + ", mDeviceMacAddress=" + this.mDeviceMacAddress + ", mDisplayName='" + this.mDisplayName + '\'' + ", mDeviceProfile='" + this.mDeviceProfile + '\'' + ", mSelfManaged=" + this.mSelfManaged + ", mAssociatedDevice=" + this.mAssociatedDevice + ", mNotifyOnDeviceNearby=" + this.mNotifyOnDeviceNearby + ", mRevoked=" + this.mRevoked + ", mPending=" + this.mPending + ", mTimeApprovedMs=" + new Date(this.mTimeApprovedMs) + ", mLastTimeConnectedMs=" + (this.mLastTimeConnectedMs == Long.MAX_VALUE ? LAST_TIME_CONNECTED_NONE : new Date(this.mLastTimeConnectedMs)) + ", mSystemDataSyncFlags=" + this.mSystemDataSyncFlags + ", mDeviceId='" + this.mDeviceId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociationInfo)) {
            return false;
        }
        AssociationInfo that = (AssociationInfo)o;
        return this.mId == that.mId && this.mUserId == that.mUserId && this.mSelfManaged == that.mSelfManaged && this.mNotifyOnDeviceNearby == that.mNotifyOnDeviceNearby && this.mRevoked == that.mRevoked && this.mPending == that.mPending && this.mTimeApprovedMs == that.mTimeApprovedMs && this.mLastTimeConnectedMs == that.mLastTimeConnectedMs && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mDeviceMacAddress, that.mDeviceMacAddress) && Objects.equals(this.mDisplayName, that.mDisplayName) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && Objects.equals(this.mAssociatedDevice, that.mAssociatedDevice) && this.mSystemDataSyncFlags == that.mSystemDataSyncFlags && this.isSameIcon(this.mDeviceIcon, that.mDeviceIcon) && Objects.equals(this.mDeviceId, that.mDeviceId);
    }

    private boolean isSameIcon(Icon iconA, Icon iconB) {
        return iconA == null && iconB == null || iconA != null && iconB != null && iconA.getBitmap().sameAs(iconB.getBitmap());
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mUserId, this.mPackageName, this.mDeviceMacAddress, this.mDisplayName, this.mDeviceProfile, this.mAssociatedDevice, this.mSelfManaged, this.mNotifyOnDeviceNearby, this.mRevoked, this.mPending, this.mTimeApprovedMs, this.mLastTimeConnectedMs, this.mSystemDataSyncFlags, this.mDeviceIcon, this.mDeviceId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mUserId);
        dest.writeString(this.mPackageName);
        dest.writeTypedObject(this.mDeviceMacAddress, 0);
        dest.writeCharSequence(this.mDisplayName);
        dest.writeString(this.mDeviceProfile);
        dest.writeTypedObject(this.mAssociatedDevice, 0);
        dest.writeBoolean(this.mSelfManaged);
        dest.writeBoolean(this.mNotifyOnDeviceNearby);
        dest.writeBoolean(this.mRevoked);
        dest.writeBoolean(this.mPending);
        dest.writeLong(this.mTimeApprovedMs);
        dest.writeLong(this.mLastTimeConnectedMs);
        dest.writeInt(this.mSystemDataSyncFlags);
        if (Flags.associationDeviceIcon() && this.mDeviceIcon != null) {
            dest.writeInt(1);
            this.mDeviceIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (Flags.associationTag() && this.mDeviceId != null) {
            dest.writeInt(1);
            dest.writeTypedObject(this.mDeviceId, flags);
        } else {
            dest.writeInt(0);
        }
    }

    private AssociationInfo(@NonNull Parcel in) {
        this.mId = in.readInt();
        this.mUserId = in.readInt();
        this.mPackageName = in.readString();
        this.mDeviceMacAddress = in.readTypedObject(MacAddress.CREATOR);
        this.mDisplayName = in.readCharSequence();
        this.mDeviceProfile = in.readString();
        this.mAssociatedDevice = in.readTypedObject(AssociatedDevice.CREATOR);
        this.mSelfManaged = in.readBoolean();
        this.mNotifyOnDeviceNearby = in.readBoolean();
        this.mRevoked = in.readBoolean();
        this.mPending = in.readBoolean();
        this.mTimeApprovedMs = in.readLong();
        this.mLastTimeConnectedMs = in.readLong();
        this.mSystemDataSyncFlags = in.readInt();
        int deviceIcon = in.readInt();
        this.mDeviceIcon = Flags.associationDeviceIcon() && deviceIcon == 1 ? Icon.CREATOR.createFromParcel(in) : null;
        int deviceId = in.readInt();
        this.mDeviceId = Flags.associationTag() && deviceId == 1 ? in.readTypedObject(DeviceId.CREATOR) : null;
    }

    @FlaggedApi(value="android.companion.new_association_builder")
    public static class Builder {
        private final int mId;
        private final int mUserId;
        private final String mPackageName;
        private MacAddress mDeviceMacAddress;
        private CharSequence mDisplayName;
        private String mDeviceProfile;
        private AssociatedDevice mAssociatedDevice;
        private boolean mSelfManaged;
        private boolean mNotifyOnDeviceNearby;
        private boolean mRevoked;
        private boolean mPending;
        private long mTimeApprovedMs;
        private long mLastTimeConnectedMs;
        private int mSystemDataSyncFlags;
        private Icon mDeviceIcon;
        private DeviceId mDeviceId;

        public Builder(int id2, int userId, @NonNull String packageName) {
            this.mId = id2;
            this.mUserId = userId;
            this.mPackageName = packageName;
        }

        public Builder(@NonNull AssociationInfo info) {
            this.mId = info.mId;
            this.mUserId = info.mUserId;
            this.mPackageName = info.mPackageName;
            this.mDeviceMacAddress = info.mDeviceMacAddress;
            this.mDisplayName = info.mDisplayName;
            this.mDeviceProfile = info.mDeviceProfile;
            this.mAssociatedDevice = info.mAssociatedDevice;
            this.mSelfManaged = info.mSelfManaged;
            this.mNotifyOnDeviceNearby = info.mNotifyOnDeviceNearby;
            this.mRevoked = info.mRevoked;
            this.mPending = info.mPending;
            this.mTimeApprovedMs = info.mTimeApprovedMs;
            this.mLastTimeConnectedMs = info.mLastTimeConnectedMs;
            this.mSystemDataSyncFlags = info.mSystemDataSyncFlags;
            this.mDeviceIcon = info.mDeviceIcon;
            this.mDeviceId = info.mDeviceId;
        }

        public Builder(int id2, int userId, @NonNull String packageName, AssociationInfo info) {
            this.mId = id2;
            this.mUserId = userId;
            this.mPackageName = packageName;
            this.mDeviceMacAddress = info.mDeviceMacAddress;
            this.mDisplayName = info.mDisplayName;
            this.mDeviceProfile = info.mDeviceProfile;
            this.mAssociatedDevice = info.mAssociatedDevice;
            this.mSelfManaged = info.mSelfManaged;
            this.mNotifyOnDeviceNearby = info.mNotifyOnDeviceNearby;
            this.mRevoked = info.mRevoked;
            this.mPending = info.mPending;
            this.mTimeApprovedMs = info.mTimeApprovedMs;
            this.mLastTimeConnectedMs = info.mLastTimeConnectedMs;
            this.mSystemDataSyncFlags = info.mSystemDataSyncFlags;
            this.mDeviceIcon = info.mDeviceIcon;
            this.mDeviceId = info.mDeviceId;
        }

        @FlaggedApi(value="android.companion.association_tag")
        @NonNull
        public Builder setDeviceId(@Nullable DeviceId deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        @NonNull
        public Builder setDeviceMacAddress(@Nullable MacAddress deviceMacAddress) {
            this.mDeviceMacAddress = deviceMacAddress;
            return this;
        }

        @NonNull
        public Builder setDisplayName(@Nullable CharSequence displayName) {
            this.mDisplayName = displayName;
            return this;
        }

        @NonNull
        public Builder setDeviceProfile(@Nullable String deviceProfile) {
            this.mDeviceProfile = deviceProfile;
            return this;
        }

        @NonNull
        public Builder setAssociatedDevice(@Nullable AssociatedDevice associatedDevice) {
            this.mAssociatedDevice = associatedDevice;
            return this;
        }

        @NonNull
        public Builder setSelfManaged(boolean selfManaged) {
            this.mSelfManaged = selfManaged;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setNotifyOnDeviceNearby(boolean notifyOnDeviceNearby) {
            this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setRevoked(boolean revoked) {
            this.mRevoked = revoked;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setPending(boolean pending) {
            this.mPending = pending;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setTimeApproved(long timeApprovedMs) {
            if (timeApprovedMs < 0L) {
                throw new IllegalArgumentException("timeApprovedMs must be positive. Was given (" + timeApprovedMs + ")");
            }
            this.mTimeApprovedMs = timeApprovedMs;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setLastTimeConnected(long lastTimeConnectedMs) {
            if (lastTimeConnectedMs < 0L) {
                throw new IllegalArgumentException("lastTimeConnectedMs must not be negative! (Given " + lastTimeConnectedMs + " )");
            }
            this.mLastTimeConnectedMs = lastTimeConnectedMs;
            return this;
        }

        @NonNull
        public Builder setSystemDataSyncFlags(int flags) {
            this.mSystemDataSyncFlags = flags;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="android.companion.association_device_icon")
        public Builder setDeviceIcon(@Nullable Icon deviceIcon) {
            this.mDeviceIcon = deviceIcon;
            return this;
        }

        @NonNull
        public AssociationInfo build() {
            if (this.mId <= 0) {
                throw new IllegalArgumentException("Association ID should be greater than 0");
            }
            if (this.mDeviceMacAddress == null && this.mDisplayName == null) {
                throw new IllegalArgumentException("MAC address and the display name must NOT be null at the same time");
            }
            return new AssociationInfo(this.mId, this.mUserId, this.mPackageName, this.mDeviceMacAddress, this.mDisplayName, this.mDeviceProfile, this.mAssociatedDevice, this.mSelfManaged, this.mNotifyOnDeviceNearby, this.mRevoked, this.mPending, this.mTimeApprovedMs, this.mLastTimeConnectedMs, this.mSystemDataSyncFlags, this.mDeviceIcon, this.mDeviceId);
        }
    }
}

