/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothScan;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingReport;
import android.bluetooth.le.ScanResult;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.IdentityHashMap;
import java.util.Objects;

public class PeriodicAdvertisingManager {
    private static final String TAG = PeriodicAdvertisingManager.class.getSimpleName();
    private static final int SKIP_MIN = 0;
    private static final int SKIP_MAX = 499;
    private static final int TIMEOUT_MIN = 10;
    private static final int TIMEOUT_MAX = 16384;
    private final IdentityHashMap<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback> mCallbackWrappers = new IdentityHashMap();
    private final BluetoothAdapter mBluetoothAdapter;
    private final AttributionSource mAttributionSource;

    public PeriodicAdvertisingManager(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback) {
        this.registerSync(scanResult, skip, timeout, callback, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        if (scanResult == null) {
            throw new IllegalArgumentException("scanResult can't be null");
        }
        if (scanResult.getAdvertisingSid() == 255) {
            throw new IllegalArgumentException("scanResult must contain a valid sid");
        }
        if (skip < 0 || skip > 499) {
            throw new IllegalArgumentException("skip must be between 0 and 499");
        }
        if (timeout < 10 || timeout > 16384) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        handler = Objects.requireNonNullElseGet(handler, () -> new Handler(Looper.getMainLooper()));
        IPeriodicAdvertisingCallback wrapped = this.wrap(callback, handler);
        this.mCallbackWrappers.put(callback, wrapped);
        IBluetoothScan scan = this.mBluetoothAdapter.getBluetoothScan();
        try {
            scan.registerSync(scanResult, skip, timeout, wrapped, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register sync - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterSync(PeriodicAdvertisingCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        IPeriodicAdvertisingCallback wrapper = this.mCallbackWrappers.remove(callback);
        if (wrapper == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        IBluetoothScan scan = this.mBluetoothAdapter.getBluetoothScan();
        try {
            scan.unregisterSync(wrapper, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to cancel sync creation - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void transferSync(BluetoothDevice bda, int serviceData, int syncHandle) {
        IBluetoothScan scan = this.mBluetoothAdapter.getBluetoothScan();
        try {
            scan.transferSync(bda, serviceData, syncHandle, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register sync - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void transferSetInfo(BluetoothDevice bda, int serviceData, int advHandle, PeriodicAdvertisingCallback callback) {
        this.transferSetInfo(bda, serviceData, advHandle, callback, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void transferSetInfo(BluetoothDevice bda, int serviceData, int advHandle, PeriodicAdvertisingCallback callback, @Nullable Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        IPeriodicAdvertisingCallback wrapper = this.wrap(callback, handler = Objects.requireNonNullElseGet(handler, () -> new Handler(Looper.getMainLooper())));
        if (wrapper == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        IBluetoothScan scan = this.mBluetoothAdapter.getBluetoothScan();
        try {
            scan.transferSetInfo(bda, serviceData, advHandle, wrapper, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register sync - ", e);
        }
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private IPeriodicAdvertisingCallback wrap(final PeriodicAdvertisingCallback callback, final Handler handler) {
        return new IPeriodicAdvertisingCallback.Stub(){

            @Override
            public void onSyncEstablished(int syncHandle, BluetoothDevice device, int advertisingSid, int skip, int timeout, int status) {
                Attributable.setAttributionSource(device, PeriodicAdvertisingManager.this.mAttributionSource);
                handler.post(() -> {
                    callback.onSyncEstablished(syncHandle, device, advertisingSid, skip, timeout, status);
                    if (status != 0) {
                        PeriodicAdvertisingManager.this.mCallbackWrappers.remove(callback);
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingReport(PeriodicAdvertisingReport report) {
                handler.post(() -> callback.onPeriodicAdvertisingReport(report));
            }

            @Override
            public void onSyncLost(int syncHandle) {
                handler.post(() -> {
                    callback.onSyncLost(syncHandle);
                    PeriodicAdvertisingManager.this.mCallbackWrappers.remove(callback);
                });
            }

            @Override
            public void onSyncTransferred(BluetoothDevice device, int status) {
                handler.post(() -> callback.onSyncTransferred(device, status));
            }

            @Override
            public void onBigInfoAdvertisingReport(int syncHandle, boolean encrypted) {
                handler.post(() -> callback.onBigInfoAdvertisingReport(syncHandle, encrypted));
            }
        };
    }
}

