/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IDistanceMeasurement;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.DistanceMeasurementResult;
import android.content.AttributionSource;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class DistanceMeasurementSession {
    private static final String TAG = DistanceMeasurementSession.class.getSimpleName();
    private final IDistanceMeasurement mDistanceMeasurement;
    private final ParcelUuid mUuid;
    private final DistanceMeasurementParams mDistanceMeasurementParams;
    private final Executor mExecutor;
    private final Callback mCallback;
    private final AttributionSource mAttributionSource;

    public DistanceMeasurementSession(IDistanceMeasurement distanceMeasurement, ParcelUuid uuid, DistanceMeasurementParams params, Executor executor, AttributionSource attributionSource, Callback callback) {
        this.mDistanceMeasurement = Objects.requireNonNull(distanceMeasurement);
        this.mDistanceMeasurementParams = Objects.requireNonNull(params);
        this.mExecutor = Objects.requireNonNull(executor);
        this.mCallback = Objects.requireNonNull(callback);
        this.mUuid = uuid;
        this.mAttributionSource = attributionSource;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopSession() {
        try {
            return this.mDistanceMeasurement.stopDistanceMeasurement(this.mUuid, this.mDistanceMeasurementParams.getDevice(), this.mDistanceMeasurementParams.getMethodId(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return 1;
        }
    }

    void onStarted() {
        BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onStarted(this));
    }

    void onStartFail(int reason) {
        BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onStartFail(reason));
    }

    void onStopped(int reason) {
        BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onStopped(this, reason));
    }

    void onResult(@NonNull BluetoothDevice device, @NonNull DistanceMeasurementResult result) {
        BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onResult(device, result));
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onStarted(@NonNull DistanceMeasurementSession var1);

        @SystemApi
        public void onStartFail(int var1);

        @SystemApi
        public void onStopped(@NonNull DistanceMeasurementSession var1, int var2);

        @SystemApi
        public void onResult(@NonNull BluetoothDevice var1, @NonNull DistanceMeasurementResult var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopSessionReturnValues {
    }
}

