/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@SystemApi
public class ChannelSoundingParams
implements Parcelable {
    @SystemApi
    public static final int SIGHT_TYPE_UNKNOWN = 0;
    @SystemApi
    public static final int SIGHT_TYPE_LINE_OF_SIGHT = 1;
    @SystemApi
    public static final int SIGHT_TYPE_NON_LINE_OF_SIGHT = 2;
    @SystemApi
    public static final int LOCATION_TYPE_UNKNOWN = 0;
    @SystemApi
    public static final int LOCATION_TYPE_INDOOR = 1;
    @SystemApi
    public static final int LOCATION_TYPE_OUTDOOR = 2;
    @SystemApi
    public static final int CS_SECURITY_LEVEL_UNKNOWN = 0;
    @SystemApi
    public static final int CS_SECURITY_LEVEL_ONE = 1;
    @SystemApi
    public static final int CS_SECURITY_LEVEL_TWO = 2;
    @SystemApi
    public static final int CS_SECURITY_LEVEL_THREE = 3;
    @SystemApi
    public static final int CS_SECURITY_LEVEL_FOUR = 4;
    private final int mSightType;
    private final int mLocationType;
    private final int mCsSecurityLevel;
    @NonNull
    public static final Parcelable.Creator<ChannelSoundingParams> CREATOR = new Parcelable.Creator<ChannelSoundingParams>(){

        @Override
        @NonNull
        public ChannelSoundingParams createFromParcel(@NonNull Parcel in) {
            Builder builder = new Builder();
            builder.setSightType(in.readInt());
            builder.setLocationType(in.readInt());
            builder.setCsSecurityLevel(in.readInt());
            return builder.build();
        }

        @NonNull
        public ChannelSoundingParams[] newArray(int size) {
            return new ChannelSoundingParams[size];
        }
    };

    public ChannelSoundingParams(int sightType, int locationType, int csSecurityLevel) {
        this.mSightType = sightType;
        this.mLocationType = locationType;
        this.mCsSecurityLevel = csSecurityLevel;
    }

    @SystemApi
    public int getSightType() {
        return this.mSightType;
    }

    @SystemApi
    public int getLocationType() {
        return this.mLocationType;
    }

    @SystemApi
    public int getCsSecurityLevel() {
        return this.mCsSecurityLevel;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mSightType);
        out.writeInt(this.mLocationType);
        out.writeInt(this.mCsSecurityLevel);
    }

    @SystemApi
    public static class Builder {
        private int mSightType = 0;
        private int mLocationType = 0;
        private int mCsSecurityLevel = 1;

        @SystemApi
        @NonNull
        public Builder setSightType(int sightType) {
            switch (sightType) {
                case 0: 
                case 1: 
                case 2: {
                    this.mSightType = sightType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown sight type " + sightType);
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setLocationType(int locationType) {
            switch (locationType) {
                case 0: 
                case 1: 
                case 2: {
                    this.mLocationType = locationType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown location type " + locationType);
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setCsSecurityLevel(int csSecurityLevel) {
            switch (csSecurityLevel) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mCsSecurityLevel = csSecurityLevel;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown CS security level " + csSecurityLevel);
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public ChannelSoundingParams build() {
            return new ChannelSoundingParams(this.mSightType, this.mLocationType, this.mCsSecurityLevel);
        }
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    static @interface CsSecurityLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LocationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SightType {
    }
}

