/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothHciVendorSpecificCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothHciVendorSpecificCallback";

    public void onCommandStatus(int var1, int var2) throws RemoteException;

    public void onCommandComplete(int var1, byte[] var2) throws RemoteException;

    public void onEvent(int var1, byte[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHciVendorSpecificCallback {
        static final int TRANSACTION_onCommandStatus = 1;
        static final int TRANSACTION_onCommandComplete = 2;
        static final int TRANSACTION_onEvent = 3;

        public Stub() {
            this.attachInterface(this, IBluetoothHciVendorSpecificCallback.DESCRIPTOR);
        }

        public static IBluetoothHciVendorSpecificCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothHciVendorSpecificCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHciVendorSpecificCallback) {
                return (IBluetoothHciVendorSpecificCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCommandStatus";
                }
                case 2: {
                    return "onCommandComplete";
                }
                case 3: {
                    return "onEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothHciVendorSpecificCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCommandStatus(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onCommandComplete(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onEvent(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IBluetoothHciVendorSpecificCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothHciVendorSpecificCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandStatus(int ocf, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothHciVendorSpecificCallback.DESCRIPTOR);
                    _data.writeInt(ocf);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandComplete(int ocf, byte[] returnParameters) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothHciVendorSpecificCallback.DESCRIPTOR);
                    _data.writeInt(ocf);
                    _data.writeByteArray(returnParameters);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(int code, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothHciVendorSpecificCallback.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeByteArray(data);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothHciVendorSpecificCallback {
        @Override
        public void onCommandStatus(int ocf, int status) throws RemoteException {
        }

        @Override
        public void onCommandComplete(int ocf, byte[] returnParameters) throws RemoteException {
        }

        @Override
        public void onEvent(int code, byte[] data) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

