/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSinkAudioPolicy;
import android.bluetooth.IBluetoothActivityEnergyInfoListener;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothConnectionCallback;
import android.bluetooth.IBluetoothHciVendorSpecificCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothOobDataCallback;
import android.bluetooth.IBluetoothPreferredAudioProfilesCallback;
import android.bluetooth.IBluetoothQualityReportReadyCallback;
import android.bluetooth.IBluetoothSocketManager;
import android.bluetooth.IncomingRfcommSocketInfo;
import android.bluetooth.OobData;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetooth
extends IInterface {
    @RequiresNoPermission
    public int getState() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void offToBleOn(boolean var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onToBleOn(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddress(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<ParcelUuid> getUuids(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setName(String var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public String getIdentityAddress(String var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothDevice.BluetoothAddress getIdentityAddressWithType(String var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public int getNameLengthForAdvertise(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getScanMode(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setScanMode(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public long getDiscoverableTimeout(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setDiscoverableTimeout(long var1, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startDiscovery(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean cancelDiscovery(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isDiscovering(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getDiscoveryEndMillis(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public int getAdapterConnectionState() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getProfileConnectionState(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getBondedDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean createBondOutOfBand(BluetoothDevice var1, int var2, OobData var3, OobData var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean cancelBondProcess(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBondState(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isBondingInitiatedLocally(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getSupportedProfiles(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionHandle(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getRemoteName(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getRemoteType(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getRemoteAlias(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public int setRemoteAlias(BluetoothDevice var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getRemoteClass(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<ParcelUuid> getRemoteUuids(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public boolean fetchRemoteUuids(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sdpSearch(BluetoothDevice var1, ParcelUuid var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBatteryLevel(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMaxConnectedAudioDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(BluetoothDevice var1, boolean var2, int var3, byte[] var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPasskey(BluetoothDevice var1, boolean var2, int var3, byte[] var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPairingConfirmation(BluetoothDevice var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPhonebookAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSilenceMode(BluetoothDevice var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean getSilenceMode(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPhonebookAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMessageAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMessageAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getSimAccessPermission(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSimAccessPermission(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(IBluetoothCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(IBluetoothCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresNoPermission
    public void logL2capcocServerConnection(BluetoothDevice var1, int var2, boolean var3, int var4, long var5, long var7, long var9, long var11) throws RemoteException;

    @RequiresNoPermission
    public IBluetoothSocketManager getSocketManager() throws RemoteException;

    @RequiresNoPermission
    public void logL2capcocClientConnection(BluetoothDevice var1, int var2, boolean var3, int var4, long var5, long var7, long var9) throws RemoteException;

    @RequiresNoPermission
    public void logRfcommConnectionAttempt(BluetoothDevice var1, boolean var2, int var3, long var4, boolean var6) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public boolean isMultiAdvertisementSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isOffloadedFilteringSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isOffloadedScanBatchingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isActivityAndEnergyReportingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLe2MPhySupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLeCodedPhySupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLeExtendedAdvertisingSupported() throws RemoteException;

    @RequiresNoPermission
    public boolean isLePeriodicAdvertisingSupported() throws RemoteException;

    @RequiresNoPermission
    public int isLeAudioSupported() throws RemoteException;

    @RequiresNoPermission
    public int isLeAudioBroadcastSourceSupported() throws RemoteException;

    @RequiresNoPermission
    public int isLeAudioBroadcastAssistantSupported() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isDistanceMeasurementSupported(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public int getLeMaximumAdvertisingDataLength() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerMetadataListener(IBluetoothMetadataListener var1, BluetoothDevice var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterMetadataListener(IBluetoothMetadataListener var1, BluetoothDevice var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMetadata(BluetoothDevice var1, int var2, byte[] var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public byte[] getMetadata(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestActivityInfo(IBluetoothActivityEnergyInfoListener var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void bleOnToOn(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void bleOnToOff(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public int connectAllEnabledProfiles(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int disconnectAllEnabledProfiles(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setActiveDevice(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getActiveDevices(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean removeActiveDevice(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerBluetoothConnectionCallback(IBluetoothConnectionCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean canBondWithoutDialog(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public String getPackageNameOfBondingApplication(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void generateLocalOobData(int var1, IBluetoothOobDataCallback var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean allowLowLatencyAudio(boolean var1, BluetoothDevice var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isRequestAudioPolicyAsSinkSupported(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int requestAudioPolicyAsSink(BluetoothDevice var1, BluetoothSinkAudioPolicy var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothSinkAudioPolicy getRequestedAudioPolicyAsSink(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int startRfcommListener(String var1, ParcelUuid var2, PendingIntent var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopRfcommListener(ParcelUuid var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public IncomingRfcommSocketInfo retrievePendingSocketForServiceRecord(ParcelUuid var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setForegroundUserId(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setPreferredAudioProfiles(BluetoothDevice var1, Bundle var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public Bundle getPreferredAudioProfiles(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isDualModeAudioEnabled(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int notifyActiveDeviceChangeApplied(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void registerHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback var1, int[] var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void unregisterHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void sendHciVendorSpecificCommand(int var1, byte[] var2, IBluetoothHciVendorSpecificCallback var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getOffloadedTransportDiscoveryDataScanSupported(AttributionSource var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isMediaProfileConnected(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public IBinder getBluetoothGatt() throws RemoteException;

    @RequiresNoPermission
    public IBinder getBluetoothScan() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregAllGattClient(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public IBinder getProfile(int var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setActiveAudioDevicePolicy(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getActiveAudioDevicePolicy(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setMicrophonePreferredForCalls(BluetoothDevice var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isMicrophonePreferredForCalls(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void killBluetoothProcess() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isLeCocSocketOffloadSupported(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isRfcommSocketOffloadSupported(AttributionSource var1) throws RemoteException;

    @RequiresNoPermission
    public IBinder getBluetoothAdvertise() throws RemoteException;

    @RequiresNoPermission
    public IBinder getDistanceMeasurement() throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getKeyMissingCount(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IBluetooth {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetooth";
        static final int TRANSACTION_getState = 1;
        static final int TRANSACTION_offToBleOn = 2;
        static final int TRANSACTION_onToBleOn = 3;
        static final int TRANSACTION_getAddress = 4;
        static final int TRANSACTION_getUuids = 5;
        static final int TRANSACTION_setName = 6;
        static final int TRANSACTION_getIdentityAddress = 7;
        static final int TRANSACTION_getIdentityAddressWithType = 8;
        static final int TRANSACTION_getName = 9;
        static final int TRANSACTION_getNameLengthForAdvertise = 10;
        static final int TRANSACTION_getScanMode = 11;
        static final int TRANSACTION_setScanMode = 12;
        static final int TRANSACTION_getDiscoverableTimeout = 13;
        static final int TRANSACTION_setDiscoverableTimeout = 14;
        static final int TRANSACTION_startDiscovery = 15;
        static final int TRANSACTION_cancelDiscovery = 16;
        static final int TRANSACTION_isDiscovering = 17;
        static final int TRANSACTION_getDiscoveryEndMillis = 18;
        static final int TRANSACTION_getAdapterConnectionState = 19;
        static final int TRANSACTION_getProfileConnectionState = 20;
        static final int TRANSACTION_getBondedDevices = 21;
        static final int TRANSACTION_createBond = 22;
        static final int TRANSACTION_createBondOutOfBand = 23;
        static final int TRANSACTION_cancelBondProcess = 24;
        static final int TRANSACTION_removeBond = 25;
        static final int TRANSACTION_getBondState = 26;
        static final int TRANSACTION_isBondingInitiatedLocally = 27;
        static final int TRANSACTION_getSupportedProfiles = 28;
        static final int TRANSACTION_getConnectionState = 29;
        static final int TRANSACTION_getConnectionHandle = 30;
        static final int TRANSACTION_getRemoteName = 31;
        static final int TRANSACTION_getRemoteType = 32;
        static final int TRANSACTION_getRemoteAlias = 33;
        static final int TRANSACTION_setRemoteAlias = 34;
        static final int TRANSACTION_getRemoteClass = 35;
        static final int TRANSACTION_getRemoteUuids = 36;
        static final int TRANSACTION_fetchRemoteUuids = 37;
        static final int TRANSACTION_sdpSearch = 38;
        static final int TRANSACTION_getBatteryLevel = 39;
        static final int TRANSACTION_getMaxConnectedAudioDevices = 40;
        static final int TRANSACTION_setPin = 41;
        static final int TRANSACTION_setPasskey = 42;
        static final int TRANSACTION_setPairingConfirmation = 43;
        static final int TRANSACTION_getPhonebookAccessPermission = 44;
        static final int TRANSACTION_setSilenceMode = 45;
        static final int TRANSACTION_getSilenceMode = 46;
        static final int TRANSACTION_setPhonebookAccessPermission = 47;
        static final int TRANSACTION_getMessageAccessPermission = 48;
        static final int TRANSACTION_setMessageAccessPermission = 49;
        static final int TRANSACTION_getSimAccessPermission = 50;
        static final int TRANSACTION_setSimAccessPermission = 51;
        static final int TRANSACTION_registerCallback = 52;
        static final int TRANSACTION_unregisterCallback = 53;
        static final int TRANSACTION_logL2capcocServerConnection = 54;
        static final int TRANSACTION_getSocketManager = 55;
        static final int TRANSACTION_logL2capcocClientConnection = 56;
        static final int TRANSACTION_logRfcommConnectionAttempt = 57;
        static final int TRANSACTION_factoryReset = 58;
        static final int TRANSACTION_isMultiAdvertisementSupported = 59;
        static final int TRANSACTION_isOffloadedFilteringSupported = 60;
        static final int TRANSACTION_isOffloadedScanBatchingSupported = 61;
        static final int TRANSACTION_isActivityAndEnergyReportingSupported = 62;
        static final int TRANSACTION_isLe2MPhySupported = 63;
        static final int TRANSACTION_isLeCodedPhySupported = 64;
        static final int TRANSACTION_isLeExtendedAdvertisingSupported = 65;
        static final int TRANSACTION_isLePeriodicAdvertisingSupported = 66;
        static final int TRANSACTION_isLeAudioSupported = 67;
        static final int TRANSACTION_isLeAudioBroadcastSourceSupported = 68;
        static final int TRANSACTION_isLeAudioBroadcastAssistantSupported = 69;
        static final int TRANSACTION_isDistanceMeasurementSupported = 70;
        static final int TRANSACTION_getLeMaximumAdvertisingDataLength = 71;
        static final int TRANSACTION_reportActivityInfo = 72;
        static final int TRANSACTION_registerMetadataListener = 73;
        static final int TRANSACTION_unregisterMetadataListener = 74;
        static final int TRANSACTION_setMetadata = 75;
        static final int TRANSACTION_getMetadata = 76;
        static final int TRANSACTION_requestActivityInfo = 77;
        static final int TRANSACTION_bleOnToOn = 78;
        static final int TRANSACTION_bleOnToOff = 79;
        static final int TRANSACTION_connectAllEnabledProfiles = 80;
        static final int TRANSACTION_disconnectAllEnabledProfiles = 81;
        static final int TRANSACTION_setActiveDevice = 82;
        static final int TRANSACTION_getActiveDevices = 83;
        static final int TRANSACTION_getMostRecentlyConnectedDevices = 84;
        static final int TRANSACTION_removeActiveDevice = 85;
        static final int TRANSACTION_registerBluetoothConnectionCallback = 86;
        static final int TRANSACTION_unregisterBluetoothConnectionCallback = 87;
        static final int TRANSACTION_canBondWithoutDialog = 88;
        static final int TRANSACTION_getPackageNameOfBondingApplication = 89;
        static final int TRANSACTION_generateLocalOobData = 90;
        static final int TRANSACTION_allowLowLatencyAudio = 91;
        static final int TRANSACTION_isRequestAudioPolicyAsSinkSupported = 92;
        static final int TRANSACTION_requestAudioPolicyAsSink = 93;
        static final int TRANSACTION_getRequestedAudioPolicyAsSink = 94;
        static final int TRANSACTION_startRfcommListener = 95;
        static final int TRANSACTION_stopRfcommListener = 96;
        static final int TRANSACTION_retrievePendingSocketForServiceRecord = 97;
        static final int TRANSACTION_setForegroundUserId = 98;
        static final int TRANSACTION_setPreferredAudioProfiles = 99;
        static final int TRANSACTION_getPreferredAudioProfiles = 100;
        static final int TRANSACTION_isDualModeAudioEnabled = 101;
        static final int TRANSACTION_registerPreferredAudioProfilesChangedCallback = 102;
        static final int TRANSACTION_unregisterPreferredAudioProfilesChangedCallback = 103;
        static final int TRANSACTION_notifyActiveDeviceChangeApplied = 104;
        static final int TRANSACTION_registerBluetoothQualityReportReadyCallback = 105;
        static final int TRANSACTION_unregisterBluetoothQualityReportReadyCallback = 106;
        static final int TRANSACTION_registerHciVendorSpecificCallback = 107;
        static final int TRANSACTION_unregisterHciVendorSpecificCallback = 108;
        static final int TRANSACTION_sendHciVendorSpecificCommand = 109;
        static final int TRANSACTION_getOffloadedTransportDiscoveryDataScanSupported = 110;
        static final int TRANSACTION_isMediaProfileConnected = 111;
        static final int TRANSACTION_getBluetoothGatt = 112;
        static final int TRANSACTION_getBluetoothScan = 113;
        static final int TRANSACTION_unregAllGattClient = 114;
        static final int TRANSACTION_getProfile = 115;
        static final int TRANSACTION_setActiveAudioDevicePolicy = 116;
        static final int TRANSACTION_getActiveAudioDevicePolicy = 117;
        static final int TRANSACTION_setMicrophonePreferredForCalls = 118;
        static final int TRANSACTION_isMicrophonePreferredForCalls = 119;
        static final int TRANSACTION_killBluetoothProcess = 120;
        static final int TRANSACTION_isLeCocSocketOffloadSupported = 121;
        static final int TRANSACTION_isRfcommSocketOffloadSupported = 122;
        static final int TRANSACTION_getBluetoothAdvertise = 123;
        static final int TRANSACTION_getDistanceMeasurement = 124;
        static final int TRANSACTION_getKeyMissingCount = 125;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetooth asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetooth) {
                return (IBluetooth)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getState";
                }
                case 2: {
                    return "offToBleOn";
                }
                case 3: {
                    return "onToBleOn";
                }
                case 4: {
                    return "getAddress";
                }
                case 5: {
                    return "getUuids";
                }
                case 6: {
                    return "setName";
                }
                case 7: {
                    return "getIdentityAddress";
                }
                case 8: {
                    return "getIdentityAddressWithType";
                }
                case 9: {
                    return "getName";
                }
                case 10: {
                    return "getNameLengthForAdvertise";
                }
                case 11: {
                    return "getScanMode";
                }
                case 12: {
                    return "setScanMode";
                }
                case 13: {
                    return "getDiscoverableTimeout";
                }
                case 14: {
                    return "setDiscoverableTimeout";
                }
                case 15: {
                    return "startDiscovery";
                }
                case 16: {
                    return "cancelDiscovery";
                }
                case 17: {
                    return "isDiscovering";
                }
                case 18: {
                    return "getDiscoveryEndMillis";
                }
                case 19: {
                    return "getAdapterConnectionState";
                }
                case 20: {
                    return "getProfileConnectionState";
                }
                case 21: {
                    return "getBondedDevices";
                }
                case 22: {
                    return "createBond";
                }
                case 23: {
                    return "createBondOutOfBand";
                }
                case 24: {
                    return "cancelBondProcess";
                }
                case 25: {
                    return "removeBond";
                }
                case 26: {
                    return "getBondState";
                }
                case 27: {
                    return "isBondingInitiatedLocally";
                }
                case 28: {
                    return "getSupportedProfiles";
                }
                case 29: {
                    return "getConnectionState";
                }
                case 30: {
                    return "getConnectionHandle";
                }
                case 31: {
                    return "getRemoteName";
                }
                case 32: {
                    return "getRemoteType";
                }
                case 33: {
                    return "getRemoteAlias";
                }
                case 34: {
                    return "setRemoteAlias";
                }
                case 35: {
                    return "getRemoteClass";
                }
                case 36: {
                    return "getRemoteUuids";
                }
                case 37: {
                    return "fetchRemoteUuids";
                }
                case 38: {
                    return "sdpSearch";
                }
                case 39: {
                    return "getBatteryLevel";
                }
                case 40: {
                    return "getMaxConnectedAudioDevices";
                }
                case 41: {
                    return "setPin";
                }
                case 42: {
                    return "setPasskey";
                }
                case 43: {
                    return "setPairingConfirmation";
                }
                case 44: {
                    return "getPhonebookAccessPermission";
                }
                case 45: {
                    return "setSilenceMode";
                }
                case 46: {
                    return "getSilenceMode";
                }
                case 47: {
                    return "setPhonebookAccessPermission";
                }
                case 48: {
                    return "getMessageAccessPermission";
                }
                case 49: {
                    return "setMessageAccessPermission";
                }
                case 50: {
                    return "getSimAccessPermission";
                }
                case 51: {
                    return "setSimAccessPermission";
                }
                case 52: {
                    return "registerCallback";
                }
                case 53: {
                    return "unregisterCallback";
                }
                case 54: {
                    return "logL2capcocServerConnection";
                }
                case 55: {
                    return "getSocketManager";
                }
                case 56: {
                    return "logL2capcocClientConnection";
                }
                case 57: {
                    return "logRfcommConnectionAttempt";
                }
                case 58: {
                    return "factoryReset";
                }
                case 59: {
                    return "isMultiAdvertisementSupported";
                }
                case 60: {
                    return "isOffloadedFilteringSupported";
                }
                case 61: {
                    return "isOffloadedScanBatchingSupported";
                }
                case 62: {
                    return "isActivityAndEnergyReportingSupported";
                }
                case 63: {
                    return "isLe2MPhySupported";
                }
                case 64: {
                    return "isLeCodedPhySupported";
                }
                case 65: {
                    return "isLeExtendedAdvertisingSupported";
                }
                case 66: {
                    return "isLePeriodicAdvertisingSupported";
                }
                case 67: {
                    return "isLeAudioSupported";
                }
                case 68: {
                    return "isLeAudioBroadcastSourceSupported";
                }
                case 69: {
                    return "isLeAudioBroadcastAssistantSupported";
                }
                case 70: {
                    return "isDistanceMeasurementSupported";
                }
                case 71: {
                    return "getLeMaximumAdvertisingDataLength";
                }
                case 72: {
                    return "reportActivityInfo";
                }
                case 73: {
                    return "registerMetadataListener";
                }
                case 74: {
                    return "unregisterMetadataListener";
                }
                case 75: {
                    return "setMetadata";
                }
                case 76: {
                    return "getMetadata";
                }
                case 77: {
                    return "requestActivityInfo";
                }
                case 78: {
                    return "bleOnToOn";
                }
                case 79: {
                    return "bleOnToOff";
                }
                case 80: {
                    return "connectAllEnabledProfiles";
                }
                case 81: {
                    return "disconnectAllEnabledProfiles";
                }
                case 82: {
                    return "setActiveDevice";
                }
                case 83: {
                    return "getActiveDevices";
                }
                case 84: {
                    return "getMostRecentlyConnectedDevices";
                }
                case 85: {
                    return "removeActiveDevice";
                }
                case 86: {
                    return "registerBluetoothConnectionCallback";
                }
                case 87: {
                    return "unregisterBluetoothConnectionCallback";
                }
                case 88: {
                    return "canBondWithoutDialog";
                }
                case 89: {
                    return "getPackageNameOfBondingApplication";
                }
                case 90: {
                    return "generateLocalOobData";
                }
                case 91: {
                    return "allowLowLatencyAudio";
                }
                case 92: {
                    return "isRequestAudioPolicyAsSinkSupported";
                }
                case 93: {
                    return "requestAudioPolicyAsSink";
                }
                case 94: {
                    return "getRequestedAudioPolicyAsSink";
                }
                case 95: {
                    return "startRfcommListener";
                }
                case 96: {
                    return "stopRfcommListener";
                }
                case 97: {
                    return "retrievePendingSocketForServiceRecord";
                }
                case 98: {
                    return "setForegroundUserId";
                }
                case 99: {
                    return "setPreferredAudioProfiles";
                }
                case 100: {
                    return "getPreferredAudioProfiles";
                }
                case 101: {
                    return "isDualModeAudioEnabled";
                }
                case 102: {
                    return "registerPreferredAudioProfilesChangedCallback";
                }
                case 103: {
                    return "unregisterPreferredAudioProfilesChangedCallback";
                }
                case 104: {
                    return "notifyActiveDeviceChangeApplied";
                }
                case 105: {
                    return "registerBluetoothQualityReportReadyCallback";
                }
                case 106: {
                    return "unregisterBluetoothQualityReportReadyCallback";
                }
                case 107: {
                    return "registerHciVendorSpecificCallback";
                }
                case 108: {
                    return "unregisterHciVendorSpecificCallback";
                }
                case 109: {
                    return "sendHciVendorSpecificCommand";
                }
                case 110: {
                    return "getOffloadedTransportDiscoveryDataScanSupported";
                }
                case 111: {
                    return "isMediaProfileConnected";
                }
                case 112: {
                    return "getBluetoothGatt";
                }
                case 113: {
                    return "getBluetoothScan";
                }
                case 114: {
                    return "unregAllGattClient";
                }
                case 115: {
                    return "getProfile";
                }
                case 116: {
                    return "setActiveAudioDevicePolicy";
                }
                case 117: {
                    return "getActiveAudioDevicePolicy";
                }
                case 118: {
                    return "setMicrophonePreferredForCalls";
                }
                case 119: {
                    return "isMicrophonePreferredForCalls";
                }
                case 120: {
                    return "killBluetoothProcess";
                }
                case 121: {
                    return "isLeCocSocketOffloadSupported";
                }
                case 122: {
                    return "isRfcommSocketOffloadSupported";
                }
                case 123: {
                    return "getBluetoothAdvertise";
                }
                case 124: {
                    return "getDistanceMeasurement";
                }
                case 125: {
                    return "getKeyMissingCount";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.offToBleOn(_arg0, _arg1);
                    break;
                }
                case 3: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.onToBleOn(_arg0);
                    break;
                }
                case 4: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getAddress(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<ParcelUuid> _result = this.getUuids(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setName(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getIdentityAddress(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    BluetoothDevice.BluetoothAddress _result = this.getIdentityAddressWithType(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 10: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getNameLengthForAdvertise(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getScanMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setScanMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getDiscoverableTimeout(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 14: {
                    long _arg0 = data.readLong();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setDiscoverableTimeout(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.startDiscovery(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.cancelDiscovery(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isDiscovering(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getDiscoveryEndMillis(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 19: {
                    int _result = this.getAdapterConnectionState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getProfileConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<BluetoothDevice> _result = this.getBondedDevices(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 22: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.createBond(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    OobData _arg2 = data.readTypedObject(OobData.CREATOR);
                    OobData _arg3 = data.readTypedObject(OobData.CREATOR);
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.createBondOutOfBand(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.cancelBondProcess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.removeBond(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getBondState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isBondingInitiatedLocally(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getSupportedProfiles(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 29: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 30: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getConnectionHandle(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 31: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getRemoteName(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 32: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getRemoteType(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getRemoteAlias(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 34: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setRemoteAlias(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 35: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getRemoteClass(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 36: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<ParcelUuid> _result = this.getRemoteUuids(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 37: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.fetchRemoteUuids(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sdpSearch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getBatteryLevel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 40: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getMaxConnectedAudioDevices(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 41: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setPin(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setPasskey(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 43: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setPairingConfirmation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 44: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getPhonebookAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 45: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setSilenceMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 46: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.getSilenceMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 47: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setPhonebookAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 48: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getMessageAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 49: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setMessageAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getSimAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setSimAccessPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 52: {
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1);
                    break;
                }
                case 53: {
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0, _arg1);
                    break;
                }
                case 54: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    long _arg4 = data.readLong();
                    long _arg5 = data.readLong();
                    long _arg6 = data.readLong();
                    long _arg7 = data.readLong();
                    data.enforceNoDataAvail();
                    this.logL2capcocServerConnection(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    IBluetoothSocketManager _result = this.getSocketManager();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 56: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    long _arg4 = data.readLong();
                    long _arg5 = data.readLong();
                    long _arg6 = data.readLong();
                    data.enforceNoDataAvail();
                    this.logL2capcocClientConnection(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.logRfcommConnectionAttempt(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.factoryReset(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    boolean _result = this.isMultiAdvertisementSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 60: {
                    boolean _result = this.isOffloadedFilteringSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    boolean _result = this.isOffloadedScanBatchingSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 62: {
                    boolean _result = this.isActivityAndEnergyReportingSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 63: {
                    boolean _result = this.isLe2MPhySupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 64: {
                    boolean _result = this.isLeCodedPhySupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 65: {
                    boolean _result = this.isLeExtendedAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 66: {
                    boolean _result = this.isLePeriodicAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 67: {
                    int _result = this.isLeAudioSupported();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 68: {
                    int _result = this.isLeAudioBroadcastSourceSupported();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 69: {
                    int _result = this.isLeAudioBroadcastAssistantSupported();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 70: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.isDistanceMeasurementSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 71: {
                    int _result = this.getLeMaximumAdvertisingDataLength();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 72: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    BluetoothActivityEnergyInfo _result = this.reportActivityInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 73: {
                    IBluetoothMetadataListener _arg0 = IBluetoothMetadataListener.Stub.asInterface(data.readStrongBinder());
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.registerMetadataListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 74: {
                    IBluetoothMetadataListener _arg0 = IBluetoothMetadataListener.Stub.asInterface(data.readStrongBinder());
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterMetadataListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 75: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setMetadata(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 76: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    byte[] _result = this.getMetadata(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 77: {
                    IBluetoothActivityEnergyInfoListener _arg0 = IBluetoothActivityEnergyInfoListener.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestActivityInfo(_arg0, _arg1);
                    break;
                }
                case 78: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.bleOnToOn(_arg0);
                    break;
                }
                case 79: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.bleOnToOff(_arg0);
                    break;
                }
                case 80: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.connectAllEnabledProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 81: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.disconnectAllEnabledProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 82: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setActiveDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 83: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<BluetoothDevice> _result = this.getActiveDevices(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 84: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    List<BluetoothDevice> _result = this.getMostRecentlyConnectedDevices(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 85: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.removeActiveDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 86: {
                    IBluetoothConnectionCallback _arg0 = IBluetoothConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerBluetoothConnectionCallback(_arg0, _arg1);
                    break;
                }
                case 87: {
                    IBluetoothConnectionCallback _arg0 = IBluetoothConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterBluetoothConnectionCallback(_arg0, _arg1);
                    break;
                }
                case 88: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.canBondWithoutDialog(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 89: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getPackageNameOfBondingApplication(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 90: {
                    int _arg0 = data.readInt();
                    IBluetoothOobDataCallback _arg1 = IBluetoothOobDataCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.generateLocalOobData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    boolean _arg0 = data.readBoolean();
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.allowLowLatencyAudio(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 92: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.isRequestAudioPolicyAsSinkSupported(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 93: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothSinkAudioPolicy _arg1 = data.readTypedObject(BluetoothSinkAudioPolicy.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.requestAudioPolicyAsSink(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 94: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    BluetoothSinkAudioPolicy _result = this.getRequestedAudioPolicyAsSink(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 95: {
                    String _arg0 = data.readString();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.startRfcommListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 96: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.stopRfcommListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 97: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    IncomingRfcommSocketInfo _result = this.retrievePendingSocketForServiceRecord(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 98: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setForegroundUserId(_arg0, _arg1);
                    break;
                }
                case 99: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredAudioProfiles(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 100: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    Bundle _result = this.getPreferredAudioProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 101: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.isDualModeAudioEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 102: {
                    IBluetoothPreferredAudioProfilesCallback _arg0 = IBluetoothPreferredAudioProfilesCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.registerPreferredAudioProfilesChangedCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 103: {
                    IBluetoothPreferredAudioProfilesCallback _arg0 = IBluetoothPreferredAudioProfilesCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.unregisterPreferredAudioProfilesChangedCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 104: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.notifyActiveDeviceChangeApplied(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 105: {
                    IBluetoothQualityReportReadyCallback _arg0 = IBluetoothQualityReportReadyCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.registerBluetoothQualityReportReadyCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 106: {
                    IBluetoothQualityReportReadyCallback _arg0 = IBluetoothQualityReportReadyCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.unregisterBluetoothQualityReportReadyCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 107: {
                    IBluetoothHciVendorSpecificCallback _arg0 = IBluetoothHciVendorSpecificCallback.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.registerHciVendorSpecificCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 108: {
                    IBluetoothHciVendorSpecificCallback _arg0 = IBluetoothHciVendorSpecificCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterHciVendorSpecificCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 109: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    IBluetoothHciVendorSpecificCallback _arg2 = IBluetoothHciVendorSpecificCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.sendHciVendorSpecificCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 110: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getOffloadedTransportDiscoveryDataScanSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 111: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isMediaProfileConnected(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 112: {
                    IBinder _result = this.getBluetoothGatt();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 113: {
                    IBinder _result = this.getBluetoothScan();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 114: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregAllGattClient(_arg0);
                    break;
                }
                case 115: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getProfile(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 116: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setActiveAudioDevicePolicy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 117: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getActiveAudioDevicePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 118: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setMicrophonePreferredForCalls(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 119: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isMicrophonePreferredForCalls(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 120: {
                    this.killBluetoothProcess();
                    break;
                }
                case 121: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isLeCocSocketOffloadSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 122: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isRfcommSocketOffloadSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 123: {
                    IBinder _result = this.getBluetoothAdvertise();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 124: {
                    IBinder _result = this.getDistanceMeasurement();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 125: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getKeyMissingCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 124;
        }

        private static class Proxy
        implements IBluetooth {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void offToBleOn(boolean quietMode, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(quietMode);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onToBleOn(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAddress(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ParcelUuid> getUuids(AttributionSource attributionSource) throws RemoteException {
                ArrayList<ParcelUuid> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setName(String name, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getIdentityAddress(String address) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothDevice.BluetoothAddress getIdentityAddressWithType(String address) throws RemoteException {
                BluetoothDevice.BluetoothAddress _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BluetoothDevice.BluetoothAddress.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getName(AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNameLengthForAdvertise(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getScanMode(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setScanMode(int mode, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getDiscoverableTimeout(AttributionSource attributionSource) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDiscoverableTimeout(long timeout, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeout);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startDiscovery(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelDiscovery(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDiscovering(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getDiscoveryEndMillis(AttributionSource attributionSource) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdapterConnectionState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getProfileConnectionState(int profile, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profile);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getBondedDevices(AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean createBond(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transport);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean createBondOutOfBand(BluetoothDevice device, int transport, OobData p192Data, OobData p256Data, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transport);
                    _data.writeTypedObject(p192Data, 0);
                    _data.writeTypedObject(p256Data, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelBondProcess(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeBond(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBondState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBondingInitiatedLocally(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSupportedProfiles(AttributionSource attributionSource) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionHandle(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transport);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteName(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoteType(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteAlias(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setRemoteAlias(BluetoothDevice device, String name, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeString(name);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoteClass(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ParcelUuid> getRemoteUuids(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                ArrayList<ParcelUuid> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean fetchRemoteUuids(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transport);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sdpSearch(BluetoothDevice device, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBatteryLevel(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxConnectedAudioDevices(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPin(BluetoothDevice device, boolean accept, int len, byte[] pinCode, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(accept);
                    _data.writeInt(len);
                    _data.writeByteArray(pinCode);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPasskey(BluetoothDevice device, boolean accept, int len, byte[] passkey, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(accept);
                    _data.writeInt(len);
                    _data.writeByteArray(passkey);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPairingConfirmation(BluetoothDevice device, boolean accept, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(accept);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhonebookAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSilenceMode(BluetoothDevice device, boolean silence, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(silence);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSilenceMode(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPhonebookAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(value);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMessageAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMessageAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(value);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSimAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSimAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(value);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(52, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(53, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logL2capcocServerConnection(BluetoothDevice device, int port, boolean isSecured, int result, long socketCreationTimeMillis, long socketCreationLatencyMillis, long socketConnectionTimeMillis, long timeoutMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(port);
                    _data.writeBoolean(isSecured);
                    _data.writeInt(result);
                    _data.writeLong(socketCreationTimeMillis);
                    _data.writeLong(socketCreationLatencyMillis);
                    _data.writeLong(socketConnectionTimeMillis);
                    _data.writeLong(timeoutMillis);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBluetoothSocketManager getSocketManager() throws RemoteException {
                IBluetoothSocketManager _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = IBluetoothSocketManager.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logL2capcocClientConnection(BluetoothDevice device, int port, boolean isSecured, int result, long socketCreationTimeNanos, long socketCreationLatencyNanos, long socketConnectionTimeNanos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(port);
                    _data.writeBoolean(isSecured);
                    _data.writeInt(result);
                    _data.writeLong(socketCreationTimeNanos);
                    _data.writeLong(socketCreationLatencyNanos);
                    _data.writeLong(socketConnectionTimeNanos);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logRfcommConnectionAttempt(BluetoothDevice device, boolean isSecured, int resultCode, long socketCreationTimeNanos, boolean isSerialPort) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(isSecured);
                    _data.writeInt(resultCode);
                    _data.writeLong(socketCreationTimeNanos);
                    _data.writeBoolean(isSerialPort);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiAdvertisementSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOffloadedFilteringSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOffloadedScanBatchingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLe2MPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLeCodedPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLeExtendedAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLePeriodicAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isLeAudioSupported() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isLeAudioBroadcastSourceSupported() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isLeAudioBroadcastAssistantSupported() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isDistanceMeasurementSupported(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLeMaximumAdvertisingDataLength() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource attributionSource) throws RemoteException {
                BluetoothActivityEnergyInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BluetoothActivityEnergyInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMetadata(BluetoothDevice device, int key, byte[] value, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadata(BluetoothDevice device, int key, AttributionSource attributionSource) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(key);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestActivityInfo(IBluetoothActivityEnergyInfoListener listener, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(77, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bleOnToOn(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(78, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bleOnToOff(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(79, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int connectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disconnectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setActiveDevice(BluetoothDevice device, int profiles, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(profiles);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getActiveDevices(int profile, AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profile);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeActiveDevice(int profiles, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profiles);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(86, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(87, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBondWithoutDialog(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPackageNameOfBondingApplication(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateLocalOobData(int transport, IBluetoothOobDataCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(transport);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean allowLowLatencyAudio(boolean allowed, BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(allowed);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isRequestAudioPolicyAsSinkSupported(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioPolicyAsSink(BluetoothDevice device, BluetoothSinkAudioPolicy policies, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(policies, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BluetoothSinkAudioPolicy getRequestedAudioPolicyAsSink(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                BluetoothSinkAudioPolicy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BluetoothSinkAudioPolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startRfcommListener(String name, ParcelUuid uuid, PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int stopRfcommListener(ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncomingRfcommSocketInfo retrievePendingSocketForServiceRecord(ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
                IncomingRfcommSocketInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IncomingRfcommSocketInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForegroundUserId(int userId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(98, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredAudioProfiles(BluetoothDevice device, Bundle modeToProfileBundle, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(modeToProfileBundle, 0);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getPreferredAudioProfiles(BluetoothDevice device, AttributionSource source) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isDualModeAudioEnabled(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback callback, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int unregisterPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback callback, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int notifyActiveDeviceChangeApplied(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback callback, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int unregisterBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback callback, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback callback, int[] eventCodes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeIntArray(eventCodes);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendHciVendorSpecificCommand(int ocf, byte[] parameters, IBluetoothHciVendorSpecificCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ocf);
                    _data.writeByteArray(parameters);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOffloadedTransportDiscoveryDataScanSupported(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMediaProfileConnected(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getBluetoothGatt() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getBluetoothScan() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregAllGattClient(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(114, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getProfile(int profile) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profile);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setActiveAudioDevicePolicy(BluetoothDevice device, int activeAudioDevicePolicy, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(activeAudioDevicePolicy);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveAudioDevicePolicy(BluetoothDevice device, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setMicrophonePreferredForCalls(BluetoothDevice device, boolean enabled, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMicrophonePreferredForCalls(BluetoothDevice device, AttributionSource source) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void killBluetoothProcess() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(120, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLeCocSocketOffloadSupported(AttributionSource source) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRfcommSocketOffloadSupported(AttributionSource source) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getBluetoothAdvertise() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getDistanceMeasurement() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getKeyMissingCount(BluetoothDevice device, AttributionSource source) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBluetooth {
        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public void offToBleOn(boolean quietMode, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void onToBleOn(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public String getAddress(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public List<ParcelUuid> getUuids(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean setName(String name, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public String getIdentityAddress(String address) throws RemoteException {
            return null;
        }

        @Override
        public BluetoothDevice.BluetoothAddress getIdentityAddressWithType(String address) throws RemoteException {
            return null;
        }

        @Override
        public String getName(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int getNameLengthForAdvertise(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getScanMode(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int setScanMode(int mode, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public long getDiscoverableTimeout(AttributionSource attributionSource) throws RemoteException {
            return 0L;
        }

        @Override
        public int setDiscoverableTimeout(long timeout, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean startDiscovery(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean cancelDiscovery(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean isDiscovering(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public long getDiscoveryEndMillis(AttributionSource attributionSource) throws RemoteException {
            return 0L;
        }

        @Override
        public int getAdapterConnectionState() throws RemoteException {
            return 0;
        }

        @Override
        public int getProfileConnectionState(int profile, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public List<BluetoothDevice> getBondedDevices(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean createBond(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean createBondOutOfBand(BluetoothDevice device, int transport, OobData p192Data, OobData p256Data, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean cancelBondProcess(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeBond(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getBondState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isBondingInitiatedLocally(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public long getSupportedProfiles(AttributionSource attributionSource) throws RemoteException {
            return 0L;
        }

        @Override
        public int getConnectionState(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getConnectionHandle(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public String getRemoteName(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int getRemoteType(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public String getRemoteAlias(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int setRemoteAlias(BluetoothDevice device, String name, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getRemoteClass(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public List<ParcelUuid> getRemoteUuids(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean fetchRemoteUuids(BluetoothDevice device, int transport, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean sdpSearch(BluetoothDevice device, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getBatteryLevel(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getMaxConnectedAudioDevices(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setPin(BluetoothDevice device, boolean accept, int len, byte[] pinCode, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPasskey(BluetoothDevice device, boolean accept, int len, byte[] passkey, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPairingConfirmation(BluetoothDevice device, boolean accept, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getPhonebookAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setSilenceMode(BluetoothDevice device, boolean silence, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean getSilenceMode(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setPhonebookAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getMessageAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setMessageAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getSimAccessPermission(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setSimAccessPermission(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IBluetoothCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void logL2capcocServerConnection(BluetoothDevice device, int port, boolean isSecured, int result, long socketCreationTimeMillis, long socketCreationLatencyMillis, long socketConnectionTimeMillis, long timeoutMillis) throws RemoteException {
        }

        @Override
        public IBluetoothSocketManager getSocketManager() throws RemoteException {
            return null;
        }

        @Override
        public void logL2capcocClientConnection(BluetoothDevice device, int port, boolean isSecured, int result, long socketCreationTimeNanos, long socketCreationLatencyNanos, long socketConnectionTimeNanos) throws RemoteException {
        }

        @Override
        public void logRfcommConnectionAttempt(BluetoothDevice device, boolean isSecured, int resultCode, long socketCreationTimeNanos, boolean isSerialPort) throws RemoteException {
        }

        @Override
        public boolean factoryReset(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean isMultiAdvertisementSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOffloadedFilteringSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOffloadedScanBatchingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLe2MPhySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLeCodedPhySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLeExtendedAdvertisingSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLePeriodicAdvertisingSupported() throws RemoteException {
            return false;
        }

        @Override
        public int isLeAudioSupported() throws RemoteException {
            return 0;
        }

        @Override
        public int isLeAudioBroadcastSourceSupported() throws RemoteException {
            return 0;
        }

        @Override
        public int isLeAudioBroadcastAssistantSupported() throws RemoteException {
            return 0;
        }

        @Override
        public int isDistanceMeasurementSupported(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getLeMaximumAdvertisingDataLength() throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothActivityEnergyInfo reportActivityInfo(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterMetadataListener(IBluetoothMetadataListener listener, BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public boolean setMetadata(BluetoothDevice device, int key, byte[] value, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public byte[] getMetadata(BluetoothDevice device, int key, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void requestActivityInfo(IBluetoothActivityEnergyInfoListener listener, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void bleOnToOn(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void bleOnToOff(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public int connectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int disconnectAllEnabledProfiles(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setActiveDevice(BluetoothDevice device, int profiles, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public List<BluetoothDevice> getActiveDevices(int profile, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public List<BluetoothDevice> getMostRecentlyConnectedDevices(AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public boolean removeActiveDevice(int profiles, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void registerBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterBluetoothConnectionCallback(IBluetoothConnectionCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public boolean canBondWithoutDialog(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public String getPackageNameOfBondingApplication(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void generateLocalOobData(int transport, IBluetoothOobDataCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public boolean allowLowLatencyAudio(boolean allowed, BluetoothDevice device) throws RemoteException {
            return false;
        }

        @Override
        public int isRequestAudioPolicyAsSinkSupported(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int requestAudioPolicyAsSink(BluetoothDevice device, BluetoothSinkAudioPolicy policies, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public BluetoothSinkAudioPolicy getRequestedAudioPolicyAsSink(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public int startRfcommListener(String name, ParcelUuid uuid, PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int stopRfcommListener(ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public IncomingRfcommSocketInfo retrievePendingSocketForServiceRecord(ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void setForegroundUserId(int userId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public int setPreferredAudioProfiles(BluetoothDevice device, Bundle modeToProfileBundle, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public Bundle getPreferredAudioProfiles(BluetoothDevice device, AttributionSource source) throws RemoteException {
            return null;
        }

        @Override
        public int isDualModeAudioEnabled(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int registerPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback callback, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int unregisterPreferredAudioProfilesChangedCallback(IBluetoothPreferredAudioProfilesCallback callback, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int notifyActiveDeviceChangeApplied(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int registerBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback callback, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int unregisterBluetoothQualityReportReadyCallback(IBluetoothQualityReportReadyCallback callback, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public void registerHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback callback, int[] eventCodes) throws RemoteException {
        }

        @Override
        public void unregisterHciVendorSpecificCallback(IBluetoothHciVendorSpecificCallback callback) throws RemoteException {
        }

        @Override
        public void sendHciVendorSpecificCommand(int ocf, byte[] parameters, IBluetoothHciVendorSpecificCallback callback) throws RemoteException {
        }

        @Override
        public int getOffloadedTransportDiscoveryDataScanSupported(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isMediaProfileConnected(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public IBinder getBluetoothGatt() throws RemoteException {
            return null;
        }

        @Override
        public IBinder getBluetoothScan() throws RemoteException {
            return null;
        }

        @Override
        public void unregAllGattClient(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBinder getProfile(int profile) throws RemoteException {
            return null;
        }

        @Override
        public int setActiveAudioDevicePolicy(BluetoothDevice device, int activeAudioDevicePolicy, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public int getActiveAudioDevicePolicy(BluetoothDevice device, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public int setMicrophonePreferredForCalls(BluetoothDevice device, boolean enabled, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isMicrophonePreferredForCalls(BluetoothDevice device, AttributionSource source) throws RemoteException {
            return false;
        }

        @Override
        public void killBluetoothProcess() throws RemoteException {
        }

        @Override
        public boolean isLeCocSocketOffloadSupported(AttributionSource source) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRfcommSocketOffloadSupported(AttributionSource source) throws RemoteException {
            return false;
        }

        @Override
        public IBinder getBluetoothAdvertise() throws RemoteException {
            return null;
        }

        @Override
        public IBinder getDistanceMeasurement() throws RemoteException {
            return null;
        }

        @Override
        public int getKeyMissingCount(BluetoothDevice device, AttributionSource source) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

