/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Binder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class BluetoothUtils {
    private static final String TAG = BluetoothUtils.class.getSimpleName();
    public static final UserHandle USER_HANDLE_NULL = UserHandle.of(-10000);

    private BluetoothUtils() {
    }

    public static byte[] extractBytes(byte[] rawBytes, int start, int length) {
        int remainingLength = rawBytes.length - start;
        if (remainingLength < length) {
            Log.w(TAG, "extractBytes() remaining length " + remainingLength + " is less than copying length " + length + ", array length is " + rawBytes.length + " start is " + start);
            return null;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(rawBytes, start, bytes, 0, length);
        return bytes;
    }

    public static List<TypeValueEntry> parseLengthTypeValueBytes(byte[] rawBytes) {
        int length;
        int dataLength;
        if (rawBytes == null) {
            return Collections.emptyList();
        }
        if (rawBytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeValueEntry> result = new ArrayList<TypeValueEntry>();
        for (int currentPos = 0; currentPos < rawBytes.length && (length = rawBytes[currentPos] & 0xFF) != 0; currentPos += dataLength) {
            if (++currentPos >= rawBytes.length) {
                Log.w(TAG, "parseLtv() no type and value after length, rawBytes length = " + rawBytes.length + ", currentPost = " + currentPos);
                break;
            }
            dataLength = length - 1;
            int type = rawBytes[currentPos] & 0xFF;
            if (++currentPos >= rawBytes.length) {
                Log.w(TAG, "parseLtv() no value after length, rawBytes length = " + rawBytes.length + ", currentPost = " + currentPos);
                break;
            }
            byte[] value = BluetoothUtils.extractBytes(rawBytes, currentPos, dataLength);
            if (value == null) {
                Log.w(TAG, "failed to extract bytes, currentPost = " + currentPos);
                break;
            }
            result.add(new TypeValueEntry(type, value));
        }
        return result;
    }

    public static byte[] serializeTypeValue(List<TypeValueEntry> typeValueEntries) {
        int length = 0;
        for (TypeValueEntry entry : typeValueEntries) {
            length += 2;
            if (entry.getType() - (entry.getType() & 0xFF) != 0) {
                Log.w(TAG, "serializeTypeValue() type " + entry.getType() + " is out of range of 0-0xFF");
                return null;
            }
            if (entry.getValue() == null) {
                Log.w(TAG, "serializeTypeValue() value is null");
                return null;
            }
            int lengthValue = entry.getValue().length + 1;
            if (lengthValue - (lengthValue & 0xFF) != 0) {
                Log.w(TAG, "serializeTypeValue() entry length " + entry.getValue().length + " is not in range of 0 to 254");
                return null;
            }
            length += entry.getValue().length;
        }
        byte[] result = new byte[length];
        int currentPos = 0;
        for (TypeValueEntry entry : typeValueEntries) {
            result[currentPos] = (byte)(entry.getValue().length + 1 & 0xFF);
            result[++currentPos] = (byte)(entry.getType() & 0xFF);
            System.arraycopy(entry.getValue(), 0, result, ++currentPos, entry.getValue().length);
            currentPos += entry.getValue().length;
        }
        return result;
    }

    public static String toAnonymizedAddress(String address) {
        if (address == null || address.length() != 17) {
            return null;
        }
        return "XX:XX:XX:XX" + address.substring(11);
    }

    @NonNull
    public static String formatSimple(@NonNull String format, Object ... args) {
        StringBuilder sb = new StringBuilder(format);
        int j = 0;
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '%') {
                String repl;
                char code = sb.charAt(i + 1);
                char prefixChar = '\u0000';
                int prefixLen = 0;
                int consume = 2;
                while ('0' <= code && code <= '9') {
                    if (prefixChar == '\u0000') {
                        prefixChar = code == '0' ? (char)'0' : ' ';
                    }
                    prefixLen *= 10;
                    prefixLen += Character.digit(code, 10);
                    code = sb.charAt(i + ++consume - 1);
                }
                switch (code) {
                    case 'b': {
                        Object arg;
                        if (j == args.length) {
                            throw new IllegalArgumentException("Too few arguments");
                        }
                        if ((arg = args[j++]) instanceof Boolean) {
                            repl = Boolean.toString((Boolean)arg);
                            break;
                        }
                        repl = Boolean.toString(arg != null);
                        break;
                    }
                    case 'c': 
                    case 'd': 
                    case 'f': 
                    case 's': {
                        if (j == args.length) {
                            throw new IllegalArgumentException("Too few arguments");
                        }
                        Object arg = args[j++];
                        repl = String.valueOf(arg);
                        break;
                    }
                    case 'x': {
                        Object arg;
                        if (j == args.length) {
                            throw new IllegalArgumentException("Too few arguments");
                        }
                        if ((arg = args[j++]) instanceof Integer) {
                            repl = Integer.toHexString((Integer)arg);
                            break;
                        }
                        if (arg instanceof Long) {
                            repl = Long.toHexString((Long)arg);
                            break;
                        }
                        if (arg instanceof Byte) {
                            repl = Integer.toHexString(Byte.toUnsignedInt((Byte)arg));
                            break;
                        }
                        throw new IllegalArgumentException("Unsupported hex type " + arg.getClass().getSimpleName());
                    }
                    case '%': {
                        repl = "%";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported format code " + code);
                    }
                }
                sb.replace(i, i + consume, repl);
                int prefixInsert = prefixChar == '0' && repl.charAt(0) == '-' ? 1 : 0;
                for (int k = repl.length(); k < prefixLen; ++k) {
                    sb.insert(i + prefixInsert, prefixChar);
                }
                i += Math.max(repl.length(), prefixLen);
                continue;
            }
            ++i;
        }
        if (j != args.length) {
            throw new IllegalArgumentException("Too many arguments");
        }
        return sb.toString();
    }

    public static void writeStringToParcel(@NonNull Parcel out, @Nullable String str) {
        out.writeString(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeFromBinder(@NonNull Executor executor, @NonNull Runnable callback) {
        long identity = Binder.clearCallingIdentity();
        try {
            executor.execute(() -> callback.run());
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static <S, R> R callService(S service, RemoteExceptionIgnoringFunction<S, R> function, R defaultValue) {
        return function.apply(service, defaultValue);
    }

    public static <S, R> R callServiceIfEnabled(BluetoothAdapter adapter, Supplier<S> provider, RemoteExceptionIgnoringFunction<S, R> function, R defaultValue) {
        if (!adapter.isEnabled()) {
            Log.d(TAG, "BluetoothAdapter is not enabled");
            return defaultValue;
        }
        S service = provider.get();
        if (service == null) {
            Log.d(TAG, "Proxy not attached to service");
            return defaultValue;
        }
        return BluetoothUtils.callService(service, function, defaultValue);
    }

    public static <S> void callServiceIfEnabled(BluetoothAdapter adapter, Supplier<S> provider, RemoteExceptionIgnoringConsumer<S> consumer) {
        if (!adapter.isEnabled()) {
            Log.d(TAG, "BluetoothAdapter is not enabled");
            return;
        }
        S service = provider.get();
        if (service == null) {
            Log.d(TAG, "Proxy not attached to service");
            return;
        }
        consumer.accept(service);
    }

    public static String inlineStackTrace() {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(new Throwable().getStackTrace()).skip(1L).forEach(trace -> sb.append(" [at ").append(trace).append("]"));
        return sb.toString();
    }

    public static void logRemoteException(String tag, RemoteException ex) {
        Log.w(tag, ((Object)ex).toString() + ": " + BluetoothUtils.inlineStackTrace());
    }

    static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    public static class TypeValueEntry {
        private final int mType;
        private final byte[] mValue;

        TypeValueEntry(int type, byte[] value) {
            this.mType = type;
            this.mValue = value;
        }

        @RequiresNoPermission
        public int getType() {
            return this.mType;
        }

        @RequiresNoPermission
        public byte[] getValue() {
            return this.mValue;
        }
    }

    @FunctionalInterface
    public static interface RemoteExceptionIgnoringFunction<T, R> {
        public R applyOrThrow(T var1) throws RemoteException;

        @RequiresNoPermission
        default public R apply(T t, R defaultValue) {
            try {
                return this.applyOrThrow(t);
            }
            catch (RemoteException ex) {
                BluetoothUtils.logRemoteException(TAG, ex);
                return defaultValue;
            }
        }
    }

    @FunctionalInterface
    public static interface RemoteExceptionIgnoringConsumer<T> {
        public void acceptOrThrow(T var1) throws RemoteException;

        @RequiresNoPermission
        default public void accept(T t) {
            try {
                this.acceptOrThrow(t);
            }
            catch (RemoteException ex) {
                BluetoothUtils.logRemoteException(TAG, ex);
            }
        }
    }

    @FunctionalInterface
    public static interface RemoteExceptionIgnoringRunnable {
        public void runOrThrow() throws RemoteException;

        @RequiresNoPermission
        default public void run() {
            try {
                this.runOrThrow();
            }
            catch (RemoteException ex) {
                BluetoothUtils.logRemoteException(TAG, ex);
            }
        }
    }
}

