/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.SystemApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

@FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
public class BluetoothSocketSettings {
    private static final int L2CAP_PSM_UNSPECIFIED = -1;
    @SystemApi
    public static final int DATA_PATH_NO_OFFLOAD = 0;
    @SystemApi
    public static final int DATA_PATH_HARDWARE_OFFLOAD = 1;
    @SystemApi
    private static final int HARDWARE_OFFLOAD_PACKET_MAX_SIZE = 65535;
    @SystemApi
    private static final int HARDWARE_OFFLOAD_SOCKET_NAME_MAX_LENGTH = 127;
    private static final long INVALID_HUB_ID = 0L;
    private static final long INVALID_ENDPOINT_ID = 0L;
    private final int mSocketType;
    private final boolean mEncryptionRequired;
    private final boolean mAuthenticationRequired;
    private final int mL2capPsm;
    private final String mRfcommServiceName;
    private final UUID mRfcommUuid;
    private final int mDataPath;
    private final String mSocketName;
    private final long mHubId;
    private final long mEndpointId;
    private final int mMaximumPacketSize;

    @RequiresNoPermission
    public int getSocketType() {
        return this.mSocketType;
    }

    @RequiresNoPermission
    public int getL2capPsm() {
        return this.mL2capPsm;
    }

    @Nullable
    @RequiresNoPermission
    public String getRfcommServiceName() {
        return this.mRfcommServiceName;
    }

    @Nullable
    @RequiresNoPermission
    public UUID getRfcommUuid() {
        return this.mRfcommUuid;
    }

    @RequiresNoPermission
    public boolean isEncryptionRequired() {
        return this.mEncryptionRequired;
    }

    @RequiresNoPermission
    public boolean isAuthenticationRequired() {
        return this.mAuthenticationRequired;
    }

    @SystemApi
    @RequiresNoPermission
    public int getDataPath() {
        return this.mDataPath;
    }

    @SystemApi
    @NonNull
    @RequiresNoPermission
    public String getSocketName() {
        return this.mSocketName;
    }

    @SystemApi
    @RequiresNoPermission
    public long getHubId() {
        if (this.mDataPath != 1) {
            return 0L;
        }
        return this.mHubId;
    }

    @SystemApi
    @RequiresNoPermission
    public long getEndpointId() {
        if (this.mDataPath != 1) {
            return 0L;
        }
        return this.mEndpointId;
    }

    @SystemApi
    @RequiresNoPermission
    public int getRequestedMaximumPacketSize() {
        return this.mMaximumPacketSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BluetoothSocketSettings{");
        builder.append("mSocketType=").append(this.mSocketType).append(", mEncryptionRequired=").append(this.mEncryptionRequired).append(", mAuthenticationRequired=").append(this.mAuthenticationRequired);
        if (this.mSocketType == 1) {
            builder.append(", mRfcommServiceName=").append(this.mRfcommServiceName).append(", mRfcommUuid=").append(this.mRfcommUuid);
        } else {
            builder.append(", mL2capPsm=").append(this.mL2capPsm);
        }
        if (this.mDataPath == 1) {
            builder.append(", mDataPath=").append(this.mDataPath).append(", mSocketName=").append(this.mSocketName).append(", mHubId=").append(this.mHubId).append(", mEndpointId=").append(this.mEndpointId).append(", mMaximumPacketSize=").append(this.mMaximumPacketSize);
        }
        builder.append("}");
        return builder.toString();
    }

    private BluetoothSocketSettings(int socketType, int l2capPsm, boolean encryptionRequired, boolean authenticationRequired, String rfcommServiceName, UUID rfcommUuid, int dataPath, String socketName, long hubId, long endpointId, int maximumPacketSize) {
        this.mSocketType = socketType;
        this.mL2capPsm = l2capPsm;
        this.mEncryptionRequired = encryptionRequired;
        this.mAuthenticationRequired = authenticationRequired;
        this.mRfcommUuid = rfcommUuid;
        this.mRfcommServiceName = rfcommServiceName;
        this.mDataPath = dataPath;
        this.mSocketName = socketName;
        this.mHubId = hubId;
        this.mEndpointId = endpointId;
        this.mMaximumPacketSize = maximumPacketSize;
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    public static class Builder {
        private int mSocketType = 1;
        private int mL2capPsm = -1;
        private boolean mEncryptionRequired = false;
        private boolean mAuthenticationRequired = false;
        private String mRfcommServiceName = null;
        private UUID mRfcommUuid = null;
        private int mDataPath = 0;
        private String mSocketName = "default_name";
        private long mHubId = 0L;
        private long mEndpointId = 0L;
        private int mMaximumPacketSize = 65535;

        @NonNull
        @RequiresNoPermission
        public Builder setSocketType(int socketType) {
            if (socketType != 1 && socketType != 4) {
                throw new IllegalArgumentException("invalid socketType - " + socketType);
            }
            this.mSocketType = socketType;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public Builder setL2capPsm(int l2capPsm) {
            if (l2capPsm < 128 || l2capPsm > 255) {
                throw new IllegalArgumentException("invalid L2cap PSM - " + l2capPsm);
            }
            this.mL2capPsm = l2capPsm;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public Builder setEncryptionRequired(boolean encryptionRequired) {
            this.mEncryptionRequired = encryptionRequired;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public Builder setAuthenticationRequired(boolean authenticationRequired) {
            this.mAuthenticationRequired = authenticationRequired;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public Builder setRfcommServiceName(@NonNull String rfcommServiceName) {
            this.mRfcommServiceName = rfcommServiceName;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public Builder setRfcommUuid(@NonNull UUID rfcommUuid) {
            this.mRfcommUuid = rfcommUuid;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresNoPermission
        public Builder setDataPath(int dataPath) {
            if (dataPath < 0 || dataPath > 1) {
                throw new IllegalArgumentException("Invalid dataPath - " + dataPath);
            }
            this.mDataPath = dataPath;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresNoPermission
        public Builder setSocketName(@NonNull String socketName) {
            byte[] socketNameBytes = Objects.requireNonNull(socketName).getBytes(StandardCharsets.UTF_8);
            if (socketNameBytes.length > 127) {
                throw new IllegalArgumentException("Socket name cannot exceed 127 bytes in length when encoded in UTF-8.");
            }
            this.mSocketName = Objects.requireNonNull(socketName);
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresNoPermission
        public Builder setHubId(long hubId) {
            this.mHubId = hubId;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresNoPermission
        public Builder setEndpointId(long endpointId) {
            this.mEndpointId = endpointId;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresNoPermission
        public Builder setRequestedMaximumPacketSize(int maximumPacketSize) {
            this.mMaximumPacketSize = maximumPacketSize;
            return this;
        }

        @NonNull
        @RequiresNoPermission
        public BluetoothSocketSettings build() {
            if (this.mSocketType == 1) {
                if (this.mRfcommUuid == null) {
                    throw new IllegalArgumentException("RFCOMM socket with missing uuid");
                }
                if (this.mL2capPsm != -1) {
                    throw new IllegalArgumentException("Invalid Socket config:  Socket type: " + this.mSocketType + " L2cap PSM: " + this.mL2capPsm);
                }
            }
            if (this.mSocketType == 4 && this.mRfcommUuid != null) {
                throw new IllegalArgumentException("Invalid Socket config: Socket type: " + this.mSocketType + " Rfcomm Service Name: " + this.mRfcommServiceName + " Rfcomm Uuid: " + this.mRfcommUuid);
            }
            if (this.mDataPath == 1) {
                if (this.mHubId == 0L || this.mEndpointId == 0L) {
                    throw new IllegalArgumentException("Hub ID and endpoint ID must be set for hardware data path");
                }
                if (this.mMaximumPacketSize < 0) {
                    throw new IllegalArgumentException("invalid packet size " + this.mMaximumPacketSize);
                }
            } else if (this.mHubId != 0L || this.mEndpointId != 0L) {
                throw new IllegalArgumentException("Hub ID and endpoint ID may not be set for software data path");
            }
            return new BluetoothSocketSettings(this.mSocketType, this.mL2capPsm, this.mEncryptionRequired, this.mAuthenticationRequired, this.mRfcommServiceName, this.mRfcommUuid, this.mDataPath, this.mSocketName, this.mHubId, this.mEndpointId, this.mMaximumPacketSize);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SocketDataPath {
    }
}

