/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.bluetooth.jarjar.com.android.bluetooth.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

@SystemApi
public class BluetoothQualityReport
implements Parcelable {
    private static final String TAG = BluetoothQualityReport.class.getSimpleName();
    @SystemApi
    public static final int QUALITY_REPORT_ID_MONITOR = 1;
    @SystemApi
    public static final int QUALITY_REPORT_ID_APPROACH_LSTO = 2;
    @SystemApi
    public static final int QUALITY_REPORT_ID_A2DP_CHOPPY = 3;
    @SystemApi
    public static final int QUALITY_REPORT_ID_SCO_CHOPPY = 4;
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
    public static final int QUALITY_REPORT_ID_ENERGY_MONITOR = 6;
    @SystemApi
    public static final int QUALITY_REPORT_ID_CONN_FAIL = 8;
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
    public static final int QUALITY_REPORT_ID_RF_STATS = 9;
    private final String mAddr;
    private final int mLmpVer;
    private final int mLmpSubVer;
    private final int mManufacturerId;
    private final String mName;
    private final BluetoothClass mBluetoothClass;
    private final BqrCommon mBqrCommon;
    private BqrVsLsto mBqrVsLsto;
    private BqrVsA2dpChoppy mBqrVsA2dpChoppy;
    private BqrVsScoChoppy mBqrVsScoChoppy;
    private BqrConnectFail mBqrConnectFail;
    private BqrEnergyMonitor mBqrEnergyMonitor;
    private BqrRfStats mBqrRfStats;
    @SystemApi
    @NonNull
    public static final Parcelable.Creator<BluetoothQualityReport> CREATOR = new Parcelable.Creator<BluetoothQualityReport>(){

        @Override
        public BluetoothQualityReport createFromParcel(Parcel in) {
            return new BluetoothQualityReport(in);
        }

        public BluetoothQualityReport[] newArray(int size) {
            return new BluetoothQualityReport[size];
        }
    };

    private BluetoothQualityReport(String remoteAddr, int lmpVer, int lmpSubVer, int manufacturerId, String remoteName, BluetoothClass bluetoothClass, byte[] rawData) {
        this.mAddr = remoteAddr;
        this.mLmpVer = lmpVer;
        this.mLmpSubVer = lmpSubVer;
        this.mManufacturerId = manufacturerId;
        this.mName = remoteName;
        this.mBluetoothClass = bluetoothClass;
        this.mBqrCommon = new BqrCommon(rawData, 0);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 1) {
            return;
        }
        int vsPartOffset = 85;
        if (id2 == 2) {
            this.mBqrVsLsto = new BqrVsLsto(rawData, vsPartOffset);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy = new BqrVsA2dpChoppy(rawData, vsPartOffset);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy = new BqrVsScoChoppy(rawData, vsPartOffset);
        } else if (id2 == 8) {
            this.mBqrConnectFail = new BqrConnectFail(rawData, vsPartOffset);
        } else {
            if (Flags.supportBluetoothQualityReportV6()) {
                if (id2 == 6) {
                    this.mBqrEnergyMonitor = new BqrEnergyMonitor(rawData, 1);
                    return;
                }
                if (id2 == 9) {
                    this.mBqrRfStats = new BqrRfStats(rawData, 1);
                    return;
                }
            }
            throw new IllegalArgumentException(TAG + ": unknown quality report id:" + id2);
        }
    }

    private BluetoothQualityReport(Parcel in) {
        this.mAddr = in.readString();
        this.mLmpVer = in.readInt();
        this.mLmpSubVer = in.readInt();
        this.mManufacturerId = in.readInt();
        this.mName = in.readString();
        this.mBluetoothClass = new BluetoothClass(in.readInt());
        this.mBqrCommon = new BqrCommon(in);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            this.mBqrVsLsto = new BqrVsLsto(in);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy = new BqrVsA2dpChoppy(in);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy = new BqrVsScoChoppy(in);
        } else if (id2 == 8) {
            this.mBqrConnectFail = new BqrConnectFail(in);
        }
        if (Flags.supportBluetoothQualityReportV6()) {
            if (id2 == 6) {
                this.mBqrEnergyMonitor = new BqrEnergyMonitor(in);
            } else if (id2 == 9) {
                this.mBqrRfStats = new BqrRfStats(in);
            }
        }
    }

    @SystemApi
    public int getQualityReportId() {
        return this.mBqrCommon.getQualityReportId();
    }

    @SystemApi
    @NonNull
    public static String qualityReportIdToString(int id2) {
        return BqrCommon.qualityReportIdToString(id2);
    }

    @SystemApi
    @Nullable
    public String getRemoteAddress() {
        return this.mAddr;
    }

    @SystemApi
    public int getLmpVersion() {
        return this.mLmpVer;
    }

    @SystemApi
    public int getLmpSubVersion() {
        return this.mLmpSubVer;
    }

    @SystemApi
    public int getManufacturerId() {
        return this.mManufacturerId;
    }

    @SystemApi
    @Nullable
    public String getRemoteName() {
        return this.mName;
    }

    @SystemApi
    @Nullable
    public BluetoothClass getBluetoothClass() {
        return this.mBluetoothClass;
    }

    @SystemApi
    @Nullable
    public BqrCommon getBqrCommon() {
        return this.mBqrCommon;
    }

    @SystemApi
    @Nullable
    public Parcelable getBqrEvent() {
        if (this.mBqrCommon == null) {
            return null;
        }
        int id2 = this.mBqrCommon.getQualityReportId();
        if (Flags.supportBluetoothQualityReportV6()) {
            if (id2 == 6) {
                return this.mBqrEnergyMonitor;
            }
            if (id2 == 9) {
                return this.mBqrRfStats;
            }
        }
        switch (id2) {
            case 1: {
                return this.mBqrCommon;
            }
            case 2: {
                return this.mBqrVsLsto;
            }
            case 3: {
                return this.mBqrVsA2dpChoppy;
            }
            case 4: {
                return this.mBqrVsScoChoppy;
            }
            case 8: {
                return this.mBqrConnectFail;
            }
        }
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    @SystemApi
    public void writeToParcel(@NonNull Parcel out, int flags) {
        BluetoothUtils.writeStringToParcel(out, this.mAddr);
        out.writeInt(this.mLmpVer);
        out.writeInt(this.mLmpSubVer);
        out.writeInt(this.mManufacturerId);
        BluetoothUtils.writeStringToParcel(out, this.mName);
        out.writeInt(this.mBluetoothClass.getClassOfDevice());
        this.mBqrCommon.writeToParcel(out, flags);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            this.mBqrVsLsto.writeToParcel(out, flags);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy.writeToParcel(out, flags);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy.writeToParcel(out, flags);
        } else if (id2 == 8) {
            this.mBqrConnectFail.writeToParcel(out, flags);
        }
        if (Flags.supportBluetoothQualityReportV6()) {
            if (id2 == 6) {
                this.mBqrEnergyMonitor.writeToParcel(out, flags);
            } else if (id2 == 9) {
                this.mBqrRfStats.writeToParcel(out, flags);
            }
        }
    }

    @NonNull
    public String toString() {
        String str = "BQR: {\n" + "  mAddr: " + this.mAddr + ", mLmpVer: " + String.format("0x%02X", this.mLmpVer) + ", mLmpSubVer: " + String.format("0x%04X", this.mLmpSubVer) + ", mManufacturerId: " + String.format("0x%04X", this.mManufacturerId) + ", mName: " + this.mName + ", mBluetoothClass: " + this.mBluetoothClass.toString() + ",\n" + this.mBqrCommon + "\n";
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            str = str + this.mBqrVsLsto + "\n}";
        } else if (id2 == 3) {
            str = str + this.mBqrVsA2dpChoppy + "\n}";
        } else if (id2 == 4) {
            str = str + this.mBqrVsScoChoppy + "\n}";
        } else if (id2 == 8) {
            str = str + this.mBqrConnectFail + "\n}";
        } else if (id2 == 1) {
            str = str + "}";
        }
        if (Flags.supportBluetoothQualityReportV6()) {
            if (id2 == 6) {
                str = str + this.mBqrEnergyMonitor + "\n}";
            } else if (id2 == 9) {
                str = str + this.mBqrRfStats + "\n}";
            }
        }
        return str;
    }

    @SystemApi
    public static class BqrCommon
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrCommon.class.getSimpleName();
        static final int BQR_COMMON_LEN = 85;
        private final int mQualityReportId;
        private int mPacketType;
        private int mConnectionHandle;
        private int mConnectionRole;
        private int mTxPowerLevel;
        private int mRssi;
        private int mSnr;
        private int mUnusedAfhChannelCount;
        private int mAfhSelectUnidealChannelCount;
        private int mLsto;
        private long mPiconetClock;
        private long mRetransmissionCount;
        private long mNoRxCount;
        private long mNakCount;
        private long mLastTxAckTimestamp;
        private long mFlowOffCount;
        private long mLastFlowOnTimestamp;
        private long mOverflowCount;
        private long mUnderflowCount;
        private String mAddr;
        private int mCalFailedItemCount;
        private long mTxTotalPackets;
        private long mTxUnackPackets;
        private long mTxFlushPackets;
        private long mTxLastSubeventPackets;
        private long mCrcErrorPackets;
        private long mRxDupPackets;
        private long mRxUnRecvPackets;
        private int mCoexInfoMask;
        @SystemApi
        public static final int CONNECTION_ROLE_CENTRAL = 0;
        @SystemApi
        public static final int CONNECTION_ROLE_PERIPHERAL = 1;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrCommon> CREATOR = new Parcelable.Creator<BqrCommon>(){

            @Override
            public BqrCommon createFromParcel(Parcel in) {
                return new BqrCommon(in);
            }

            public BqrCommon[] newArray(int size) {
                return new BqrCommon[size];
            }
        };

        private BqrCommon(byte[] rawData, int offset) {
            this.mQualityReportId = rawData[0] & 0xFF;
            if (Flags.supportBluetoothQualityReportV6() && (this.mQualityReportId == 6 || this.mQualityReportId == 9)) {
                return;
            }
            if (rawData == null || rawData.length < offset + 85) {
                throw new IllegalArgumentException(TAG + ": BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            bqrBuf.get();
            this.mPacketType = bqrBuf.get() & 0xFF;
            this.mConnectionHandle = bqrBuf.getShort() & 0xFFFF;
            this.mConnectionRole = bqrBuf.get() & 0xFF;
            this.mTxPowerLevel = bqrBuf.get() & 0xFF;
            this.mRssi = bqrBuf.get();
            this.mSnr = bqrBuf.get();
            this.mUnusedAfhChannelCount = bqrBuf.get() & 0xFF;
            this.mAfhSelectUnidealChannelCount = bqrBuf.get() & 0xFF;
            this.mLsto = bqrBuf.getShort() & 0xFFFF;
            this.mPiconetClock = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRetransmissionCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mNoRxCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mNakCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastTxAckTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mFlowOffCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastFlowOnTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mOverflowCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mUnderflowCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            int currentOffset = bqrBuf.position();
            this.mAddr = String.format("%02X:%02X:%02X:%02X:%02X:%02X", bqrBuf.get(currentOffset + 5), bqrBuf.get(currentOffset + 4), bqrBuf.get(currentOffset + 3), bqrBuf.get(currentOffset + 2), bqrBuf.get(currentOffset + 1), bqrBuf.get(currentOffset + 0));
            bqrBuf.position(currentOffset + 6);
            this.mCalFailedItemCount = bqrBuf.get() & 0xFF;
            this.mTxTotalPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxUnackPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxFlushPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxLastSubeventPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mCrcErrorPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRxDupPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRxUnRecvPackets = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mCoexInfoMask = bqrBuf.getShort() & 0xFFFF;
        }

        private BqrCommon(Parcel in) {
            this.mQualityReportId = in.readInt();
            this.mPacketType = in.readInt();
            this.mConnectionHandle = in.readInt();
            this.mConnectionRole = in.readInt();
            this.mTxPowerLevel = in.readInt();
            this.mRssi = in.readInt();
            this.mSnr = in.readInt();
            this.mUnusedAfhChannelCount = in.readInt();
            this.mAfhSelectUnidealChannelCount = in.readInt();
            this.mLsto = in.readInt();
            this.mPiconetClock = in.readLong();
            this.mRetransmissionCount = in.readLong();
            this.mNoRxCount = in.readLong();
            this.mNakCount = in.readLong();
            this.mLastTxAckTimestamp = in.readLong();
            this.mFlowOffCount = in.readLong();
            this.mLastFlowOnTimestamp = in.readLong();
            this.mOverflowCount = in.readLong();
            this.mUnderflowCount = in.readLong();
            this.mAddr = in.readString();
            this.mCalFailedItemCount = in.readInt();
            this.mTxTotalPackets = in.readLong();
            this.mTxUnackPackets = in.readLong();
            this.mTxFlushPackets = in.readLong();
            this.mTxLastSubeventPackets = in.readLong();
            this.mCrcErrorPackets = in.readLong();
            this.mRxDupPackets = in.readLong();
            this.mRxUnRecvPackets = in.readLong();
            this.mCoexInfoMask = in.readInt();
        }

        int getQualityReportId() {
            return this.mQualityReportId;
        }

        static String qualityReportIdToString(int id2) {
            if (Flags.supportBluetoothQualityReportV6()) {
                if (6 == id2) {
                    return "Energy Monitor";
                }
                if (9 == id2) {
                    return "RF Stats";
                }
            }
            switch (id2) {
                case 1: {
                    return "Quality monitor";
                }
                case 2: {
                    return "Approaching LSTO";
                }
                case 3: {
                    return "A2DP choppy";
                }
                case 4: {
                    return "SCO choppy";
                }
                case 8: {
                    return "Connect fail";
                }
            }
            return "INVALID";
        }

        @SystemApi
        public int getPacketType() {
            return this.mPacketType;
        }

        @SystemApi
        @Nullable
        public static String packetTypeToString(int packetType) {
            PacketType type = PacketType.fromOrdinal(packetType);
            return ((Object)((Object)type)).toString();
        }

        @SystemApi
        public int getConnectionHandle() {
            return this.mConnectionHandle;
        }

        @SystemApi
        public int getConnectionRole() {
            return this.mConnectionRole;
        }

        @SystemApi
        @NonNull
        public static String connectionRoleToString(int connectionRole) {
            if (connectionRole == 0) {
                return "Central";
            }
            if (connectionRole == 1) {
                return "Peripheral";
            }
            return "INVALID:" + connectionRole;
        }

        @SystemApi
        public int getTxPowerLevel() {
            return this.mTxPowerLevel;
        }

        @SystemApi
        public int getRssi() {
            return this.mRssi;
        }

        @SystemApi
        public int getSnr() {
            return this.mSnr;
        }

        @SystemApi
        public int getUnusedAfhChannelCount() {
            return this.mUnusedAfhChannelCount;
        }

        @SystemApi
        public int getAfhSelectUnidealChannelCount() {
            return this.mAfhSelectUnidealChannelCount;
        }

        @SystemApi
        public int getLsto() {
            return this.mLsto;
        }

        @SystemApi
        public long getPiconetClock() {
            return this.mPiconetClock;
        }

        @SystemApi
        public long getRetransmissionCount() {
            return this.mRetransmissionCount;
        }

        @SystemApi
        public long getNoRxCount() {
            return this.mNoRxCount;
        }

        @SystemApi
        public long getNakCount() {
            return this.mNakCount;
        }

        @SystemApi
        public long getLastTxAckTimestamp() {
            return this.mLastTxAckTimestamp;
        }

        @SystemApi
        public long getFlowOffCount() {
            return this.mFlowOffCount;
        }

        @SystemApi
        public long getLastFlowOnTimestamp() {
            return this.mLastFlowOnTimestamp;
        }

        @SystemApi
        public long getOverflowCount() {
            return this.mOverflowCount;
        }

        @SystemApi
        public long getUnderflowCount() {
            return this.mUnderflowCount;
        }

        @SystemApi
        public int getCalFailedItemCount() {
            return this.mCalFailedItemCount;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getTxTotalPackets() {
            return this.mTxTotalPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getTxUnackPackets() {
            return this.mTxUnackPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getTxFlushPackets() {
            return this.mTxFlushPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getTxLastSubeventPackets() {
            return this.mTxLastSubeventPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getCrcErrorPackets() {
            return this.mCrcErrorPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getRxDupPackets() {
            return this.mRxDupPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public long getRxUnRecvPackets() {
            return this.mRxUnRecvPackets;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
        public int getCoexInfoMask() {
            return this.mCoexInfoMask;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mQualityReportId);
            dest.writeInt(this.mPacketType);
            dest.writeInt(this.mConnectionHandle);
            dest.writeInt(this.mConnectionRole);
            dest.writeInt(this.mTxPowerLevel);
            dest.writeInt(this.mRssi);
            dest.writeInt(this.mSnr);
            dest.writeInt(this.mUnusedAfhChannelCount);
            dest.writeInt(this.mAfhSelectUnidealChannelCount);
            dest.writeInt(this.mLsto);
            dest.writeLong(this.mPiconetClock);
            dest.writeLong(this.mRetransmissionCount);
            dest.writeLong(this.mNoRxCount);
            dest.writeLong(this.mNakCount);
            dest.writeLong(this.mLastTxAckTimestamp);
            dest.writeLong(this.mFlowOffCount);
            dest.writeLong(this.mLastFlowOnTimestamp);
            dest.writeLong(this.mOverflowCount);
            dest.writeLong(this.mUnderflowCount);
            BluetoothUtils.writeStringToParcel(dest, this.mAddr);
            dest.writeInt(this.mCalFailedItemCount);
            dest.writeLong(this.mTxTotalPackets);
            dest.writeLong(this.mTxUnackPackets);
            dest.writeLong(this.mTxFlushPackets);
            dest.writeLong(this.mTxLastSubeventPackets);
            dest.writeLong(this.mCrcErrorPackets);
            dest.writeLong(this.mRxDupPackets);
            dest.writeLong(this.mRxUnRecvPackets);
            dest.writeInt(this.mCoexInfoMask);
        }

        @NonNull
        public String toString() {
            String str = "  BqrCommon: {\n    mQualityReportId: " + BqrCommon.qualityReportIdToString(this.getQualityReportId()) + "(" + String.format("0x%02X", this.mQualityReportId) + "), mPacketType: " + BqrCommon.packetTypeToString(this.mPacketType) + "(" + String.format("0x%02X", this.mPacketType) + "), mConnectionHandle: " + String.format("0x%04X", this.mConnectionHandle) + ", mConnectionRole: " + this.getConnectionRole() + "(" + this.mConnectionRole + "), mTxPowerLevel: " + this.mTxPowerLevel + ", mRssi: " + this.mRssi + ", mSnr: " + this.mSnr + ", mUnusedAfhChannelCount: " + this.mUnusedAfhChannelCount + ",\n    mAfhSelectUnidealChannelCount: " + this.mAfhSelectUnidealChannelCount + ", mLsto: " + this.mLsto + ", mPiconetClock: " + String.format("0x%08X", this.mPiconetClock) + ", mRetransmissionCount: " + this.mRetransmissionCount + ", mNoRxCount: " + this.mNoRxCount + ", mNakCount: " + this.mNakCount + ", mLastTxAckTimestamp: " + String.format("0x%08X", this.mLastTxAckTimestamp) + ", mFlowOffCount: " + this.mFlowOffCount + ",\n    mLastFlowOnTimestamp: " + String.format("0x%08X", this.mLastFlowOnTimestamp) + ", mOverflowCount: " + this.mOverflowCount + ", mUnderflowCount: " + this.mUnderflowCount + ", mAddr: " + this.mAddr + ", mCalFailedItemCount: " + this.mCalFailedItemCount + ",\n    mTxTotalPackets: " + this.mTxTotalPackets + ", mTxUnackPackets: " + this.mTxUnackPackets + ", mTxFlushPackets: " + this.mTxFlushPackets + ", mTxLastSubeventPackets: " + this.mTxLastSubeventPackets + ", mCrcErrorPackets: " + this.mCrcErrorPackets + ", mRxDupPackets: " + this.mRxDupPackets + ", mRxUnRecvPackets: " + this.mRxUnRecvPackets + ", mCoexInfoMask: " + this.mCoexInfoMask + "\n  }";
            return str;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConnectionRole {
        }
    }

    @SystemApi
    public static class BqrVsLsto
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrVsLsto.class.getSimpleName();
        private final int mConnState;
        private final long mBasebandStats;
        private final long mSlotsUsed;
        private final int mCxmDenials;
        private final int mTxSkipped;
        private final int mRfLoss;
        private final long mNativeClock;
        private final long mLastTxAckTimestamp;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrVsLsto> CREATOR = new Parcelable.Creator<BqrVsLsto>(){

            @Override
            public BqrVsLsto createFromParcel(Parcel in) {
                return new BqrVsLsto(in);
            }

            public BqrVsLsto[] newArray(int size) {
                return new BqrVsLsto[size];
            }
        };

        private BqrVsLsto(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mConnState = bqrBuf.get() & 0xFF;
            this.mBasebandStats = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mSlotsUsed = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mTxSkipped = bqrBuf.getShort() & 0xFFFF;
            this.mRfLoss = bqrBuf.getShort() & 0xFFFF;
            this.mNativeClock = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastTxAckTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
        }

        private BqrVsLsto(Parcel in) {
            this.mConnState = in.readInt();
            this.mBasebandStats = in.readLong();
            this.mSlotsUsed = in.readLong();
            this.mCxmDenials = in.readInt();
            this.mTxSkipped = in.readInt();
            this.mRfLoss = in.readInt();
            this.mNativeClock = in.readLong();
            this.mLastTxAckTimestamp = in.readLong();
        }

        @SystemApi
        public int getConnState() {
            return this.mConnState;
        }

        @SystemApi
        @Nullable
        public static String connStateToString(int connectionState) {
            return ConnState.toString(connectionState);
        }

        @SystemApi
        public long getBasebandStats() {
            return this.mBasebandStats;
        }

        @SystemApi
        public long getSlotsUsed() {
            return this.mSlotsUsed;
        }

        @SystemApi
        public int getCxmDenials() {
            return this.mCxmDenials;
        }

        @SystemApi
        public int getTxSkipped() {
            return this.mTxSkipped;
        }

        @SystemApi
        public int getRfLoss() {
            return this.mRfLoss;
        }

        @SystemApi
        public long getNativeClock() {
            return this.mNativeClock;
        }

        @SystemApi
        public long getLastTxAckTimestamp() {
            return this.mLastTxAckTimestamp;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mConnState);
            dest.writeLong(this.mBasebandStats);
            dest.writeLong(this.mSlotsUsed);
            dest.writeInt(this.mCxmDenials);
            dest.writeInt(this.mTxSkipped);
            dest.writeInt(this.mRfLoss);
            dest.writeLong(this.mNativeClock);
            dest.writeLong(this.mLastTxAckTimestamp);
        }

        @NonNull
        public String toString() {
            String str = "  BqrVsLsto: {\n    mConnState: " + BqrVsLsto.connStateToString(this.getConnState()) + "(" + String.format("0x%02X", this.mConnState) + "), mBasebandStats: " + String.format("0x%08X", this.mBasebandStats) + ", mSlotsUsed: " + this.mSlotsUsed + ", mCxmDenials: " + this.mCxmDenials + ", mTxSkipped: " + this.mTxSkipped + ", mRfLoss: " + this.mRfLoss + ", mNativeClock: " + String.format("0x%08X", this.mNativeClock) + ", mLastTxAckTimestamp: " + String.format("0x%08X", this.mLastTxAckTimestamp) + "\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrVsA2dpChoppy
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrVsA2dpChoppy.class.getSimpleName();
        private final long mArrivalTime;
        private final long mScheduleTime;
        private final int mGlitchCount;
        private final int mTxCxmDenials;
        private final int mRxCxmDenials;
        private final int mAclTxQueueLength;
        private final int mLinkQuality;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrVsA2dpChoppy> CREATOR = new Parcelable.Creator<BqrVsA2dpChoppy>(){

            @Override
            public BqrVsA2dpChoppy createFromParcel(Parcel in) {
                return new BqrVsA2dpChoppy(in);
            }

            public BqrVsA2dpChoppy[] newArray(int size) {
                return new BqrVsA2dpChoppy[size];
            }
        };

        private BqrVsA2dpChoppy(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mArrivalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mScheduleTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mGlitchCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mRxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mAclTxQueueLength = bqrBuf.get() & 0xFF;
            this.mLinkQuality = bqrBuf.get() & 0xFF;
        }

        private BqrVsA2dpChoppy(Parcel in) {
            this.mArrivalTime = in.readLong();
            this.mScheduleTime = in.readLong();
            this.mGlitchCount = in.readInt();
            this.mTxCxmDenials = in.readInt();
            this.mRxCxmDenials = in.readInt();
            this.mAclTxQueueLength = in.readInt();
            this.mLinkQuality = in.readInt();
        }

        @SystemApi
        public long getArrivalTime() {
            return this.mArrivalTime;
        }

        @SystemApi
        public long getScheduleTime() {
            return this.mScheduleTime;
        }

        @SystemApi
        public int getGlitchCount() {
            return this.mGlitchCount;
        }

        @SystemApi
        public int getTxCxmDenials() {
            return this.mTxCxmDenials;
        }

        @SystemApi
        public int getRxCxmDenials() {
            return this.mRxCxmDenials;
        }

        @SystemApi
        public int getAclTxQueueLength() {
            return this.mAclTxQueueLength;
        }

        @SystemApi
        public int getLinkQuality() {
            return this.mLinkQuality;
        }

        @SystemApi
        @Nullable
        public static String linkQualityToString(int linkQuality) {
            LinkQuality q = LinkQuality.fromOrdinal(linkQuality);
            return ((Object)((Object)q)).toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeLong(this.mArrivalTime);
            dest.writeLong(this.mScheduleTime);
            dest.writeInt(this.mGlitchCount);
            dest.writeInt(this.mTxCxmDenials);
            dest.writeInt(this.mRxCxmDenials);
            dest.writeInt(this.mAclTxQueueLength);
            dest.writeInt(this.mLinkQuality);
        }

        @NonNull
        public String toString() {
            String str = "  BqrVsA2dpChoppy: {\n    mArrivalTime: " + String.format("0x%08X", this.mArrivalTime) + ", mScheduleTime: " + String.format("0x%08X", this.mScheduleTime) + ", mGlitchCount: " + this.mGlitchCount + ", mTxCxmDenials: " + this.mTxCxmDenials + ", mRxCxmDenials: " + this.mRxCxmDenials + ", mAclTxQueueLength: " + this.mAclTxQueueLength + ", mLinkQuality: " + BqrVsA2dpChoppy.linkQualityToString(this.mLinkQuality) + "(" + String.format("0x%02X", this.mLinkQuality) + ")\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrVsScoChoppy
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrVsScoChoppy.class.getSimpleName();
        private final int mGlitchCount;
        private final int mIntervalEsco;
        private final int mWindowEsco;
        private final int mAirFormat;
        private final int mInstanceCount;
        private final int mTxCxmDenials;
        private final int mRxCxmDenials;
        private final int mTxAbortCount;
        private final int mLateDispatch;
        private final int mMicIntrMiss;
        private final int mLpaIntrMiss;
        private final int mSprIntrMiss;
        private final int mPlcFillCount;
        private final int mPlcDiscardCount;
        private final int mMissedInstanceCount;
        private final int mTxRetransmitSlotCount;
        private final int mRxRetransmitSlotCount;
        private final int mGoodRxFrameCount;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrVsScoChoppy> CREATOR = new Parcelable.Creator<BqrVsScoChoppy>(){

            @Override
            public BqrVsScoChoppy createFromParcel(Parcel in) {
                return new BqrVsScoChoppy(in);
            }

            public BqrVsScoChoppy[] newArray(int size) {
                return new BqrVsScoChoppy[size];
            }
        };

        private BqrVsScoChoppy(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mGlitchCount = bqrBuf.getShort() & 0xFFFF;
            this.mIntervalEsco = bqrBuf.get() & 0xFF;
            this.mWindowEsco = bqrBuf.get() & 0xFF;
            this.mAirFormat = bqrBuf.get() & 0xFF;
            this.mInstanceCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mRxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mTxAbortCount = bqrBuf.getShort() & 0xFFFF;
            this.mLateDispatch = bqrBuf.getShort() & 0xFFFF;
            this.mMicIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mLpaIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mSprIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mPlcFillCount = bqrBuf.getShort() & 0xFFFF;
            this.mPlcDiscardCount = bqrBuf.getShort() & 0xFFFF;
            this.mMissedInstanceCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxRetransmitSlotCount = bqrBuf.getShort() & 0xFFFF;
            this.mRxRetransmitSlotCount = bqrBuf.getShort() & 0xFFFF;
            this.mGoodRxFrameCount = bqrBuf.getShort() & 0xFFFF;
        }

        private BqrVsScoChoppy(Parcel in) {
            this.mGlitchCount = in.readInt();
            this.mIntervalEsco = in.readInt();
            this.mWindowEsco = in.readInt();
            this.mAirFormat = in.readInt();
            this.mInstanceCount = in.readInt();
            this.mTxCxmDenials = in.readInt();
            this.mRxCxmDenials = in.readInt();
            this.mTxAbortCount = in.readInt();
            this.mLateDispatch = in.readInt();
            this.mMicIntrMiss = in.readInt();
            this.mLpaIntrMiss = in.readInt();
            this.mSprIntrMiss = in.readInt();
            this.mPlcFillCount = in.readInt();
            this.mPlcDiscardCount = in.readInt();
            this.mMissedInstanceCount = in.readInt();
            this.mTxRetransmitSlotCount = in.readInt();
            this.mRxRetransmitSlotCount = in.readInt();
            this.mGoodRxFrameCount = in.readInt();
        }

        @SystemApi
        public int getGlitchCount() {
            return this.mGlitchCount;
        }

        @SystemApi
        public int getIntervalEsco() {
            return this.mIntervalEsco;
        }

        @SystemApi
        public int getWindowEsco() {
            return this.mWindowEsco;
        }

        @SystemApi
        public int getAirFormat() {
            return this.mAirFormat;
        }

        @SystemApi
        @Nullable
        public static String airFormatToString(int airFormat) {
            AirMode m = AirMode.fromOrdinal(airFormat);
            return ((Object)((Object)m)).toString();
        }

        @SystemApi
        public int getInstanceCount() {
            return this.mInstanceCount;
        }

        @SystemApi
        public int getTxCxmDenials() {
            return this.mTxCxmDenials;
        }

        @SystemApi
        public int getRxCxmDenials() {
            return this.mRxCxmDenials;
        }

        @SystemApi
        public int getTxAbortCount() {
            return this.mTxAbortCount;
        }

        @SystemApi
        public int getLateDispatch() {
            return this.mLateDispatch;
        }

        @SystemApi
        public int getMicIntrMiss() {
            return this.mMicIntrMiss;
        }

        @SystemApi
        public int getLpaIntrMiss() {
            return this.mLpaIntrMiss;
        }

        @SystemApi
        public int getSprIntrMiss() {
            return this.mSprIntrMiss;
        }

        @SystemApi
        public int getPlcFillCount() {
            return this.mPlcFillCount;
        }

        @SystemApi
        public int getPlcDiscardCount() {
            return this.mPlcDiscardCount;
        }

        @SystemApi
        public int getMissedInstanceCount() {
            return this.mMissedInstanceCount;
        }

        @SystemApi
        public int getTxRetransmitSlotCount() {
            return this.mTxRetransmitSlotCount;
        }

        @SystemApi
        public int getRxRetransmitSlotCount() {
            return this.mRxRetransmitSlotCount;
        }

        @SystemApi
        public int getGoodRxFrameCount() {
            return this.mGoodRxFrameCount;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mGlitchCount);
            dest.writeInt(this.mIntervalEsco);
            dest.writeInt(this.mWindowEsco);
            dest.writeInt(this.mAirFormat);
            dest.writeInt(this.mInstanceCount);
            dest.writeInt(this.mTxCxmDenials);
            dest.writeInt(this.mRxCxmDenials);
            dest.writeInt(this.mTxAbortCount);
            dest.writeInt(this.mLateDispatch);
            dest.writeInt(this.mMicIntrMiss);
            dest.writeInt(this.mLpaIntrMiss);
            dest.writeInt(this.mSprIntrMiss);
            dest.writeInt(this.mPlcFillCount);
            dest.writeInt(this.mPlcDiscardCount);
            dest.writeInt(this.mMissedInstanceCount);
            dest.writeInt(this.mTxRetransmitSlotCount);
            dest.writeInt(this.mRxRetransmitSlotCount);
            dest.writeInt(this.mGoodRxFrameCount);
        }

        @NonNull
        public String toString() {
            String str = "  BqrVsScoChoppy: {\n    mGlitchCount: " + this.mGlitchCount + ", mIntervalEsco: " + this.mIntervalEsco + ", mWindowEsco: " + this.mWindowEsco + ", mAirFormat: " + BqrVsScoChoppy.airFormatToString(this.mAirFormat) + "(" + String.format("0x%02X", this.mAirFormat) + "), mInstanceCount: " + this.mInstanceCount + ", mTxCxmDenials: " + this.mTxCxmDenials + ", mRxCxmDenials: " + this.mRxCxmDenials + ", mTxAbortCount: " + this.mTxAbortCount + ",\n    mLateDispatch: " + this.mLateDispatch + ", mMicIntrMiss: " + this.mMicIntrMiss + ", mLpaIntrMiss: " + this.mLpaIntrMiss + ", mSprIntrMiss: " + this.mSprIntrMiss + ", mPlcFillCount: " + this.mPlcFillCount + ", mPlcDiscardCount: " + this.mPlcDiscardCount + ", mMissedInstanceCount: " + this.mMissedInstanceCount + ", mTxRetransmitSlotCount: " + this.mTxRetransmitSlotCount + ",\n    mRxRetransmitSlotCount: " + this.mRxRetransmitSlotCount + ", mGoodRxFrameCount: " + this.mGoodRxFrameCount + "\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrConnectFail
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrConnectFail.class.getSimpleName();
        @SystemApi
        public static final int CONNECT_FAIL_ID_NO_ERROR = 0;
        @SystemApi
        public static final int CONNECT_FAIL_ID_PAGE_TIMEOUT = 4;
        @SystemApi
        public static final int CONNECT_FAIL_ID_CONNECTION_TIMEOUT = 8;
        @SystemApi
        public static final int CONNECT_FAIL_ID_ACL_ALREADY_EXIST = 11;
        @SystemApi
        public static final int CONNECT_FAIL_ID_CONTROLLER_BUSY = 58;
        private final int mFailReason;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrConnectFail> CREATOR = new Parcelable.Creator<BqrConnectFail>(){

            @Override
            public BqrConnectFail createFromParcel(Parcel in) {
                return new BqrConnectFail(in);
            }

            public BqrConnectFail[] newArray(int size) {
                return new BqrConnectFail[size];
            }
        };

        private BqrConnectFail(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mFailReason = bqrBuf.get() & 0xFF;
        }

        private BqrConnectFail(Parcel in) {
            this.mFailReason = in.readInt();
        }

        @SystemApi
        public int getFailReason() {
            return this.mFailReason;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mFailReason);
        }

        @SystemApi
        @NonNull
        public static String connectFailIdToString(int id2) {
            switch (id2) {
                case 0: {
                    return "No error";
                }
                case 4: {
                    return "Page Timeout";
                }
                case 8: {
                    return "Connection Timeout";
                }
                case 11: {
                    return "ACL already exists";
                }
                case 58: {
                    return "Controller busy";
                }
            }
            return "INVALID";
        }

        @NonNull
        public String toString() {
            String str = "  BqrConnectFail: {\n    mFailReason: " + BqrConnectFail.connectFailIdToString(this.mFailReason) + " (" + String.format("0x%02X", this.mFailReason) + ")\n  }";
            return str;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConnectFailId {
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
    public static class BqrEnergyMonitor
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrEnergyMonitor.class.getSimpleName();
        private final int mAvgCurrentConsume;
        private final long mIdleTotalTime;
        private final long mIdleStateEnterCount;
        private final long mActiveTotalTime;
        private final long mActiveStateEnterCount;
        private final long mBredrTxTotalTime;
        private final long mBredrTxStateEnterCount;
        private final int mBredrTxAvgPowerLevel;
        private final long mBredrRxTotalTime;
        private final long mBredrRxStateEnterCount;
        private final long mLeTxTotalTime;
        private final long mLeTxStateEnterCount;
        private final int mLeTxAvgPowerLevel;
        private final long mLeRxTotalTime;
        private final long mLeRxStateEnterCount;
        private final long mReportTotalTime;
        private final long mRxActiveOneChainTime;
        private final long mRxActiveTwoChainTime;
        private final long mTxiPaActiveOneChainTime;
        private final long mTxiPaActiveTwoChainTime;
        private final long mTxePaActiveOneChainTime;
        private final long mTxePaActiveTwoChainTime;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrEnergyMonitor> CREATOR = new Parcelable.Creator<BqrEnergyMonitor>(){

            @Override
            public BqrEnergyMonitor createFromParcel(Parcel in) {
                return new BqrEnergyMonitor(in);
            }

            public BqrEnergyMonitor[] newArray(int size) {
                return new BqrEnergyMonitor[size];
            }
        };

        private BqrEnergyMonitor(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR EnergyMonitor raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mAvgCurrentConsume = bqrBuf.getShort() & 0xFFFF;
            this.mIdleTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mIdleStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mActiveTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mActiveStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mBredrTxTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mBredrTxStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mBredrTxAvgPowerLevel = bqrBuf.get() & 0xFF;
            this.mBredrRxTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mBredrRxStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLeTxTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLeTxStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLeTxAvgPowerLevel = bqrBuf.get() & 0xFF;
            this.mLeRxTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLeRxStateEnterCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mReportTotalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRxActiveOneChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRxActiveTwoChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxiPaActiveOneChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxiPaActiveTwoChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxePaActiveOneChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxePaActiveTwoChainTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
        }

        private BqrEnergyMonitor(Parcel in) {
            this.mAvgCurrentConsume = in.readInt();
            this.mIdleTotalTime = in.readLong();
            this.mIdleStateEnterCount = in.readLong();
            this.mActiveTotalTime = in.readLong();
            this.mActiveStateEnterCount = in.readLong();
            this.mBredrTxTotalTime = in.readLong();
            this.mBredrTxStateEnterCount = in.readLong();
            this.mBredrTxAvgPowerLevel = in.readInt();
            this.mBredrRxTotalTime = in.readLong();
            this.mBredrRxStateEnterCount = in.readLong();
            this.mLeTxTotalTime = in.readLong();
            this.mLeTxStateEnterCount = in.readLong();
            this.mLeTxAvgPowerLevel = in.readInt();
            this.mLeRxTotalTime = in.readLong();
            this.mLeRxStateEnterCount = in.readLong();
            this.mReportTotalTime = in.readLong();
            this.mRxActiveOneChainTime = in.readLong();
            this.mRxActiveTwoChainTime = in.readLong();
            this.mTxiPaActiveOneChainTime = in.readLong();
            this.mTxiPaActiveTwoChainTime = in.readLong();
            this.mTxePaActiveOneChainTime = in.readLong();
            this.mTxePaActiveTwoChainTime = in.readLong();
        }

        @SystemApi
        public int getAverageCurrentConsumptionMicroamps() {
            return this.mAvgCurrentConsume;
        }

        @SystemApi
        public long getIdleStateTotalTimeMillis() {
            return this.mIdleTotalTime;
        }

        @SystemApi
        public long getIdleStateEnterCount() {
            return this.mIdleStateEnterCount;
        }

        @SystemApi
        public long getActiveStateTotalTimeMillis() {
            return this.mActiveTotalTime;
        }

        @SystemApi
        public long getActiveStateEnterCount() {
            return this.mActiveStateEnterCount;
        }

        @SystemApi
        public long getBredrTxTotalTimeMillis() {
            return this.mBredrTxTotalTime;
        }

        @SystemApi
        public long getBredrTxStateEnterCount() {
            return this.mBredrTxStateEnterCount;
        }

        @SystemApi
        public int getBredrAverageTxPowerLeveldBm() {
            return this.mBredrTxAvgPowerLevel;
        }

        @SystemApi
        public long getBredrRxTotalTimeMillis() {
            return this.mBredrRxTotalTime;
        }

        @SystemApi
        public long getBredrRxStateEnterCount() {
            return this.mBredrRxStateEnterCount;
        }

        @SystemApi
        public long getLeTsTotalTimeMillis() {
            return this.mLeTxTotalTime;
        }

        @SystemApi
        public long getLeTxStateEnterCount() {
            return this.mLeTxStateEnterCount;
        }

        @SystemApi
        public int getLeAverageTxPowerLeveldBm() {
            return this.mLeTxAvgPowerLevel;
        }

        @SystemApi
        public long getLeRxTotalTimeMillis() {
            return this.mLeRxTotalTime;
        }

        @SystemApi
        public long getLeRxStateEnterCount() {
            return this.mLeRxStateEnterCount;
        }

        @SystemApi
        public long getPowerDataTotalTimeMillis() {
            return this.mReportTotalTime;
        }

        @SystemApi
        public long getRxSingleChainActiveDurationMillis() {
            return this.mRxActiveOneChainTime;
        }

        @SystemApi
        public long getRxDualChainActiveDurationMillis() {
            return this.mRxActiveTwoChainTime;
        }

        @SystemApi
        public long getTxInternalPaSingleChainActiveDurationMillis() {
            return this.mTxiPaActiveOneChainTime;
        }

        @SystemApi
        public long getTxInternalPaDualChainActiveDurationMillis() {
            return this.mTxiPaActiveTwoChainTime;
        }

        @SystemApi
        public long getTxExternalPaSingleChainActiveDurationMillis() {
            return this.mTxePaActiveOneChainTime;
        }

        @SystemApi
        public long getTxExternalPaDualChainActiveDurationMillis() {
            return this.mTxePaActiveTwoChainTime;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mAvgCurrentConsume);
            dest.writeLong(this.mIdleTotalTime);
            dest.writeLong(this.mIdleStateEnterCount);
            dest.writeLong(this.mActiveTotalTime);
            dest.writeLong(this.mActiveStateEnterCount);
            dest.writeLong(this.mBredrTxTotalTime);
            dest.writeLong(this.mBredrTxStateEnterCount);
            dest.writeInt(this.mBredrTxAvgPowerLevel);
            dest.writeLong(this.mBredrRxTotalTime);
            dest.writeLong(this.mBredrRxStateEnterCount);
            dest.writeLong(this.mLeTxTotalTime);
            dest.writeLong(this.mLeTxStateEnterCount);
            dest.writeInt(this.mLeTxAvgPowerLevel);
            dest.writeLong(this.mLeRxTotalTime);
            dest.writeLong(this.mLeRxStateEnterCount);
            dest.writeLong(this.mReportTotalTime);
            dest.writeLong(this.mRxActiveOneChainTime);
            dest.writeLong(this.mRxActiveTwoChainTime);
            dest.writeLong(this.mTxiPaActiveOneChainTime);
            dest.writeLong(this.mTxiPaActiveTwoChainTime);
            dest.writeLong(this.mTxePaActiveOneChainTime);
            dest.writeLong(this.mTxePaActiveTwoChainTime);
        }

        @NonNull
        public String toString() {
            return "  BqrEnergyMonitor: {\n    AvgCurrentConsume: " + this.mAvgCurrentConsume + ", mIdleTotalTime: " + this.mIdleTotalTime + ", mIdleStateEnterCount: " + this.mIdleStateEnterCount + ", mActiveTotalTime: " + this.mActiveTotalTime + ", mActiveStateEnterCount: " + this.mActiveStateEnterCount + ",\n    mBredrTxTotalTime: " + this.mBredrTxTotalTime + ", mBredrTxStateEnterCount: " + this.mBredrTxStateEnterCount + ", mBredrTxAvgPowerLevel: " + this.mBredrTxAvgPowerLevel + ", mBredrRxTotalTime: " + this.mBredrRxTotalTime + ", mBredrRxStateEnterCount: " + this.mBredrRxStateEnterCount + ", mLeTxTotalTime: " + this.mLeTxTotalTime + ", mLeTxStateEnterCount: " + this.mLeTxStateEnterCount + ", mLeTxAvgPowerLevel: " + this.mLeTxAvgPowerLevel + ", mLeRxTotalTime: " + this.mLeRxTotalTime + ", mLeRxStateEnterCount: " + this.mLeRxStateEnterCount + ", mReportTotalTime: " + this.mReportTotalTime + ", mRxActiveOneChainTime: " + this.mRxActiveOneChainTime + ", mRxActiveTwoChainTime: " + this.mRxActiveTwoChainTime + ", mTxiPaActiveOneChainTime: " + this.mTxiPaActiveOneChainTime + ", mTxiPaActiveTwoChainTime: " + this.mTxiPaActiveTwoChainTime + ", mTxePaActiveOneChainTime: " + this.mTxePaActiveOneChainTime + ", mTxePaActiveTwoChainTime: " + this.mTxePaActiveTwoChainTime + "\n  }";
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_bluetooth_quality_report_v6")
    public static class BqrRfStats
    implements Parcelable {
        private static final String TAG = TAG + "." + BqrRfStats.class.getSimpleName();
        private final int mExtensionInfo;
        private final long mReportTimePeriod;
        private final long mTxPoweriPaBf;
        private final long mTxPowerePaBf;
        private final long mTxPoweriPaDiv;
        private final long mTxPowerePaDiv;
        private final long mRssiChainOver50;
        private final long mRssiChain50To55;
        private final long mRssiChain55To60;
        private final long mRssiChain60To65;
        private final long mRssiChain65To70;
        private final long mRssiChain70To75;
        private final long mRssiChain75To80;
        private final long mRssiChain80To85;
        private final long mRssiChain85To90;
        private final long mRssiChainUnder90;
        private final long mRssiDeltaUnder2;
        private final long mRssiDelta2To5;
        private final long mRssiDelta5To8;
        private final long mRssiDelta8To11;
        private final long mRssiDeltaOver11;
        @SystemApi
        @NonNull
        public static final Parcelable.Creator<BqrRfStats> CREATOR = new Parcelable.Creator<BqrRfStats>(){

            @Override
            public BqrRfStats createFromParcel(Parcel in) {
                return new BqrRfStats(in);
            }

            public BqrRfStats[] newArray(int size) {
                return new BqrRfStats[size];
            }
        };

        private BqrRfStats(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException(TAG + ": BQR RF Stats raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mExtensionInfo = bqrBuf.get() & 0xFF;
            this.mReportTimePeriod = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxPoweriPaBf = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxPowerePaBf = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxPoweriPaDiv = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mTxPowerePaDiv = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChainOver50 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain50To55 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain55To60 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain60To65 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain65To70 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain70To75 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain75To80 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain80To85 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChain85To90 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiChainUnder90 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiDeltaUnder2 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiDelta2To5 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiDelta5To8 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiDelta8To11 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRssiDeltaOver11 = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
        }

        private BqrRfStats(Parcel in) {
            this.mExtensionInfo = in.readInt();
            this.mReportTimePeriod = in.readLong();
            this.mTxPoweriPaBf = in.readLong();
            this.mTxPowerePaBf = in.readLong();
            this.mTxPoweriPaDiv = in.readLong();
            this.mTxPowerePaDiv = in.readLong();
            this.mRssiChainOver50 = in.readLong();
            this.mRssiChain50To55 = in.readLong();
            this.mRssiChain55To60 = in.readLong();
            this.mRssiChain60To65 = in.readLong();
            this.mRssiChain65To70 = in.readLong();
            this.mRssiChain70To75 = in.readLong();
            this.mRssiChain75To80 = in.readLong();
            this.mRssiChain80To85 = in.readLong();
            this.mRssiChain85To90 = in.readLong();
            this.mRssiChainUnder90 = in.readLong();
            this.mRssiDeltaUnder2 = in.readLong();
            this.mRssiDelta2To5 = in.readLong();
            this.mRssiDelta5To8 = in.readLong();
            this.mRssiDelta8To11 = in.readLong();
            this.mRssiDeltaOver11 = in.readLong();
        }

        @SystemApi
        public int getExtensionInfo() {
            return this.mExtensionInfo;
        }

        @SystemApi
        public long getPerformanceDurationMillis() {
            return this.mReportTimePeriod;
        }

        @SystemApi
        public long getTxPowerInternalPaBeamformingCount() {
            return this.mTxPoweriPaBf;
        }

        @SystemApi
        public long getTxPowerExternalPaBeamformingCount() {
            return this.mTxPowerePaBf;
        }

        @SystemApi
        public long getTxPowerInternalPaDiversityCount() {
            return this.mTxPoweriPaDiv;
        }

        @SystemApi
        public long getTxPowerExternalPaDiversityCount() {
            return this.mTxPowerePaDiv;
        }

        @SystemApi
        public long getPacketsWithRssiAboveMinus50dBm() {
            return this.mRssiChainOver50;
        }

        @SystemApi
        public long getPacketsWithRssi50To55dBm() {
            return this.mRssiChain50To55;
        }

        @SystemApi
        public long getPacketsWithRssi55To60dBm() {
            return this.mRssiChain55To60;
        }

        @SystemApi
        public long getPacketsWithRssi60To65dBm() {
            return this.mRssiChain60To65;
        }

        @SystemApi
        public long getPacketsWithRssi65To70dBm() {
            return this.mRssiChain65To70;
        }

        @SystemApi
        public long getPacketsWithRssi70To75dBm() {
            return this.mRssiChain70To75;
        }

        @SystemApi
        public long getPacketsWithRssi75To80dBm() {
            return this.mRssiChain75To80;
        }

        @SystemApi
        public long getPacketsWithRssi80To85dBm() {
            return this.mRssiChain80To85;
        }

        @SystemApi
        public long getPacketsWithRssi85To90dBm() {
            return this.mRssiChain85To90;
        }

        @SystemApi
        public long getPacketsWithRssiBelowMinus90dBm() {
            return this.mRssiChainUnder90;
        }

        @SystemApi
        public long getPacketsWithRssiDeltaBelow2dBm() {
            return this.mRssiDeltaUnder2;
        }

        @SystemApi
        public long getPacketsWithRssiDelta2To5dBm() {
            return this.mRssiDelta2To5;
        }

        @SystemApi
        public long getPacketsWithRssiDelta5To8dBm() {
            return this.mRssiDelta5To8;
        }

        @SystemApi
        public long getPacketsWithRssiDelta8To11dBm() {
            return this.mRssiDelta8To11;
        }

        @SystemApi
        public long getPacketsWithRssiDeltaAbove11dBm() {
            return this.mRssiDeltaOver11;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mExtensionInfo);
            dest.writeLong(this.mReportTimePeriod);
            dest.writeLong(this.mTxPoweriPaBf);
            dest.writeLong(this.mTxPowerePaBf);
            dest.writeLong(this.mTxPoweriPaDiv);
            dest.writeLong(this.mTxPowerePaDiv);
            dest.writeLong(this.mRssiChainOver50);
            dest.writeLong(this.mRssiChain50To55);
            dest.writeLong(this.mRssiChain55To60);
            dest.writeLong(this.mRssiChain60To65);
            dest.writeLong(this.mRssiChain65To70);
            dest.writeLong(this.mRssiChain70To75);
            dest.writeLong(this.mRssiChain75To80);
            dest.writeLong(this.mRssiChain80To85);
            dest.writeLong(this.mRssiChain85To90);
            dest.writeLong(this.mRssiChainUnder90);
            dest.writeLong(this.mRssiDeltaUnder2);
            dest.writeLong(this.mRssiDelta2To5);
            dest.writeLong(this.mRssiDelta5To8);
            dest.writeLong(this.mRssiDelta8To11);
            dest.writeLong(this.mRssiDeltaOver11);
        }

        @NonNull
        public String toString() {
            return "  BqrRfStats: {\n    mExtensionInfo: " + this.mExtensionInfo + ", mReportTimePeriod: " + this.mReportTimePeriod + ", mTxPoweriPaBf: " + this.mTxPoweriPaBf + ", mTxPowerePaBf: " + this.mTxPowerePaBf + ", mTxPoweriPaDiv: " + this.mTxPoweriPaDiv + ", mTxPowerePaDiv: " + this.mTxPowerePaDiv + ",\n    mRssiChainOver50: " + this.mRssiChainOver50 + ", mRssiChain50To55: " + this.mRssiChain50To55 + ", mRssiChain55To60: " + this.mRssiChain55To60 + ", mRssiChain60To65: " + this.mRssiChain60To65 + ", mRssiChain65To70: " + this.mRssiChain65To70 + ", mRssiChain70To75: " + this.mRssiChain70To75 + ", mRssiChain75To80: " + this.mRssiChain75To80 + ", mRssiChain80To85: " + this.mRssiChain80To85 + ", mRssiChain85To90: " + this.mRssiChain85To90 + ", mRssiChainUnder90: " + this.mRssiChainUnder90 + ",\n    mRssiDeltaUnder2: " + this.mRssiDeltaUnder2 + ", mRssiDelta2To5: " + this.mRssiDelta2To5 + ", mRssiDelta5To8: " + this.mRssiDelta5To8 + ", mRssiDelta8To11: " + this.mRssiDelta8To11 + ", mRssiDeltaOver11: " + this.mRssiDeltaOver11 + "\n  }";
        }
    }

    @SystemApi
    public static class Builder {
        private String remoteAddr = "00:00:00:00:00:00";
        private int lmpVer;
        private int lmpSubVer;
        private int manufacturerId;
        private String remoteName = "";
        private BluetoothClass bluetoothClass = new BluetoothClass(0);
        private final byte[] rawData;

        @SystemApi
        public Builder(@NonNull byte[] rawData) {
            this.rawData = Objects.requireNonNull(rawData);
        }

        @SystemApi
        @NonNull
        public Builder setRemoteAddress(@Nullable String remoteAddr) {
            if (!BluetoothAdapter.checkBluetoothAddress(remoteAddr)) {
                Log.d(TAG, "remote address is not a valid bluetooth address: " + remoteAddr);
            } else {
                this.remoteAddr = remoteAddr;
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setLmpVersion(int lmpVer) {
            this.lmpVer = lmpVer;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setLmpSubVersion(int lmpSubVer) {
            this.lmpSubVer = lmpSubVer;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setManufacturerId(int manufacturerId) {
            this.manufacturerId = manufacturerId;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setRemoteName(@Nullable String remoteName) {
            if (remoteName == null) {
                Log.d(TAG, "remote name is null");
            } else {
                this.remoteName = remoteName;
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setBluetoothClass(@Nullable BluetoothClass bluetoothClass) {
            if (bluetoothClass == null) {
                Log.d(TAG, "remote bluetooth class is null");
            } else {
                this.bluetoothClass = bluetoothClass;
            }
            return this;
        }

        @SystemApi
        @NonNull
        public BluetoothQualityReport build() {
            return new BluetoothQualityReport(this.remoteAddr, this.lmpVer, this.lmpSubVer, this.manufacturerId, this.remoteName, this.bluetoothClass, this.rawData);
        }
    }

    static enum AirMode {
        uLaw,
        aLaw,
        CVSD,
        transparent_msbc,
        INVALID;

        private static final AirMode[] sAllValues;

        static AirMode fromOrdinal(int n) {
            if (n < sAllValues.length - 1) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = AirMode.values();
        }
    }

    static enum LinkQuality {
        ULTRA_HIGH,
        HIGH,
        STANDARD,
        MEDIUM,
        LOW,
        INVALID;

        private static final LinkQuality[] sAllValues;

        static LinkQuality fromOrdinal(int n) {
            if (n < sAllValues.length - 1) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = LinkQuality.values();
        }
    }

    static enum ConnState {
        CONN_IDLE(0),
        CONN_ACTIVE(129),
        CONN_HOLD(2),
        CONN_SNIFF_IDLE(3),
        CONN_SNIFF_ACTIVE(132),
        CONN_SNIFF_MASTER_TRANSITION(133),
        CONN_PARK(6),
        CONN_PARK_PEND(71),
        CONN_UNPARK_PEND(8),
        CONN_UNPARK_ACTIVE(137),
        CONN_DISCONNECT_PENDING(74),
        CONN_PAGING(11),
        CONN_PAGE_SCAN(12),
        CONN_LOCAL_LOOPBACK(13),
        CONN_LE_ACTIVE(14),
        CONN_ANT_ACTIVE(15),
        CONN_TRIGGER_SCAN(16),
        CONN_RECONNECTING(17),
        CONN_SEMI_CONN(18);

        private final int mValue;
        private static final ConnState[] sAllStates;

        private ConnState(int val) {
            this.mValue = val;
        }

        public static String toString(int val) {
            for (ConnState state : sAllStates) {
                if (state.mValue != val) continue;
                return ((Object)((Object)state)).toString();
            }
            return "INVALID";
        }

        static {
            sAllStates = ConnState.values();
        }
    }

    static enum PacketType {
        INVALID,
        TYPE_ID,
        TYPE_NULL,
        TYPE_POLL,
        TYPE_FHS,
        TYPE_HV1,
        TYPE_HV2,
        TYPE_HV3,
        TYPE_DV,
        TYPE_EV3,
        TYPE_EV4,
        TYPE_EV5,
        TYPE_2EV3,
        TYPE_2EV5,
        TYPE_3EV3,
        TYPE_3EV5,
        TYPE_DM1,
        TYPE_DH1,
        TYPE_DM3,
        TYPE_DH3,
        TYPE_DM5,
        TYPE_DH5,
        TYPE_AUX1,
        TYPE_2DH1,
        TYPE_2DH3,
        TYPE_2DH5,
        TYPE_3DH1,
        TYPE_3DH3,
        TYPE_3DH5;

        private static final PacketType[] sAllValues;

        static PacketType fromOrdinal(int n) {
            if (n < sAllValues.length) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = PacketType.values();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QualityReportId {
    }
}

