/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.IBluetoothGatt;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.jarjar.com.android.modules.utils.build.SdkLevel;
import java.util.ArrayList;
import java.util.List;

public class BluetoothManager {
    private static final String TAG = BluetoothManager.class.getSimpleName();
    private final BluetoothAdapter mAdapter;
    private final Context mContext;

    public BluetoothManager(Context context) {
        this.mContext = SdkLevel.isAtLeastU() ? context.createDeviceContext(0) : context;
        this.mAdapter = BluetoothAdapter.createAdapter(this.mContext.getAttributionSource());
    }

    @RequiresNoPermission
    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device, int profile) {
        List<BluetoothDevice> connectedDevices = this.getConnectedDevices(profile);
        for (BluetoothDevice connectedDevice : connectedDevices) {
            if (!device.equals(connectedDevice)) continue;
            return 2;
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices(int profile) {
        return this.getDevicesMatchingConnectionStates(profile, new int[]{2});
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int profile, int[] states) {
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        IBluetoothGatt iGatt = this.mAdapter.getBluetoothGatt();
        if (iGatt == null) {
            return devices;
        }
        try {
            devices = Attributable.setAttributionSource(iGatt.getDevicesMatchingConnectionStates(states, this.mContext.getAttributionSource()), this.mContext.getAttributionSource());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return devices;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback) {
        return this.openGattServer(context, callback, 0);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, boolean eattSupport) {
        return this.openGattServer(context, callback, 0, eattSupport);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, int transport) {
        return this.openGattServer(context, callback, transport, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, int transport, boolean eattSupport) {
        if (context == null || callback == null) {
            throw new IllegalArgumentException("null parameter: " + context + " " + callback);
        }
        IBluetoothGatt iGatt = this.mAdapter.getBluetoothGatt();
        if (iGatt == null) {
            Log.e(TAG, "Fail to get GATT Server connection");
            return null;
        }
        BluetoothGattServer mGattServer = new BluetoothGattServer(iGatt, transport, this.mAdapter);
        Boolean regStatus = mGattServer.registerCallback(callback, eattSupport);
        return regStatus != false ? mGattServer : null;
    }
}

