/*
 * Decompiled with CFR 0.152.
 */
package android.app.wallpaper;

import android.annotation.FlaggedApi;
import android.app.WallpaperInfo;
import android.app.wallpaper.WallpaperDescription;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.Objects;

@FlaggedApi(value="android.app.live_wallpaper_content_handling")
public class WallpaperInstance
implements Parcelable {
    private static final String DEFAULT_ID = "default_id";
    @Nullable
    private final WallpaperInfo mInfo;
    @NonNull
    private final WallpaperDescription mDescription;
    @Nullable
    private final String mIdOverride;
    @NonNull
    public static final Parcelable.Creator<WallpaperInstance> CREATOR = new Parcelable.Creator<WallpaperInstance>(){

        @Override
        public WallpaperInstance createFromParcel(Parcel in) {
            return new WallpaperInstance(in);
        }

        public WallpaperInstance[] newArray(int size) {
            return new WallpaperInstance[size];
        }
    };

    public WallpaperInstance(@Nullable WallpaperInfo info, @NonNull WallpaperDescription description) {
        this(info, description, null);
    }

    public WallpaperInstance(@Nullable WallpaperInfo info, @NonNull WallpaperDescription description, @Nullable String idOverride) {
        this.mInfo = info;
        this.mDescription = description;
        this.mIdOverride = idOverride;
    }

    @Nullable
    public WallpaperInfo getInfo() {
        return this.mInfo;
    }

    @NonNull
    public String getId() {
        if (this.mIdOverride != null) {
            return this.mIdOverride;
        }
        if (this.mDescription.getId() != null) {
            return this.mDescription.getId();
        }
        if (this.mInfo != null) {
            return this.mInfo.getComponent().flattenToString();
        }
        return DEFAULT_ID;
    }

    @NonNull
    public WallpaperDescription getDescription() {
        return this.mDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WallpaperInstance)) {
            return false;
        }
        WallpaperInstance that = (WallpaperInstance)o;
        if (this.mInfo == null) {
            return that.mInfo == null && Objects.equals(this.getId(), that.getId());
        }
        return that.mInfo != null && Objects.equals(this.mInfo.getComponent(), that.mInfo.getComponent()) && Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.mInfo != null ? Objects.hash(this.mInfo.getComponent(), this.getId()) : Objects.hash(this.getId());
    }

    WallpaperInstance(@NonNull Parcel in) {
        this.mInfo = in.readTypedObject(WallpaperInfo.CREATOR);
        this.mDescription = WallpaperDescription.CREATOR.createFromParcel(in);
        this.mIdOverride = in.readString8();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mInfo, flags);
        this.mDescription.writeToParcel(dest, flags);
        dest.writeString8(this.mIdOverride);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

