/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.NonNull;
import android.app.usage.UsageEvents;
import android.content.res.Configuration;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ParcelableUsageEventList
implements Parcelable {
    private static final String TAG = "ParcelableUsageEventList";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_ALL = false;
    private static final int MAX_IPC_SIZE = IBinder.getSuggestedMaxIpcSizeBytes();
    private List<UsageEvents.Event> mList;
    public static final Parcelable.Creator<ParcelableUsageEventList> CREATOR = new Parcelable.Creator<ParcelableUsageEventList>(){

        @Override
        public ParcelableUsageEventList createFromParcel(Parcel in) {
            return new ParcelableUsageEventList(in);
        }

        public ParcelableUsageEventList[] newArray(int size) {
            return new ParcelableUsageEventList[size];
        }
    };

    public ParcelableUsageEventList(@NonNull List<UsageEvents.Event> list) {
        if (list == null) {
            throw new IllegalArgumentException("Empty list");
        }
        this.mList = list;
    }

    private ParcelableUsageEventList(Parcel in) {
        int i;
        int N2 = in.readInt();
        this.mList = new ArrayList<UsageEvents.Event>(N2);
        if (N2 <= 0) {
            return;
        }
        for (i = 0; i < N2 && in.readInt() != 0; ++i) {
            this.mList.add(this.readEventFromParcel(in));
        }
        if (i >= N2) {
            return;
        }
        IBinder retriever = in.readStrongBinder();
        while (i < N2) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
                reply.readException();
                int count = 0;
                while (i < N2 && reply.readInt() != 0) {
                    this.mList.add(this.readEventFromParcel(reply));
                    ++i;
                    ++count;
                }
            }
            catch (RemoteException e) {
                throw new BadParcelableException("Failure retrieving array; only received " + i + " of " + N2, e);
            }
            finally {
                reply.recycle();
                data.recycle();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        final int N2 = this.mList.size();
        final int callFlags = flags;
        dest.writeInt(N2);
        if (N2 > 0) {
            int i;
            for (i = 0; i < N2 && dest.dataSize() < MAX_IPC_SIZE; ++i) {
                dest.writeInt(1);
                UsageEvents.Event event = this.mList.get(i);
                this.writeEventToParcel(event, dest, callFlags);
            }
            if (i < N2) {
                dest.writeInt(0);
                Binder retriever = new Binder(){

                    @Override
                    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        if (ParcelableUsageEventList.this.mList == null) {
                            throw new IllegalArgumentException("Attempt to transfer null list, did transfer finish?");
                        }
                        int i = data.readInt();
                        try {
                            reply.writeNoException();
                            int count = 0;
                            while (i < N2 && reply.dataSize() < 65536) {
                                reply.writeInt(1);
                                UsageEvents.Event event = ParcelableUsageEventList.this.mList.get(i);
                                ParcelableUsageEventList.this.writeEventToParcel(event, reply, callFlags);
                                ++i;
                                ++count;
                            }
                            if (i < N2) {
                                reply.writeInt(0);
                            } else {
                                ParcelableUsageEventList.this.mList = null;
                            }
                        }
                        catch (RuntimeException e) {
                            ParcelableUsageEventList.this.mList = null;
                            throw e;
                        }
                        return true;
                    }
                };
                dest.writeStrongBinder(retriever);
            }
        }
    }

    public List<UsageEvents.Event> getList() {
        return this.mList;
    }

    private UsageEvents.Event readEventFromParcel(Parcel in) {
        UsageEvents.Event event = new UsageEvents.Event();
        event.mPackage = in.readString();
        event.mClass = in.readString();
        event.mInstanceId = in.readInt();
        event.mTaskRootPackage = in.readString();
        event.mTaskRootClass = in.readString();
        event.mEventType = in.readInt();
        event.mTimeStamp = in.readLong();
        event.mConfiguration = null;
        event.mShortcutId = null;
        event.mAction = null;
        event.mContentType = null;
        event.mContentAnnotations = null;
        event.mNotificationChannelId = null;
        event.mLocusId = null;
        event.mExtras = null;
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration = Configuration.CREATOR.createFromParcel(in);
                break;
            }
            case 8: {
                event.mShortcutId = in.readString();
                break;
            }
            case 9: {
                event.mAction = in.readString();
                event.mContentType = in.readString();
                event.mContentAnnotations = in.readStringArray();
                break;
            }
            case 11: {
                event.mBucketAndReason = in.readInt();
                break;
            }
            case 12: {
                event.mNotificationChannelId = in.readString();
                break;
            }
            case 30: {
                event.mLocusId = in.readString();
                break;
            }
            case 7: {
                if (in.readInt() == 0) break;
                event.mExtras = in.readPersistableBundle(this.getClass().getClassLoader());
            }
        }
        event.mFlags = in.readInt();
        return event;
    }

    private void writeEventToParcel(@NonNull UsageEvents.Event event, @NonNull Parcel dest, int flags) {
        dest.writeString(event.mPackage);
        dest.writeString(event.mClass);
        dest.writeInt(event.mInstanceId);
        dest.writeString(event.mTaskRootPackage);
        dest.writeString(event.mTaskRootClass);
        dest.writeInt(event.mEventType);
        dest.writeLong(event.mTimeStamp);
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration.writeToParcel(dest, flags);
                break;
            }
            case 8: {
                dest.writeString(event.mShortcutId);
                break;
            }
            case 9: {
                dest.writeString(event.mAction);
                dest.writeString(event.mContentType);
                dest.writeStringArray(event.mContentAnnotations);
                break;
            }
            case 11: {
                dest.writeInt(event.mBucketAndReason);
                break;
            }
            case 12: {
                dest.writeString(event.mNotificationChannelId);
                break;
            }
            case 30: {
                dest.writeString(event.mLocusId);
                break;
            }
            case 7: {
                if (event.mExtras != null) {
                    dest.writeInt(1);
                    dest.writePersistableBundle(event.mExtras);
                    break;
                }
                dest.writeInt(0);
            }
        }
        dest.writeInt(event.mFlags);
    }
}

