/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.app.ActivityThread;
import android.app.WindowConfiguration;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.window.ActivityWindowInfo;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;

public class ClientTransactionListenerController {
    private static final String TAG = "ClientTransactionListenerController";
    private static ClientTransactionListenerController sController;
    private final Object mLock = new Object();
    private final DisplayManagerGlobal mDisplayManager;
    @GuardedBy(value={"mLock"})
    private final ArraySet<BiConsumer<IBinder, ActivityWindowInfo>> mActivityWindowInfoChangedListeners = new ArraySet();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Context, Configuration> mContextToPreChangedConfigMap = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private boolean mIsClientTransactionExecuting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ClientTransactionListenerController getInstance() {
        Class<ClientTransactionListenerController> clazz = ClientTransactionListenerController.class;
        synchronized (ClientTransactionListenerController.class) {
            if (sController == null) {
                sController = new ClientTransactionListenerController(DisplayManagerGlobal.getInstance());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sController;
        }
    }

    @VisibleForTesting
    @NonNull
    public static ClientTransactionListenerController createInstanceForTesting(@NonNull DisplayManagerGlobal displayManager) {
        return new ClientTransactionListenerController(displayManager);
    }

    private ClientTransactionListenerController(@NonNull DisplayManagerGlobal displayManager) {
        this.mDisplayManager = Objects.requireNonNull(displayManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityWindowInfoChangedListener(@NonNull BiConsumer<IBinder, ActivityWindowInfo> listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActivityWindowInfoChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityWindowInfoChangedListener(@NonNull BiConsumer<IBinder, ActivityWindowInfo> listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActivityWindowInfoChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityWindowInfoChanged(@NonNull IBinder activityToken, @NonNull ActivityWindowInfo activityWindowInfo) {
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            if (this.mActivityWindowInfoChangedListeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            Object[] activityWindowInfoChangedListeners = this.mActivityWindowInfoChangedListeners.toArray();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (Object activityWindowInfoChangedListener : activityWindowInfoChangedListeners) {
                ((BiConsumer)activityWindowInfoChangedListener).accept(activityToken, new ActivityWindowInfo(activityWindowInfo));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientTransactionStarted() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClientTransactionExecuting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientTransactionFinished() {
        ArraySet<Integer> configUpdatedDisplayIds;
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClientTransactionExecuting = false;
            if (this.mContextToPreChangedConfigMap.isEmpty()) {
                return;
            }
            configUpdatedDisplayIds = new ArraySet<Integer>();
            int contextCount = this.mContextToPreChangedConfigMap.size();
            try {
                for (int i = 0; i < contextCount; ++i) {
                    Configuration preChangedConfig;
                    Context context = this.mContextToPreChangedConfigMap.keyAt(i);
                    if (!this.shouldReportDisplayChange(context, preChangedConfig = this.mContextToPreChangedConfigMap.valueAt(i))) continue;
                    configUpdatedDisplayIds.add(context.getDisplayId());
                }
            }
            finally {
                this.mContextToPreChangedConfigMap.clear();
            }
        }
        try {
            int displayCount = configUpdatedDisplayIds.size();
            for (int i = 0; i < displayCount; ++i) {
                int displayId = (Integer)configUpdatedDisplayIds.valueAt(i);
                this.onDisplayChanged(displayId);
            }
        }
        catch (RejectedExecutionException e) {
            Log.w(TAG, "Failed to notify DisplayListener because the Handler is shutting down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContextConfigurationPreChanged(@NonNull Context context) {
        if (ActivityThread.isSystem()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mContextToPreChangedConfigMap.containsKey(context)) {
                return;
            }
            this.mContextToPreChangedConfigMap.put(context, new Configuration(context.getResources().getConfiguration()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContextConfigurationPostChanged(@NonNull Context context) {
        if (ActivityThread.isSystem()) {
            return;
        }
        int changedDisplayId = -1;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClientTransactionExecuting) {
                return;
            }
            Configuration preChangedConfig = this.mContextToPreChangedConfigMap.remove(context);
            if (preChangedConfig != null && this.shouldReportDisplayChange(context, preChangedConfig)) {
                changedDisplayId = context.getDisplayId();
            }
        }
        if (changedDisplayId != -1) {
            try {
                this.onDisplayChanged(changedDisplayId);
            }
            catch (RejectedExecutionException e) {
                Log.w(TAG, "Failed to notify DisplayListener because the Handler is shutting down");
            }
        }
    }

    private boolean shouldReportDisplayChange(@NonNull Context context, @NonNull Configuration preChangedConfig) {
        Configuration postChangedConfig = context.getResources().getConfiguration();
        return !WindowConfiguration.areConfigurationsEqualForDisplay(postChangedConfig, preChangedConfig);
    }

    @VisibleForTesting
    public void onDisplayChanged(int displayId) throws RejectedExecutionException {
        this.mDisplayManager.handleDisplayChangeFromWindowManager(displayId);
    }
}

