/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.search.ISearchCallback;
import android.app.search.ISearchUiManager;
import android.app.search.Query;
import android.app.search.SearchContext;
import android.app.search.SearchSessionId;
import android.app.search.SearchTarget;
import android.app.search.SearchTargetEvent;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

@SystemApi
public class SearchSession
implements AutoCloseable {
    private static final String TAG = SearchSession.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ISearchUiManager mInterface;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
    private final SearchSessionId mSessionId;
    private final IBinder mToken = new Binder();
    @GuardedBy(value={"itself"})
    private final ArrayMap<Callback, CallbackWrapper> mRegisteredCallbacks = new ArrayMap();

    SearchSession(@NonNull Context context, @NonNull SearchContext searchContext) {
        IBinder b = ServiceManager.getService("search_ui");
        this.mInterface = ISearchUiManager.Stub.asInterface(b);
        this.mSessionId = new SearchSessionId(context.getPackageName() + ":" + ((Object)UUID.randomUUID()).toString(), context.getUserId());
        searchContext.setPackageName(context.getPackageName());
        try {
            this.mInterface.createSearchSession(searchContext, this.mSessionId, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to search session", e);
            e.rethrowFromSystemServer();
        }
        this.mCloseGuard.open("SearchSession.close");
    }

    public void notifyEvent(@NonNull Query query, @NonNull SearchTargetEvent event) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        try {
            this.mInterface.notifyEvent(this.mSessionId, query, event);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to notify event", e);
            e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public void query(@NonNull Query input, @NonNull Executor callbackExecutor, @NonNull Consumer<List<SearchTarget>> callback) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        try {
            this.mInterface.query(this.mSessionId, input, new CallbackWrapper(callbackExecutor, callback));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to sort targets", e);
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmptyQueryResultUpdateCallback(@NonNull Executor callbackExecutor, @NonNull Callback callback) {
        ArrayMap<Callback, CallbackWrapper> arrayMap = this.mRegisteredCallbacks;
        synchronized (arrayMap) {
            if (this.mIsClosed.get()) {
                throw new IllegalStateException("This client has already been destroyed.");
            }
            if (this.mRegisteredCallbacks.containsKey(callback)) {
                return;
            }
            try {
                CallbackWrapper callbackWrapper = new CallbackWrapper(callbackExecutor, callback::onTargetsAvailable);
                this.mInterface.registerEmptyQueryResultUpdateCallback(this.mSessionId, callbackWrapper);
                this.mRegisteredCallbacks.put(callback, callbackWrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to register for empty query result updates", e);
                e.rethrowAsRuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEmptyQueryResultUpdateCallback(@NonNull Callback callback) {
        ArrayMap<Callback, CallbackWrapper> arrayMap = this.mRegisteredCallbacks;
        synchronized (arrayMap) {
            if (this.mIsClosed.get()) {
                throw new IllegalStateException("This client has already been destroyed.");
            }
            if (!this.mRegisteredCallbacks.containsKey(callback)) {
                return;
            }
            try {
                CallbackWrapper callbackWrapper = this.mRegisteredCallbacks.remove(callback);
                this.mInterface.unregisterEmptyQueryResultUpdateCallback(this.mSessionId, callbackWrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to unregister for empty query result updates", e);
                e.rethrowAsRuntimeException();
            }
        }
    }

    @Deprecated
    public void destroy() {
        if (!this.mIsClosed.getAndSet(true)) {
            this.mCloseGuard.close();
            try {
                this.mInterface.destroySearchSession(this.mSessionId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to notify search target event", e);
                e.rethrowFromSystemServer();
            }
        } else {
            throw new IllegalStateException("This client has already been destroyed.");
        }
    }

    protected void finalize() {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mIsClosed.get()) {
                this.destroy();
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class CallbackWrapper
    extends ISearchCallback.Stub {
        private final Consumer<List<SearchTarget>> mCallback;
        private final Executor mExecutor;

        CallbackWrapper(@NonNull Executor callbackExecutor, @NonNull Consumer<List<SearchTarget>> callback) {
            this.mCallback = callback;
            this.mExecutor = callbackExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(ParceledListSlice result) {
            long identity = Binder.clearCallingIdentity();
            try {
                Bundle bundle;
                List list = result.getList();
                if (list.size() > 0 && (bundle = ((SearchTarget)list.get(0)).getExtras()) != null) {
                    bundle.putLong("key_ipc_start", SystemClock.elapsedRealtime());
                }
                this.mExecutor.execute(() -> this.mCallback.accept(list));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface Callback {
        public void onTargetsAvailable(@NonNull List<SearchTarget> var1);
    }
}

