/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.app.search.ISearchCallback;
import android.app.search.Query;
import android.app.search.SearchContext;
import android.app.search.SearchSessionId;
import android.app.search.SearchTargetEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISearchUiManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.search.ISearchUiManager";

    public void createSearchSession(SearchContext var1, SearchSessionId var2, IBinder var3) throws RemoteException;

    public void query(SearchSessionId var1, Query var2, ISearchCallback var3) throws RemoteException;

    public void notifyEvent(SearchSessionId var1, Query var2, SearchTargetEvent var3) throws RemoteException;

    public void registerEmptyQueryResultUpdateCallback(SearchSessionId var1, ISearchCallback var2) throws RemoteException;

    public void unregisterEmptyQueryResultUpdateCallback(SearchSessionId var1, ISearchCallback var2) throws RemoteException;

    public void destroySearchSession(SearchSessionId var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISearchUiManager {
        static final int TRANSACTION_createSearchSession = 1;
        static final int TRANSACTION_query = 2;
        static final int TRANSACTION_notifyEvent = 3;
        static final int TRANSACTION_registerEmptyQueryResultUpdateCallback = 4;
        static final int TRANSACTION_unregisterEmptyQueryResultUpdateCallback = 5;
        static final int TRANSACTION_destroySearchSession = 6;

        public Stub() {
            this.attachInterface(this, ISearchUiManager.DESCRIPTOR);
        }

        public static ISearchUiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISearchUiManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISearchUiManager) {
                return (ISearchUiManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createSearchSession";
                }
                case 2: {
                    return "query";
                }
                case 3: {
                    return "notifyEvent";
                }
                case 4: {
                    return "registerEmptyQueryResultUpdateCallback";
                }
                case 5: {
                    return "unregisterEmptyQueryResultUpdateCallback";
                }
                case 6: {
                    return "destroySearchSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISearchUiManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SearchContext _arg0 = data.readTypedObject(SearchContext.CREATOR);
                    SearchSessionId _arg1 = data.readTypedObject(SearchSessionId.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createSearchSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    SearchSessionId _arg0 = data.readTypedObject(SearchSessionId.CREATOR);
                    Query _arg1 = data.readTypedObject(Query.CREATOR);
                    ISearchCallback _arg2 = ISearchCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.query(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    SearchSessionId _arg0 = data.readTypedObject(SearchSessionId.CREATOR);
                    Query _arg1 = data.readTypedObject(Query.CREATOR);
                    SearchTargetEvent _arg2 = data.readTypedObject(SearchTargetEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    SearchSessionId _arg0 = data.readTypedObject(SearchSessionId.CREATOR);
                    ISearchCallback _arg1 = ISearchCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerEmptyQueryResultUpdateCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    SearchSessionId _arg0 = data.readTypedObject(SearchSessionId.CREATOR);
                    ISearchCallback _arg1 = ISearchCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterEmptyQueryResultUpdateCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    SearchSessionId _arg0 = data.readTypedObject(SearchSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.destroySearchSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ISearchUiManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISearchUiManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSearchSession(SearchContext context, SearchSessionId sessionId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void query(SearchSessionId sessionId, Query input, ISearchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(input, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyEvent(SearchSessionId sessionId, Query input, SearchTargetEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(input, 0);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerEmptyQueryResultUpdateCallback(SearchSessionId sessionId, ISearchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterEmptyQueryResultUpdateCallback(SearchSessionId sessionId, ISearchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroySearchSession(SearchSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISearchUiManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISearchUiManager {
        @Override
        public void createSearchSession(SearchContext context, SearchSessionId sessionId, IBinder token) throws RemoteException {
        }

        @Override
        public void query(SearchSessionId sessionId, Query input, ISearchCallback callback) throws RemoteException {
        }

        @Override
        public void notifyEvent(SearchSessionId sessionId, Query input, SearchTargetEvent event) throws RemoteException {
        }

        @Override
        public void registerEmptyQueryResultUpdateCallback(SearchSessionId sessionId, ISearchCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterEmptyQueryResultUpdateCallback(SearchSessionId sessionId, ISearchCallback callback) throws RemoteException {
        }

        @Override
        public void destroySearchSession(SearchSessionId sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

