/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox.sandboxactivity;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.sdksandbox.sandboxactivity.ActivityContextInfo;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityRegistry;
import android.content.Context;
import android.content.Intent;
import com.android.layoutlib.androidx.annotation.RequiresApi;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public abstract class SdkSandboxActivityAuthority {
    @NonNull
    public static SdkSandboxActivityAuthority getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private SdkSandboxActivityAuthority() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean isSdkSandboxActivityIntent(@NonNull Context context, @Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        if (intent.getAction() != null && intent.getAction().equals("android.app.sdksandbox.action.START_SANDBOXED_ACTIVITY")) {
            return true;
        }
        String sandboxPackageName = context.getPackageManager().getSdkSandboxPackageName();
        if (intent.getPackage() != null && intent.getPackage().equals(sandboxPackageName)) {
            return true;
        }
        return intent.getComponent() != null && intent.getComponent().getPackageName().equals(sandboxPackageName);
    }

    @NonNull
    @RequiresApi(value=34)
    public ActivityContextInfo getActivityContextInfo(@NonNull Intent intent) {
        SdkSandboxActivityRegistry registry = SdkSandboxActivityRegistry.getInstance();
        ActivityContextInfo contextInfo = registry.getContextInfo(intent);
        if (contextInfo == null) {
            throw new IllegalArgumentException("There is no registered SdkSandboxActivityHandler for the passed intent, " + intent);
        }
        return contextInfo;
    }

    private static class InstanceHolder {
        private static final SdkSandboxActivityAuthority INSTANCE = new SdkSandboxActivityAuthorityImpl();

        private InstanceHolder() {
        }
    }

    private static class SdkSandboxActivityAuthorityImpl
    extends SdkSandboxActivityAuthority {
        private SdkSandboxActivityAuthorityImpl() {
        }
    }
}

