/*
 * Decompiled with CFR 0.152.
 */
package android.app.prediction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class AppPredictionContext
implements Parcelable {
    private final int mPredictedTargetCount;
    @NonNull
    private final String mUiSurface;
    @NonNull
    private final String mPackageName;
    @Nullable
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<AppPredictionContext> CREATOR = new Parcelable.Creator<AppPredictionContext>(){

        @Override
        public AppPredictionContext createFromParcel(Parcel parcel) {
            return new AppPredictionContext(parcel);
        }

        public AppPredictionContext[] newArray(int size) {
            return new AppPredictionContext[size];
        }
    };

    private AppPredictionContext(@NonNull String uiSurface, int numPredictedTargets, @NonNull String packageName, @Nullable Bundle extras) {
        this.mUiSurface = uiSurface;
        this.mPredictedTargetCount = numPredictedTargets;
        this.mPackageName = packageName;
        this.mExtras = extras;
    }

    private AppPredictionContext(@NonNull Parcel parcel) {
        this.mUiSurface = parcel.readString();
        this.mPredictedTargetCount = parcel.readInt();
        this.mPackageName = parcel.readString();
        this.mExtras = parcel.readBundle();
    }

    @NonNull
    public String getUiSurface() {
        return this.mUiSurface;
    }

    public int getPredictedTargetCount() {
        return this.mPredictedTargetCount;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!this.getClass().equals(o != null ? o.getClass() : null)) {
            return false;
        }
        AppPredictionContext other = (AppPredictionContext)o;
        return this.mPredictedTargetCount == other.mPredictedTargetCount && this.mUiSurface.equals(other.mUiSurface) && this.mPackageName.equals(other.mPackageName);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mUiSurface, this.mPackageName);
        hashCode = 31 * hashCode + this.mPredictedTargetCount;
        return hashCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mUiSurface);
        dest.writeInt(this.mPredictedTargetCount);
        dest.writeString(this.mPackageName);
        dest.writeBundle(this.mExtras);
    }

    @SystemApi
    public static class Builder {
        @NonNull
        private final String mPackageName;
        private int mPredictedTargetCount;
        @Nullable
        private String mUiSurface;
        @Nullable
        private Bundle mExtras;

        @SystemApi
        public Builder(@NonNull Context context) {
            this.mPackageName = context.getPackageName();
        }

        @NonNull
        public Builder setPredictedTargetCount(int predictedTargetCount) {
            this.mPredictedTargetCount = predictedTargetCount;
            return this;
        }

        @NonNull
        public Builder setUiSurface(@NonNull String uiSurface) {
            this.mUiSurface = uiSurface;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public AppPredictionContext build() {
            return new AppPredictionContext(this.mUiSurface, this.mPredictedTargetCount, this.mPackageName, this.mExtras);
        }
    }
}

