/*
 * Decompiled with CFR 0.152.
 */
package android.app.people;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ConversationStatus
implements Parcelable {
    private static final String TAG = "ConversationStatus";
    public static final int ACTIVITY_OTHER = 0;
    public static final int ACTIVITY_BIRTHDAY = 1;
    public static final int ACTIVITY_ANNIVERSARY = 2;
    public static final int ACTIVITY_NEW_STORY = 3;
    public static final int ACTIVITY_AUDIO = 4;
    public static final int ACTIVITY_VIDEO = 5;
    public static final int ACTIVITY_GAME = 6;
    public static final int ACTIVITY_LOCATION = 7;
    public static final int ACTIVITY_UPCOMING_BIRTHDAY = 8;
    public static final int AVAILABILITY_UNKNOWN = -1;
    public static final int AVAILABILITY_AVAILABLE = 0;
    public static final int AVAILABILITY_BUSY = 1;
    public static final int AVAILABILITY_OFFLINE = 2;
    private final String mId;
    private final int mActivity;
    private int mAvailability;
    private CharSequence mDescription;
    private Icon mIcon;
    private long mStartTimeMs;
    private long mEndTimeMs;
    @NonNull
    public static final Parcelable.Creator<ConversationStatus> CREATOR = new Parcelable.Creator<ConversationStatus>(){

        @Override
        public ConversationStatus createFromParcel(Parcel source) {
            return new ConversationStatus(source);
        }

        public ConversationStatus[] newArray(int size) {
            return new ConversationStatus[size];
        }
    };

    private ConversationStatus(Builder b) {
        this.mId = b.mId;
        this.mActivity = b.mActivity;
        this.mAvailability = b.mAvailability;
        this.mDescription = b.mDescription;
        this.mIcon = b.mIcon;
        this.mStartTimeMs = b.mStartTimeMs;
        this.mEndTimeMs = b.mEndTimeMs;
    }

    private ConversationStatus(Parcel p) {
        this.mId = p.readString();
        this.mActivity = p.readInt();
        this.mAvailability = p.readInt();
        this.mDescription = p.readCharSequence();
        this.mIcon = p.readParcelable(Icon.class.getClassLoader(), Icon.class);
        this.mStartTimeMs = p.readLong();
        this.mEndTimeMs = p.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mActivity);
        dest.writeInt(this.mAvailability);
        dest.writeCharSequence(this.mDescription);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeLong(this.mStartTimeMs);
        dest.writeLong(this.mEndTimeMs);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public int getActivity() {
        return this.mActivity;
    }

    public int getAvailability() {
        return this.mAvailability;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Icon getIcon() {
        return this.mIcon;
    }

    public long getStartTimeMillis() {
        return this.mStartTimeMs;
    }

    public long getEndTimeMillis() {
        return this.mEndTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationStatus that = (ConversationStatus)o;
        return this.mActivity == that.mActivity && this.mAvailability == that.mAvailability && this.mStartTimeMs == that.mStartTimeMs && this.mEndTimeMs == that.mEndTimeMs && this.mId.equals(that.mId) && Objects.equals(this.mDescription, that.mDescription) && Objects.equals(this.mIcon, that.mIcon);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mActivity, this.mAvailability, this.mDescription, this.mIcon, this.mStartTimeMs, this.mEndTimeMs);
    }

    public String toString() {
        return "ConversationStatus{mId='" + this.mId + '\'' + ", mActivity=" + this.mActivity + ", mAvailability=" + this.mAvailability + ", mDescription=" + this.mDescription + ", mIcon=" + this.mIcon + ", mStartTimeMs=" + this.mStartTimeMs + ", mEndTimeMs=" + this.mEndTimeMs + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        final String mId;
        final int mActivity;
        int mAvailability = -1;
        CharSequence mDescription;
        Icon mIcon;
        long mStartTimeMs = -1L;
        long mEndTimeMs = -1L;

        public Builder(@NonNull String id2, @NonNull int activity) {
            this.mId = id2;
            this.mActivity = activity;
        }

        @NonNull
        public Builder setAvailability(int availability) {
            this.mAvailability = availability;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable CharSequence description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable Icon icon) {
            this.mIcon = icon;
            return this;
        }

        @NonNull
        public Builder setStartTimeMillis(long startTimeMs) {
            this.mStartTimeMs = startTimeMs;
            return this;
        }

        @NonNull
        public Builder setEndTimeMillis(long endTimeMs) {
            this.mEndTimeMs = endTimeMs;
            return this;
        }

        @NonNull
        public ConversationStatus build() {
            return new ConversationStatus(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Availability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActivityType {
    }
}

