/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
@FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence_module")
public class InferenceInfo
implements Parcelable {
    private final int uid;
    private final long startTimeMs;
    private final long endTimeMs;
    private final long suspendedTimeMs;
    @NonNull
    public static final Parcelable.Creator<InferenceInfo> CREATOR = new Parcelable.Creator<InferenceInfo>(){

        public InferenceInfo[] newArray(int size) {
            return new InferenceInfo[size];
        }

        @Override
        public InferenceInfo createFromParcel(@NonNull Parcel in) {
            return new InferenceInfo(in);
        }
    };

    InferenceInfo(int uid, long startTimeMs, long endTimeMs, long suspendedTimeMs) {
        this.uid = uid;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.suspendedTimeMs = suspendedTimeMs;
    }

    private InferenceInfo(@NonNull Parcel in) {
        this.uid = in.readInt();
        this.startTimeMs = in.readLong();
        this.endTimeMs = in.readLong();
        this.suspendedTimeMs = in.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.uid);
        dest.writeLong(this.startTimeMs);
        dest.writeLong(this.endTimeMs);
        dest.writeLong(this.suspendedTimeMs);
    }

    public int getUid() {
        return this.uid;
    }

    public long getStartTimeMillis() {
        return this.startTimeMs;
    }

    public long getEndTimeMillis() {
        return this.endTimeMs;
    }

    public long getSuspendedTimeMillis() {
        return this.suspendedTimeMs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final int uid;
        private long startTimeMs;
        private long endTimeMs;
        private long suspendedTimeMs;

        public Builder(int uid) {
            this.uid = uid;
        }

        @NonNull
        public Builder setStartTimeMillis(long startTimeMs) {
            this.startTimeMs = startTimeMs;
            return this;
        }

        @NonNull
        public Builder setEndTimeMillis(long endTimeMs) {
            this.endTimeMs = endTimeMs;
            return this;
        }

        @NonNull
        public Builder setSuspendedTimeMillis(long suspendedTimeMs) {
            this.suspendedTimeMs = suspendedTimeMs;
            return this;
        }

        @NonNull
        public InferenceInfo build() {
            return new InferenceInfo(this.uid, this.startTimeMs, this.endTimeMs, this.suspendedTimeMs);
        }
    }
}

