/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.NonNull;
import android.app.job.JobInfo;
import android.os.Parcel;
import android.os.Parcelable;

public class JobSnapshot
implements Parcelable {
    private final JobInfo mJob;
    private final int mSatisfiedConstraints;
    private final boolean mIsRunnable;
    @NonNull
    public static final Parcelable.Creator<JobSnapshot> CREATOR = new Parcelable.Creator<JobSnapshot>(){

        @Override
        public JobSnapshot createFromParcel(Parcel in) {
            return new JobSnapshot(in);
        }

        public JobSnapshot[] newArray(int size) {
            return new JobSnapshot[size];
        }
    };

    public JobSnapshot(JobInfo info, int satisfiedMask, boolean runnable) {
        this.mJob = info;
        this.mSatisfiedConstraints = satisfiedMask;
        this.mIsRunnable = runnable;
    }

    public JobSnapshot(Parcel in) {
        this.mJob = JobInfo.CREATOR.createFromParcel(in);
        this.mSatisfiedConstraints = in.readInt();
        this.mIsRunnable = in.readBoolean();
    }

    private boolean satisfied(int flag) {
        return (this.mSatisfiedConstraints & flag) != 0;
    }

    public JobInfo getJobInfo() {
        return this.mJob;
    }

    public boolean isRunnable() {
        return this.mIsRunnable;
    }

    public boolean isChargingSatisfied() {
        return !this.mJob.isRequireCharging() || this.satisfied(1);
    }

    public boolean isBatteryNotLowSatisfied() {
        return !this.mJob.isRequireBatteryNotLow() || this.satisfied(2);
    }

    public boolean isRequireDeviceIdleSatisfied() {
        return !this.mJob.isRequireDeviceIdle() || this.satisfied(4);
    }

    public boolean isRequireStorageNotLowSatisfied() {
        return !this.mJob.isRequireStorageNotLow() || this.satisfied(8);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mJob.writeToParcel(out, flags);
        out.writeInt(this.mSatisfiedConstraints);
        out.writeBoolean(this.mIsRunnable);
    }
}

