/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.job.IJobCallback;
import android.app.job.JobWorkItem;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.net.Network;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.system.SystemCleaner;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.app.job.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Cleaner;

public class JobParameters
implements Parcelable {
    private static final String TAG = "JobParameters";
    public static final int INTERNAL_STOP_REASON_UNKNOWN = -1;
    public static final int INTERNAL_STOP_REASON_CANCELED = 0;
    public static final int INTERNAL_STOP_REASON_CONSTRAINTS_NOT_SATISFIED = 1;
    public static final int INTERNAL_STOP_REASON_PREEMPT = 2;
    public static final int INTERNAL_STOP_REASON_TIMEOUT = 3;
    public static final int INTERNAL_STOP_REASON_DEVICE_IDLE = 4;
    public static final int INTERNAL_STOP_REASON_DEVICE_THERMAL = 5;
    public static final int INTERNAL_STOP_REASON_RESTRICTED_BUCKET = 6;
    public static final int INTERNAL_STOP_REASON_UNINSTALL = 7;
    public static final int INTERNAL_STOP_REASON_DATA_CLEARED = 8;
    public static final int INTERNAL_STOP_REASON_RTC_UPDATED = 9;
    public static final int INTERNAL_STOP_REASON_SUCCESSFUL_FINISH = 10;
    public static final int INTERNAL_STOP_REASON_USER_UI_STOP = 11;
    public static final int INTERNAL_STOP_REASON_ANR = 12;
    public static final int INTERNAL_STOP_REASON_TIMEOUT_ABANDONED = 13;
    public static final int[] JOB_STOP_REASON_CODES = new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    public static final int STOP_REASON_UNDEFINED = 0;
    public static final int STOP_REASON_CANCELLED_BY_APP = 1;
    public static final int STOP_REASON_PREEMPT = 2;
    public static final int STOP_REASON_TIMEOUT = 3;
    public static final int STOP_REASON_DEVICE_STATE = 4;
    public static final int STOP_REASON_CONSTRAINT_BATTERY_NOT_LOW = 5;
    public static final int STOP_REASON_CONSTRAINT_CHARGING = 6;
    public static final int STOP_REASON_CONSTRAINT_CONNECTIVITY = 7;
    public static final int STOP_REASON_CONSTRAINT_DEVICE_IDLE = 8;
    public static final int STOP_REASON_CONSTRAINT_STORAGE_NOT_LOW = 9;
    public static final int STOP_REASON_QUOTA = 10;
    public static final int STOP_REASON_BACKGROUND_RESTRICTION = 11;
    public static final int STOP_REASON_APP_STANDBY = 12;
    public static final int STOP_REASON_USER = 13;
    public static final int STOP_REASON_SYSTEM_PROCESSING = 14;
    public static final int STOP_REASON_ESTIMATED_APP_LAUNCH_TIME_CHANGED = 15;
    @FlaggedApi(value="android.app.job.handle_abandoned_jobs")
    public static final int STOP_REASON_TIMEOUT_ABANDONED = 16;
    @UnsupportedAppUsage
    private final int jobId;
    @Nullable
    private final String mJobNamespace;
    private final PersistableBundle extras;
    private final Bundle transientExtras;
    private final ClipData clipData;
    private final int clipGrantFlags;
    @UnsupportedAppUsage
    private final IBinder callback;
    private final boolean overrideDeadlineExpired;
    private final boolean mIsExpedited;
    private final boolean mIsUserInitiated;
    private final Uri[] mTriggeredContentUris;
    private final String[] mTriggeredContentAuthorities;
    @Nullable
    private Network mNetwork;
    private int mStopReason = 0;
    private int mInternalStopReason = -1;
    private String debugStopReason;
    @Nullable
    private JobCleanupCallback mJobCleanupCallback;
    @Nullable
    private Cleaner.Cleanable mCleanable;
    public static final long OVERRIDE_HANDLE_ABANDONED_JOBS = 372529068L;
    @NonNull
    public static final Parcelable.Creator<JobParameters> CREATOR = new Parcelable.Creator<JobParameters>(){

        @Override
        public JobParameters createFromParcel(Parcel in) {
            return new JobParameters(in);
        }

        public JobParameters[] newArray(int size) {
            return new JobParameters[size];
        }
    };

    @NonNull
    public static String getInternalReasonCodeDescription(int reasonCode) {
        switch (reasonCode) {
            case 0: {
                return "canceled";
            }
            case 1: {
                return "constraints";
            }
            case 2: {
                return "preempt";
            }
            case 3: {
                return "timeout";
            }
            case 4: {
                return "device_idle";
            }
            case 5: {
                return "thermal";
            }
            case 6: {
                return "restricted_bucket";
            }
            case 7: {
                return "uninstall";
            }
            case 8: {
                return "data_cleared";
            }
            case 9: {
                return "rtc_updated";
            }
            case 10: {
                return "successful_finish";
            }
            case 11: {
                return "user_ui_stop";
            }
            case 12: {
                return "anr";
            }
            case 13: {
                return "timeout_abandoned";
            }
        }
        return "unknown:" + reasonCode;
    }

    @NonNull
    public static int[] getJobStopReasonCodes() {
        return JOB_STOP_REASON_CODES;
    }

    public JobParameters(IBinder callback, String namespace, int jobId, PersistableBundle extras, Bundle transientExtras, ClipData clipData, int clipGrantFlags, boolean overrideDeadlineExpired, boolean isExpedited, boolean isUserInitiated, Uri[] triggeredContentUris, String[] triggeredContentAuthorities, Network network) {
        this.jobId = jobId;
        this.extras = extras;
        this.transientExtras = transientExtras;
        this.clipData = clipData;
        this.clipGrantFlags = clipGrantFlags;
        this.callback = callback;
        this.overrideDeadlineExpired = overrideDeadlineExpired;
        this.mIsExpedited = isExpedited;
        this.mIsUserInitiated = isUserInitiated;
        this.mTriggeredContentUris = triggeredContentUris;
        this.mTriggeredContentAuthorities = triggeredContentAuthorities;
        this.mNetwork = network;
        this.mJobNamespace = namespace;
        this.mJobCleanupCallback = null;
        this.mCleanable = null;
    }

    public int getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getJobNamespace() {
        return this.mJobNamespace;
    }

    public int getStopReason() {
        return this.mStopReason;
    }

    public int getInternalStopReasonCode() {
        return this.mInternalStopReason;
    }

    public String getDebugStopReason() {
        return this.debugStopReason;
    }

    @NonNull
    public PersistableBundle getExtras() {
        return this.extras;
    }

    @NonNull
    public Bundle getTransientExtras() {
        return this.transientExtras;
    }

    @Nullable
    public ClipData getClipData() {
        return this.clipData;
    }

    public int getClipGrantFlags() {
        return this.clipGrantFlags;
    }

    public boolean isExpeditedJob() {
        return this.mIsExpedited;
    }

    public boolean isUserInitiatedJob() {
        return this.mIsUserInitiated;
    }

    public boolean isOverrideDeadlineExpired() {
        return this.overrideDeadlineExpired;
    }

    @Nullable
    public Uri[] getTriggeredContentUris() {
        return this.mTriggeredContentUris;
    }

    @Nullable
    public String[] getTriggeredContentAuthorities() {
        return this.mTriggeredContentAuthorities;
    }

    @Nullable
    public Network getNetwork() {
        return this.mNetwork;
    }

    @Nullable
    public JobWorkItem dequeueWork() {
        try {
            return this.getCallback().dequeueWork(this.getJobId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void completeWork(@NonNull JobWorkItem work) {
        try {
            if (!this.getCallback().completeWork(this.getJobId(), work.getWorkId())) {
                throw new IllegalArgumentException("Given work is not active: " + work);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public IJobCallback getCallback() {
        return IJobCallback.Stub.asInterface(this.callback);
    }

    private JobParameters(Parcel in) {
        this.jobId = in.readInt();
        this.mJobNamespace = in.readString();
        this.extras = in.readPersistableBundle();
        this.transientExtras = in.readBundle();
        if (in.readInt() != 0) {
            this.clipData = ClipData.CREATOR.createFromParcel(in);
            this.clipGrantFlags = in.readInt();
        } else {
            this.clipData = null;
            this.clipGrantFlags = 0;
        }
        this.callback = in.readStrongBinder();
        this.overrideDeadlineExpired = in.readInt() == 1;
        this.mIsExpedited = in.readBoolean();
        this.mIsUserInitiated = in.readBoolean();
        this.mTriggeredContentUris = in.createTypedArray(Uri.CREATOR);
        this.mTriggeredContentAuthorities = in.createStringArray();
        this.mNetwork = in.readInt() != 0 ? Network.CREATOR.createFromParcel(in) : null;
        this.mStopReason = in.readInt();
        this.mInternalStopReason = in.readInt();
        this.debugStopReason = in.readString();
        this.mJobCleanupCallback = null;
        this.mCleanable = null;
    }

    public void setNetwork(@Nullable Network network) {
        this.mNetwork = network;
    }

    public void setStopReason(int reason, int internalStopReason, String debugStopReason) {
        this.mStopReason = reason;
        this.mInternalStopReason = internalStopReason;
        this.debugStopReason = debugStopReason;
    }

    public void initCleaner(JobCleanupCallback jobCleanupCallback) {
        this.mJobCleanupCallback = jobCleanupCallback;
        this.mCleanable = SystemCleaner.cleaner().register(this, this.mJobCleanupCallback);
    }

    public void enableCleaner() {
        if (!Flags.handleAbandonedJobs() || Compatibility.isChangeEnabled(372529068L)) {
            return;
        }
        if (Process.myUid() == 1000) {
            return;
        }
        if (this.mJobCleanupCallback == null) {
            this.initCleaner(new JobCleanupCallback(IJobCallback.Stub.asInterface(this.callback), this.jobId));
        }
        this.mJobCleanupCallback.enableCleaner();
    }

    public void disableCleaner() {
        if (!Flags.handleAbandonedJobs() || Compatibility.isChangeEnabled(372529068L)) {
            return;
        }
        if (this.mJobCleanupCallback != null) {
            this.mJobCleanupCallback.disableCleaner();
            if (this.mCleanable != null) {
                this.mCleanable.clean();
                this.mCleanable = null;
            }
            this.mJobCleanupCallback = null;
        }
    }

    @VisibleForTesting
    @Nullable
    public Cleaner.Cleanable getCleanable() {
        return this.mCleanable;
    }

    @VisibleForTesting
    @Nullable
    public JobCleanupCallback getJobCleanupCallback() {
        return this.mJobCleanupCallback;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.jobId);
        dest.writeString(this.mJobNamespace);
        dest.writePersistableBundle(this.extras);
        dest.writeBundle(this.transientExtras);
        if (this.clipData != null) {
            dest.writeInt(1);
            this.clipData.writeToParcel(dest, flags);
            dest.writeInt(this.clipGrantFlags);
        } else {
            dest.writeInt(0);
        }
        dest.writeStrongBinder(this.callback);
        dest.writeInt(this.overrideDeadlineExpired ? 1 : 0);
        dest.writeBoolean(this.mIsExpedited);
        dest.writeBoolean(this.mIsUserInitiated);
        dest.writeTypedArray(this.mTriggeredContentUris, flags);
        dest.writeStringArray(this.mTriggeredContentAuthorities);
        if (this.mNetwork != null) {
            dest.writeInt(1);
            this.mNetwork.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mStopReason);
        dest.writeInt(this.mInternalStopReason);
        dest.writeString(this.debugStopReason);
    }

    public static class JobCleanupCallback
    implements Runnable {
        private final IJobCallback mCallback;
        private final int mJobId;
        private boolean mIsCleanerEnabled;

        public JobCleanupCallback(IJobCallback callback, int jobId) {
            this.mCallback = callback;
            this.mJobId = jobId;
            this.mIsCleanerEnabled = false;
        }

        public boolean isCleanerEnabled() {
            return this.mIsCleanerEnabled;
        }

        public void enableCleaner() {
            this.mIsCleanerEnabled = true;
        }

        public void disableCleaner() {
            this.mIsCleanerEnabled = false;
        }

        @Override
        public void run() {
            if (!this.isCleanerEnabled()) {
                return;
            }
            try {
                this.mCallback.handleAbandonedJob(this.mJobId);
            }
            catch (Exception e) {
                Log.wtf(JobParameters.TAG, "Could not destroy running job", e);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopReason {
    }
}

