/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.job.IUserVisibleJobObserver;
import android.app.job.JobInfo;
import android.app.job.JobWorkItem;
import android.app.job.PendingJobReasonsInfo;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public interface IJobScheduler
extends IInterface {
    public int schedule(String var1, JobInfo var2) throws RemoteException;

    public int enqueue(String var1, JobInfo var2, JobWorkItem var3) throws RemoteException;

    public int scheduleAsPackage(String var1, JobInfo var2, String var3, int var4, String var5) throws RemoteException;

    public void cancel(String var1, int var2) throws RemoteException;

    public void cancelAll() throws RemoteException;

    public void cancelAllInNamespace(String var1) throws RemoteException;

    public Map<String, ParceledListSlice<JobInfo>> getAllPendingJobs() throws RemoteException;

    public ParceledListSlice<JobInfo> getAllPendingJobsInNamespace(String var1) throws RemoteException;

    public JobInfo getPendingJob(String var1, int var2) throws RemoteException;

    public int getPendingJobReason(String var1, int var2) throws RemoteException;

    public int[] getPendingJobReasons(String var1, int var2) throws RemoteException;

    public List<PendingJobReasonsInfo> getPendingJobReasonsHistory(String var1, int var2) throws RemoteException;

    public boolean canRunUserInitiatedJobs(String var1) throws RemoteException;

    public boolean hasRunUserInitiatedJobsPermission(String var1, int var2) throws RemoteException;

    public List<JobInfo> getStartedJobs() throws RemoteException;

    public ParceledListSlice getAllJobSnapshots() throws RemoteException;

    @EnforcePermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void registerUserVisibleJobObserver(IUserVisibleJobObserver var1) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void unregisterUserVisibleJobObserver(IUserVisibleJobObserver var1) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void notePendingUserRequestedAppStop(String var1, int var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IJobScheduler {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.app.job.IJobScheduler";
        static final int TRANSACTION_schedule = 1;
        static final int TRANSACTION_enqueue = 2;
        static final int TRANSACTION_scheduleAsPackage = 3;
        static final int TRANSACTION_cancel = 4;
        static final int TRANSACTION_cancelAll = 5;
        static final int TRANSACTION_cancelAllInNamespace = 6;
        static final int TRANSACTION_getAllPendingJobs = 7;
        static final int TRANSACTION_getAllPendingJobsInNamespace = 8;
        static final int TRANSACTION_getPendingJob = 9;
        static final int TRANSACTION_getPendingJobReason = 10;
        static final int TRANSACTION_getPendingJobReasons = 11;
        static final int TRANSACTION_getPendingJobReasonsHistory = 12;
        static final int TRANSACTION_canRunUserInitiatedJobs = 13;
        static final int TRANSACTION_hasRunUserInitiatedJobsPermission = 14;
        static final int TRANSACTION_getStartedJobs = 15;
        static final int TRANSACTION_getAllJobSnapshots = 16;
        static final int TRANSACTION_registerUserVisibleJobObserver = 17;
        static final String[] PERMISSIONS_registerUserVisibleJobObserver = new String[]{"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"};
        static final int TRANSACTION_unregisterUserVisibleJobObserver = 18;
        static final String[] PERMISSIONS_unregisterUserVisibleJobObserver = new String[]{"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"};
        static final int TRANSACTION_notePendingUserRequestedAppStop = 19;
        static final String[] PERMISSIONS_notePendingUserRequestedAppStop = new String[]{"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"};

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IJobScheduler asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IJobScheduler) {
                return (IJobScheduler)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "schedule";
                }
                case 2: {
                    return "enqueue";
                }
                case 3: {
                    return "scheduleAsPackage";
                }
                case 4: {
                    return "cancel";
                }
                case 5: {
                    return "cancelAll";
                }
                case 6: {
                    return "cancelAllInNamespace";
                }
                case 7: {
                    return "getAllPendingJobs";
                }
                case 8: {
                    return "getAllPendingJobsInNamespace";
                }
                case 9: {
                    return "getPendingJob";
                }
                case 10: {
                    return "getPendingJobReason";
                }
                case 11: {
                    return "getPendingJobReasons";
                }
                case 12: {
                    return "getPendingJobReasonsHistory";
                }
                case 13: {
                    return "canRunUserInitiatedJobs";
                }
                case 14: {
                    return "hasRunUserInitiatedJobsPermission";
                }
                case 15: {
                    return "getStartedJobs";
                }
                case 16: {
                    return "getAllJobSnapshots";
                }
                case 17: {
                    return "registerUserVisibleJobObserver";
                }
                case 18: {
                    return "unregisterUserVisibleJobObserver";
                }
                case 19: {
                    return "notePendingUserRequestedAppStop";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    JobInfo _arg1 = data.readTypedObject(JobInfo.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.schedule(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    JobInfo _arg1 = data.readTypedObject(JobInfo.CREATOR);
                    JobWorkItem _arg2 = data.readTypedObject(JobWorkItem.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.enqueue(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    JobInfo _arg1 = data.readTypedObject(JobInfo.CREATOR);
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.scheduleAsPackage(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancel(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.cancelAll();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cancelAllInNamespace(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    Map<String, ParceledListSlice<JobInfo>> _result = this.getAllPendingJobs();
                    reply.writeNoException();
                    if (_result == null) {
                        reply.writeInt(-1);
                        break;
                    }
                    reply.writeInt(_result.size());
                    _result.forEach((k, v) -> {
                        reply.writeString((String)k);
                        reply.writeTypedObject(v, 1);
                    });
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<JobInfo> _result = this.getAllPendingJobsInNamespace(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    JobInfo _result = this.getPendingJob(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPendingJobReason(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getPendingJobReasons(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PendingJobReasonsInfo> _result = this.getPendingJobReasonsHistory(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.canRunUserInitiatedJobs(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasRunUserInitiatedJobsPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    List<JobInfo> _result = this.getStartedJobs();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 16: {
                    ParceledListSlice _result = this.getAllJobSnapshots();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    IUserVisibleJobObserver _arg0 = IUserVisibleJobObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerUserVisibleJobObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IUserVisibleJobObserver _arg0 = IUserVisibleJobObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterUserVisibleJobObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.notePendingUserRequestedAppStop(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void registerUserVisibleJobObserver_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_registerUserVisibleJobObserver, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterUserVisibleJobObserver_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_unregisterUserVisibleJobObserver, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notePendingUserRequestedAppStop_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_notePendingUserRequestedAppStop, Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 18;
        }

        private static class Proxy
        implements IJobScheduler {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int schedule(String namespace, JobInfo job) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeTypedObject(job, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enqueue(String namespace, JobInfo job, JobWorkItem work) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeTypedObject(job, 0);
                    _data.writeTypedObject(work, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int scheduleAsPackage(String namespace, JobInfo job, String packageName, int userId, String tag) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeTypedObject(job, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel(String namespace, int jobId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAll() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAllInNamespace(String namespace) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, ParceledListSlice<JobInfo>> getAllPendingJobs() throws RemoteException {
                HashMap<String, ParceledListSlice<JobInfo>> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    int N2 = _reply.readInt();
                    _result = N2 < 0 ? null : new HashMap<String, ParceledListSlice<JobInfo>>();
                    IntStream.range(0, N2).forEach(i -> {
                        String k = _reply.readString();
                        ParceledListSlice v = _reply.readTypedObject(ParceledListSlice.CREATOR);
                        _result.put(k, v);
                    });
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<JobInfo> getAllPendingJobsInNamespace(String namespace) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JobInfo getPendingJob(String namespace, int jobId) throws RemoteException {
                JobInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(JobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPendingJobReason(String namespace, int jobId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getPendingJobReasons(String namespace, int jobId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PendingJobReasonsInfo> getPendingJobReasonsHistory(String namespace, int jobId) throws RemoteException {
                ArrayList<PendingJobReasonsInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(namespace);
                    _data.writeInt(jobId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PendingJobReasonsInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canRunUserInitiatedJobs(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasRunUserInitiatedJobsPermission(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<JobInfo> getStartedJobs() throws RemoteException {
                ArrayList<JobInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(JobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAllJobSnapshots() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUserVisibleJobObserver(IUserVisibleJobObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUserVisibleJobObserver(IUserVisibleJobObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notePendingUserRequestedAppStop(String packageName, int userId, String debugReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeString(debugReason);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IJobScheduler {
        @Override
        public int schedule(String namespace, JobInfo job) throws RemoteException {
            return 0;
        }

        @Override
        public int enqueue(String namespace, JobInfo job, JobWorkItem work) throws RemoteException {
            return 0;
        }

        @Override
        public int scheduleAsPackage(String namespace, JobInfo job, String packageName, int userId, String tag) throws RemoteException {
            return 0;
        }

        @Override
        public void cancel(String namespace, int jobId) throws RemoteException {
        }

        @Override
        public void cancelAll() throws RemoteException {
        }

        @Override
        public void cancelAllInNamespace(String namespace) throws RemoteException {
        }

        @Override
        public Map<String, ParceledListSlice<JobInfo>> getAllPendingJobs() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<JobInfo> getAllPendingJobsInNamespace(String namespace) throws RemoteException {
            return null;
        }

        @Override
        public JobInfo getPendingJob(String namespace, int jobId) throws RemoteException {
            return null;
        }

        @Override
        public int getPendingJobReason(String namespace, int jobId) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getPendingJobReasons(String namespace, int jobId) throws RemoteException {
            return null;
        }

        @Override
        public List<PendingJobReasonsInfo> getPendingJobReasonsHistory(String namespace, int jobId) throws RemoteException {
            return null;
        }

        @Override
        public boolean canRunUserInitiatedJobs(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasRunUserInitiatedJobsPermission(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<JobInfo> getStartedJobs() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAllJobSnapshots() throws RemoteException {
            return null;
        }

        @Override
        public void registerUserVisibleJobObserver(IUserVisibleJobObserver observer) throws RemoteException {
        }

        @Override
        public void unregisterUserVisibleJobObserver(IUserVisibleJobObserver observer) throws RemoteException {
        }

        @Override
        public void notePendingUserRequestedAppStop(String packageName, int userId, String debugReason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

