/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RavenwoodKeepWholeClass
public class PackageOverride {
    public static final int VALUE_UNDEFINED = 0;
    public static final int VALUE_ENABLED = 1;
    public static final int VALUE_DISABLED = 2;
    private final long mMinVersionCode;
    private final long mMaxVersionCode;
    private final boolean mEnabled;

    private PackageOverride(long minVersionCode, long maxVersionCode, boolean enabled) {
        this.mMinVersionCode = minVersionCode;
        this.mMaxVersionCode = maxVersionCode;
        this.mEnabled = enabled;
    }

    public int evaluate(long versionCode) {
        if (versionCode >= this.mMinVersionCode && versionCode <= this.mMaxVersionCode) {
            return this.mEnabled ? 1 : 2;
        }
        return 0;
    }

    public int evaluateForAllVersions() {
        if (this.mMinVersionCode == Long.MIN_VALUE && this.mMaxVersionCode == Long.MAX_VALUE) {
            return this.mEnabled ? 1 : 2;
        }
        return 0;
    }

    public long getMinVersionCode() {
        return this.mMinVersionCode;
    }

    public long getMaxVersionCode() {
        return this.mMaxVersionCode;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void writeToParcel(Parcel dest) {
        dest.writeLong(this.mMinVersionCode);
        dest.writeLong(this.mMaxVersionCode);
        dest.writeBoolean(this.mEnabled);
    }

    public static PackageOverride createFromParcel(Parcel in) {
        return new PackageOverride(in.readLong(), in.readLong(), in.readBoolean());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageOverride that = (PackageOverride)o;
        return this.mMinVersionCode == that.mMinVersionCode && this.mMaxVersionCode == that.mMaxVersionCode && this.mEnabled == that.mEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.mMinVersionCode, this.mMaxVersionCode, this.mEnabled);
    }

    public String toString() {
        if (this.mMinVersionCode == Long.MIN_VALUE && this.mMaxVersionCode == Long.MAX_VALUE) {
            return Boolean.toString(this.mEnabled);
        }
        return String.format("[%d,%d,%b]", this.mMinVersionCode, this.mMaxVersionCode, this.mEnabled);
    }

    public static class Builder {
        private long mMinVersionCode = Long.MIN_VALUE;
        private long mMaxVersionCode = Long.MAX_VALUE;
        private boolean mEnabled;

        @NonNull
        public Builder setMinVersionCode(long minVersionCode) {
            this.mMinVersionCode = minVersionCode;
            return this;
        }

        @NonNull
        public Builder setMaxVersionCode(long maxVersionCode) {
            this.mMaxVersionCode = maxVersionCode;
            return this;
        }

        @NonNull
        public Builder setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }

        @NonNull
        public PackageOverride build() {
            if (this.mMinVersionCode > this.mMaxVersionCode) {
                throw new IllegalArgumentException("minVersionCode must not be larger than maxVersionCode");
            }
            return new PackageOverride(this.mMinVersionCode, this.mMaxVersionCode, this.mEnabled);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EvaluatedOverride {
    }
}

