/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.exceptions;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchResult;

public class AppSearchException
extends Exception {
    private final int mResultCode;

    public AppSearchException(int resultCode) {
        this(resultCode, null);
    }

    public AppSearchException(int resultCode, @Nullable String message) {
        this(resultCode, message, null);
    }

    public AppSearchException(int resultCode, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.mResultCode = resultCode;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @NonNull
    public <T> AppSearchResult<T> toAppSearchResult() {
        return AppSearchResult.newFailedResult(this.mResultCode, this.getMessage());
    }
}

