/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.CommitBlobResponse;
import android.app.appsearch.OpenBlobForReadResponse;
import android.app.appsearch.OpenBlobForWriteResponse;
import android.app.appsearch.ParcelableUtil;
import android.app.appsearch.RemoveBlobResponse;
import android.app.appsearch.aidl.AppSearchResultParcelV2Creator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.util.Objects;

@SafeParcelable.Class(creator="AppSearchResultParcelV2Creator", creatorIsFinal=false)
public class AppSearchResultParcelV2<ValueType>
extends AbstractSafeParcelable {
    private static final String TAG = "AppSearchResultParcelV2";
    @NonNull
    public static final Parcelable.Creator<AppSearchResultParcelV2> CREATOR = new AppSearchResultParcelV2Creator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppSearchResultParcelV2 createFromParcel(Parcel in) {
            int writeParcelModel = in.readInt();
            switch (writeParcelModel) {
                case 1: {
                    byte[] dataBlob = Objects.requireNonNull(ParcelableUtil.readBlob(in));
                    Parcel unmarshallParcel = Parcel.obtain();
                    try {
                        unmarshallParcel.unmarshall(dataBlob, 0, dataBlob.length);
                        unmarshallParcel.setDataPosition(0);
                        AppSearchResultParcelV2<?> appSearchResultParcelV2 = AppSearchResultParcelV2.directlyReadFromParcel(unmarshallParcel);
                        return appSearchResultParcelV2;
                    }
                    finally {
                        unmarshallParcel.recycle();
                    }
                }
                case 2: {
                    return AppSearchResultParcelV2.directlyReadFromParcel(in);
                }
            }
            throw new UnsupportedOperationException("Cannot read AppSearchResultParcelV2 from Parcel with unknown model: " + writeParcelModel);
        }
    };
    @NonNull
    private static final Parcelable.Creator<AppSearchResultParcelV2> CREATOR_WITHOUT_BLOB = new AppSearchResultParcelV2Creator();
    @SafeParcelable.Field(id=1)
    int mWriteParcelMode;
    @SafeParcelable.Field(id=2)
    int mResultCode;
    @SafeParcelable.Field(id=3)
    @Nullable
    String mErrorMessage;
    @SafeParcelable.Field(id=4)
    @Nullable
    ParcelFileDescriptor mParcelFileDescriptor;
    @SafeParcelable.Field(id=5)
    @Nullable
    OpenBlobForWriteResponse mOpenBlobForWriteResponse;
    @SafeParcelable.Field(id=6)
    @Nullable
    CommitBlobResponse mCommitBlobResponse;
    @SafeParcelable.Field(id=7)
    @Nullable
    OpenBlobForReadResponse mOpenBlobForReadResponse;
    @SafeParcelable.Field(id=8)
    @Nullable
    RemoveBlobResponse mRemoveBlobResponse;
    @NonNull
    AppSearchResult<ValueType> mResultCached;

    static AppSearchResultParcelV2<?> directlyReadFromParcel(@NonNull Parcel data) {
        return CREATOR_WITHOUT_BLOB.createFromParcel(data);
    }

    static void directlyWriteToParcel(@NonNull AppSearchResultParcelV2<?> result, @NonNull Parcel data, int flags) {
        AppSearchResultParcelV2Creator.writeToParcel(result, data, flags);
    }

    @SafeParcelable.Constructor
    AppSearchResultParcelV2(@SafeParcelable.Param(id=1) int writeParcelMode, @SafeParcelable.Param(id=2) int resultCode, @SafeParcelable.Param(id=3) @Nullable String errorMessage, @SafeParcelable.Param(id=4) @Nullable ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=5) @Nullable OpenBlobForWriteResponse openBlobForWriteResponse, @SafeParcelable.Param(id=6) @Nullable CommitBlobResponse commitBlobResponse, @SafeParcelable.Param(id=7) @Nullable OpenBlobForReadResponse openBlobForReadResponse, @SafeParcelable.Param(id=8) @Nullable RemoveBlobResponse removeBlobResponse) {
        this.mWriteParcelMode = writeParcelMode;
        this.mResultCode = resultCode;
        this.mErrorMessage = errorMessage;
        if (resultCode == 0) {
            this.mParcelFileDescriptor = parcelFileDescriptor;
            this.mOpenBlobForWriteResponse = openBlobForWriteResponse;
            this.mCommitBlobResponse = commitBlobResponse;
            this.mOpenBlobForReadResponse = openBlobForReadResponse;
            this.mRemoveBlobResponse = removeBlobResponse;
            this.mResultCached = this.mParcelFileDescriptor != null ? AppSearchResult.newSuccessfulResult(this.mParcelFileDescriptor) : (this.mOpenBlobForWriteResponse != null ? AppSearchResult.newSuccessfulResult(this.mOpenBlobForWriteResponse) : (this.mCommitBlobResponse != null ? AppSearchResult.newSuccessfulResult(this.mCommitBlobResponse) : (this.mOpenBlobForReadResponse != null ? AppSearchResult.newSuccessfulResult(this.mOpenBlobForReadResponse) : (this.mRemoveBlobResponse != null ? AppSearchResult.newSuccessfulResult(this.mRemoveBlobResponse) : AppSearchResult.newSuccessfulResult(null)))));
        } else {
            this.mResultCached = AppSearchResult.newFailedResult(this.mResultCode, this.mErrorMessage);
        }
    }

    public static AppSearchResultParcelV2 fromVoid() {
        return new Builder(2, 0).build();
    }

    public static AppSearchResultParcelV2 fromFailedResult(AppSearchResult failedResult) {
        if (failedResult.isSuccess()) {
            throw new IllegalStateException("Creating a failed AppSearchResultParcelV2 from a successful response");
        }
        return new Builder(2, failedResult.getResultCode()).setErrorMessage(failedResult.getErrorMessage()).build();
    }

    public static AppSearchResultParcelV2<ParcelFileDescriptor> fromParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
        return new Builder(2, 0).setParcelFileDescriptor(parcelFileDescriptor).build();
    }

    public static AppSearchResultParcelV2<OpenBlobForWriteResponse> fromOpenBlobForWriteResponse(OpenBlobForWriteResponse openBlobForWriteResponse) {
        return new Builder(2, 0).setOpenBlobForWriteResponse(openBlobForWriteResponse).build();
    }

    public static AppSearchResultParcelV2<RemoveBlobResponse> fromRemoveBlobResponseParcel(RemoveBlobResponse removeBlobResponse) {
        return new Builder(1, 0).setRemoveBlobResponse(removeBlobResponse).build();
    }

    public static AppSearchResultParcelV2<CommitBlobResponse> fromCommitBlobResponseParcel(CommitBlobResponse commitBlobResponse) {
        return new Builder(1, 0).setCommitBlobResponse(commitBlobResponse).build();
    }

    public static AppSearchResultParcelV2<OpenBlobForReadResponse> fromOpenBlobForReadResponse(OpenBlobForReadResponse OpenBlobForReadResponse2) {
        return new Builder(2, 0).setOpenBlobForReadResponse(OpenBlobForReadResponse2).build();
    }

    @NonNull
    public AppSearchResult<ValueType> getResult() {
        return this.mResultCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mWriteParcelMode);
        switch (this.mWriteParcelMode) {
            case 1: {
                byte[] bytes;
                Parcel data = Parcel.obtain();
                try {
                    AppSearchResultParcelV2.directlyWriteToParcel(this, data, flags);
                    bytes = data.marshall();
                }
                finally {
                    data.recycle();
                }
                ParcelableUtil.writeBlob(dest, bytes);
                break;
            }
            case 2: {
                AppSearchResultParcelV2.directlyWriteToParcel(this, dest, flags | 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot write AppSearchResultParcelV2 to Parcel with unknown model: " + this.mWriteParcelMode);
            }
        }
    }

    static class Builder<ValueType> {
        private final int mWriteParcelMode;
        private final int mResultCode;
        @Nullable
        private String mErrorMessage;
        @Nullable
        private ParcelFileDescriptor mParcelFileDescriptor;
        @Nullable
        private OpenBlobForWriteResponse mOpenBlobForWriteResponse;
        @Nullable
        private CommitBlobResponse mCommitBlobResponse;
        @Nullable
        private OpenBlobForReadResponse mOpenBlobForReadResponse;
        @Nullable
        private RemoveBlobResponse mRemoveBlobResponse;

        Builder(int writeParcelMode, int resultCode) {
            this.mWriteParcelMode = writeParcelMode;
            this.mResultCode = resultCode;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
            this.mParcelFileDescriptor = parcelFileDescriptor;
            return this;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setOpenBlobForWriteResponse(OpenBlobForWriteResponse openBlobForWriteResponse) {
            this.mOpenBlobForWriteResponse = openBlobForWriteResponse;
            return this;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setRemoveBlobResponse(RemoveBlobResponse removeBlobResponse) {
            this.mRemoveBlobResponse = removeBlobResponse;
            return this;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setCommitBlobResponse(CommitBlobResponse commitBlobResponse) {
            this.mCommitBlobResponse = commitBlobResponse;
            return this;
        }

        @CanIgnoreReturnValue
        Builder<ValueType> setOpenBlobForReadResponse(OpenBlobForReadResponse OpenBlobForReadResponse2) {
            this.mOpenBlobForReadResponse = OpenBlobForReadResponse2;
            return this;
        }

        @NonNull
        AppSearchResultParcelV2<ValueType> build() {
            return new AppSearchResultParcelV2(this.mWriteParcelMode, this.mResultCode, this.mErrorMessage, this.mParcelFileDescriptor, this.mOpenBlobForWriteResponse, this.mCommitBlobResponse, this.mOpenBlobForReadResponse, this.mRemoveBlobResponse);
        }
    }
}

