/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.app.appsearch.aidl.AppSearchAttributionSourceCreator;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os._Original_Build;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

@SafeParcelable.Class(creator="AppSearchAttributionSourceCreator")
public class AppSearchAttributionSource
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AppSearchAttributionSource> CREATOR = new AppSearchAttributionSourceCreator();
    @NonNull
    private final Compat mCompat;
    @Nullable
    @SafeParcelable.Field(id=1, getter="getAttributionSource")
    private final AttributionSource mAttributionSource;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getPackageName")
    private final String mCallingPackageName;
    @SafeParcelable.Field(id=3, getter="getUid")
    private final int mCallingUid;
    @SafeParcelable.Field(id=4, getter="getPid")
    private int mCallingPid;
    private static final int INVALID_PID = -1;

    @SafeParcelable.Constructor
    AppSearchAttributionSource(@SafeParcelable.Param(id=1) @Nullable AttributionSource attributionSource, @SafeParcelable.Param(id=2) @NonNull String callingPackageName, @SafeParcelable.Param(id=3) int callingUid, @SafeParcelable.Param(id=4) int callingPid) {
        this.mAttributionSource = attributionSource;
        this.mCallingPackageName = Objects.requireNonNull(callingPackageName);
        this.mCallingUid = callingUid;
        this.mCallingPid = callingPid;
        if (_Original_Build.VERSION.SDK_INT >= 31 && this.mAttributionSource != null) {
            this.mCompat = new Api31Impl(this.mAttributionSource, this.mCallingPid);
        } else {
            int callingPidFromBinder = Binder.getCallingPid();
            if (callingPidFromBinder == 0) {
                this.mCallingPid = -1;
            }
            Api19Impl impl = new Api19Impl(this.mCallingPackageName, this.mCallingUid, this.mCallingPid);
            impl.enforceCallingUid();
            impl.enforceCallingPid();
            this.mCompat = impl;
        }
    }

    private AppSearchAttributionSource(@NonNull Compat compat) {
        this.mCompat = Objects.requireNonNull(compat);
        this.mAttributionSource = this.mCompat.getAttributionSource();
        this.mCallingPackageName = this.mCompat.getPackageName();
        this.mCallingUid = this.mCompat.getUid();
        this.mCallingPid = this.mCompat.getPid();
    }

    @VisibleForTesting
    public AppSearchAttributionSource(@NonNull String callingPackageName, int callingUid, int callingPid) {
        this.mCallingPackageName = Objects.requireNonNull(callingPackageName);
        this.mCallingUid = callingUid;
        this.mCallingPid = callingPid;
        if (_Original_Build.VERSION.SDK_INT >= 31) {
            AttributionSource.Builder attributionSourceBuilder = new AttributionSource.Builder(this.mCallingUid).setPackageName(this.mCallingPackageName);
            if (_Original_Build.VERSION.SDK_INT >= 34) {
                attributionSourceBuilder.setPid(callingPid);
            }
            this.mAttributionSource = attributionSourceBuilder.build();
            this.mCompat = new Api31Impl(this.mAttributionSource, this.mCallingPid);
        } else {
            this.mAttributionSource = null;
            this.mCompat = new Api19Impl(this.mCallingPackageName, this.mCallingUid, this.mCallingPid);
        }
    }

    @RequiresApi(value=31)
    @NonNull
    private static AppSearchAttributionSource toAppSearchAttributionSource(@NonNull AttributionSource attributionSource, int pid) {
        return new AppSearchAttributionSource(new Api31Impl(attributionSource, pid));
    }

    private static AppSearchAttributionSource toAppSearchAttributionSource(@NonNull String packageName, int uid, int pid) {
        return new AppSearchAttributionSource(new Api19Impl(packageName, uid, pid));
    }

    public static AppSearchAttributionSource createAttributionSource(@NonNull Context context, int callingPid) {
        if (_Original_Build.VERSION.SDK_INT >= 31) {
            return AppSearchAttributionSource.toAppSearchAttributionSource(context.getAttributionSource(), callingPid);
        }
        return AppSearchAttributionSource.toAppSearchAttributionSource(context.getPackageName(), Process.myUid(), callingPid);
    }

    @Nullable
    public AttributionSource getAttributionSource() {
        return this.mCompat.getAttributionSource();
    }

    @NonNull
    public String getPackageName() {
        return this.mCompat.getPackageName();
    }

    public int getUid() {
        return this.mCompat.getUid();
    }

    public int getPid() {
        return this.mCompat.getPid();
    }

    public int hashCode() {
        if (_Original_Build.VERSION.SDK_INT >= 31) {
            AttributionSource attributionSource = Objects.requireNonNull(this.mCompat.getAttributionSource());
            return ((Object)attributionSource).hashCode();
        }
        return Objects.hash(this.mCompat.getUid(), this.mCompat.getPackageName());
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof AppSearchAttributionSource)) {
            return false;
        }
        AppSearchAttributionSource that = (AppSearchAttributionSource)o;
        if (_Original_Build.VERSION.SDK_INT >= 31) {
            AttributionSource thatAttributionSource;
            AttributionSource thisAttributionSource = Objects.requireNonNull(this.mCompat.getAttributionSource());
            return ((Object)thisAttributionSource).equals(thatAttributionSource = Objects.requireNonNull(that.getAttributionSource())) && that.getPid() == this.mCompat.getPid();
        }
        return Objects.equals(this.mCompat.getPackageName(), that.getPackageName()) && this.mCompat.getUid() == that.getUid() && this.mCompat.getPid() == that.getPid();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        AppSearchAttributionSourceCreator.writeToParcel(this, dest, flags);
    }

    @RequiresApi(value=31)
    private static class Api31Impl
    implements Compat {
        private final AttributionSource mAttributionSource;
        private final int mPid;

        Api31Impl(@NonNull AttributionSource attributionSource, int pid) {
            this.mAttributionSource = attributionSource;
            this.mPid = pid;
        }

        @Override
        @NonNull
        public String getPackageName() {
            return Objects.requireNonNull(this.mAttributionSource.getPackageName());
        }

        @Override
        @Nullable
        public AttributionSource getAttributionSource() {
            return this.mAttributionSource;
        }

        @Override
        public int getUid() {
            return this.mAttributionSource.getUid();
        }

        @Override
        public int getPid() {
            return this.mPid;
        }
    }

    private static interface Compat {
        @NonNull
        public String getPackageName();

        @Nullable
        public AttributionSource getAttributionSource();

        public int getUid();

        public int getPid();
    }

    private static class Api19Impl
    implements Compat {
        @NonNull
        private final String mPackageName;
        private final int mUid;
        private final int mPid;

        Api19Impl(@NonNull String packageName, int uid, int pid) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mUid = uid;
            this.mPid = pid;
        }

        @Override
        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        @Override
        @Nullable
        public AttributionSource getAttributionSource() {
            return null;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        @Override
        public int getPid() {
            return this.mPid;
        }

        private void enforceCallingUid() {
            if (!this.checkCallingUid()) {
                int callingUid = Binder.getCallingUid();
                throw new SecurityException("Calling uid: " + callingUid + " doesn't match source uid: " + this.mUid);
            }
        }

        private boolean checkCallingUid() {
            int callingUid = Binder.getCallingUid();
            return callingUid == this.mUid;
        }

        private void enforceCallingPid() {
            if (!this.checkCallingPid()) {
                if (Binder.getCallingPid() == 0) {
                    throw new SecurityException("Calling pid unavailable due to oneway Binder call.");
                }
                throw new SecurityException("Calling pid: " + Binder.getCallingPid() + " doesn't match source pid: " + this.mPid);
            }
        }

        private boolean checkCallingPid() {
            int callingPid = Binder.getCallingPid();
            return this.mPid == -1 || this.mPid == callingPid;
        }
    }
}

