/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.appsearch.EmbeddingVector;
import android.app.appsearch.JoinSpec;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.SearchSpecCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="SearchSpecCreator")
public class SearchSpec
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<SearchSpec> CREATOR = new SearchSpecCreator();
    @Deprecated
    public static final String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";
    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
    public static final String SCHEMA_TYPE_WILDCARD = "*";
    @SafeParcelable.Field(id=1, getter="getTermMatch")
    private final int mTermMatchType;
    @SafeParcelable.Field(id=2, getter="getFilterSchemas")
    private final List<String> mSchemas;
    @SafeParcelable.Field(id=3, getter="getFilterNamespaces")
    private final List<String> mNamespaces;
    @SafeParcelable.Field(id=4)
    final Bundle mTypePropertyFilters;
    @SafeParcelable.Field(id=5, getter="getFilterPackageNames")
    private final List<String> mPackageNames;
    @SafeParcelable.Field(id=6, getter="getResultCountPerPage")
    private final int mResultCountPerPage;
    @SafeParcelable.Field(id=7, getter="getRankingStrategy")
    private final int mRankingStrategy;
    @SafeParcelable.Field(id=8, getter="getOrder")
    private final int mOrder;
    @SafeParcelable.Field(id=9, getter="getSnippetCount")
    private final int mSnippetCount;
    @SafeParcelable.Field(id=10, getter="getSnippetCountPerProperty")
    private final int mSnippetCountPerProperty;
    @SafeParcelable.Field(id=11, getter="getMaxSnippetSize")
    private final int mMaxSnippetSize;
    @SafeParcelable.Field(id=12)
    final Bundle mProjectionTypePropertyMasks;
    @SafeParcelable.Field(id=13, getter="getResultGroupingTypeFlags")
    private final int mResultGroupingTypeFlags;
    @SafeParcelable.Field(id=14, getter="getResultGroupingLimit")
    private final int mGroupingLimit;
    @SafeParcelable.Field(id=15)
    final Bundle mTypePropertyWeightsField;
    @SafeParcelable.Field(id=16, getter="getJoinSpec")
    @Nullable
    private final JoinSpec mJoinSpec;
    @SafeParcelable.Field(id=17, getter="getAdvancedRankingExpression")
    private final String mAdvancedRankingExpression;
    @SafeParcelable.Field(id=18, getter="getEnabledFeatures")
    private final List<String> mEnabledFeatures;
    @SafeParcelable.Field(id=19, getter="getSearchSourceLogTag")
    @Nullable
    private final String mSearchSourceLogTag;
    @SafeParcelable.Field(id=20, getter="getEmbeddingParameters")
    @NonNull
    private final List<EmbeddingVector> mEmbeddingParameters;
    @SafeParcelable.Field(id=21, getter="getDefaultEmbeddingSearchMetricType")
    private final int mDefaultEmbeddingSearchMetricType;
    @SafeParcelable.Field(id=22, getter="getInformationalRankingExpressions")
    @NonNull
    private final List<String> mInformationalRankingExpressions;
    @SafeParcelable.Field(id=23, getter="getSearchStringParameters")
    @NonNull
    private final List<String> mSearchStringParameters;
    @SafeParcelable.Field(id=24, getter="getFilterDocumentIds")
    @NonNull
    private final List<String> mFilterDocumentIds;
    @SafeParcelable.Field(id=25, getter="shouldRetrieveEmbeddingMatchInfos")
    private final boolean mRetrieveEmbeddingMatchInfos;
    public static final int DEFAULT_NUM_PER_PAGE = 10;
    private static final int MAX_NUM_PER_PAGE = 10000;
    private static final int MAX_SNIPPET_COUNT = 10000;
    private static final int MAX_SNIPPET_PER_PROPERTY_COUNT = 10000;
    private static final int MAX_SNIPPET_SIZE_LIMIT = 10000;
    public static final int TERM_MATCH_EXACT_ONLY = 1;
    public static final int TERM_MATCH_PREFIX = 2;
    public static final int RANKING_STRATEGY_NONE = 0;
    public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1;
    public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2;
    public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3;
    public static final int RANKING_STRATEGY_USAGE_COUNT = 4;
    public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5;
    public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6;
    public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7;
    public static final int RANKING_STRATEGY_JOIN_AGGREGATE_SCORE = 8;
    public static final int RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION = 9;
    public static final int ORDER_DESCENDING = 0;
    public static final int ORDER_ASCENDING = 1;
    public static final int GROUPING_TYPE_PER_PACKAGE = 1;
    public static final int GROUPING_TYPE_PER_NAMESPACE = 2;
    @FlaggedApi(value="com.android.appsearch.flags.enable_grouping_type_per_schema")
    public static final int GROUPING_TYPE_PER_SCHEMA = 4;
    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public static final int EMBEDDING_SEARCH_METRIC_TYPE_DEFAULT = 0;
    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public static final int EMBEDDING_SEARCH_METRIC_TYPE_COSINE = 1;
    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public static final int EMBEDDING_SEARCH_METRIC_TYPE_DOT_PRODUCT = 2;
    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public static final int EMBEDDING_SEARCH_METRIC_TYPE_EUCLIDEAN = 3;

    @SafeParcelable.Constructor
    SearchSpec(@SafeParcelable.Param(id=1) int termMatchType, @SafeParcelable.Param(id=2) @NonNull List<String> schemas, @SafeParcelable.Param(id=3) @NonNull List<String> namespaces, @SafeParcelable.Param(id=4) @NonNull Bundle properties, @SafeParcelable.Param(id=5) @NonNull List<String> packageNames, @SafeParcelable.Param(id=6) int resultCountPerPage, @SafeParcelable.Param(id=7) int rankingStrategy, @SafeParcelable.Param(id=8) int order, @SafeParcelable.Param(id=9) int snippetCount, @SafeParcelable.Param(id=10) int snippetCountPerProperty, @SafeParcelable.Param(id=11) int maxSnippetSize, @SafeParcelable.Param(id=12) @NonNull Bundle projectionTypePropertyMasks, @SafeParcelable.Param(id=13) int resultGroupingTypeFlags, @SafeParcelable.Param(id=14) int groupingLimit, @SafeParcelable.Param(id=15) @NonNull Bundle typePropertyWeightsField, @SafeParcelable.Param(id=16) @Nullable JoinSpec joinSpec, @SafeParcelable.Param(id=17) @NonNull String advancedRankingExpression, @SafeParcelable.Param(id=18) @NonNull List<String> enabledFeatures, @SafeParcelable.Param(id=19) @Nullable String searchSourceLogTag, @SafeParcelable.Param(id=20) @Nullable List<EmbeddingVector> embeddingParameters, @SafeParcelable.Param(id=21) int defaultEmbeddingSearchMetricType, @SafeParcelable.Param(id=22) @Nullable List<String> informationalRankingExpressions, @SafeParcelable.Param(id=23) @Nullable List<String> searchStringParameters, @SafeParcelable.Param(id=24) @Nullable List<String> filterDocumentIds, @SafeParcelable.Param(id=25) boolean retrieveEmbeddingMatchInfos) {
        this.mTermMatchType = termMatchType;
        this.mSchemas = Collections.unmodifiableList(Objects.requireNonNull(schemas));
        this.mNamespaces = Collections.unmodifiableList(Objects.requireNonNull(namespaces));
        this.mTypePropertyFilters = Objects.requireNonNull(properties);
        this.mPackageNames = Collections.unmodifiableList(Objects.requireNonNull(packageNames));
        this.mResultCountPerPage = resultCountPerPage;
        this.mRankingStrategy = rankingStrategy;
        this.mOrder = order;
        this.mSnippetCount = snippetCount;
        this.mSnippetCountPerProperty = snippetCountPerProperty;
        this.mMaxSnippetSize = maxSnippetSize;
        this.mProjectionTypePropertyMasks = Objects.requireNonNull(projectionTypePropertyMasks);
        this.mResultGroupingTypeFlags = resultGroupingTypeFlags;
        this.mGroupingLimit = groupingLimit;
        this.mTypePropertyWeightsField = Objects.requireNonNull(typePropertyWeightsField);
        this.mJoinSpec = joinSpec;
        this.mAdvancedRankingExpression = Objects.requireNonNull(advancedRankingExpression);
        this.mEnabledFeatures = Collections.unmodifiableList(Objects.requireNonNull(enabledFeatures));
        this.mSearchSourceLogTag = searchSourceLogTag;
        this.mEmbeddingParameters = embeddingParameters != null ? Collections.unmodifiableList(embeddingParameters) : Collections.emptyList();
        this.mDefaultEmbeddingSearchMetricType = defaultEmbeddingSearchMetricType;
        this.mInformationalRankingExpressions = informationalRankingExpressions != null ? Collections.unmodifiableList(informationalRankingExpressions) : Collections.emptyList();
        this.mSearchStringParameters = searchStringParameters != null ? Collections.unmodifiableList(searchStringParameters) : Collections.emptyList();
        this.mFilterDocumentIds = filterDocumentIds != null ? Collections.unmodifiableList(filterDocumentIds) : Collections.emptyList();
        this.mRetrieveEmbeddingMatchInfos = retrieveEmbeddingMatchInfos;
    }

    public int getTermMatch() {
        return this.mTermMatchType;
    }

    @NonNull
    public List<String> getFilterSchemas() {
        if (this.mSchemas == null) {
            return Collections.emptyList();
        }
        return this.mSchemas;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
    @NonNull
    public Map<String, List<String>> getFilterProperties() {
        Set<String> schemas = this.mTypePropertyFilters.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            typePropertyPathsMap.put(schema, (List<String>)Objects.requireNonNull(this.mTypePropertyFilters.getStringArrayList(schema)));
        }
        return typePropertyPathsMap;
    }

    @NonNull
    public List<String> getFilterNamespaces() {
        if (this.mNamespaces == null) {
            return Collections.emptyList();
        }
        return this.mNamespaces;
    }

    @NonNull
    public List<String> getFilterPackageNames() {
        if (this.mPackageNames == null) {
            return Collections.emptyList();
        }
        return this.mPackageNames;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_document_ids")
    @NonNull
    public List<String> getFilterDocumentIds() {
        return this.mFilterDocumentIds;
    }

    public int getResultCountPerPage() {
        return this.mResultCountPerPage;
    }

    public int getRankingStrategy() {
        return this.mRankingStrategy;
    }

    public int getOrder() {
        return this.mOrder;
    }

    public int getSnippetCount() {
        return this.mSnippetCount;
    }

    public int getSnippetCountPerProperty() {
        return this.mSnippetCountPerProperty;
    }

    public int getMaxSnippetSize() {
        return this.mMaxSnippetSize;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
    public boolean shouldRetrieveEmbeddingMatchInfos() {
        return this.mRetrieveEmbeddingMatchInfos;
    }

    @NonNull
    public Map<String, List<String>> getProjections() {
        Set<String> schemas = this.mProjectionTypePropertyMasks.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            typePropertyPathsMap.put(schema, (List<String>)Objects.requireNonNull(this.mProjectionTypePropertyMasks.getStringArrayList(schema)));
        }
        return typePropertyPathsMap;
    }

    @NonNull
    public Map<String, List<PropertyPath>> getProjectionPaths() {
        Set<String> schemas = this.mProjectionTypePropertyMasks.keySet();
        ArrayMap<String, List<PropertyPath>> typePropertyPathsMap = new ArrayMap<String, List<PropertyPath>>(schemas.size());
        for (String schema : schemas) {
            ArrayList<String> propertyPathList = this.mProjectionTypePropertyMasks.getStringArrayList(schema);
            if (propertyPathList == null) continue;
            ArrayList<PropertyPath> copy = new ArrayList<PropertyPath>(propertyPathList.size());
            for (int i = 0; i < propertyPathList.size(); ++i) {
                String p = propertyPathList.get(i);
                copy.add(new PropertyPath(p));
            }
            typePropertyPathsMap.put(schema, copy);
        }
        return typePropertyPathsMap;
    }

    @NonNull
    public Map<String, Map<String, Double>> getPropertyWeights() {
        Set<String> schemaTypes = this.mTypePropertyWeightsField.keySet();
        ArrayMap<String, Map<String, Double>> typePropertyWeightsMap = new ArrayMap<String, Map<String, Double>>(schemaTypes.size());
        for (String schemaType : schemaTypes) {
            Bundle propertyPathBundle = this.mTypePropertyWeightsField.getBundle(schemaType);
            if (propertyPathBundle == null) continue;
            Set<String> propertyPaths = propertyPathBundle.keySet();
            ArrayMap<String, Double> propertyPathWeights = new ArrayMap<String, Double>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                propertyPathWeights.put(propertyPath, propertyPathBundle.getDouble(propertyPath));
            }
            typePropertyWeightsMap.put(schemaType, propertyPathWeights);
        }
        return typePropertyWeightsMap;
    }

    @NonNull
    public Map<String, Map<PropertyPath, Double>> getPropertyWeightPaths() {
        Set<String> schemaTypes = this.mTypePropertyWeightsField.keySet();
        ArrayMap<String, Map<PropertyPath, Double>> typePropertyWeightsMap = new ArrayMap<String, Map<PropertyPath, Double>>(schemaTypes.size());
        for (String schemaType : schemaTypes) {
            Bundle propertyPathBundle = this.mTypePropertyWeightsField.getBundle(schemaType);
            if (propertyPathBundle == null) continue;
            Set<String> propertyPaths = propertyPathBundle.keySet();
            ArrayMap<PropertyPath, Double> propertyPathWeights = new ArrayMap<PropertyPath, Double>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                propertyPathWeights.put(new PropertyPath(propertyPath), propertyPathBundle.getDouble(propertyPath));
            }
            typePropertyWeightsMap.put(schemaType, propertyPathWeights);
        }
        return typePropertyWeightsMap;
    }

    public int getResultGroupingTypeFlags() {
        return this.mResultGroupingTypeFlags;
    }

    public int getResultGroupingLimit() {
        return this.mGroupingLimit;
    }

    @Nullable
    public JoinSpec getJoinSpec() {
        return this.mJoinSpec;
    }

    @NonNull
    public String getAdvancedRankingExpression() {
        return this.mAdvancedRankingExpression;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_set_search_source_log_tag")
    @Nullable
    public String getSearchSourceLogTag() {
        return this.mSearchSourceLogTag;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    @NonNull
    public List<EmbeddingVector> getEmbeddingParameters() {
        return this.mEmbeddingParameters;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public int getDefaultEmbeddingSearchMetricType() {
        return this.mDefaultEmbeddingSearchMetricType;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_informational_ranking_expressions")
    @NonNull
    public List<String> getInformationalRankingExpressions() {
        return this.mInformationalRankingExpressions;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
    @NonNull
    public List<String> getSearchStringParameters() {
        return this.mSearchStringParameters;
    }

    public boolean isNumericSearchEnabled() {
        return this.mEnabledFeatures.contains("NUMERIC_SEARCH");
    }

    public boolean isVerbatimSearchEnabled() {
        return this.mEnabledFeatures.contains("VERBATIM_SEARCH");
    }

    public boolean isListFilterQueryLanguageEnabled() {
        return this.mEnabledFeatures.contains("LIST_FILTER_QUERY_LANGUAGE");
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
    public boolean isScorablePropertyRankingEnabled() {
        return this.mEnabledFeatures.contains("SCHEMA_SCORABLE_PROPERTY_CONFIG");
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_list_filter_has_property_function")
    public boolean isListFilterHasPropertyFunctionEnabled() {
        return this.mEnabledFeatures.contains("LIST_FILTER_HAS_PROPERTY_FUNCTION");
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_list_filter_match_score_expression_function")
    public boolean isListFilterMatchScoreExpressionFunctionEnabled() {
        return this.mEnabledFeatures.contains("LIST_FILTER_MATCH_SCORE_EXPRESSION_FUNCTION");
    }

    @NonNull
    public List<String> getEnabledFeatures() {
        return this.mEnabledFeatures;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SearchSpecCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private List<String> mSchemas = new ArrayList<String>();
        private List<String> mNamespaces = new ArrayList<String>();
        private Bundle mTypePropertyFilters = new Bundle();
        private List<String> mPackageNames = new ArrayList<String>();
        private ArraySet<String> mEnabledFeatures = new ArraySet();
        private Bundle mProjectionTypePropertyMasks = new Bundle();
        private Bundle mTypePropertyWeights = new Bundle();
        private List<EmbeddingVector> mEmbeddingParameters = new ArrayList<EmbeddingVector>();
        private List<String> mSearchStringParameters = new ArrayList<String>();
        private List<String> mFilterDocumentIds = new ArrayList<String>();
        private int mResultCountPerPage = 10;
        private int mTermMatchType = 2;
        private int mDefaultEmbeddingSearchMetricType = 1;
        private int mSnippetCount = 0;
        private int mSnippetCountPerProperty = 10000;
        private int mMaxSnippetSize = 0;
        private int mRankingStrategy = 0;
        private int mOrder = 0;
        private int mGroupingTypeFlags = 0;
        private int mGroupingLimit = 0;
        @Nullable
        private JoinSpec mJoinSpec;
        private String mAdvancedRankingExpression = "";
        private List<String> mInformationalRankingExpressions = new ArrayList<String>();
        @Nullable
        private String mSearchSourceLogTag;
        private boolean mRetrieveEmbeddingMatchInfos = false;
        private boolean mBuilt = false;

        public Builder() {
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull SearchSpec searchSpec) {
            Objects.requireNonNull(searchSpec);
            this.mSchemas = new ArrayList<String>(searchSpec.getFilterSchemas());
            this.mNamespaces = new ArrayList<String>(searchSpec.getFilterNamespaces());
            for (Map.Entry<String, List<String>> entry : searchSpec.getFilterProperties().entrySet()) {
                this.addFilterProperties(entry.getKey(), (Collection<String>)entry.getValue());
            }
            this.mPackageNames = new ArrayList<String>(searchSpec.getFilterPackageNames());
            this.mEnabledFeatures = new ArraySet<String>(searchSpec.getEnabledFeatures());
            for (Map.Entry<String, List<String>> entry : searchSpec.getProjections().entrySet()) {
                this.addProjection(entry.getKey(), (Collection<String>)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : searchSpec.getPropertyWeights().entrySet()) {
                this.setPropertyWeights(entry.getKey(), (Map)entry.getValue());
            }
            this.mEmbeddingParameters = new ArrayList<EmbeddingVector>(searchSpec.getEmbeddingParameters());
            this.mSearchStringParameters = new ArrayList<String>(searchSpec.getSearchStringParameters());
            this.mResultCountPerPage = searchSpec.getResultCountPerPage();
            this.mTermMatchType = searchSpec.getTermMatch();
            this.mDefaultEmbeddingSearchMetricType = searchSpec.getDefaultEmbeddingSearchMetricType();
            this.mSnippetCount = searchSpec.getSnippetCount();
            this.mSnippetCountPerProperty = searchSpec.getSnippetCountPerProperty();
            this.mMaxSnippetSize = searchSpec.getMaxSnippetSize();
            this.mRankingStrategy = searchSpec.getRankingStrategy();
            this.mOrder = searchSpec.getOrder();
            this.mGroupingTypeFlags = searchSpec.getResultGroupingTypeFlags();
            this.mGroupingLimit = searchSpec.getResultGroupingLimit();
            this.mJoinSpec = searchSpec.getJoinSpec();
            this.mAdvancedRankingExpression = searchSpec.getAdvancedRankingExpression();
            this.mInformationalRankingExpressions = new ArrayList<String>(searchSpec.getInformationalRankingExpressions());
            this.mSearchSourceLogTag = searchSpec.getSearchSourceLogTag();
            this.mFilterDocumentIds = new ArrayList<String>(searchSpec.getFilterDocumentIds());
            this.mRetrieveEmbeddingMatchInfos = searchSpec.shouldRetrieveEmbeddingMatchInfos();
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setTermMatch(int termMatchType) {
            Preconditions.checkArgumentInRange(termMatchType, 1, 2, "Term match type");
            this.resetIfBuilt();
            this.mTermMatchType = termMatchType;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(String ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemas));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(@NonNull Collection<String> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemas);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearFilterSchemas() {
            this.resetIfBuilt();
            this.mSchemas.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
        @NonNull
        public Builder addFilterProperties(@NonNull String schema, @NonNull Collection<String> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsArrayList.add(propertyPath);
            }
            this.mTypePropertyFilters.putStringArrayList(schema, propertyPathsArrayList);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
        @NonNull
        public Builder addFilterPropertyPaths(@NonNull String schema, @NonNull Collection<PropertyPath> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (PropertyPath propertyPath : propertyPaths) {
                propertyPathsArrayList.add(propertyPath.toString());
            }
            return this.addFilterProperties(schema, propertyPathsArrayList);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearFilterProperties() {
            this.resetIfBuilt();
            this.mTypePropertyFilters.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterNamespaces(String ... namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            return this.addFilterNamespaces(Arrays.asList(namespaces));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterNamespaces(@NonNull Collection<String> namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            this.mNamespaces.addAll(namespaces);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearFilterNamespaces() {
            this.resetIfBuilt();
            this.mNamespaces.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterPackageNames(String ... packageNames) {
            Objects.requireNonNull(packageNames);
            this.resetIfBuilt();
            return this.addFilterPackageNames(Arrays.asList(packageNames));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterPackageNames(@NonNull Collection<String> packageNames) {
            Objects.requireNonNull(packageNames);
            this.resetIfBuilt();
            this.mPackageNames.addAll(packageNames);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearFilterPackageNames() {
            this.resetIfBuilt();
            this.mPackageNames.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_document_ids")
        @NonNull
        public Builder addFilterDocumentIds(String ... documentIds) {
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            return this.addFilterDocumentIds(Arrays.asList(documentIds));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_document_ids")
        @NonNull
        public Builder addFilterDocumentIds(@NonNull Collection<String> documentIds) {
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            this.mFilterDocumentIds.addAll(documentIds);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearFilterDocumentIds() {
            this.resetIfBuilt();
            this.mFilterDocumentIds.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setResultCountPerPage(int resultCountPerPage) {
            Preconditions.checkArgumentInRange(resultCountPerPage, 0, 10000, "resultCountPerPage");
            this.resetIfBuilt();
            this.mResultCountPerPage = resultCountPerPage;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setRankingStrategy(int rankingStrategy) {
            Preconditions.checkArgumentInRange(rankingStrategy, 0, 8, "Result ranking strategy");
            this.resetIfBuilt();
            this.mRankingStrategy = rankingStrategy;
            this.mAdvancedRankingExpression = "";
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setRankingStrategy(@NonNull String advancedRankingExpression) {
            Preconditions.checkStringNotEmpty(advancedRankingExpression);
            this.resetIfBuilt();
            this.mRankingStrategy = 9;
            this.mAdvancedRankingExpression = advancedRankingExpression;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_informational_ranking_expressions")
        @NonNull
        public Builder addInformationalRankingExpressions(String ... informationalRankingExpressions) {
            Objects.requireNonNull(informationalRankingExpressions);
            this.resetIfBuilt();
            return this.addInformationalRankingExpressions(Arrays.asList(informationalRankingExpressions));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_informational_ranking_expressions")
        @NonNull
        public Builder addInformationalRankingExpressions(@NonNull Collection<String> informationalRankingExpressions) {
            Objects.requireNonNull(informationalRankingExpressions);
            this.resetIfBuilt();
            this.mInformationalRankingExpressions.addAll(informationalRankingExpressions);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearInformationalRankingExpressions() {
            this.resetIfBuilt();
            this.mInformationalRankingExpressions.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_set_search_source_log_tag")
        @NonNull
        public Builder setSearchSourceLogTag(@NonNull String searchSourceLogTag) {
            Preconditions.checkStringNotEmpty(searchSourceLogTag);
            Preconditions.checkArgument(searchSourceLogTag.length() <= 100, "The maximum supported tag length is 100. This tag is too long: " + searchSourceLogTag.length());
            this.resetIfBuilt();
            this.mSearchSourceLogTag = searchSourceLogTag;
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSearchSourceLogTag() {
            this.resetIfBuilt();
            this.mSearchSourceLogTag = null;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setOrder(int order) {
            Preconditions.checkArgumentInRange(order, 0, 1, "Result ranking order");
            this.resetIfBuilt();
            this.mOrder = order;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setSnippetCount(int snippetCount) {
            Preconditions.checkArgumentInRange(snippetCount, 0, 10000, "snippetCount");
            this.resetIfBuilt();
            this.mSnippetCount = snippetCount;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setSnippetCountPerProperty(int snippetCountPerProperty) {
            Preconditions.checkArgumentInRange(snippetCountPerProperty, 0, 10000, "snippetCountPerProperty");
            this.resetIfBuilt();
            this.mSnippetCountPerProperty = snippetCountPerProperty;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setMaxSnippetSize(int maxSnippetSize) {
            Preconditions.checkArgumentInRange(maxSnippetSize, 0, 10000, "maxSnippetSize");
            this.resetIfBuilt();
            this.mMaxSnippetSize = maxSnippetSize;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setRetrieveEmbeddingMatchInfos(boolean retrieveEmbeddingMatchInfos) {
            this.resetIfBuilt();
            this.mRetrieveEmbeddingMatchInfos = retrieveEmbeddingMatchInfos;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addProjection(@NonNull String schema, @NonNull Collection<String> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsArrayList.add(propertyPath);
            }
            this.mProjectionTypePropertyMasks.putStringArrayList(schema, propertyPathsArrayList);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addProjectionPaths(@NonNull String schema, @NonNull Collection<PropertyPath> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (PropertyPath propertyPath : propertyPaths) {
                propertyPathsArrayList.add(propertyPath.toString());
            }
            return this.addProjection(schema, propertyPathsArrayList);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearProjections() {
            this.resetIfBuilt();
            this.mProjectionTypePropertyMasks.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setResultGrouping(int groupingTypeFlags, int limit) {
            Preconditions.checkState(groupingTypeFlags != 0, "Result grouping type cannot be zero.");
            this.resetIfBuilt();
            this.mGroupingTypeFlags = groupingTypeFlags;
            this.mGroupingLimit = limit;
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearResultGrouping() {
            this.resetIfBuilt();
            this.mGroupingTypeFlags = 0;
            this.mGroupingLimit = 0;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setPropertyWeights(@NonNull String schemaType, @NonNull Map<String, Double> propertyPathWeights) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(propertyPathWeights);
            Bundle propertyPathBundle = new Bundle();
            for (Map.Entry<String, Double> propertyPathWeightEntry : propertyPathWeights.entrySet()) {
                String propertyPath = Objects.requireNonNull(propertyPathWeightEntry.getKey());
                Double weight = Objects.requireNonNull(propertyPathWeightEntry.getValue());
                if (weight <= 0.0) {
                    throw new IllegalArgumentException("Cannot set non-positive property weight value " + weight + " for property path: " + propertyPath);
                }
                propertyPathBundle.putDouble(propertyPath, weight);
            }
            this.mTypePropertyWeights.putBundle(schemaType, propertyPathBundle);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearPropertyWeights() {
            this.resetIfBuilt();
            this.mTypePropertyWeights.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setJoinSpec(@NonNull JoinSpec joinSpec) {
            this.resetIfBuilt();
            this.mJoinSpec = Objects.requireNonNull(joinSpec);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearJoinSpec() {
            this.resetIfBuilt();
            this.mJoinSpec = null;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setPropertyWeightPaths(@NonNull String schemaType, @NonNull Map<PropertyPath, Double> propertyPathWeights) {
            Objects.requireNonNull(propertyPathWeights);
            ArrayMap<String, Double> propertyWeights = new ArrayMap<String, Double>(propertyPathWeights.size());
            for (Map.Entry<PropertyPath, Double> propertyPathWeightEntry : propertyPathWeights.entrySet()) {
                PropertyPath propertyPath = Objects.requireNonNull(propertyPathWeightEntry.getKey());
                propertyWeights.put(propertyPath.toString(), propertyPathWeightEntry.getValue());
            }
            return this.setPropertyWeights(schemaType, propertyWeights);
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
        @NonNull
        public Builder addEmbeddingParameters(EmbeddingVector ... searchEmbeddings) {
            Objects.requireNonNull(searchEmbeddings);
            this.resetIfBuilt();
            return this.addEmbeddingParameters(Arrays.asList(searchEmbeddings));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
        @NonNull
        public Builder addEmbeddingParameters(@NonNull Collection<EmbeddingVector> searchEmbeddings) {
            Objects.requireNonNull(searchEmbeddings);
            this.resetIfBuilt();
            this.mEmbeddingParameters.addAll(searchEmbeddings);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearEmbeddingParameters() {
            this.resetIfBuilt();
            this.mEmbeddingParameters.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
        @NonNull
        public Builder setDefaultEmbeddingSearchMetricType(int defaultEmbeddingSearchMetricType) {
            Preconditions.checkArgumentInRange(defaultEmbeddingSearchMetricType, 1, 3, "Embedding search metric type");
            this.resetIfBuilt();
            this.mDefaultEmbeddingSearchMetricType = defaultEmbeddingSearchMetricType;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
        @NonNull
        public Builder addSearchStringParameters(String ... searchStringParameters) {
            Objects.requireNonNull(searchStringParameters);
            this.resetIfBuilt();
            return this.addSearchStringParameters(Arrays.asList(searchStringParameters));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
        @NonNull
        public Builder addSearchStringParameters(@NonNull List<String> searchStringParameters) {
            Objects.requireNonNull(searchStringParameters);
            this.resetIfBuilt();
            this.mSearchStringParameters.addAll(searchStringParameters);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSearchStringParameters() {
            this.resetIfBuilt();
            this.mSearchStringParameters.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setNumericSearchEnabled(boolean enabled) {
            this.modifyEnabledFeature("NUMERIC_SEARCH", enabled);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setVerbatimSearchEnabled(boolean enabled) {
            this.modifyEnabledFeature("VERBATIM_SEARCH", enabled);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setListFilterQueryLanguageEnabled(boolean enabled) {
            this.modifyEnabledFeature("LIST_FILTER_QUERY_LANGUAGE", enabled);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_list_filter_has_property_function")
        @NonNull
        public Builder setListFilterHasPropertyFunctionEnabled(boolean enabled) {
            this.modifyEnabledFeature("LIST_FILTER_HAS_PROPERTY_FUNCTION", enabled);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_list_filter_match_score_expression_function")
        @NonNull
        public Builder setListFilterMatchScoreExpressionFunctionEnabled(boolean enabled) {
            this.modifyEnabledFeature("LIST_FILTER_MATCH_SCORE_EXPRESSION_FUNCTION", enabled);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
        @NonNull
        public Builder setScorablePropertyRankingEnabled(boolean enabled) {
            this.modifyEnabledFeature("SCHEMA_SCORABLE_PROPERTY_CONFIG", enabled);
            return this;
        }

        @NonNull
        public SearchSpec build() {
            if (this.mJoinSpec != null) {
                if (this.mRankingStrategy != 8 && this.mJoinSpec.getAggregationScoringStrategy() != 0) {
                    throw new IllegalStateException("Aggregate scoring strategy has been set in the nested JoinSpec, but ranking strategy is not RANKING_STRATEGY_JOIN_AGGREGATE_SCORE");
                }
            } else if (this.mRankingStrategy == 8) {
                throw new IllegalStateException("Attempting to rank based on joined documents, but no JoinSpec provided");
            }
            if (!this.mTypePropertyWeights.isEmpty() && this.mRankingStrategy != 3 && this.mRankingStrategy != 9) {
                throw new IllegalArgumentException("Property weights are only compatible with the RANKING_STRATEGY_RELEVANCE_SCORE and RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION ranking strategies.");
            }
            this.mBuilt = true;
            return new SearchSpec(this.mTermMatchType, this.mSchemas, this.mNamespaces, this.mTypePropertyFilters, this.mPackageNames, this.mResultCountPerPage, this.mRankingStrategy, this.mOrder, this.mSnippetCount, this.mSnippetCountPerProperty, this.mMaxSnippetSize, this.mProjectionTypePropertyMasks, this.mGroupingTypeFlags, this.mGroupingLimit, this.mTypePropertyWeights, this.mJoinSpec, this.mAdvancedRankingExpression, new ArrayList<String>(this.mEnabledFeatures), this.mSearchSourceLogTag, this.mEmbeddingParameters, this.mDefaultEmbeddingSearchMetricType, this.mInformationalRankingExpressions, this.mSearchStringParameters, this.mFilterDocumentIds, this.mRetrieveEmbeddingMatchInfos);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSchemas = new ArrayList<String>(this.mSchemas);
                this.mTypePropertyFilters = BundleUtil.deepCopy(this.mTypePropertyFilters);
                this.mNamespaces = new ArrayList<String>(this.mNamespaces);
                this.mPackageNames = new ArrayList<String>(this.mPackageNames);
                this.mProjectionTypePropertyMasks = BundleUtil.deepCopy(this.mProjectionTypePropertyMasks);
                this.mTypePropertyWeights = BundleUtil.deepCopy(this.mTypePropertyWeights);
                this.mEmbeddingParameters = new ArrayList<EmbeddingVector>(this.mEmbeddingParameters);
                this.mInformationalRankingExpressions = new ArrayList<String>(this.mInformationalRankingExpressions);
                this.mSearchStringParameters = new ArrayList<String>(this.mSearchStringParameters);
                this.mFilterDocumentIds = new ArrayList<String>(this.mFilterDocumentIds);
                this.mBuilt = false;
            }
        }

        private void modifyEnabledFeature(@NonNull String feature, boolean enabled) {
            this.resetIfBuilt();
            if (enabled) {
                this.mEnabledFeatures.add(feature);
            } else {
                this.mEnabledFeatures.remove(feature);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmbeddingSearchMetricType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Order {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RankingStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TermMatch {
    }
}

