/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.EmbeddingMatchInfoCreator;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.MatchInfoCreator;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.SearchResultCreator;
import android.app.appsearch.TextMatchInfoCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="SearchResultCreator")
public class SearchResult
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<SearchResult> CREATOR = new SearchResultCreator();
    @SafeParcelable.Field(id=1)
    final GenericDocumentParcel mDocument;
    @SafeParcelable.Field(id=2)
    final List<MatchInfo> mMatchInfos;
    @SafeParcelable.Field(id=3, getter="getPackageName")
    private final String mPackageName;
    @SafeParcelable.Field(id=4, getter="getDatabaseName")
    private final String mDatabaseName;
    @SafeParcelable.Field(id=5, getter="getRankingSignal")
    private final double mRankingSignal;
    @SafeParcelable.Field(id=6, getter="getJoinedResults")
    private final List<SearchResult> mJoinedResults;
    @SafeParcelable.Field(id=7, getter="getInformationalRankingSignals")
    @NonNull
    private final List<Double> mInformationalRankingSignals;
    @SafeParcelable.Field(id=8)
    @NonNull
    final Bundle mParentTypeMap;
    @Nullable
    private GenericDocument mDocumentCached;
    @Nullable
    private List<MatchInfo> mMatchInfosCached;

    @SafeParcelable.Constructor
    SearchResult(@SafeParcelable.Param(id=1) @NonNull GenericDocumentParcel document, @SafeParcelable.Param(id=2) @NonNull List<MatchInfo> matchInfos, @SafeParcelable.Param(id=3) @NonNull String packageName, @SafeParcelable.Param(id=4) @NonNull String databaseName, @SafeParcelable.Param(id=5) double rankingSignal, @SafeParcelable.Param(id=6) @NonNull List<SearchResult> joinedResults, @SafeParcelable.Param(id=7) @Nullable List<Double> informationalRankingSignals, @SafeParcelable.Param(id=8) @Nullable Bundle parentTypeMap) {
        this.mDocument = Objects.requireNonNull(document);
        this.mMatchInfos = Objects.requireNonNull(matchInfos);
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mRankingSignal = rankingSignal;
        this.mJoinedResults = Collections.unmodifiableList(Objects.requireNonNull(joinedResults));
        this.mInformationalRankingSignals = informationalRankingSignals != null ? Collections.unmodifiableList(informationalRankingSignals) : Collections.emptyList();
        this.mParentTypeMap = parentTypeMap != null ? parentTypeMap : Bundle.EMPTY;
    }

    @NonNull
    public GenericDocument getGenericDocument() {
        if (this.mDocumentCached == null) {
            this.mDocumentCached = new GenericDocument(this.mDocument);
        }
        return this.mDocumentCached;
    }

    @NonNull
    public List<MatchInfo> getMatchInfos() {
        if (this.mMatchInfosCached == null) {
            this.mMatchInfosCached = new ArrayList<MatchInfo>(this.mMatchInfos.size());
            for (int i = 0; i < this.mMatchInfos.size(); ++i) {
                MatchInfo matchInfo = this.mMatchInfos.get(i);
                matchInfo.setDocument(this.getGenericDocument());
                if (matchInfo.getTextMatch() != null) {
                    matchInfo.mTextMatch.setPropertyPath(matchInfo.getPropertyPath());
                }
                if (this.mMatchInfosCached == null) continue;
                this.mMatchInfosCached.add(matchInfo);
            }
            this.mMatchInfosCached = Collections.unmodifiableList(this.mMatchInfosCached);
        }
        return Objects.requireNonNull(this.mMatchInfosCached);
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    public double getRankingSignal() {
        return this.mRankingSignal;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_informational_ranking_expressions")
    @NonNull
    public List<Double> getInformationalRankingSignals() {
        return this.mInformationalRankingSignals;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_result_parent_types")
    @NonNull
    public Map<String, List<String>> getParentTypeMap() {
        Set<String> schemaTypes = this.mParentTypeMap.keySet();
        ArrayMap<String, List<String>> parentTypeMap = new ArrayMap<String, List<String>>(schemaTypes.size());
        for (String schemaType : schemaTypes) {
            ArrayList<String> parentTypes = this.mParentTypeMap.getStringArrayList(schemaType);
            if (parentTypes == null) continue;
            parentTypeMap.put(schemaType, parentTypes);
        }
        return parentTypeMap;
    }

    @NonNull
    public List<SearchResult> getJoinedResults() {
        return this.mJoinedResults;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SearchResultCreator.writeToParcel(this, dest, flags);
    }

    @SafeParcelable.Class(creator="MatchInfoCreator")
    public static class MatchInfo
    extends AbstractSafeParcelable {
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        @NonNull
        public static final Parcelable.Creator<MatchInfo> CREATOR = new MatchInfoCreator();
        @SafeParcelable.Field(id=1, getter="getPropertyPath")
        private final String mPropertyPath;
        @SafeParcelable.Field(id=2)
        final int mExactMatchRangeStart;
        @SafeParcelable.Field(id=3)
        final int mExactMatchRangeEnd;
        @SafeParcelable.Field(id=4)
        final int mSubmatchRangeStart;
        @SafeParcelable.Field(id=5)
        final int mSubmatchRangeEnd;
        @SafeParcelable.Field(id=6)
        final int mSnippetRangeStart;
        @SafeParcelable.Field(id=7)
        final int mSnippetRangeEnd;
        @SafeParcelable.Field(id=8, getter="getTextMatch")
        @Nullable
        private final TextMatchInfo mTextMatch;
        @SafeParcelable.Field(id=9, getter="getEmbeddingMatch")
        @Nullable
        private final EmbeddingMatchInfo mEmbeddingMatch;
        @Nullable
        private PropertyPath mPropertyPathObject = null;
        @Nullable
        private GenericDocument mDocument = null;

        @SafeParcelable.Constructor
        MatchInfo(@SafeParcelable.Param(id=1) @NonNull String propertyPath, @SafeParcelable.Param(id=2) int exactMatchRangeStart, @SafeParcelable.Param(id=3) int exactMatchRangeEnd, @SafeParcelable.Param(id=4) int submatchRangeStart, @SafeParcelable.Param(id=5) int submatchRangeEnd, @SafeParcelable.Param(id=6) int snippetRangeStart, @SafeParcelable.Param(id=7) int snippetRangeEnd, @SafeParcelable.Param(id=8) @Nullable TextMatchInfo textMatchInfo, @SafeParcelable.Param(id=9) @Nullable EmbeddingMatchInfo embeddingMatchInfo) {
            this.mPropertyPath = Objects.requireNonNull(propertyPath);
            this.mExactMatchRangeStart = exactMatchRangeStart;
            this.mExactMatchRangeEnd = exactMatchRangeEnd;
            this.mSubmatchRangeStart = submatchRangeStart;
            this.mSubmatchRangeEnd = submatchRangeEnd;
            this.mSnippetRangeStart = snippetRangeStart;
            this.mSnippetRangeEnd = snippetRangeEnd;
            this.mEmbeddingMatch = embeddingMatchInfo;
            TextMatchInfo tempTextMatch = textMatchInfo;
            if (tempTextMatch == null && this.mEmbeddingMatch == null) {
                tempTextMatch = new TextMatchInfo(exactMatchRangeStart, exactMatchRangeEnd, submatchRangeStart, submatchRangeEnd, snippetRangeStart, snippetRangeEnd);
                tempTextMatch.setPropertyPath(this.mPropertyPath);
            }
            this.mTextMatch = tempTextMatch;
        }

        @NonNull
        public String getPropertyPath() {
            return this.mPropertyPath;
        }

        @NonNull
        public PropertyPath getPropertyPathObject() {
            if (this.mPropertyPathObject == null) {
                this.mPropertyPathObject = new PropertyPath(this.mPropertyPath);
            }
            return this.mPropertyPathObject;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @Nullable
        public TextMatchInfo getTextMatch() {
            return this.mTextMatch;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @Nullable
        public EmbeddingMatchInfo getEmbeddingMatch() {
            return this.mEmbeddingMatch;
        }

        @NonNull
        public String getFullText() {
            if (this.mTextMatch == null) {
                return "";
            }
            return this.mTextMatch.getFullText();
        }

        @NonNull
        public MatchRange getExactMatchRange() {
            if (this.mTextMatch == null) {
                return new MatchRange(0, 0);
            }
            return this.mTextMatch.getExactMatchRange();
        }

        @NonNull
        public CharSequence getExactMatch() {
            if (this.mTextMatch == null) {
                return "";
            }
            return this.mTextMatch.getExactMatch();
        }

        @NonNull
        public MatchRange getSubmatchRange() {
            if (this.mTextMatch == null) {
                return new MatchRange(0, 0);
            }
            return this.mTextMatch.getSubmatchRange();
        }

        @NonNull
        public CharSequence getSubmatch() {
            if (this.mTextMatch == null) {
                return "";
            }
            return this.mTextMatch.getSubmatch();
        }

        @NonNull
        public MatchRange getSnippetRange() {
            if (this.mTextMatch == null) {
                return new MatchRange(0, 0);
            }
            return this.mTextMatch.getSnippetRange();
        }

        @NonNull
        public CharSequence getSnippet() {
            if (this.mTextMatch == null) {
                return "";
            }
            return this.mTextMatch.getSnippet();
        }

        void setDocument(@NonNull GenericDocument document) {
            this.mDocument = Objects.requireNonNull(document);
            if (this.mTextMatch != null) {
                this.mTextMatch.setDocument(document);
            }
        }

        @Override
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            MatchInfoCreator.writeToParcel(this, dest, flags);
        }

        public static class Builder {
            private final String mPropertyPath;
            private EmbeddingMatchInfo mEmbeddingMatch = null;
            private MatchRange mExactMatchRange = new MatchRange(0, 0);
            private MatchRange mSubmatchRange = new MatchRange(-1, -1);
            private MatchRange mSnippetRange = new MatchRange(0, 0);

            public Builder(@NonNull String propertyPath) {
                this.mPropertyPath = Objects.requireNonNull(propertyPath);
            }

            public Builder(@NonNull MatchInfo matchInfo) {
                Objects.requireNonNull(matchInfo);
                this.mPropertyPath = matchInfo.mPropertyPath;
                this.mEmbeddingMatch = matchInfo.getEmbeddingMatch();
                this.mExactMatchRange = matchInfo.getExactMatchRange();
                this.mSubmatchRange = new MatchRange(matchInfo.mSubmatchRangeStart, matchInfo.mSubmatchRangeEnd);
                this.mSnippetRange = matchInfo.getSnippetRange();
            }

            @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
            @CanIgnoreReturnValue
            @NonNull
            public Builder setEmbeddingMatch(@Nullable EmbeddingMatchInfo embeddingMatch) {
                this.mEmbeddingMatch = embeddingMatch;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setExactMatchRange(@NonNull MatchRange matchRange) {
                this.mExactMatchRange = Objects.requireNonNull(matchRange);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSubmatchRange(@NonNull MatchRange matchRange) {
                this.mSubmatchRange = Objects.requireNonNull(matchRange);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setSnippetRange(@NonNull MatchRange matchRange) {
                this.mSnippetRange = Objects.requireNonNull(matchRange);
                return this;
            }

            @NonNull
            public MatchInfo build() {
                TextMatchInfo textMatch = null;
                if (this.mEmbeddingMatch == null) {
                    textMatch = new TextMatchInfo(this.mExactMatchRange.getStart(), this.mExactMatchRange.getEnd(), this.mSubmatchRange.getStart(), this.mSubmatchRange.getEnd(), this.mSnippetRange.getStart(), this.mSnippetRange.getEnd());
                    textMatch.setPropertyPath(this.mPropertyPath);
                }
                return new MatchInfo(this.mPropertyPath, this.mExactMatchRange.getStart(), this.mExactMatchRange.getEnd(), this.mSubmatchRange.getStart(), this.mSubmatchRange.getEnd(), this.mSnippetRange.getStart(), this.mSnippetRange.getEnd(), textMatch, this.mEmbeddingMatch);
            }
        }
    }

    @SafeParcelable.Class(creator="TextMatchInfoCreator")
    @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
    public static class TextMatchInfo
    extends AbstractSafeParcelable {
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        @NonNull
        public static final Parcelable.Creator<TextMatchInfo> CREATOR = new TextMatchInfoCreator();
        @SafeParcelable.Field(id=1)
        final int mExactMatchRangeStart;
        @SafeParcelable.Field(id=2)
        final int mExactMatchRangeEnd;
        @SafeParcelable.Field(id=3)
        final int mSubmatchRangeStart;
        @SafeParcelable.Field(id=4)
        final int mSubmatchRangeEnd;
        @SafeParcelable.Field(id=5)
        final int mSnippetRangeStart;
        @SafeParcelable.Field(id=6)
        final int mSnippetRangeEnd;
        @Nullable
        private String mPropertyPath = null;
        @Nullable
        private GenericDocument mDocument = null;
        @Nullable
        private String mFullText;
        @Nullable
        private MatchRange mExactMatchRangeCached;
        @Nullable
        private MatchRange mSubmatchRangeCached;
        @Nullable
        private MatchRange mWindowRangeCached;

        @SafeParcelable.Constructor
        public TextMatchInfo(@SafeParcelable.Param(id=1) int exactMatchRangeStart, @SafeParcelable.Param(id=2) int exactMatchRangeEnd, @SafeParcelable.Param(id=3) int submatchRangeStart, @SafeParcelable.Param(id=4) int submatchRangeEnd, @SafeParcelable.Param(id=5) int snippetRangeStart, @SafeParcelable.Param(id=6) int snippetRangeEnd) {
            this.mExactMatchRangeStart = exactMatchRangeStart;
            this.mExactMatchRangeEnd = exactMatchRangeEnd;
            this.mSubmatchRangeStart = submatchRangeStart;
            this.mSubmatchRangeEnd = submatchRangeEnd;
            this.mSnippetRangeStart = snippetRangeStart;
            this.mSnippetRangeEnd = snippetRangeEnd;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public String getFullText() {
            if (this.mFullText == null) {
                if (this.mDocument == null || this.mPropertyPath == null) {
                    throw new IllegalStateException("Document or property path has not been populated; this TextMatchInfo cannot be used yet");
                }
                this.mFullText = TextMatchInfo.getPropertyValues(this.mDocument, this.mPropertyPath);
            }
            return this.mFullText;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public MatchRange getExactMatchRange() {
            if (this.mExactMatchRangeCached == null) {
                this.mExactMatchRangeCached = new MatchRange(this.mExactMatchRangeStart, this.mExactMatchRangeEnd);
            }
            return this.mExactMatchRangeCached;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public CharSequence getExactMatch() {
            return this.getSubstring(this.getExactMatchRange());
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public MatchRange getSubmatchRange() {
            this.checkSubmatchSupported();
            if (this.mSubmatchRangeCached == null) {
                this.mSubmatchRangeCached = new MatchRange(this.mSubmatchRangeStart, this.mSubmatchRangeEnd);
            }
            return this.mSubmatchRangeCached;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public CharSequence getSubmatch() {
            this.checkSubmatchSupported();
            return this.getSubstring(this.getSubmatchRange());
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public MatchRange getSnippetRange() {
            if (this.mWindowRangeCached == null) {
                this.mWindowRangeCached = new MatchRange(this.mSnippetRangeStart, this.mSnippetRangeEnd);
            }
            return this.mWindowRangeCached;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        @NonNull
        public CharSequence getSnippet() {
            return this.getSubstring(this.getSnippetRange());
        }

        private CharSequence getSubstring(MatchRange range) {
            return this.getFullText().substring(range.getStart(), range.getEnd());
        }

        private void checkSubmatchSupported() {
            if (this.mSubmatchRangeStart == -1) {
                throw new UnsupportedOperationException("Submatch is not supported with this backend/Android API level combination");
            }
        }

        private static String getPropertyValues(GenericDocument document, String propertyName) {
            String result = document.getPropertyString(propertyName);
            if (result == null) {
                throw new IllegalStateException("No content found for requested property path: " + propertyName);
            }
            return result;
        }

        void setDocument(@NonNull GenericDocument document) {
            this.mDocument = Objects.requireNonNull(document);
        }

        void setPropertyPath(@NonNull String propertyPath) {
            this.mPropertyPath = Objects.requireNonNull(propertyPath);
        }

        @Override
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            TextMatchInfoCreator.writeToParcel(this, dest, flags);
        }
    }

    public static class MatchRange {
        private final int mEnd;
        private final int mStart;

        public MatchRange(int start, int end) {
            if (start > end) {
                throw new IllegalArgumentException("Start point must be less than or equal to end point");
            }
            this.mStart = start;
            this.mEnd = end;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchRange)) {
                return false;
            }
            MatchRange otherMatchRange = (MatchRange)other;
            return this.getStart() == otherMatchRange.getStart() && this.getEnd() == otherMatchRange.getEnd();
        }

        @NonNull
        public String toString() {
            return "MatchRange { start: " + this.mStart + " , end: " + this.mEnd + "}";
        }

        public int hashCode() {
            return Objects.hash(this.mStart, this.mEnd);
        }
    }

    @SafeParcelable.Class(creator="EmbeddingMatchInfoCreator")
    @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
    public static class EmbeddingMatchInfo
    extends AbstractSafeParcelable {
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        @NonNull
        public static final Parcelable.Creator<EmbeddingMatchInfo> CREATOR = new EmbeddingMatchInfoCreator();
        @SafeParcelable.Field(id=1, getter="getSemanticScore")
        private final double mSemanticScore;
        @SafeParcelable.Field(id=2, getter="getQueryEmbeddingVectorIndex")
        private final int mQueryEmbeddingVectorIndex;
        @SafeParcelable.Field(id=3, getter="getEmbeddingSearchMetricType")
        private final int mEmbeddingSearchMetricType;

        @SafeParcelable.Constructor
        public EmbeddingMatchInfo(@SafeParcelable.Param(id=1) double semanticScore, @SafeParcelable.Param(id=2) int queryEmbeddingVectorIndex, @SafeParcelable.Param(id=3) int embeddingSearchMetricType) {
            Preconditions.checkArgumentInRange(embeddingSearchMetricType, 1, 3, "Embedding search metric type");
            this.mSemanticScore = semanticScore;
            this.mQueryEmbeddingVectorIndex = queryEmbeddingVectorIndex;
            this.mEmbeddingSearchMetricType = embeddingSearchMetricType;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        public double getSemanticScore() {
            return this.mSemanticScore;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        public int getQueryEmbeddingVectorIndex() {
            return this.mQueryEmbeddingVectorIndex;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_embedding_match_info")
        public int getEmbeddingSearchMetricType() {
            return this.mEmbeddingSearchMetricType;
        }

        @Override
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            EmbeddingMatchInfoCreator.writeToParcel(this, dest, flags);
        }
    }

    public static class Builder {
        private final String mPackageName;
        private final String mDatabaseName;
        private List<MatchInfo> mMatchInfos = new ArrayList<MatchInfo>();
        private GenericDocument mGenericDocument;
        private double mRankingSignal;
        private List<Double> mInformationalRankingSignals = new ArrayList<Double>();
        private Bundle mParentTypeMap = new Bundle();
        private List<SearchResult> mJoinedResults = new ArrayList<SearchResult>();
        private boolean mBuilt = false;

        public Builder(@NonNull String packageName, @NonNull String databaseName) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mDatabaseName = Objects.requireNonNull(databaseName);
        }

        public Builder(@NonNull SearchResult searchResult) {
            Objects.requireNonNull(searchResult);
            this.mPackageName = searchResult.getPackageName();
            this.mDatabaseName = searchResult.getDatabaseName();
            this.mGenericDocument = searchResult.getGenericDocument();
            this.mRankingSignal = searchResult.getRankingSignal();
            this.mInformationalRankingSignals = new ArrayList<Double>(searchResult.getInformationalRankingSignals());
            this.setParentTypeMap(searchResult.getParentTypeMap());
            List<MatchInfo> matchInfos = searchResult.getMatchInfos();
            for (int i = 0; i < matchInfos.size(); ++i) {
                this.addMatchInfo(new MatchInfo.Builder(matchInfos.get(i)).build());
            }
            List<SearchResult> joinedResults = searchResult.getJoinedResults();
            for (int i = 0; i < joinedResults.size(); ++i) {
                this.addJoinedResult(joinedResults.get(i));
            }
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setGenericDocument(@NonNull GenericDocument document) {
            Objects.requireNonNull(document);
            this.resetIfBuilt();
            this.mGenericDocument = document;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addMatchInfo(@NonNull MatchInfo matchInfo) {
            Preconditions.checkState(matchInfo.mDocument == null, "This MatchInfo is already associated with a SearchResult and can't be reassigned");
            this.resetIfBuilt();
            this.mMatchInfos.add(matchInfo);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setRankingSignal(double rankingSignal) {
            this.resetIfBuilt();
            this.mRankingSignal = rankingSignal;
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_informational_ranking_expressions")
        @NonNull
        public Builder addInformationalRankingSignal(double rankingSignal) {
            this.resetIfBuilt();
            this.mInformationalRankingSignals.add(rankingSignal);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_result_parent_types")
        @NonNull
        public Builder setParentTypeMap(@NonNull Map<String, List<String>> parentTypeMap) {
            Objects.requireNonNull(parentTypeMap);
            this.resetIfBuilt();
            this.mParentTypeMap.clear();
            for (Map.Entry<String, List<String>> entry : parentTypeMap.entrySet()) {
                Objects.requireNonNull(entry.getKey());
                Objects.requireNonNull(entry.getValue());
                ArrayList<String> parentTypes = new ArrayList<String>(entry.getValue().size());
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    String parentType = entry.getValue().get(i);
                    parentTypes.add(Objects.requireNonNull(parentType));
                }
                this.mParentTypeMap.putStringArrayList(entry.getKey(), parentTypes);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addJoinedResult(@NonNull SearchResult joinedResult) {
            this.resetIfBuilt();
            this.mJoinedResults.add(joinedResult);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder clearMatchInfos() {
            this.resetIfBuilt();
            this.mMatchInfos.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder clearJoinedResults() {
            this.resetIfBuilt();
            this.mJoinedResults.clear();
            return this;
        }

        @NonNull
        public SearchResult build() {
            this.mBuilt = true;
            return new SearchResult(this.mGenericDocument.getDocumentParcel(), this.mMatchInfos, this.mPackageName, this.mDatabaseName, this.mRankingSignal, this.mJoinedResults, this.mInformationalRankingSignals, this.mParentTypeMap);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mMatchInfos = new ArrayList<MatchInfo>(this.mMatchInfos);
                this.mJoinedResults = new ArrayList<SearchResult>(this.mJoinedResults);
                this.mInformationalRankingSignals = new ArrayList<Double>(this.mInformationalRankingSignals);
                this.mParentTypeMap = BundleUtil.deepCopy(this.mParentTypeMap);
                this.mBuilt = false;
            }
        }
    }
}

