/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchemaCreator;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.exceptions.IllegalSchemaException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.PropertyConfigParcel;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.IndentingStringBuilder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="AppSearchSchemaCreator")
public class AppSearchSchema
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<AppSearchSchema> CREATOR = new AppSearchSchemaCreator();
    @SafeParcelable.Field(id=1, getter="getSchemaType")
    private final String mSchemaType;
    @SafeParcelable.Field(id=2)
    final List<PropertyConfigParcel> mPropertyConfigParcels;
    @SafeParcelable.Field(id=3, getter="getParentTypes")
    private final List<String> mParentTypes;
    @SafeParcelable.Field(id=4, getter="getDescription")
    private final String mDescription;

    @SafeParcelable.Constructor
    AppSearchSchema(@SafeParcelable.Param(id=1) @NonNull String schemaType, @SafeParcelable.Param(id=2) @NonNull List<PropertyConfigParcel> propertyConfigParcels, @SafeParcelable.Param(id=3) @NonNull List<String> parentTypes, @SafeParcelable.Param(id=4) @NonNull String description) {
        this.mSchemaType = Objects.requireNonNull(schemaType);
        this.mPropertyConfigParcels = Objects.requireNonNull(propertyConfigParcels);
        this.mParentTypes = Objects.requireNonNull(parentTypes);
        this.mDescription = Objects.requireNonNull(description);
    }

    @NonNull
    public String toString() {
        IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
        this.appendAppSearchSchemaString(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendAppSearchSchemaString(@NonNull IndentingStringBuilder builder) {
        Objects.requireNonNull(builder);
        builder.append("{\n");
        builder.increaseIndentLevel();
        builder.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        builder.append("description: \"").append(this.getDescription()).append("\",\n");
        builder.append("properties: [\n");
        PropertyConfig[] sortedProperties = this.getProperties().toArray(new PropertyConfig[0]);
        Arrays.sort(sortedProperties, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (int i = 0; i < sortedProperties.length; ++i) {
            PropertyConfig propertyConfig = sortedProperties[i];
            builder.increaseIndentLevel();
            propertyConfig.appendPropertyConfigString(builder);
            if (i != sortedProperties.length - 1) {
                builder.append(",\n");
            }
            builder.decreaseIndentLevel();
        }
        builder.append("\n");
        builder.append("]\n");
        builder.decreaseIndentLevel();
        builder.append("}");
    }

    @NonNull
    public String getSchemaType() {
        return this.mSchemaType;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @NonNull
    public List<PropertyConfig> getProperties() {
        if (this.mPropertyConfigParcels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PropertyConfig> ret = new ArrayList<PropertyConfig>(this.mPropertyConfigParcels.size());
        for (int i = 0; i < this.mPropertyConfigParcels.size(); ++i) {
            ret.add(PropertyConfig.fromParcel(this.mPropertyConfigParcels.get(i)));
        }
        return ret;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_get_parent_types_and_indexable_nested_properties")
    @NonNull
    public List<String> getParentTypes() {
        return Collections.unmodifiableList(this.mParentTypes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppSearchSchema)) {
            return false;
        }
        AppSearchSchema otherSchema = (AppSearchSchema)other;
        if (!this.getSchemaType().equals(otherSchema.getSchemaType())) {
            return false;
        }
        if (!this.getDescription().equals(otherSchema.getDescription())) {
            return false;
        }
        if (!this.getParentTypes().equals(otherSchema.getParentTypes())) {
            return false;
        }
        return this.getProperties().equals(otherSchema.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaType(), this.getProperties(), this.getParentTypes(), this.getDescription());
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        AppSearchSchemaCreator.writeToParcel(this, dest, flags);
    }

    public static abstract class PropertyConfig {
        public static final int DATA_TYPE_STRING = 1;
        public static final int DATA_TYPE_LONG = 2;
        public static final int DATA_TYPE_DOUBLE = 3;
        public static final int DATA_TYPE_BOOLEAN = 4;
        public static final int DATA_TYPE_BYTES = 5;
        public static final int DATA_TYPE_DOCUMENT = 6;
        public static final int DATA_TYPE_EMBEDDING = 7;
        public static final int DATA_TYPE_BLOB_HANDLE = 8;
        public static final int CARDINALITY_REPEATED = 1;
        public static final int CARDINALITY_OPTIONAL = 2;
        public static final int CARDINALITY_REQUIRED = 3;
        final PropertyConfigParcel mPropertyConfigParcel;

        PropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            this.mPropertyConfigParcel = Objects.requireNonNull(propertyConfigParcel);
        }

        @NonNull
        public String toString() {
            IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
            this.appendPropertyConfigString(stringBuilder);
            return stringBuilder.toString();
        }

        void appendPropertyConfigString(@NonNull IndentingStringBuilder builder) {
            Objects.requireNonNull(builder);
            builder.append("{\n");
            builder.increaseIndentLevel();
            builder.append("name: \"").append(this.getName()).append("\",\n");
            builder.append("description: \"").append(this.getDescription()).append("\",\n");
            if (this instanceof StringPropertyConfig) {
                ((StringPropertyConfig)this).appendStringPropertyConfigFields(builder);
            } else if (this instanceof DocumentPropertyConfig) {
                ((DocumentPropertyConfig)this).appendDocumentPropertyConfigFields(builder);
            } else if (this instanceof LongPropertyConfig) {
                ((LongPropertyConfig)this).appendLongPropertyConfigFields(builder);
            }
            switch (this.getCardinality()) {
                case 1: {
                    builder.append("cardinality: CARDINALITY_REPEATED,\n");
                    break;
                }
                case 2: {
                    builder.append("cardinality: CARDINALITY_OPTIONAL,\n");
                    break;
                }
                case 3: {
                    builder.append("cardinality: CARDINALITY_REQUIRED,\n");
                    break;
                }
                default: {
                    builder.append("cardinality: CARDINALITY_UNKNOWN,\n");
                }
            }
            switch (this.getDataType()) {
                case 1: {
                    builder.append("dataType: DATA_TYPE_STRING,\n");
                    break;
                }
                case 2: {
                    builder.append("dataType: DATA_TYPE_LONG,\n");
                    break;
                }
                case 3: {
                    builder.append("dataType: DATA_TYPE_DOUBLE,\n");
                    break;
                }
                case 4: {
                    builder.append("dataType: DATA_TYPE_BOOLEAN,\n");
                    break;
                }
                case 5: {
                    builder.append("dataType: DATA_TYPE_BYTES,\n");
                    break;
                }
                case 6: {
                    builder.append("dataType: DATA_TYPE_DOCUMENT,\n");
                    break;
                }
                case 7: {
                    builder.append("dataType: DATA_TYPE_EMBEDDING,\n");
                    break;
                }
                case 8: {
                    builder.append("dataType: DATA_TYPE_BLOB_HANDLE,\n");
                    break;
                }
                default: {
                    builder.append("dataType: DATA_TYPE_UNKNOWN,\n");
                }
            }
            builder.decreaseIndentLevel();
            builder.append("}");
        }

        @NonNull
        public String getName() {
            return this.mPropertyConfigParcel.getName();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
        @NonNull
        public String getDescription() {
            return this.mPropertyConfigParcel.getDescription();
        }

        public int getDataType() {
            return this.mPropertyConfigParcel.getDataType();
        }

        public int getCardinality() {
            return this.mPropertyConfigParcel.getCardinality();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyConfig)) {
                return false;
            }
            PropertyConfig otherProperty = (PropertyConfig)other;
            return Objects.equals(this.mPropertyConfigParcel, otherProperty.mPropertyConfigParcel);
        }

        public int hashCode() {
            return this.mPropertyConfigParcel.hashCode();
        }

        @NonNull
        public static PropertyConfig fromParcel(@NonNull PropertyConfigParcel propertyConfigParcel) {
            Objects.requireNonNull(propertyConfigParcel);
            switch (propertyConfigParcel.getDataType()) {
                case 1: {
                    return new StringPropertyConfig(propertyConfigParcel);
                }
                case 2: {
                    return new LongPropertyConfig(propertyConfigParcel);
                }
                case 3: {
                    return new DoublePropertyConfig(propertyConfigParcel);
                }
                case 4: {
                    return new BooleanPropertyConfig(propertyConfigParcel);
                }
                case 5: {
                    return new BytesPropertyConfig(propertyConfigParcel);
                }
                case 6: {
                    return new DocumentPropertyConfig(propertyConfigParcel);
                }
                case 7: {
                    return new EmbeddingPropertyConfig(propertyConfigParcel);
                }
                case 8: {
                    return new BlobHandlePropertyConfig(propertyConfigParcel);
                }
            }
            throw new IllegalArgumentException("Unsupported property bundle of type " + propertyConfigParcel.getDataType() + "; contents: " + propertyConfigParcel);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Cardinality {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataType {
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public static class BlobHandlePropertyConfig
    extends PropertyConfig {
        BlobHandlePropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @NonNull
            public BlobHandlePropertyConfig build() {
                return new BlobHandlePropertyConfig(PropertyConfigParcel.createForBlobHandle(this.mPropertyName, this.mDescription, this.mCardinality));
            }
        }
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    public static class EmbeddingPropertyConfig
    extends PropertyConfig {
        public static final int INDEXING_TYPE_NONE = 0;
        public static final int INDEXING_TYPE_SIMILARITY = 1;
        public static final int QUANTIZATION_TYPE_NONE = 0;
        public static final int QUANTIZATION_TYPE_8_BIT = 1;

        EmbeddingPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        public int getIndexingType() {
            PropertyConfigParcel.EmbeddingIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getEmbeddingIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return 0;
            }
            return indexingConfigParcel.getIndexingType();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_quantization")
        public int getQuantizationType() {
            PropertyConfigParcel.EmbeddingIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getEmbeddingIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return 0;
            }
            return indexingConfigParcel.getQuantizationType();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;
            private int mIndexingType = 0;
            private int mQuantizationType = 0;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIndexingType(int indexingType) {
                Preconditions.checkArgumentInRange(indexingType, 0, 1, "indexingType");
                this.mIndexingType = indexingType;
                return this;
            }

            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_quantization")
            @CanIgnoreReturnValue
            @NonNull
            public Builder setQuantizationType(int quantizationType) {
                Preconditions.checkArgumentInRange(quantizationType, 0, 1, "quantizationType");
                this.mQuantizationType = quantizationType;
                return this;
            }

            @NonNull
            public EmbeddingPropertyConfig build() {
                return new EmbeddingPropertyConfig(PropertyConfigParcel.createForEmbedding(this.mPropertyName, this.mDescription, this.mCardinality, this.mIndexingType, this.mQuantizationType));
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface QuantizationType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IndexingType {
        }
    }

    public static class DocumentPropertyConfig
    extends PropertyConfig {
        DocumentPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        @NonNull
        public String getSchemaType() {
            return Objects.requireNonNull(this.mPropertyConfigParcel.getSchemaType());
        }

        public boolean shouldIndexNestedProperties() {
            PropertyConfigParcel.DocumentIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getDocumentIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return false;
            }
            return indexingConfigParcel.shouldIndexNestedProperties();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_get_parent_types_and_indexable_nested_properties")
        @NonNull
        public List<String> getIndexableNestedProperties() {
            PropertyConfigParcel.DocumentIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getDocumentIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return Collections.emptyList();
            }
            List<String> indexableNestedPropertiesList = indexingConfigParcel.getIndexableNestedPropertiesList();
            if (indexableNestedPropertiesList == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(indexableNestedPropertiesList);
        }

        void appendDocumentPropertyConfigFields(@NonNull IndentingStringBuilder builder) {
            builder.append("shouldIndexNestedProperties: ").append(this.shouldIndexNestedProperties()).append(",\n");
            builder.append("indexableNestedProperties: ").append(this.getIndexableNestedProperties()).append(",\n");
            builder.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        }

        public static class Builder {
            private final String mPropertyName;
            private final String mSchemaType;
            private String mDescription = "";
            private int mCardinality = 2;
            private boolean mShouldIndexNestedProperties = false;
            private final Set<String> mIndexableNestedPropertiesList = new ArraySet<String>();

            public Builder(@NonNull String propertyName, @NonNull String schemaType) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
                this.mSchemaType = Objects.requireNonNull(schemaType);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setShouldIndexNestedProperties(boolean indexNestedProperties) {
                this.mShouldIndexNestedProperties = indexNestedProperties;
                return this;
            }

            @FlaggedApi(value="com.android.appsearch.flags.enable_get_parent_types_and_indexable_nested_properties")
            @CanIgnoreReturnValue
            @NonNull
            public Builder addIndexableNestedProperties(String ... indexableNestedProperties) {
                Objects.requireNonNull(indexableNestedProperties);
                return this.addIndexableNestedProperties(Arrays.asList(indexableNestedProperties));
            }

            @FlaggedApi(value="com.android.appsearch.flags.enable_get_parent_types_and_indexable_nested_properties")
            @CanIgnoreReturnValue
            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder addIndexableNestedPropertyPaths(PropertyPath ... indexableNestedPropertyPaths) {
                Objects.requireNonNull(indexableNestedPropertyPaths);
                return this.addIndexableNestedPropertyPaths(Arrays.asList(indexableNestedPropertyPaths));
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder addIndexableNestedProperties(@NonNull Collection<String> indexableNestedProperties) {
                Objects.requireNonNull(indexableNestedProperties);
                this.mIndexableNestedPropertiesList.addAll(indexableNestedProperties);
                return this;
            }

            @FlaggedApi(value="com.android.appsearch.flags.enable_get_parent_types_and_indexable_nested_properties")
            @CanIgnoreReturnValue
            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder addIndexableNestedPropertyPaths(@NonNull Collection<PropertyPath> indexableNestedPropertyPaths) {
                Objects.requireNonNull(indexableNestedPropertyPaths);
                ArrayList<PropertyPath> propertyPathList = new ArrayList<PropertyPath>(indexableNestedPropertyPaths);
                for (int i = 0; i < indexableNestedPropertyPaths.size(); ++i) {
                    this.mIndexableNestedPropertiesList.add(((PropertyPath)propertyPathList.get(i)).toString());
                }
                return this;
            }

            @NonNull
            public DocumentPropertyConfig build() {
                if (this.mShouldIndexNestedProperties && !this.mIndexableNestedPropertiesList.isEmpty()) {
                    throw new IllegalArgumentException("DocumentIndexingConfig#shouldIndexNestedProperties is required to be false when one or more indexableNestedProperties are provided.");
                }
                return new DocumentPropertyConfig(PropertyConfigParcel.createForDocument(this.mPropertyName, this.mDescription, this.mCardinality, this.mSchemaType, new PropertyConfigParcel.DocumentIndexingConfigParcel(this.mShouldIndexNestedProperties, new ArrayList<String>(this.mIndexableNestedPropertiesList))));
            }
        }
    }

    public static class BytesPropertyConfig
    extends PropertyConfig {
        BytesPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @NonNull
            public BytesPropertyConfig build() {
                return new BytesPropertyConfig(PropertyConfigParcel.createForBytes(this.mPropertyName, this.mDescription, this.mCardinality));
            }
        }
    }

    public static class BooleanPropertyConfig
    extends PropertyConfig {
        BooleanPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
        public boolean isScoringEnabled() {
            return this.mPropertyConfigParcel.isScoringEnabled();
        }

        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;
            private boolean mScoringEnabled = false;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
            @NonNull
            public Builder setScoringEnabled(boolean scoringEnabled) {
                this.mScoringEnabled = scoringEnabled;
                return this;
            }

            @NonNull
            public BooleanPropertyConfig build() {
                return new BooleanPropertyConfig(PropertyConfigParcel.createForBoolean(this.mPropertyName, this.mDescription, this.mCardinality, this.mScoringEnabled));
            }
        }
    }

    public static class DoublePropertyConfig
    extends PropertyConfig {
        DoublePropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
        public boolean isScoringEnabled() {
            return this.mPropertyConfigParcel.isScoringEnabled();
        }

        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;
            private boolean mScoringEnabled = false;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
            @NonNull
            public Builder setScoringEnabled(boolean scoringEnabled) {
                this.mScoringEnabled = scoringEnabled;
                return this;
            }

            @NonNull
            public DoublePropertyConfig build() {
                return new DoublePropertyConfig(PropertyConfigParcel.createForDouble(this.mPropertyName, this.mDescription, this.mCardinality, this.mScoringEnabled));
            }
        }
    }

    public static class LongPropertyConfig
    extends PropertyConfig {
        public static final int INDEXING_TYPE_NONE = 0;
        public static final int INDEXING_TYPE_RANGE = 1;

        LongPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        public int getIndexingType() {
            PropertyConfigParcel.IntegerIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getIntegerIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return 0;
            }
            return indexingConfigParcel.getIndexingType();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
        public boolean isScoringEnabled() {
            return this.mPropertyConfigParcel.isScoringEnabled();
        }

        void appendLongPropertyConfigFields(@NonNull IndentingStringBuilder builder) {
            switch (this.getIndexingType()) {
                case 0: {
                    builder.append("indexingType: INDEXING_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder.append("indexingType: INDEXING_TYPE_RANGE,\n");
                    break;
                }
                default: {
                    builder.append("indexingType: INDEXING_TYPE_UNKNOWN,\n");
                }
            }
        }

        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;
            private int mIndexingType = 0;
            private boolean mScoringEnabled = false;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIndexingType(int indexingType) {
                Preconditions.checkArgumentInRange(indexingType, 0, 1, "indexingType");
                this.mIndexingType = indexingType;
                return this;
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_scorable_property")
            @NonNull
            public Builder setScoringEnabled(boolean scoringEnabled) {
                this.mScoringEnabled = scoringEnabled;
                return this;
            }

            @NonNull
            public LongPropertyConfig build() {
                return new LongPropertyConfig(PropertyConfigParcel.createForLong(this.mPropertyName, this.mDescription, this.mCardinality, this.mIndexingType, this.mScoringEnabled));
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IndexingType {
        }
    }

    public static class StringPropertyConfig
    extends PropertyConfig {
        public static final int INDEXING_TYPE_NONE = 0;
        public static final int INDEXING_TYPE_EXACT_TERMS = 1;
        public static final int INDEXING_TYPE_PREFIXES = 2;
        public static final int TOKENIZER_TYPE_NONE = 0;
        public static final int TOKENIZER_TYPE_PLAIN = 1;
        public static final int TOKENIZER_TYPE_VERBATIM = 2;
        public static final int TOKENIZER_TYPE_RFC822 = 3;
        public static final int JOINABLE_VALUE_TYPE_NONE = 0;
        public static final int JOINABLE_VALUE_TYPE_QUALIFIED_ID = 1;
        @FlaggedApi(value="com.android.appsearch.flags.enable_delete_propagation_type")
        public static final int DELETE_PROPAGATION_TYPE_NONE = 0;
        @FlaggedApi(value="com.android.appsearch.flags.enable_delete_propagation_type")
        public static final int DELETE_PROPAGATION_TYPE_PROPAGATE_FROM = 1;

        StringPropertyConfig(@NonNull PropertyConfigParcel propertyConfigParcel) {
            super(propertyConfigParcel);
        }

        public int getIndexingType() {
            PropertyConfigParcel.StringIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getStringIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return 0;
            }
            return indexingConfigParcel.getIndexingType();
        }

        public int getTokenizerType() {
            PropertyConfigParcel.StringIndexingConfigParcel indexingConfigParcel = this.mPropertyConfigParcel.getStringIndexingConfigParcel();
            if (indexingConfigParcel == null) {
                return 0;
            }
            return indexingConfigParcel.getTokenizerType();
        }

        public int getJoinableValueType() {
            PropertyConfigParcel.JoinableConfigParcel joinableConfigParcel = this.mPropertyConfigParcel.getJoinableConfigParcel();
            if (joinableConfigParcel == null) {
                return 0;
            }
            return joinableConfigParcel.getJoinableValueType();
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_delete_propagation_type")
        public int getDeletePropagationType() {
            PropertyConfigParcel.JoinableConfigParcel joinableConfigParcel = this.mPropertyConfigParcel.getJoinableConfigParcel();
            if (joinableConfigParcel == null) {
                return 0;
            }
            return joinableConfigParcel.getDeletePropagationType();
        }

        void appendStringPropertyConfigFields(@NonNull IndentingStringBuilder builder) {
            switch (this.getIndexingType()) {
                case 0: {
                    builder.append("indexingType: INDEXING_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder.append("indexingType: INDEXING_TYPE_EXACT_TERMS,\n");
                    break;
                }
                case 2: {
                    builder.append("indexingType: INDEXING_TYPE_PREFIXES,\n");
                    break;
                }
                default: {
                    builder.append("indexingType: INDEXING_TYPE_UNKNOWN,\n");
                }
            }
            switch (this.getTokenizerType()) {
                case 0: {
                    builder.append("tokenizerType: TOKENIZER_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder.append("tokenizerType: TOKENIZER_TYPE_PLAIN,\n");
                    break;
                }
                case 2: {
                    builder.append("tokenizerType: TOKENIZER_TYPE_VERBATIM,\n");
                    break;
                }
                case 3: {
                    builder.append("tokenizerType: TOKENIZER_TYPE_RFC822,\n");
                    break;
                }
                default: {
                    builder.append("tokenizerType: TOKENIZER_TYPE_UNKNOWN,\n");
                }
            }
            switch (this.getJoinableValueType()) {
                case 0: {
                    builder.append("joinableValueType: JOINABLE_VALUE_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder.append("joinableValueType: JOINABLE_VALUE_TYPE_QUALIFIED_ID,\n");
                    break;
                }
                default: {
                    builder.append("joinableValueType: JOINABLE_VALUE_TYPE_UNKNOWN,\n");
                }
            }
            switch (this.getDeletePropagationType()) {
                case 0: {
                    builder.append("deletePropagationType: DELETE_PROPAGATION_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder.append("deletePropagationType: DELETE_PROPAGATION_TYPE_PROPAGATE_FROM,\n");
                    break;
                }
                default: {
                    builder.append("deletePropagationType: DELETE_PROPAGATION_TYPE_UNKNOWN,\n");
                }
            }
        }

        public static class Builder {
            private final String mPropertyName;
            private String mDescription = "";
            private int mCardinality = 2;
            private int mIndexingType = 0;
            private int mTokenizerType = 0;
            private int mJoinableValueType = 0;
            private int mDeletePropagationType = 0;

            public Builder(@NonNull String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.mDescription = Objects.requireNonNull(description);
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setIndexingType(int indexingType) {
                Preconditions.checkArgumentInRange(indexingType, 0, 2, "indexingType");
                this.mIndexingType = indexingType;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setTokenizerType(int tokenizerType) {
                Preconditions.checkArgumentInRange(tokenizerType, 0, 3, "tokenizerType");
                this.mTokenizerType = tokenizerType;
                return this;
            }

            @CanIgnoreReturnValue
            @NonNull
            public Builder setJoinableValueType(int joinableValueType) {
                Preconditions.checkArgumentInRange(joinableValueType, 0, 1, "joinableValueType");
                this.mJoinableValueType = joinableValueType;
                return this;
            }

            @CanIgnoreReturnValue
            @FlaggedApi(value="com.android.appsearch.flags.enable_delete_propagation_type")
            @NonNull
            public Builder setDeletePropagationType(int deletePropagationType) {
                Preconditions.checkArgumentInRange(deletePropagationType, 0, 1, "deletePropagationType");
                this.mDeletePropagationType = deletePropagationType;
                return this;
            }

            @NonNull
            public StringPropertyConfig build() {
                if (this.mTokenizerType == 0) {
                    Preconditions.checkState(this.mIndexingType == 0, "Cannot set TOKENIZER_TYPE_NONE with an indexing type other than INDEXING_TYPE_NONE.");
                } else {
                    Preconditions.checkState(this.mIndexingType != 0, "Cannot set TOKENIZER_TYPE_PLAIN with INDEXING_TYPE_NONE.");
                }
                if (this.mJoinableValueType == 1) {
                    Preconditions.checkState(this.mCardinality != 1, "Cannot set JOINABLE_VALUE_TYPE_QUALIFIED_ID with CARDINALITY_REPEATED.");
                }
                if (this.mDeletePropagationType != 0) {
                    Preconditions.checkState(this.mJoinableValueType == 1, "Cannot set delete propagation without setting JOINABLE_VALUE_TYPE_QUALIFIED_ID.");
                }
                PropertyConfigParcel.StringIndexingConfigParcel stringConfigParcel = new PropertyConfigParcel.StringIndexingConfigParcel(this.mIndexingType, this.mTokenizerType);
                PropertyConfigParcel.JoinableConfigParcel joinableConfigParcel = new PropertyConfigParcel.JoinableConfigParcel(this.mJoinableValueType, this.mDeletePropagationType);
                return new StringPropertyConfig(PropertyConfigParcel.createForString(this.mPropertyName, this.mDescription, this.mCardinality, stringConfigParcel, joinableConfigParcel));
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DeletePropagationType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface JoinableValueType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TokenizerType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IndexingType {
        }
    }

    public static class Builder {
        private String mSchemaType;
        private String mDescription = "";
        private ArrayList<PropertyConfigParcel> mPropertyConfigParcels = new ArrayList();
        private LinkedHashSet<String> mParentTypes = new LinkedHashSet();
        private final Set<String> mPropertyNames = new ArraySet<String>();
        private boolean mBuilt = false;

        public Builder(@NonNull String schemaType) {
            this.mSchemaType = Objects.requireNonNull(schemaType);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull AppSearchSchema schema) {
            this.mSchemaType = schema.getSchemaType();
            this.mDescription = schema.getDescription();
            this.mPropertyConfigParcels.addAll(schema.mPropertyConfigParcels);
            this.mParentTypes.addAll(schema.mParentTypes);
            for (int i = 0; i < this.mPropertyConfigParcels.size(); ++i) {
                this.mPropertyNames.add(this.mPropertyConfigParcels.get(i).getName());
            }
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder setSchemaType(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            this.mSchemaType = schemaType;
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_description")
        @CanIgnoreReturnValue
        @NonNull
        public Builder setDescription(@NonNull String description) {
            Objects.requireNonNull(description);
            this.resetIfBuilt();
            this.mDescription = description;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addProperty(@NonNull PropertyConfig propertyConfig) {
            Objects.requireNonNull(propertyConfig);
            this.resetIfBuilt();
            String name = propertyConfig.getName();
            if (!this.mPropertyNames.add(name)) {
                throw new IllegalSchemaException("Property defined more than once: " + name);
            }
            this.mPropertyConfigParcels.add(propertyConfig.mPropertyConfigParcel);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearProperties() {
            this.resetIfBuilt();
            this.mPropertyConfigParcels.clear();
            this.mPropertyNames.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addParentType(@NonNull String parentSchemaType) {
            Objects.requireNonNull(parentSchemaType);
            this.resetIfBuilt();
            this.mParentTypes.add(parentSchemaType);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearParentTypes() {
            this.resetIfBuilt();
            this.mParentTypes.clear();
            return this;
        }

        @NonNull
        public AppSearchSchema build() {
            this.mBuilt = true;
            return new AppSearchSchema(this.mSchemaType, this.mPropertyConfigParcels, new ArrayList<String>(this.mParentTypes), this.mDescription);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mPropertyConfigParcels = new ArrayList<PropertyConfigParcel>(this.mPropertyConfigParcels);
                this.mParentTypes = new LinkedHashSet<String>(this.mParentTypes);
                this.mBuilt = false;
            }
        }
    }
}

