/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appfunctions.GenericDocumentWrapper;
import android.app.appsearch.GenericDocument;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class ExecuteAppFunctionResponse
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ExecuteAppFunctionResponse> CREATOR = new Parcelable.Creator<ExecuteAppFunctionResponse>(){

        @Override
        public ExecuteAppFunctionResponse createFromParcel(Parcel parcel) {
            GenericDocumentWrapper resultWrapper = Objects.requireNonNull(GenericDocumentWrapper.CREATOR.createFromParcel(parcel));
            Bundle extras = Objects.requireNonNull(parcel.readBundle(Bundle.class.getClassLoader()));
            return new ExecuteAppFunctionResponse(resultWrapper.getValue(), extras);
        }

        public ExecuteAppFunctionResponse[] newArray(int size) {
            return new ExecuteAppFunctionResponse[size];
        }
    };
    public static final String PROPERTY_RETURN_VALUE = "androidAppfunctionsReturnValue";
    @NonNull
    private final GenericDocumentWrapper mResultDocumentWrapper;
    @NonNull
    private final Bundle mExtras;

    public ExecuteAppFunctionResponse(@NonNull GenericDocument resultDocument) {
        this(resultDocument, Bundle.EMPTY);
    }

    public ExecuteAppFunctionResponse(@NonNull GenericDocument resultDocument, @NonNull Bundle extras) {
        this.mResultDocumentWrapper = new GenericDocumentWrapper(Objects.requireNonNull(resultDocument));
        this.mExtras = Objects.requireNonNull(extras);
    }

    @NonNull
    public GenericDocument getResultDocument() {
        return this.mResultDocumentWrapper.getValue();
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public int getResponseDataSize() {
        return this.mResultDocumentWrapper.getDataSize() + this.mExtras.getSize();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mResultDocumentWrapper.writeToParcel(dest, flags);
        dest.writeBundle(this.mExtras);
    }
}

