/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appfunctions.ExecuteAppFunctionRequest;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class ExecuteAppFunctionAidlRequest
implements Parcelable {
    public static final Parcelable.Creator<ExecuteAppFunctionAidlRequest> CREATOR = new Parcelable.Creator<ExecuteAppFunctionAidlRequest>(){

        @Override
        public ExecuteAppFunctionAidlRequest createFromParcel(Parcel in) {
            ExecuteAppFunctionRequest clientRequest = ExecuteAppFunctionRequest.CREATOR.createFromParcel(in);
            UserHandle userHandle = UserHandle.CREATOR.createFromParcel(in);
            String callingPackage = in.readString8();
            long requestTime = in.readLong();
            return new ExecuteAppFunctionAidlRequest(clientRequest, userHandle, callingPackage, requestTime);
        }

        public ExecuteAppFunctionAidlRequest[] newArray(int size) {
            return new ExecuteAppFunctionAidlRequest[size];
        }
    };
    private final ExecuteAppFunctionRequest mClientRequest;
    private final UserHandle mUserHandle;
    private final String mCallingPackage;
    private final long mRequestTime;

    public ExecuteAppFunctionAidlRequest(ExecuteAppFunctionRequest clientRequest, UserHandle userHandle, String callingPackage, long requestTime) {
        this.mClientRequest = Objects.requireNonNull(clientRequest);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mCallingPackage = Objects.requireNonNull(callingPackage);
        this.mRequestTime = requestTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mClientRequest.writeToParcel(dest, flags);
        this.mUserHandle.writeToParcel(dest, flags);
        dest.writeString8(this.mCallingPackage);
        dest.writeLong(this.mRequestTime);
    }

    @NonNull
    public ExecuteAppFunctionRequest getClientRequest() {
        return this.mClientRequest;
    }

    @NonNull
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @NonNull
    public String getCallingPackage() {
        return this.mCallingPackage;
    }

    public long getRequestTime() {
        return this.mRequestTime;
    }
}

