/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.appfunctions.AppFunctionException;
import android.app.appfunctions.AppFunctionManagerHelper;
import android.app.appfunctions.ExecuteAppFunctionAidlRequest;
import android.app.appfunctions.ExecuteAppFunctionRequest;
import android.app.appfunctions.ExecuteAppFunctionResponse;
import android.app.appfunctions.IAppFunctionEnabledCallback;
import android.app.appfunctions.IAppFunctionManager;
import android.app.appfunctions.IExecuteAppFunctionCallback;
import android.app.appsearch.AppSearchManager;
import android.content.Context;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.OutcomeReceiver;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.SystemClock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class AppFunctionManager {
    public static final int APP_FUNCTION_STATE_DEFAULT = 0;
    public static final int APP_FUNCTION_STATE_ENABLED = 1;
    public static final int APP_FUNCTION_STATE_DISABLED = 2;
    private final IAppFunctionManager mService;
    private final Context mContext;

    public AppFunctionManager(IAppFunctionManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(value="android.permission.EXECUTE_APP_FUNCTIONS", conditional=true)
    public void executeAppFunction(@NonNull ExecuteAppFunctionRequest request, final @NonNull Executor executor, @NonNull CancellationSignal cancellationSignal, final @NonNull OutcomeReceiver<ExecuteAppFunctionResponse, AppFunctionException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        ExecuteAppFunctionAidlRequest aidlRequest = new ExecuteAppFunctionAidlRequest(request, this.mContext.getUser(), this.mContext.getPackageName(), SystemClock.elapsedRealtime());
        try {
            ICancellationSignal cancellationTransport = this.mService.executeAppFunction(aidlRequest, new IExecuteAppFunctionCallback.Stub(this){

                @Override
                public void onSuccess(ExecuteAppFunctionResponse result) {
                    try {
                        executor.execute(() -> callback.onResult(result));
                    }
                    catch (RuntimeException e) {
                        executor.execute(() -> callback.onError(new AppFunctionException(2000, e.getMessage())));
                    }
                }

                @Override
                public void onError(AppFunctionException exception) {
                    executor.execute(() -> callback.onError(exception));
                }
            });
            if (cancellationTransport != null) {
                cancellationSignal.setRemote(cancellationTransport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.EXECUTE_APP_FUNCTIONS", conditional=true)
    public void isAppFunctionEnabled(@NonNull String functionIdentifier, @NonNull String targetPackage, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        this.isAppFunctionEnabledInternal(functionIdentifier, targetPackage, executor, callback);
    }

    public void isAppFunctionEnabled(@NonNull String functionIdentifier, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        this.isAppFunctionEnabledInternal(functionIdentifier, this.mContext.getPackageName(), executor, callback);
    }

    public void setAppFunctionEnabled(@NonNull String functionIdentifier, int newEnabledState, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(functionIdentifier);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        CallbackWrapper callbackWrapper = new CallbackWrapper(executor, callback);
        try {
            this.mService.setAppFunctionEnabled(this.mContext.getPackageName(), functionIdentifier, this.mContext.getUser(), newEnabledState, callbackWrapper);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void isAppFunctionEnabledInternal(@NonNull String functionIdentifier, @NonNull String targetPackage, @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(functionIdentifier);
        Objects.requireNonNull(targetPackage);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        AppSearchManager appSearchManager = this.mContext.getSystemService(AppSearchManager.class);
        if (appSearchManager == null) {
            callback.onError(new IllegalStateException("Failed to get AppSearchManager."));
            return;
        }
        OutcomeReceiver<Boolean, Exception> callbackWithExceptionInterceptor = new OutcomeReceiver<Boolean, Exception>(this){

            @Override
            public void onResult(@NonNull Boolean result) {
                callback.onResult(result);
            }

            @Override
            public void onError(@NonNull Exception exception) {
                if (exception instanceof AppFunctionManagerHelper.AppFunctionNotFoundException) {
                    exception = new IllegalArgumentException(exception);
                }
                callback.onError(exception);
            }
        };
        AppFunctionManagerHelper.isAppFunctionEnabled(functionIdentifier, targetPackage, appSearchManager, executor, callbackWithExceptionInterceptor);
    }

    private static class CallbackWrapper
    extends IAppFunctionEnabledCallback.Stub {
        private final OutcomeReceiver<Void, Exception> mCallback;
        private final Executor mExecutor;

        CallbackWrapper(@NonNull Executor callbackExecutor, @NonNull OutcomeReceiver<Void, Exception> callback) {
            this.mCallback = callback;
            this.mExecutor = callbackExecutor;
        }

        @Override
        public void onSuccess() {
            this.mExecutor.execute(() -> this.mCallback.onResult(null));
        }

        @Override
        public void onError(@NonNull ParcelableException exception) {
            this.mExecutor.execute(() -> {
                if (IllegalArgumentException.class.isAssignableFrom(exception.getCause().getClass())) {
                    this.mCallback.onError((IllegalArgumentException)exception.getCause());
                } else if (SecurityException.class.isAssignableFrom(exception.getCause().getClass())) {
                    this.mCallback.onError((SecurityException)exception.getCause());
                } else {
                    this.mCallback.onError(exception);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnabledState {
    }
}

