/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.WireTypeMismatchException;
import android.view.Surface;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class WindowConfiguration
implements Parcelable,
Comparable<WindowConfiguration> {
    private final Rect mBounds = new Rect();
    @Nullable
    private Rect mAppBounds;
    private final Rect mMaxBounds = new Rect();
    private int mDisplayRotation = -1;
    private int mRotation = -1;
    public static final int ROTATION_UNDEFINED = -1;
    private int mWindowingMode;
    public static final int WINDOWING_MODE_UNDEFINED = 0;
    public static final int WINDOWING_MODE_FULLSCREEN = 1;
    public static final int WINDOWING_MODE_PINNED = 2;
    public static final int WINDOWING_MODE_FREEFORM = 5;
    public static final int WINDOWING_MODE_MULTI_WINDOW = 6;
    private int mActivityType;
    public static final int ACTIVITY_TYPE_UNDEFINED = 0;
    public static final int ACTIVITY_TYPE_STANDARD = 1;
    public static final int ACTIVITY_TYPE_HOME = 2;
    public static final int ACTIVITY_TYPE_RECENTS = 3;
    public static final int ACTIVITY_TYPE_ASSISTANT = 4;
    public static final int ACTIVITY_TYPE_DREAM = 5;
    @AlwaysOnTop
    private int mAlwaysOnTop;
    private static final int ALWAYS_ON_TOP_UNDEFINED = 0;
    private static final int ALWAYS_ON_TOP_ON = 1;
    private static final int ALWAYS_ON_TOP_OFF = 2;
    public static final int WINDOW_CONFIG_BOUNDS = 1;
    public static final int WINDOW_CONFIG_APP_BOUNDS = 2;
    public static final int WINDOW_CONFIG_MAX_BOUNDS = 4;
    public static final int WINDOW_CONFIG_WINDOWING_MODE = 8;
    public static final int WINDOW_CONFIG_ACTIVITY_TYPE = 16;
    public static final int WINDOW_CONFIG_ALWAYS_ON_TOP = 32;
    public static final int WINDOW_CONFIG_ROTATION = 64;
    public static final int WINDOW_CONFIG_DISPLAY_ROTATION = 128;
    @NonNull
    public static final Parcelable.Creator<WindowConfiguration> CREATOR = new Parcelable.Creator<WindowConfiguration>(){

        @Override
        public WindowConfiguration createFromParcel(Parcel in) {
            return new WindowConfiguration(in);
        }

        public WindowConfiguration[] newArray(int size) {
            return new WindowConfiguration[size];
        }
    };

    @UnsupportedAppUsage
    public WindowConfiguration() {
        this.unset();
    }

    public WindowConfiguration(WindowConfiguration configuration) {
        this.setTo(configuration);
    }

    private WindowConfiguration(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mBounds.writeToParcel(dest, flags);
        dest.writeTypedObject(this.mAppBounds, flags);
        this.mMaxBounds.writeToParcel(dest, flags);
        dest.writeInt(this.mWindowingMode);
        dest.writeInt(this.mActivityType);
        dest.writeInt(this.mAlwaysOnTop);
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mDisplayRotation);
    }

    public void readFromParcel(@NonNull Parcel source) {
        this.mBounds.readFromParcel(source);
        this.mAppBounds = source.readTypedObject(Rect.CREATOR);
        this.mMaxBounds.readFromParcel(source);
        this.mWindowingMode = source.readInt();
        this.mActivityType = source.readInt();
        this.mAlwaysOnTop = source.readInt();
        this.mRotation = source.readInt();
        this.mDisplayRotation = source.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setBounds(@Nullable Rect rect) {
        if (rect == null) {
            this.mBounds.setEmpty();
            return;
        }
        this.mBounds.set(rect);
    }

    public void setAppBounds(@Nullable Rect rect) {
        if (rect == null) {
            this.mAppBounds = null;
            return;
        }
        this.setAppBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setMaxBounds(@Nullable Rect rect) {
        if (rect == null) {
            this.mMaxBounds.setEmpty();
            return;
        }
        this.mMaxBounds.set(rect);
    }

    public void setMaxBounds(int left, int top, int right, int bottom) {
        this.mMaxBounds.set(left, top, right, bottom);
    }

    public void setDisplayRotation(int rotation) {
        this.mDisplayRotation = rotation;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.mAlwaysOnTop = alwaysOnTop ? 1 : 2;
    }

    public void unsetAlwaysOnTop() {
        this.mAlwaysOnTop = 0;
    }

    private void setAlwaysOnTop(@AlwaysOnTop int alwaysOnTop) {
        this.mAlwaysOnTop = alwaysOnTop;
    }

    public void setAppBounds(int left, int top, int right, int bottom) {
        if (this.mAppBounds == null) {
            this.mAppBounds = new Rect();
        }
        this.mAppBounds.set(left, top, right, bottom);
    }

    @Nullable
    public Rect getAppBounds() {
        return this.mAppBounds;
    }

    @NonNull
    public Rect getBounds() {
        return this.mBounds;
    }

    @NonNull
    public Rect getMaxBounds() {
        return this.mMaxBounds;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getDisplayRotation() {
        return this.mDisplayRotation;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public void setRotation(int rotation) {
        this.mRotation = rotation;
    }

    public void setWindowingMode(int windowingMode) {
        this.mWindowingMode = windowingMode;
    }

    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    public void setActivityType(int activityType) {
        if (this.mActivityType == activityType) {
            return;
        }
        if (ActivityThread.isSystem() && this.mActivityType != 0 && activityType != 0) {
            throw new IllegalStateException("Can't change activity type once set: " + this + " activityType=" + WindowConfiguration.activityTypeToString(activityType));
        }
        this.mActivityType = activityType;
    }

    public int getActivityType() {
        return this.mActivityType;
    }

    public void setTo(WindowConfiguration other) {
        this.setBounds(other.mBounds);
        this.setAppBounds(other.mAppBounds);
        this.setMaxBounds(other.mMaxBounds);
        this.setDisplayRotation(other.mDisplayRotation);
        this.setWindowingMode(other.mWindowingMode);
        this.setActivityType(other.mActivityType);
        this.setAlwaysOnTop(other.mAlwaysOnTop);
        this.setRotation(other.mRotation);
    }

    public void unset() {
        this.setToDefaults();
    }

    public void setToDefaults() {
        this.setAppBounds(null);
        this.setBounds(null);
        this.setMaxBounds(null);
        this.setDisplayRotation(-1);
        this.setWindowingMode(0);
        this.setActivityType(0);
        this.setAlwaysOnTop(0);
        this.setRotation(-1);
    }

    public void scale(float scale) {
        WindowConfiguration.scaleBounds(scale, this.mBounds);
        WindowConfiguration.scaleBounds(scale, this.mMaxBounds);
        if (this.mAppBounds != null) {
            WindowConfiguration.scaleBounds(scale, this.mAppBounds);
        }
    }

    private static void scaleBounds(float scale, Rect bounds) {
        int w = bounds.width();
        int h = bounds.height();
        bounds.left = (int)((float)bounds.left * scale + 0.5f);
        bounds.top = (int)((float)bounds.top * scale + 0.5f);
        bounds.right = bounds.left + (int)((float)w * scale + 0.5f);
        bounds.bottom = bounds.top + (int)((float)h * scale + 0.5f);
    }

    @WindowConfig
    public int updateFrom(@NonNull WindowConfiguration delta) {
        int changed = 0;
        if (!delta.mBounds.isEmpty() && !delta.mBounds.equals(this.mBounds)) {
            changed |= 1;
            this.setBounds(delta.mBounds);
        }
        if (delta.mAppBounds != null && !delta.mAppBounds.equals(this.mAppBounds)) {
            changed |= 2;
            this.setAppBounds(delta.mAppBounds);
        }
        if (!delta.mMaxBounds.isEmpty() && !delta.mMaxBounds.equals(this.mMaxBounds)) {
            changed |= 4;
            this.setMaxBounds(delta.mMaxBounds);
        }
        if (delta.mWindowingMode != 0 && this.mWindowingMode != delta.mWindowingMode) {
            changed |= 8;
            this.setWindowingMode(delta.mWindowingMode);
        }
        if (delta.mActivityType != 0 && this.mActivityType != delta.mActivityType) {
            changed |= 0x10;
            this.setActivityType(delta.mActivityType);
        }
        if (delta.mAlwaysOnTop != 0 && this.mAlwaysOnTop != delta.mAlwaysOnTop) {
            changed |= 0x20;
            this.setAlwaysOnTop(delta.mAlwaysOnTop);
        }
        if (delta.mRotation != -1 && delta.mRotation != this.mRotation) {
            changed |= 0x40;
            this.setRotation(delta.mRotation);
        }
        if (delta.mDisplayRotation != -1 && delta.mDisplayRotation != this.mDisplayRotation) {
            changed |= 0x80;
            this.setDisplayRotation(delta.mDisplayRotation);
        }
        return changed;
    }

    public void setTo(@NonNull WindowConfiguration delta, @WindowConfig int mask) {
        if ((mask & 1) != 0) {
            this.setBounds(delta.mBounds);
        }
        if ((mask & 2) != 0) {
            this.setAppBounds(delta.mAppBounds);
        }
        if ((mask & 4) != 0) {
            this.setMaxBounds(delta.mMaxBounds);
        }
        if ((mask & 8) != 0) {
            this.setWindowingMode(delta.mWindowingMode);
        }
        if ((mask & 0x10) != 0) {
            this.setActivityType(delta.mActivityType);
        }
        if ((mask & 0x20) != 0) {
            this.setAlwaysOnTop(delta.mAlwaysOnTop);
        }
        if ((mask & 0x40) != 0) {
            this.setRotation(delta.mRotation);
        }
        if ((mask & 0x80) != 0) {
            this.setDisplayRotation(delta.mDisplayRotation);
        }
    }

    @WindowConfig
    public long diff(WindowConfiguration other, boolean compareUndefined) {
        long changes = 0L;
        if (!this.mBounds.equals(other.mBounds)) {
            changes |= 1L;
        }
        if (!(!compareUndefined && other.mAppBounds == null || this.mAppBounds == other.mAppBounds || this.mAppBounds != null && this.mAppBounds.equals(other.mAppBounds))) {
            changes |= 2L;
        }
        if (!this.mMaxBounds.equals(other.mMaxBounds)) {
            changes |= 4L;
        }
        if ((compareUndefined || other.mWindowingMode != 0) && this.mWindowingMode != other.mWindowingMode) {
            changes |= 8L;
        }
        if ((compareUndefined || other.mActivityType != 0) && this.mActivityType != other.mActivityType) {
            changes |= 0x10L;
        }
        if ((compareUndefined || other.mAlwaysOnTop != 0) && this.mAlwaysOnTop != other.mAlwaysOnTop) {
            changes |= 0x20L;
        }
        if ((compareUndefined || other.mRotation != -1) && this.mRotation != other.mRotation) {
            changes |= 0x40L;
        }
        if ((compareUndefined || other.mDisplayRotation != -1) && this.mDisplayRotation != other.mDisplayRotation) {
            changes |= 0x80L;
        }
        return changes;
    }

    @Override
    public int compareTo(WindowConfiguration that) {
        int n = 0;
        if (this.mAppBounds == null && that.mAppBounds != null) {
            return 1;
        }
        if (this.mAppBounds != null && that.mAppBounds == null) {
            return -1;
        }
        if (this.mAppBounds != null && that.mAppBounds != null) {
            n = this.mAppBounds.left - that.mAppBounds.left;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.top - that.mAppBounds.top;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.right - that.mAppBounds.right;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.bottom - that.mAppBounds.bottom;
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.mMaxBounds.left - that.mMaxBounds.left) != 0) {
            return n;
        }
        n = this.mMaxBounds.top - that.mMaxBounds.top;
        if (n != 0) {
            return n;
        }
        n = this.mMaxBounds.right - that.mMaxBounds.right;
        if (n != 0) {
            return n;
        }
        n = this.mMaxBounds.bottom - that.mMaxBounds.bottom;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.left - that.mBounds.left;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.top - that.mBounds.top;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.right - that.mBounds.right;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.bottom - that.mBounds.bottom;
        if (n != 0) {
            return n;
        }
        n = this.mWindowingMode - that.mWindowingMode;
        if (n != 0) {
            return n;
        }
        n = this.mActivityType - that.mActivityType;
        if (n != 0) {
            return n;
        }
        n = this.mAlwaysOnTop - that.mAlwaysOnTop;
        if (n != 0) {
            return n;
        }
        n = this.mRotation - that.mRotation;
        if (n != 0) {
            return n;
        }
        n = this.mDisplayRotation - that.mDisplayRotation;
        if (n != 0) {
            return n;
        }
        return n;
    }

    public boolean equals(@Nullable Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (!(that instanceof WindowConfiguration)) {
            return false;
        }
        return this.compareTo((WindowConfiguration)that) == 0;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode(this.mAppBounds);
        result = 31 * result + Objects.hashCode(this.mBounds);
        result = 31 * result + Objects.hashCode(this.mMaxBounds);
        result = 31 * result + this.mWindowingMode;
        result = 31 * result + this.mActivityType;
        result = 31 * result + this.mAlwaysOnTop;
        result = 31 * result + this.mRotation;
        result = 31 * result + this.mDisplayRotation;
        return result;
    }

    public String toString() {
        return "{ mBounds=" + this.mBounds + " mAppBounds=" + this.mAppBounds + " mMaxBounds=" + this.mMaxBounds + " mDisplayRotation=" + (this.mRotation == -1 ? "undefined" : Surface.rotationToString(this.mDisplayRotation)) + " mWindowingMode=" + WindowConfiguration.windowingModeToString(this.mWindowingMode) + " mActivityType=" + WindowConfiguration.activityTypeToString(this.mActivityType) + " mAlwaysOnTop=" + WindowConfiguration.alwaysOnTopToString(this.mAlwaysOnTop) + " mRotation=" + (this.mRotation == -1 ? "undefined" : Surface.rotationToString(this.mRotation)) + "}";
    }

    public void dumpDebug(ProtoOutputStream protoOutputStream, long fieldId) {
        long token = protoOutputStream.start(fieldId);
        if (this.mAppBounds != null) {
            this.mAppBounds.dumpDebug(protoOutputStream, 0x10B00000001L);
        }
        protoOutputStream.write(1120986464258L, this.mWindowingMode);
        protoOutputStream.write(1120986464259L, this.mActivityType);
        this.mBounds.dumpDebug(protoOutputStream, 1146756268036L);
        this.mMaxBounds.dumpDebug(protoOutputStream, 1146756268037L);
        protoOutputStream.end(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromProto(ProtoInputStream proto, long fieldId) throws IOException, WireTypeMismatchException {
        long token = proto.start(fieldId);
        try {
            while (proto.nextField() != -1) {
                switch (proto.getFieldNumber()) {
                    case 1: {
                        this.mAppBounds = new Rect();
                        this.mAppBounds.readFromProto(proto, 0x10B00000001L);
                        break;
                    }
                    case 4: {
                        this.mBounds.readFromProto(proto, 1146756268036L);
                        break;
                    }
                    case 5: {
                        this.mMaxBounds.readFromProto(proto, 1146756268037L);
                        break;
                    }
                    case 2: {
                        this.mWindowingMode = proto.readInt(1120986464258L);
                        break;
                    }
                    case 3: {
                        this.mActivityType = proto.readInt(1120986464259L);
                    }
                }
            }
        }
        finally {
            proto.end(token);
        }
    }

    public boolean hasWindowShadow() {
        return this.mWindowingMode != 6 && this.tasksAreFloating();
    }

    public boolean canResizeTask() {
        return this.mWindowingMode == 5 || this.mWindowingMode == 6;
    }

    public boolean tasksAreFloating() {
        return WindowConfiguration.isFloating(this.mWindowingMode);
    }

    public static boolean isFloating(int windowingMode) {
        return windowingMode == 5 || windowingMode == 2;
    }

    public static boolean inMultiWindowMode(int windowingMode) {
        return windowingMode != 1 && windowingMode != 0;
    }

    public boolean canReceiveKeys() {
        return this.mWindowingMode != 2;
    }

    public boolean isAlwaysOnTop() {
        if (this.mWindowingMode == 2) {
            return true;
        }
        if (this.mActivityType == 5) {
            return true;
        }
        if (this.mAlwaysOnTop != 1) {
            return false;
        }
        return this.mWindowingMode == 5 || this.mWindowingMode == 6;
    }

    public boolean useWindowFrameForBackdrop() {
        return this.mWindowingMode == 5 || this.mWindowingMode == 2;
    }

    public boolean hasMovementAnimations() {
        return this.mWindowingMode != 2;
    }

    public boolean supportSplitScreenWindowingMode() {
        return WindowConfiguration.supportSplitScreenWindowingMode(this.mActivityType);
    }

    public static boolean supportSplitScreenWindowingMode(int activityType) {
        return activityType != 4 && activityType != 5;
    }

    public static boolean areConfigurationsEqualForDisplay(@NonNull Configuration newConfig, @NonNull Configuration oldConfig) {
        if (!newConfig.windowConfiguration.getMaxBounds().equals(oldConfig.windowConfiguration.getMaxBounds())) {
            return false;
        }
        return newConfig.windowConfiguration.getDisplayRotation() == oldConfig.windowConfiguration.getDisplayRotation();
    }

    public static String windowingModeToString(int windowingMode) {
        switch (windowingMode) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "fullscreen";
            }
            case 6: {
                return "multi-window";
            }
            case 2: {
                return "pinned";
            }
            case 5: {
                return "freeform";
            }
        }
        return String.valueOf(windowingMode);
    }

    public static String activityTypeToString(int applicationType) {
        switch (applicationType) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "home";
            }
            case 3: {
                return "recents";
            }
            case 4: {
                return "assistant";
            }
            case 5: {
                return "dream";
            }
        }
        return String.valueOf(applicationType);
    }

    public static String alwaysOnTopToString(@AlwaysOnTop int alwaysOnTop) {
        switch (alwaysOnTop) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "off";
            }
        }
        return String.valueOf(alwaysOnTop);
    }

    public static @interface WindowConfig {
    }

    private static @interface AlwaysOnTop {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActivityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WindowingMode {
    }
}

