/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Flags;
import android.app.ILocalWallpaperColorConsumer;
import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.app.compat.CompatChanges;
import android.app.wallpaper.WallpaperDescription;
import android.app.wallpaper.WallpaperInstance;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadSystemException;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.MathUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.Keep;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public class WallpaperManager {
    private static String TAG = "WallpaperManager";
    private static final boolean DEBUG = false;
    static final long RETURN_DEFAULT_ON_SECURITY_EXCEPTION = 239784307L;
    static final long THROW_ON_SECURITY_EXCEPTION = 237508058L;
    private float mWallpaperXStep = -1.0f;
    private float mWallpaperYStep = -1.0f;
    @NonNull
    private static final RectF LOCAL_COLOR_BOUNDS = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private static final String PROP_WALLPAPER = "ro.config.wallpaper";
    private static final String PROP_LOCK_WALLPAPER = "ro.config.lock_wallpaper";
    private static final String PROP_WALLPAPER_COMPONENT = "ro.config.wallpaper_component";
    private static final String VALUE_CMF_COLOR = SystemProperties.get("ro.boot.hardware.color");
    private static final String WALLPAPER_CMF_PATH = "/wallpaper/image/";
    public static final String ACTION_CROP_AND_SET_WALLPAPER = "android.service.wallpaper.CROP_AND_SET_WALLPAPER";
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String ACTION_CHANGE_LIVE_WALLPAPER = "android.service.wallpaper.CHANGE_LIVE_WALLPAPER";
    public static final String EXTRA_LIVE_WALLPAPER_COMPONENT = "android.service.wallpaper.extra.LIVE_WALLPAPER_COMPONENT";
    public static final String WALLPAPER_PREVIEW_META_DATA = "android.wallpaper.preview";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    public static final String COMMAND_SECONDARY_TAP = "android.wallpaper.secondaryTap";
    public static final String COMMAND_DROP = "android.home.drop";
    public static final String COMMAND_WAKING_UP = "android.wallpaper.wakingup";
    public static final String COMMAND_KEYGUARD_GOING_AWAY = "android.wallpaper.keyguardgoingaway";
    public static final String COMMAND_KEYGUARD_APPEARING = "android.wallpaper.keyguardappearing";
    public static final String COMMAND_GOING_TO_SLEEP = "android.wallpaper.goingtosleep";
    public static final String COMMAND_REAPPLY = "android.wallpaper.reapply";
    public static final String COMMAND_FREEZE = "android.wallpaper.freeze";
    public static final String COMMAND_UNFREEZE = "android.wallpaper.unfreeze";
    public static final String COMMAND_LOCKSCREEN_LAYOUT_CHANGED = "android.wallpaper.lockscreen_layout_changed";
    public static final String COMMAND_LOCKSCREEN_TAP = "android.wallpaper.lockscreen_tap";
    public static final String EXTRA_NEW_WALLPAPER_ID = "android.service.wallpaper.extra.ID";
    public static final String EXTRA_FROM_FOREGROUND_APP = "android.service.wallpaper.extra.FROM_FOREGROUND_APP";
    public static final String EXTRA_WHICH_WALLPAPER_CHANGED = "android.service.wallpaper.extra.WHICH_WALLPAPER_CHANGED";
    public static final int ORIENTATION_UNKNOWN = -1;
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_SQUARE_PORTRAIT = 2;
    public static final int ORIENTATION_SQUARE_LANDSCAPE = 3;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_LOCK = 2;
    private static final Object sSync = new Object[0];
    @UnsupportedAppUsage
    private static Globals sGlobals;
    private final Context mContext;
    private final boolean mWcgEnabled;
    private final ColorManagementProxy mCmProxy;
    private static Boolean sIsMultiCropEnabled;

    public static int getOrientation(@NonNull Point screenSize) {
        float ratio = (float)screenSize.x / (float)screenSize.y;
        return ratio >= 1.3333334f ? 1 : (ratio > 1.0f ? 3 : (ratio > 0.75f ? 2 : 0));
    }

    public static int getRotatedOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initGlobals(IWallpaperManager service, Looper looper) {
        Object object = sSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(service, looper);
            }
        }
    }

    WallpaperManager(IWallpaperManager service, Context context, Handler handler) {
        this.mContext = context;
        if (service != null) {
            WallpaperManager.initGlobals(service, context.getMainLooper());
        }
        this.mWcgEnabled = context.getResources().getConfiguration().isScreenWideColorGamut() && context.getResources().getBoolean(0x1110199);
        this.mCmProxy = new ColorManagementProxy(context);
    }

    WallpaperManager() {
        this.mContext = null;
        this.mCmProxy = null;
        this.mWcgEnabled = false;
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    @UnsupportedAppUsage
    public IWallpaperManager getIWallpaperManager() {
        return WallpaperManager.sGlobals.mService;
    }

    public boolean isLockscreenLiveWallpaperEnabled() {
        return true;
    }

    public static boolean isMultiCropEnabled() {
        if (sIsMultiCropEnabled == null) {
            sIsMultiCropEnabled = com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.multiCrop();
        }
        return sIsMultiCropEnabled;
    }

    public boolean shouldEnableWideColorGamut() {
        return this.mWcgEnabled;
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable getDrawable() {
        return this.getDrawable(1);
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable getDrawable(int which) {
        ColorManagementProxy cmProxy;
        boolean returnDefault = which != 2;
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, returnDefault, which, cmProxy = this.getColorManagementProxy());
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getBuiltInDrawable() {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, 1);
    }

    public Drawable getBuiltInDrawable(int which) {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, which);
    }

    public Drawable getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment) {
        return this.getBuiltInDrawable(outWidth, outHeight, scaleToFit, horizontalAlignment, verticalAlignment, 1);
    }

    public Drawable getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment, int which) {
        RectF cropRectF;
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        Resources resources = this.mContext.getResources();
        horizontalAlignment = Math.max(0.0f, Math.min(1.0f, horizontalAlignment));
        verticalAlignment = Math.max(0.0f, Math.min(1.0f, verticalAlignment));
        InputStream wpStream = WallpaperManager.openDefaultWallpaper(this.mContext, which);
        if (wpStream == null) {
            return null;
        }
        BufferedInputStream is = new BufferedInputStream(wpStream);
        if (outWidth <= 0 || outHeight <= 0) {
            Bitmap fullSize = BitmapFactory.decodeStream(is, null, null);
            return new BitmapDrawable(resources, fullSize);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(is, null, options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.e(TAG, "default wallpaper dimensions are 0");
            return null;
        }
        int inWidth = options.outWidth;
        int inHeight = options.outHeight;
        is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
        outWidth = Math.min(inWidth, outWidth);
        outHeight = Math.min(inHeight, outHeight);
        if (scaleToFit) {
            cropRectF = WallpaperManager.getMaxCropRect(inWidth, inHeight, outWidth, outHeight, horizontalAlignment, verticalAlignment);
        } else {
            float left = (float)(inWidth - outWidth) * horizontalAlignment;
            float right = left + (float)outWidth;
            float top = (float)(inHeight - outHeight) * verticalAlignment;
            float bottom = top + (float)outHeight;
            cropRectF = new RectF(left, top, right, bottom);
        }
        Rect roundedTrueCrop = new Rect();
        cropRectF.roundOut(roundedTrueCrop);
        if (roundedTrueCrop.width() <= 0 || roundedTrueCrop.height() <= 0) {
            Log.w(TAG, "crop has bad values for full size image");
            return null;
        }
        int scaleDownSampleSize = Math.min(roundedTrueCrop.width() / outWidth, roundedTrueCrop.height() / outHeight);
        BitmapRegionDecoder decoder = null;
        try {
            decoder = BitmapRegionDecoder.newInstance(is, true);
        }
        catch (IOException e) {
            Log.w(TAG, "cannot open region decoder for default wallpaper");
        }
        Bitmap crop = null;
        if (decoder != null) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options2.inSampleSize = scaleDownSampleSize;
            }
            crop = decoder.decodeRegion(roundedTrueCrop, options2);
            decoder.recycle();
        }
        if (crop == null) {
            is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
            Bitmap fullSize = null;
            BitmapFactory.Options options3 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options3.inSampleSize = scaleDownSampleSize;
            }
            if ((fullSize = BitmapFactory.decodeStream(is, null, options3)) != null) {
                crop = Bitmap.createBitmap(fullSize, roundedTrueCrop.left, roundedTrueCrop.top, roundedTrueCrop.width(), roundedTrueCrop.height());
            }
        }
        if (crop == null) {
            Log.w(TAG, "cannot decode default wallpaper");
            return null;
        }
        if (outWidth > 0 && outHeight > 0 && (crop.getWidth() != outWidth || crop.getHeight() != outHeight)) {
            Matrix m = new Matrix();
            RectF cropRect = new RectF(0.0f, 0.0f, crop.getWidth(), crop.getHeight());
            RectF returnRect = new RectF(0.0f, 0.0f, outWidth, outHeight);
            m.setRectToRect(cropRect, returnRect, Matrix.ScaleToFit.FILL);
            Bitmap tmp = Bitmap.createBitmap((int)returnRect.width(), (int)returnRect.height(), Bitmap.Config.ARGB_8888);
            if (tmp != null) {
                Canvas c = new Canvas(tmp);
                Paint p = new Paint();
                p.setFilterBitmap(true);
                c.drawBitmap(crop, m, p);
                crop = tmp;
            }
        }
        return new BitmapDrawable(resources, crop);
    }

    private static RectF getMaxCropRect(int inWidth, int inHeight, int outWidth, int outHeight, float horizontalAlignment, float verticalAlignment) {
        RectF cropRect = new RectF();
        if ((float)inWidth / (float)inHeight > (float)outWidth / (float)outHeight) {
            cropRect.top = 0.0f;
            cropRect.bottom = inHeight;
            float cropWidth = (float)outWidth * ((float)inHeight / (float)outHeight);
            cropRect.left = ((float)inWidth - cropWidth) * horizontalAlignment;
            cropRect.right = cropRect.left + cropWidth;
        } else {
            cropRect.left = 0.0f;
            cropRect.right = inWidth;
            float cropHeight = (float)outHeight * ((float)inWidth / (float)outWidth);
            cropRect.top = ((float)inHeight - cropHeight) * verticalAlignment;
            cropRect.bottom = cropRect.top + cropHeight;
        }
        return cropRect;
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable peekDrawable() {
        return this.peekDrawable(1);
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable peekDrawable(int which) {
        return this.getDrawable(which);
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable getFastDrawable() {
        return this.getFastDrawable(1);
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable getFastDrawable(int which) {
        ColorManagementProxy cmProxy;
        boolean returnDefault = which != 2;
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, returnDefault, which, cmProxy = this.getColorManagementProxy());
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable peekFastDrawable() {
        return this.peekFastDrawable(1);
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public Drawable peekFastDrawable(int which) {
        return this.getFastDrawable(which);
    }

    public boolean wallpaperSupportsWcg(int which) {
        if (!this.shouldEnableWideColorGamut()) {
            return false;
        }
        ColorManagementProxy cmProxy = this.getColorManagementProxy();
        Bitmap bitmap = sGlobals.peekWallpaperBitmap(this.mContext, false, which, cmProxy);
        return bitmap != null && bitmap.getColorSpace() != null && bitmap.getColorSpace() != ColorSpace.get(ColorSpace.Named.SRGB) && cmProxy.isSupportedColorSpace(bitmap.getColorSpace());
    }

    @Nullable
    @UnsupportedAppUsage
    public Bitmap getBitmap() {
        return this.getBitmap(false);
    }

    @UnsupportedAppUsage
    public Bitmap getBitmap(boolean hardware) {
        return this.getBitmapAsUser(this.mContext.getUserId(), hardware);
    }

    @Nullable
    public Bitmap getBitmap(boolean hardware, int which) {
        return this.getBitmapAsUser(this.mContext.getUserId(), hardware, which);
    }

    public Bitmap getBitmapAsUser(int userId, boolean hardware) {
        ColorManagementProxy cmProxy = this.getColorManagementProxy();
        return sGlobals.peekWallpaperBitmap(this.mContext, true, 1, userId, hardware, cmProxy);
    }

    @Nullable
    public Bitmap getBitmapAsUser(int userId, boolean hardware, int which) {
        boolean returnDefault = which != 2;
        return this.getBitmapAsUser(userId, hardware, which, returnDefault);
    }

    @Nullable
    public Bitmap getBitmapAsUser(int userId, boolean hardware, int which, boolean returnDefault) {
        ColorManagementProxy cmProxy = this.getColorManagementProxy();
        return sGlobals.peekWallpaperBitmap(this.mContext, returnDefault, which, userId, hardware, cmProxy);
    }

    @Nullable
    public Rect peekBitmapDimensions() {
        return this.peekBitmapDimensions(1);
    }

    @Nullable
    public Rect peekBitmapDimensions(int which) {
        boolean returnDefault = which != 2;
        return this.peekBitmapDimensions(which, returnDefault);
    }

    @Nullable
    public Rect peekBitmapDimensions(int which, boolean returnDefault) {
        if (com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.multiCrop()) {
            return this.peekBitmapDimensionsAsUser(which, returnDefault, this.mContext.getUserId());
        }
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        return sGlobals.peekWallpaperDimensions(this.mContext, returnDefault, which, this.mContext.getUserId());
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @Nullable
    public Rect peekBitmapDimensionsAsUser(int which, boolean returnDefault, int userId) {
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        return sGlobals.peekWallpaperDimensions(this.mContext, returnDefault, which, userId);
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @RequiresPermission(value="android.permission.READ_WALLPAPER_INTERNAL")
    @NonNull
    public List<Rect> getBitmapCrops(@NonNull List<Point> displaySizes, int which, boolean originalBitmap) {
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        try {
            List result = WallpaperManager.sGlobals.mService.getBitmapCrops(displaySizes, which, originalBitmap, this.mContext.getUserId());
            if (result != null) {
                return result;
            }
            Rect bitmapDimensions = this.peekBitmapDimensions(which, true);
            if (bitmapDimensions == null) {
                return List.of();
            }
            Point bitmapSize = new Point(bitmapDimensions.width(), bitmapDimensions.height());
            return this.getBitmapCrops(bitmapSize, displaySizes, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @NonNull
    public List<Rect> getBitmapCrops(@NonNull Point bitmapSize, @NonNull List<Point> displaySizes, @Nullable Map<Point, Rect> cropHints) {
        try {
            if (cropHints == null) {
                cropHints = Map.of();
            }
            Set<Map.Entry<Point, Rect>> entries = cropHints.entrySet();
            int[] screenOrientations = entries.stream().mapToInt(entry -> WallpaperManager.getOrientation((Point)entry.getKey())).toArray();
            List<Rect> crops = entries.stream().map(Map.Entry::getValue).toList();
            return WallpaperManager.sGlobals.mService.getFutureBitmapCrops(bitmapSize, displaySizes, screenOrientations, crops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @RequiresPermission(value="android.permission.SET_WALLPAPER_DIM_AMOUNT")
    @Nullable
    public WallpaperColors getWallpaperColors(@NonNull Bitmap bitmap, @Nullable Map<Point, Rect> cropHints) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            if (cropHints == null) {
                cropHints = Map.of();
            }
            Set<Map.Entry<Point, Rect>> entries = cropHints.entrySet();
            int[] screenOrientations = entries.stream().mapToInt(entry -> WallpaperManager.getOrientation((Point)entry.getKey())).toArray();
            List<Rect> crops = entries.stream().map(Map.Entry::getValue).toList();
            Point bitmapSize = new Point(bitmap.getWidth(), bitmap.getHeight());
            Rect crop = WallpaperManager.sGlobals.mService.getBitmapCrop(bitmapSize, screenOrientations, crops);
            float dimAmount = this.getWallpaperDimAmount();
            Bitmap croppedBitmap = Bitmap.createBitmap(bitmap, crop.left, crop.top, crop.width(), crop.height());
            WallpaperColors result = WallpaperColors.fromBitmap(croppedBitmap, dimAmount);
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.READ_WALLPAPER_INTERNAL"})
    public ParcelFileDescriptor getWallpaperFile(int which) {
        return this.getWallpaperFile(which, this.mContext.getUserId());
    }

    public void addOnColorsChangedListener(@NonNull OnColorsChangedListener listener, @NonNull Handler handler) {
        this.addOnColorsChangedListener(listener, handler, this.mContext.getUserId());
    }

    @UnsupportedAppUsage
    public void addOnColorsChangedListener(@NonNull OnColorsChangedListener listener, @NonNull Handler handler, int userId) {
        sGlobals.addOnColorsChangedListener(listener, handler, userId, this.mContext.getDisplayId());
    }

    public void removeOnColorsChangedListener(@NonNull OnColorsChangedListener callback) {
        this.removeOnColorsChangedListener(callback, this.mContext.getUserId());
    }

    public void removeOnColorsChangedListener(@NonNull OnColorsChangedListener callback, int userId) {
        sGlobals.removeOnColorsChangedListener(callback, userId, this.mContext.getDisplayId());
    }

    @Nullable
    public WallpaperColors getWallpaperColors(int which) {
        return this.getWallpaperColors(which, this.mContext.getUserId());
    }

    @UnsupportedAppUsage
    @Nullable
    public WallpaperColors getWallpaperColors(int which, int userId) {
        StrictMode.assertUiContext(this.mContext, "getWallpaperColors");
        return sGlobals.getWallpaperColors(which, userId, this.mContext.getDisplayId());
    }

    public void addOnColorsChangedListener(@NonNull LocalWallpaperColorConsumer callback, List<RectF> regions, int which) throws IllegalArgumentException {
        for (RectF region : regions) {
            if (LOCAL_COLOR_BOUNDS.contains(region)) continue;
            throw new IllegalArgumentException("Regions must be within bounds " + LOCAL_COLOR_BOUNDS);
        }
        sGlobals.addOnColorsChangedListener(callback, regions, which, this.mContext.getUserId(), this.mContext.getDisplayId());
    }

    public void removeOnColorsChangedListener(@NonNull LocalWallpaperColorConsumer callback) {
        sGlobals.removeOnColorsChangedListener(callback, 1, this.mContext.getUserId(), this.mContext.getDisplayId());
    }

    @UnsupportedAppUsage
    public ParcelFileDescriptor getWallpaperFile(int which, int userId) {
        return this.getWallpaperFile(which, userId, true);
    }

    @Nullable
    public ParcelFileDescriptor getWallpaperFile(int which, boolean getCropped) {
        return this.getWallpaperFile(which, this.mContext.getUserId(), getCropped);
    }

    private ParcelFileDescriptor getWallpaperFile(int which, int userId, boolean getCropped) {
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Bundle outParams = new Bundle();
            return WallpaperManager.sGlobals.mService.getWallpaperWithFeature(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), null, which, outParams, userId, getCropped);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SecurityException e) {
            if (CompatChanges.isChangeEnabled(239784307L) && !CompatChanges.isChangeEnabled(237508058L)) {
                Log.w(TAG, "No permission to access wallpaper, returning default wallpaper file to avoid crashing legacy app.");
                return WallpaperManager.getDefaultSystemWallpaperFile();
            }
            if (this.mContext.getApplicationInfo().targetSdkVersion < 27) {
                Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                return null;
            }
            throw e;
        }
    }

    public void forgetLoadedWallpaper() {
        sGlobals.forgetLoadedWallpaper();
    }

    @RequiresPermission(value="QUERY_ALL_PACKAGES", conditional=true)
    public WallpaperInfo getWallpaperInfo() {
        return this.getWallpaperInfoForUser(this.mContext.getUserId());
    }

    public WallpaperInfo getWallpaperInfoForUser(int userId) {
        return this.getWallpaperInfo(1, userId);
    }

    @Nullable
    public WallpaperInfo getWallpaperInfo(int which) {
        return this.getWallpaperInfo(which, this.mContext.getUserId());
    }

    public WallpaperInfo getWallpaperInfo(int which, int userId) {
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        try {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return WallpaperManager.sGlobals.mService.getWallpaperInfoWithFlags(which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @RequiresPermission(value="android.permission.READ_WALLPAPER_INTERNAL")
    public WallpaperInstance getWallpaperInstance(int which) {
        WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
        try {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return WallpaperManager.sGlobals.mService.getWallpaperInstance(which, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public ParcelFileDescriptor getWallpaperInfoFile() {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.getWallpaperInfoFile(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getWallpaperId(int which) {
        return this.getWallpaperIdForUser(which, this.mContext.getUserId());
    }

    public int getWallpaperIdForUser(int which, int userId) {
        try {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return WallpaperManager.sGlobals.mService.getWallpaperIdForUser(which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Intent getCropAndSetWallpaperIntent(Uri imageUri) {
        if (imageUri == null) {
            throw new IllegalArgumentException("Image URI must not be null");
        }
        if (!"content".equals(imageUri.getScheme())) {
            throw new IllegalArgumentException("Image URI must be of the content scheme type");
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent cropAndSetWallpaperIntent = new Intent(ACTION_CROP_AND_SET_WALLPAPER, imageUri);
        cropAndSetWallpaperIntent.addFlags(1);
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo resolvedHome = packageManager.resolveActivity(homeIntent, 65536);
        if (resolvedHome != null) {
            cropAndSetWallpaperIntent.setPackage(resolvedHome.activityInfo.packageName);
            List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
            if (cropAppList.size() > 0) {
                return cropAndSetWallpaperIntent;
            }
        }
        String cropperPackage = this.mContext.getString(17040107);
        cropAndSetWallpaperIntent.setPackage(cropperPackage);
        List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
        if (cropAppList.size() > 0) {
            return cropAndSetWallpaperIntent;
        }
        throw new IllegalArgumentException("Cannot use passed URI to set wallpaper; check that the type returned by ContentProvider matches image/*");
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void setResource(int resid) throws IOException {
        this.setResource(resid, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setResource(int resid, int which) throws IOException {
        Bundle result;
        block5: {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                Resources resources = this.mContext.getResources();
                ParcelFileDescriptor fd = WallpaperManager.sGlobals.mService.setWallpaper("res:" + resources.getResourceName(resid), this.mContext.getOpPackageName(), null, null, false, result, which, completion, this.mContext.getUserId());
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(resources.openRawResource(resid), fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void setBitmap(Bitmap bitmap) throws IOException {
        this.setBitmap(bitmap, null, true);
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, 3);
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, which, this.mContext.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which, int userId) throws IOException {
        Bundle result;
        block7: {
            if (com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.multiCrop()) {
                SparseArray<Rect> cropMap = new SparseArray<Rect>();
                if (visibleCropHint != null) {
                    cropMap.put(-1, visibleCropHint);
                }
                return this.setBitmapWithCrops(fullImage, cropMap, allowBackup, which, userId);
            }
            this.validateRect(visibleCropHint);
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            List<Rect> crops = visibleCropHint == null ? null : List.of(visibleCropHint);
            try {
                ParcelFileDescriptor fd = WallpaperManager.sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), null, crops, allowBackup, result, which, completion, userId);
                if (fd == null) break block7;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    fullImage.compress(Bitmap.CompressFormat.PNG, 90, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setBitmapWithCrops(@Nullable Bitmap fullImage, @NonNull Map<Point, Rect> cropHints, boolean allowBackup, int which) throws IOException {
        SparseArray<Rect> crops = new SparseArray<Rect>();
        cropHints.forEach((k, v) -> crops.put(WallpaperManager.getOrientation(k), (Rect)v));
        return this.setBitmapWithCrops(fullImage, crops, allowBackup, which, this.mContext.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    private int setBitmapWithCrops(@Nullable Bitmap fullImage, @NonNull SparseArray<Rect> cropHints, boolean allowBackup, int which, int userId) throws IOException {
        Bundle result;
        block6: {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            int size = cropHints.size();
            int[] screenOrientations = new int[size];
            ArrayList<Rect> crops = new ArrayList<Rect>(size);
            for (int i = 0; i < size; ++i) {
                screenOrientations[i] = cropHints.keyAt(i);
                Rect cropHint = cropHints.valueAt(i);
                this.validateRect(cropHint);
                crops.add(cropHint);
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                ParcelFileDescriptor fd = WallpaperManager.sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), screenOrientations, crops, allowBackup, result, which, completion, userId);
                if (fd == null) break block6;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    fullImage.compress(Bitmap.CompressFormat.PNG, 90, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setBitmapWithDescription(@Nullable Bitmap fullImage, @NonNull WallpaperDescription description, boolean allowBackup, int which) throws IOException {
        return this.setBitmapWithCrops(fullImage, description.getCropHints(), allowBackup, which, this.mContext.getUserId());
    }

    private void validateRect(Rect rect) {
        if (rect != null && rect.isEmpty()) {
            throw new IllegalArgumentException("visibleCrop rectangle must be valid and non-empty");
        }
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void setStream(InputStream bitmapData) throws IOException {
        this.setStream(bitmapData, null, true);
    }

    private void copyStreamToWallpaperFile(InputStream data, FileOutputStream fos) throws IOException {
        FileUtils.copy(data, fos);
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setStream(bitmapData, visibleCropHint, allowBackup, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        Bundle result;
        block7: {
            if (com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.multiCrop()) {
                SparseArray<Rect> cropMap = new SparseArray<Rect>();
                if (visibleCropHint != null) {
                    cropMap.put(-1, visibleCropHint);
                }
                return this.setStreamWithCrops(bitmapData, cropMap, allowBackup, which);
            }
            this.validateRect(visibleCropHint);
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            List<Rect> crops = visibleCropHint == null ? null : List.of(visibleCropHint);
            try {
                ParcelFileDescriptor fd = WallpaperManager.sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), null, crops, allowBackup, result, which, completion, this.mContext.getUserId());
                if (fd == null) break block7;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(bitmapData, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setStreamWithCrops(@NonNull InputStream bitmapData, @NonNull Map<Point, Rect> cropHints, boolean allowBackup, int which) throws IOException {
        SparseArray<Rect> crops = new SparseArray<Rect>();
        cropHints.forEach((k, v) -> crops.put(WallpaperManager.getOrientation(k), (Rect)v));
        return this.setStreamWithCrops(bitmapData, crops, allowBackup, which);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.window.flags.multi_crop")
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setStreamWithCrops(@NonNull InputStream bitmapData, @NonNull SparseArray<Rect> cropHints, boolean allowBackup, int which) throws IOException {
        Bundle result;
        block6: {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            int size = cropHints.size();
            int[] screenOrientations = new int[size];
            ArrayList<Rect> crops = new ArrayList<Rect>(size);
            for (int i = 0; i < size; ++i) {
                screenOrientations[i] = cropHints.keyAt(i);
                Rect cropHint = cropHints.valueAt(i);
                this.validateRect(cropHint);
                crops.add(cropHint);
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                ParcelFileDescriptor fd = WallpaperManager.sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), screenOrientations, crops, allowBackup, result, which, completion, this.mContext.getUserId());
                if (fd == null) break block6;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(bitmapData, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt(EXTRA_NEW_WALLPAPER_ID, 0);
    }

    @SystemApi
    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public int setStreamWithDescription(@NonNull InputStream bitmapData, @NonNull WallpaperDescription description, boolean allowBackup, int which) throws IOException {
        return this.setStreamWithCrops(bitmapData, description.getCropHints(), allowBackup, which);
    }

    public boolean hasResourceWallpaper(int resid) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Resources resources = this.mContext.getResources();
            String name = "res:" + resources.getResourceName(resid);
            return WallpaperManager.sGlobals.mService.hasNamedWallpaper(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDesiredMinimumWidth() {
        StrictMode.assertUiContext(this.mContext, "getDesiredMinimumWidth");
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.getWidthHint(this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDesiredMinimumHeight() {
        StrictMode.assertUiContext(this.mContext, "getDesiredMinimumHeight");
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.getHeightHint(this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void suggestDesiredDimensions(int minimumWidth, int minimumHeight) {
        StrictMode.assertUiContext(this.mContext, "suggestDesiredDimensions");
        try {
            int maximumTextureSize;
            try {
                maximumTextureSize = SystemProperties.getInt("sys.max_texture_size", 0);
            }
            catch (Exception e) {
                maximumTextureSize = 0;
            }
            if (maximumTextureSize > 0 && (minimumWidth > maximumTextureSize || minimumHeight > maximumTextureSize)) {
                float aspect = (float)minimumHeight / (float)minimumWidth;
                if (minimumWidth > minimumHeight) {
                    minimumWidth = maximumTextureSize;
                    minimumHeight = (int)((double)((float)minimumWidth * aspect) + 0.5);
                } else {
                    minimumHeight = maximumTextureSize;
                    minimumWidth = (int)((double)((float)minimumHeight / aspect) + 0.5);
                }
            }
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            WallpaperManager.sGlobals.mService.setDimensionHints(minimumWidth, minimumHeight, this.mContext.getOpPackageName(), this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER_HINTS")
    public void setDisplayPadding(Rect padding) {
        StrictMode.assertUiContext(this.mContext, "setDisplayPadding");
        try {
            if (WallpaperManager.sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            WallpaperManager.sGlobals.mService.setDisplayPadding(padding, this.mContext.getOpPackageName(), this.mContext.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setDisplayOffset(IBinder windowToken, int x, int y) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperDisplayOffset(windowToken, x, y);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void clearWallpaper() {
        this.clearWallpaper(3, this.mContext.getUserId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public void clearWallpaper(int which, int userId) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            WallpaperManager.sGlobals.mService.clearWallpaper(this.mContext.getOpPackageName(), which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_WALLPAPER_COMPONENT")
    public boolean setWallpaperComponent(ComponentName name) {
        return this.setWallpaperComponent(name, this.mContext.getUserId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_WALLPAPER_DIM_AMOUNT")
    public void setWallpaperDimAmount(float dimAmount) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            WallpaperManager.sGlobals.mService.setWallpaperDimAmount(MathUtils.saturate(dimAmount));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_WALLPAPER_DIM_AMOUNT")
    public float getWallpaperDimAmount() {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.getWallpaperDimAmount();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean lockScreenWallpaperExists() {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.lockScreenWallpaperExists();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER_COMPONENT")
    @UnsupportedAppUsage
    public boolean setWallpaperComponent(ComponentName name, int userId) {
        return this.setWallpaperComponentWithFlags(name, 3, userId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_WALLPAPER_COMPONENT")
    public boolean setWallpaperComponentWithFlags(@NonNull ComponentName name, int which) {
        return this.setWallpaperComponentWithFlags(name, which, this.mContext.getUserId());
    }

    @RequiresPermission(allOf={"android.permission.SET_WALLPAPER_COMPONENT", "android.permission.INTERACT_ACROSS_USERS_FULL"}, conditional=true)
    public boolean setWallpaperComponentWithFlags(@NonNull ComponentName name, int which, int userId) {
        WallpaperDescription description = new WallpaperDescription.Builder().setComponent(name).build();
        return this.setWallpaperComponentWithDescription(description, which, userId);
    }

    @SystemApi
    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @RequiresPermission(allOf={"android.permission.SET_WALLPAPER_COMPONENT", "android.permission.INTERACT_ACROSS_USERS_FULL"}, conditional=true)
    public boolean setWallpaperComponentWithDescription(@NonNull WallpaperDescription description, int which) {
        return this.setWallpaperComponentWithDescription(description, which, this.mContext.getUserId());
    }

    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @RequiresPermission(allOf={"android.permission.SET_WALLPAPER_COMPONENT", "android.permission.INTERACT_ACROSS_USERS_FULL"}, conditional=true)
    public boolean setWallpaperComponentWithDescription(@NonNull WallpaperDescription description, int which, int userId) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperManagerService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            WallpaperManager.sGlobals.mService.setWallpaperComponentChecked(description, this.mContext.getOpPackageName(), which, userId);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setWallpaperOffsets(IBinder windowToken, float xOffset, float yOffset) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, xOffset, yOffset, this.mWallpaperXStep, this.mWallpaperYStep);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setWallpaperOffsetSteps(float xStep, float yStep) {
        this.mWallpaperXStep = xStep;
        this.mWallpaperYStep = yStep;
    }

    @RequiresPermission(value="android.permission.ALWAYS_UPDATE_WALLPAPER", conditional=true)
    public void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        try {
            WindowManagerGlobal.getWindowSession().sendWallpaperCommand(windowToken, action, x, y, z, extras, false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Keep
    public void setWallpaperZoomOut(@NonNull IBinder windowToken, float zoom) {
        if (zoom < 0.0f || zoom > 1.0f) {
            throw new IllegalArgumentException("zoom must be between 0 and 1: " + zoom);
        }
        if (windowToken == null) {
            throw new IllegalArgumentException("windowToken must not be null");
        }
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperZoomOut(windowToken, zoom);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWallpaperSupported() {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.isWallpaperSupported(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSetWallpaperAllowed() {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.isSetWallpaperAllowed(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearWallpaperOffsets(IBinder windowToken) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, -1.0f, -1.0f, -1.0f, -1.0f);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void clear() throws IOException {
        this.clear(3);
    }

    @RequiresPermission(value="android.permission.SET_WALLPAPER")
    public void clear(int which) throws IOException {
        this.clearWallpaper(which, this.mContext.getUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static InputStream openDefaultWallpaper(Context context, int which) {
        String whichProp = PROP_WALLPAPER;
        int defaultResId = 17302267;
        String path = SystemProperties.get(whichProp);
        InputStream wallpaperInputStream = WallpaperManager.getWallpaperInputStream(path);
        if (wallpaperInputStream != null) {
            return wallpaperInputStream;
        }
        String cmfPath = WallpaperManager.getCmfWallpaperPath();
        InputStream cmfWallpaperInputStream = WallpaperManager.getWallpaperInputStream(cmfPath);
        if (cmfWallpaperInputStream != null) {
            return cmfWallpaperInputStream;
        }
        try {
            return context.getResources().openRawResource(defaultResId);
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    private static ParcelFileDescriptor getDefaultSystemWallpaperFile() {
        for (String path : WallpaperManager.getDefaultSystemWallpaperPaths()) {
            File file = new File(path);
            if (!file.exists()) continue;
            try {
                return ParcelFileDescriptor.open(file, 0x10000000);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    private static InputStream getWallpaperInputStream(String path) {
        File file;
        if (!TextUtils.isEmpty(path) && (file = new File(path)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<String> getDefaultSystemWallpaperPaths() {
        return List.of(SystemProperties.get(PROP_WALLPAPER), WallpaperManager.getCmfWallpaperPath());
    }

    private static String getCmfWallpaperPath() {
        return Environment.getProductDirectory() + WALLPAPER_CMF_PATH + "default_wallpaper_" + VALUE_CMF_COLOR;
    }

    public static ComponentName getDefaultWallpaperComponent(Context context) {
        ComponentName cn = null;
        String flat = SystemProperties.get(PROP_WALLPAPER_COMPONENT);
        if (!TextUtils.isEmpty(flat)) {
            cn = ComponentName.unflattenFromString(flat);
        }
        if (cn == null && !TextUtils.isEmpty(flat = context.getString(17040206))) {
            cn = ComponentName.unflattenFromString(flat);
        }
        if (!WallpaperManager.isComponentExist(context, cn)) {
            cn = null;
        }
        return cn;
    }

    public static ComponentName getCmfDefaultWallpaperComponent(Context context) {
        ComponentName cn = null;
        String[] cmfWallpaperMap = context.getResources().getStringArray(17236204);
        if (cmfWallpaperMap != null && cmfWallpaperMap.length > 0) {
            for (String entry : cmfWallpaperMap) {
                String[] cmfWallpaper;
                if (TextUtils.isEmpty(entry) || (cmfWallpaper = entry.split(",")) == null || cmfWallpaper.length != 2 || !VALUE_CMF_COLOR.equals(cmfWallpaper[0]) || TextUtils.isEmpty(cmfWallpaper[1])) continue;
                cn = ComponentName.unflattenFromString(cmfWallpaper[1]);
                break;
            }
        }
        if (!WallpaperManager.isComponentExist(context, cn)) {
            cn = null;
        }
        return cn == null ? WallpaperManager.getDefaultWallpaperComponent(context) : cn;
    }

    private static boolean isComponentExist(Context context, ComponentName cn) {
        if (cn == null) {
            return false;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo(cn.getPackageName(), 786432);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean isWallpaperBackupEligible(int which) {
        if (WallpaperManager.sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return WallpaperManager.sGlobals.mService.isWallpaperBackupEligible(which, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception querying wallpaper backup eligibility: " + e.getMessage());
            return false;
        }
    }

    public ColorManagementProxy getColorManagementProxy() {
        return this.mCmProxy;
    }

    private static void checkExactlyOneWallpaperFlagSet(int which) {
        if (which == 1 || which == 2) {
            return;
        }
        throw new IllegalArgumentException("Must specify exactly one kind of wallpaper");
    }

    static {
        sIsMultiCropEnabled = null;
    }

    private static class Globals
    extends IWallpaperManagerCallback.Stub {
        private final IWallpaperManager mService;
        private boolean mColorCallbackRegistered;
        private final ArrayList<Pair<OnColorsChangedListener, Handler>> mColorListeners = new ArrayList();
        private CachedWallpaper mCachedWallpaper;
        private Bitmap mDefaultWallpaper;
        private Handler mMainLooperHandler;
        private ArrayMap<LocalWallpaperColorConsumer, ArraySet<RectF>> mLocalColorCallbackAreas = new ArrayMap();
        private ILocalWallpaperColorConsumer mLocalColorCallback = new ILocalWallpaperColorConsumer.Stub(){

            @Override
            public void onColorsChanged(RectF area, WallpaperColors colors) {
                for (LocalWallpaperColorConsumer callback : mLocalColorCallbackAreas.keySet()) {
                    ArraySet<RectF> areas = mLocalColorCallbackAreas.get(callback);
                    if (areas == null || !areas.contains(area)) continue;
                    callback.onColorsChanged(area, colors);
                }
            }
        };

        Globals(IWallpaperManager service, Looper looper) {
            this.mService = service;
            this.mMainLooperHandler = new Handler(looper);
            this.forgetLoadedWallpaper();
        }

        @Override
        public void onWallpaperChanged() {
            this.forgetLoadedWallpaper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnColorsChangedListener(@NonNull OnColorsChangedListener callback, @Nullable Handler handler, int userId, int displayId) {
            Globals globals = this;
            synchronized (globals) {
                if (!this.mColorCallbackRegistered) {
                    try {
                        this.mService.registerWallpaperColorsCallback(this, userId, displayId);
                        this.mColorCallbackRegistered = true;
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't register for color updates", e);
                    }
                }
                this.mColorListeners.add(new Pair<OnColorsChangedListener, Handler>(callback, handler));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnColorsChangedListener(@NonNull LocalWallpaperColorConsumer callback, @NonNull List<RectF> regions, int which, int userId, int displayId) {
            Globals globals = this;
            synchronized (globals) {
                for (RectF area : regions) {
                    ArraySet<RectF> areas = this.mLocalColorCallbackAreas.get(callback);
                    if (areas == null) {
                        areas = new ArraySet();
                        this.mLocalColorCallbackAreas.put(callback, areas);
                    }
                    areas.add(area);
                }
                try {
                    this.mService.addOnLocalColorsChangedListener(this.mLocalColorCallback, regions, which, userId, displayId);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Can't register for local color updates", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOnColorsChangedListener(@NonNull LocalWallpaperColorConsumer callback, int which, int userId, int displayId) {
            Globals globals = this;
            synchronized (globals) {
                ArraySet<RectF> removeAreas = this.mLocalColorCallbackAreas.remove(callback);
                if (removeAreas == null || removeAreas.size() == 0) {
                    return;
                }
                for (LocalWallpaperColorConsumer cb : this.mLocalColorCallbackAreas.keySet()) {
                    ArraySet<RectF> areas = this.mLocalColorCallbackAreas.get(cb);
                    if (areas == null || cb == callback) continue;
                    removeAreas.removeAll(areas);
                }
                try {
                    if (removeAreas.size() > 0) {
                        this.mService.removeOnLocalColorsChangedListener(this.mLocalColorCallback, new ArrayList<RectF>(removeAreas), which, userId, displayId);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Can't unregister for local color updates", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOnColorsChangedListener(@NonNull OnColorsChangedListener callback, int userId, int displayId) {
            Globals globals = this;
            synchronized (globals) {
                this.mColorListeners.removeIf(pair -> pair.first == callback);
                if (this.mColorListeners.size() == 0 && this.mColorCallbackRegistered) {
                    this.mColorCallbackRegistered = false;
                    try {
                        this.mService.unregisterWallpaperColorsCallback(this, userId, displayId);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't unregister color updates", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) {
            Globals globals = this;
            synchronized (globals) {
                for (Pair<OnColorsChangedListener, Handler> listener : this.mColorListeners) {
                    Handler handler = (Handler)listener.second;
                    if (listener.second == null) {
                        handler = this.mMainLooperHandler;
                    }
                    handler.post(() -> {
                        boolean stillExists;
                        Globals globals = sGlobals;
                        synchronized (globals) {
                            stillExists = this.mColorListeners.contains(listener);
                        }
                        if (stillExists) {
                            ((OnColorsChangedListener)listener.first).onColorsChanged(colors, which, userId);
                        }
                    });
                }
            }
        }

        WallpaperColors getWallpaperColors(int which, int userId, int displayId) {
            WallpaperManager.checkExactlyOneWallpaperFlagSet(which);
            try {
                return this.mService.getWallpaperColors(which, userId, displayId);
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault, int which, ColorManagementProxy cmProxy) {
            return this.peekWallpaperBitmap(context, returnDefault, which, context.getUserId(), false, cmProxy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault, int which, int userId, boolean hardware, ColorManagementProxy cmProxy) {
            if (this.mService != null) {
                try {
                    Trace.beginSection("WPMS.isWallpaperSupported");
                    if (!this.mService.isWallpaperSupported(context.getOpPackageName())) {
                        Bitmap bitmap = null;
                        return bitmap;
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                finally {
                    Trace.endSection();
                }
            }
            Globals globals = this;
            synchronized (globals) {
                if (this.mCachedWallpaper != null && this.mCachedWallpaper.isValid(userId, which) && context.checkSelfPermission("android.permission.READ_WALLPAPER_INTERNAL") == 0) {
                    return this.mCachedWallpaper.mCachedWallpaper;
                }
                this.mCachedWallpaper = null;
                Bitmap currentWallpaper = null;
                try {
                    Trace.beginSection("WPMS.getCurrentWallpaperLocked");
                    currentWallpaper = this.getCurrentWallpaperLocked(context, which, userId, hardware, cmProxy);
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Out of memory loading the current wallpaper: " + e);
                }
                catch (SecurityException e) {
                    if (CompatChanges.isChangeEnabled(239784307L) && !CompatChanges.isChangeEnabled(237508058L)) {
                        Log.w(TAG, "No permission to access wallpaper, returning default wallpaper to avoid crashing legacy app.");
                        Bitmap bitmap = this.getDefaultWallpaper(context, 1);
                        return bitmap;
                    }
                    if (context.getApplicationInfo().targetSdkVersion >= 27) throw e;
                    Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                }
                finally {
                    Trace.endSection();
                }
                if (currentWallpaper != null) {
                    this.mCachedWallpaper = new CachedWallpaper(currentWallpaper, userId, which);
                    return currentWallpaper;
                }
            }
            if (returnDefault) return this.getDefaultWallpaper(context, which);
            if (which != 2) return null;
            if (!this.isStaticWallpaper(2)) return null;
            return this.getDefaultWallpaper(context, which);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Rect peekWallpaperDimensions(Context context, boolean returnDefault, int which, int userId) {
            InputStream is;
            if (this.mService != null) {
                try {
                    if (!this.mService.isWallpaperSupported(context.getOpPackageName())) {
                        return new Rect();
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            Rect dimensions = null;
            Globals globals = this;
            synchronized (globals) {
                Bundle params = new Bundle();
                try (ParcelFileDescriptor pfd = this.mService.getWallpaperWithFeature(context.getOpPackageName(), context.getAttributionTag(), this, which, params, userId, true);){
                    if (pfd != null) {
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inJustDecodeBounds = true;
                        BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor(), null, options);
                        dimensions = new Rect(0, 0, options.outWidth, options.outHeight);
                    }
                }
                catch (RemoteException ex) {
                    Log.w(TAG, "peek wallpaper dimensions failed", ex);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((dimensions == null || dimensions.width() == 0 || dimensions.height() == 0) && (returnDefault || which == 2 && this.isStaticWallpaper(2)) && (is = WallpaperManager.openDefaultWallpaper(context, which)) != null) {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeStream(is, null, options);
                    dimensions = new Rect(0, 0, options.outWidth, options.outHeight);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
            }
            return dimensions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forgetLoadedWallpaper() {
            Globals globals = this;
            synchronized (globals) {
                this.mCachedWallpaper = null;
                this.mDefaultWallpaper = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Bitmap getCurrentWallpaperLocked(Context context, int which, int userId, boolean hardware, ColorManagementProxy cmProxy) {
            Bitmap bitmap;
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            Bundle params = new Bundle();
            Trace.beginSection("WPMS.getWallpaperWithFeature_" + which);
            ParcelFileDescriptor pfd = this.mService.getWallpaperWithFeature(context.getOpPackageName(), context.getAttributionTag(), this, which, params, userId, true);
            Trace.endSection();
            if (pfd == null) {
                return null;
            }
            ParcelFileDescriptor.AutoCloseInputStream is = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
            try {
                ImageDecoder.Source src = Flags.enableConnectedDisplaysWallpaper() ? ImageDecoder.createSource(context.getResources(), is, 0) : ImageDecoder.createSource(context.getResources(), is);
                bitmap = ImageDecoder.decodeBitmap(src, (decoder, info, source) -> {
                    decoder.setMutableRequired(!hardware);
                    if (cmProxy != null) {
                        cmProxy.doColorManagement(decoder, info);
                    }
                });
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | OutOfMemoryError e) {
                        Log.w(TAG, "Can't decode file", e);
                        return null;
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            ((InputStream)is).close();
            return bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap getDefaultWallpaper(Context context, int which) {
            Trace.beginSection("WPMS.getDefaultWallpaper_" + which);
            Bitmap defaultWallpaper = this.mDefaultWallpaper;
            if (defaultWallpaper == null || defaultWallpaper.isRecycled()) {
                defaultWallpaper = null;
                Trace.beginSection("WPMS.openDefaultWallpaper");
                try (InputStream is = WallpaperManager.openDefaultWallpaper(context, which);){
                    Trace.endSection();
                    if (is != null) {
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        Trace.beginSection("WPMS.decodeStream");
                        defaultWallpaper = BitmapFactory.decodeStream(is, null, options);
                        Trace.endSection();
                    }
                }
                catch (IOException | OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode stream", e);
                }
            }
            Globals globals = this;
            synchronized (globals) {
                this.mDefaultWallpaper = defaultWallpaper;
            }
            Trace.endSection();
            return defaultWallpaper;
        }

        private boolean isStaticWallpaper(int which) {
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            try {
                return this.mService.isStaticWallpaper(which);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static class ColorManagementProxy {
        private final Set<ColorSpace> mSupportedColorSpaces = new HashSet<ColorSpace>();

        public ColorManagementProxy(@NonNull Context context) {
            Display display = context.getDisplayNoVerify();
            if (display != null) {
                this.mSupportedColorSpaces.addAll(Arrays.asList(display.getSupportedWideColorGamut()));
            }
        }

        @NonNull
        public Set<ColorSpace> getSupportedColorSpaces() {
            return this.mSupportedColorSpaces;
        }

        boolean isSupportedColorSpace(ColorSpace colorSpace) {
            return colorSpace != null && (colorSpace == ColorSpace.get(ColorSpace.Named.SRGB) || this.getSupportedColorSpaces().contains(colorSpace));
        }

        void doColorManagement(ImageDecoder decoder, ImageDecoder.ImageInfo info) {
            if (!this.isSupportedColorSpace(info.getColorSpace())) {
                decoder.setTargetColorSpace(ColorSpace.get(ColorSpace.Named.SRGB));
                Log.w(TAG, "Not supported color space: " + info.getColorSpace());
            }
        }
    }

    static class FastBitmapDrawable
    extends Drawable {
        private final Bitmap mBitmap;
        private final int mWidth;
        private final int mHeight;
        private int mDrawLeft;
        private int mDrawTop;
        private final Paint mPaint;

        private FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mPaint = new Paint();
            this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, this.mPaint);
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setBounds(int left, int top, int right, int bottom) {
            this.mDrawLeft = left + (right - left - this.mWidth) / 2;
            this.mDrawTop = top + (bottom - top - this.mHeight) / 2;
        }

        @Override
        public void setAlpha(int alpha) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setDither(boolean dither) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setFilterBitmap(boolean filter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        @Override
        public int getMinimumWidth() {
            return this.mWidth;
        }

        @Override
        public int getMinimumHeight() {
            return this.mHeight;
        }
    }

    public static interface OnColorsChangedListener {
        public void onColorsChanged(@Nullable WallpaperColors var1, int var2);

        default public void onColorsChanged(@Nullable WallpaperColors colors, int which, int userId) {
            this.onColorsChanged(colors, which);
        }
    }

    public static interface LocalWallpaperColorConsumer {
        public void onColorsChanged(RectF var1, WallpaperColors var2);
    }

    private class WallpaperSetCompletion
    extends IWallpaperManagerCallback.Stub {
        final CountDownLatch mLatch = new CountDownLatch(1);

        public WallpaperSetCompletion(WallpaperManager wallpaperManager) {
        }

        public void waitForCompletion() {
            try {
                boolean completed = this.mLatch.await(30L, TimeUnit.SECONDS);
                if (completed) {
                    Log.d(TAG, "Wallpaper set completion.");
                } else {
                    Log.d(TAG, "Timeout waiting for wallpaper set completion!");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void onWallpaperChanged() throws RemoteException {
            this.mLatch.countDown();
        }

        @Override
        public void onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) throws RemoteException {
            sGlobals.onWallpaperColorsChanged(colors, which, userId);
        }
    }

    private static class CachedWallpaper {
        final Bitmap mCachedWallpaper;
        final int mCachedWallpaperUserId;
        final int mWhich;

        CachedWallpaper(Bitmap cachedWallpaper, int cachedWallpaperUserId, int which) {
            this.mCachedWallpaper = cachedWallpaper;
            this.mCachedWallpaperUserId = cachedWallpaperUserId;
            this.mWhich = which;
        }

        boolean isValid(int userId, int which) {
            return userId == this.mCachedWallpaperUserId && which == this.mWhich && !this.mCachedWallpaper.isRecycled();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetWallpaperFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScreenOrientation {
    }
}

